/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BlockedThreadWarning
implements TestRule {
    private boolean doTest;
    private String poolName;
    private long maxExecuteTime;

    public synchronized void expectMessage(String poolName, long maxExecuteTime) {
        this.doTest = true;
        this.poolName = poolName;
        this.maxExecuteTime = maxExecuteTime;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
                BlockedThreadWarning.this.doTest(description);
            }
        };
    }

    private synchronized void doTest(Description description) throws IOException {
        if (!this.doTest) {
            return;
        }
        List<String> logs = this.getLogs(description.getTestClass().getSimpleName(), description.getMethodName());
        Assert.assertThat(logs, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)" has been blocked for "), (Matcher)CoreMatchers.containsString((String)(" time limit is " + TimeUnit.MILLISECONDS.convert(this.maxExecuteTime, TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.containsString((String)("Thread[" + this.poolName + "-")))));
    }

    private List<String> getLogs(String testClass, String methodName) throws IOException {
        String startingTestMessage = "Starting test: " + testClass + "#" + methodName;
        ArrayList<String> logs = new ArrayList<String>();
        AtomicBoolean reachedTest = new AtomicBoolean();
        Files.lines(Paths.get(System.getProperty("java.io.tmpdir"), "vertx.log")).forEach(line -> {
            if (!reachedTest.get()) {
                if (line.contains(startingTestMessage)) {
                    reachedTest.set(true);
                }
            } else {
                logs.add((String)line);
            }
        });
        return logs;
    }
}

