/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.test.core.VertxTestBase;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class JsonMapperTest
extends VertxTestBase {
    @Test
    public void testGetSetMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.mapper;
        this.assertNotNull(mapper);
        Json.mapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.mapper);
        Json.mapper = mapper;
    }

    @Test
    public void testGetSetPrettyMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.prettyMapper;
        this.assertNotNull(mapper);
        Json.prettyMapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.prettyMapper);
        Json.prettyMapper = mapper;
    }

    @Test
    public void encodeCustomTypeInstant() {
        Instant now = Instant.now();
        String json = Json.encode((Object)now);
        this.assertNotNull(json);
        Instant decoded = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(json.substring(1, json.length() - 1)));
        this.assertEquals(now, decoded);
    }

    @Test
    public void encodeCustomTypeInstantNull() {
        Object now = null;
        String json = Json.encode(now);
        this.assertNotNull(json);
        this.assertEquals("null", json);
    }

    @Test
    public void encodeCustomTypeBinary() {
        byte[] data = new byte[]{104, 101, 108, 108, 111};
        String json = Json.encode((Object)data);
        this.assertNotNull(json);
        this.assertEquals("\"aGVsbG8=\"", json);
    }

    @Test
    public void encodeCustomTypeBinaryNull() {
        Object data = null;
        String json = Json.encode(data);
        this.assertNotNull(json);
        this.assertEquals("null", json);
    }

    @Test
    public void encodeToBuffer() {
        Buffer json = Json.encodeToBuffer((Object)"Hello World!");
        this.assertNotNull(json);
        this.assertEquals("\"Hello World!\"", json.toString("UTF-8"));
    }

    @Test
    public void testGenericDecoding() {
        Pojo original = new Pojo();
        original.value = "test";
        String json = Json.encode(Collections.singletonList(original));
        List correct = (List)Json.decodeValue((String)json, (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        correct = (List)Json.decodeValue((Buffer)Buffer.buffer((String)json, (String)"UTF8"), (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        List incorrect = (List)Json.decodeValue((String)json, List.class);
        this.assertFalse(incorrect.get(0) instanceof Pojo);
        this.assertTrue(incorrect.get(0) instanceof Map);
        this.assertEquals(original.value, ((Map)incorrect.get(0)).get("value"));
    }

    private static class Pojo {
        @JsonProperty
        String value;

        private Pojo() {
        }
    }
}

