/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.launcher.commands.HelloCommand;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.core.impl.launcher.commands.VersionCommand;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.CustomMetricsOptions;
import io.vertx.test.core.MetricsOptionsTest;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.TestVerticle;
import io.vertx.test.core.VertxTestBase;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LauncherTest
extends VertxTestBase {
    private String expectedVersion;
    private ByteArrayOutputStream out;
    private PrintStream stream;
    private Vertx vertx;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestVerticle.instanceCount.set(0);
        TestVerticle.processArgs = null;
        TestVerticle.conf = null;
        URL resource = this.getClass().getClassLoader().getResource("vertx-version.txt");
        if (resource == null) {
            throw new IllegalStateException("Cannot find the vertx-version.txt");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
        this.expectedVersion = in.readLine();
        in.close();
        Launcher.resetProcessArguments();
        this.out = new ByteArrayOutputStream();
        this.stream = new PrintStream(this.out);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearProperties();
        super.tearDown();
        this.out.close();
        this.stream.close();
        if (this.vertx != null) {
            this.vertx.close();
        }
    }

    @Test
    public void testVersion() throws Exception {
        String[] args = new String[]{"-version"};
        MyLauncher launcher = new MyLauncher();
        launcher.dispatch(args);
        VersionCommand version = (VersionCommand)launcher.getExistingCommandInstance("version");
        this.assertNotNull(version);
        this.assertEquals(version.getVersion(), this.expectedVersion);
    }

    @Test
    public void testRunVerticleWithoutArgs() throws Exception {
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        launcher.assertHooksInvoked();
    }

    @Test
    public void testRunWithoutArgs() throws Exception {
        MyLauncher launcher = new MyLauncher(){

            @Override
            public PrintStream getPrintStream() {
                return this.stream;
            }
        };
        String[] args = new String[]{"run"};
        launcher.dispatch(args);
        this.assertTrue(this.out.toString().contains("The argument 'main-verticle' is required"));
    }

    @Test
    public void testNoArgsAndNoMainVerticle() throws Exception {
        MyLauncher launcher = new MyLauncher(){

            @Override
            public PrintStream getPrintStream() {
                return this.stream;
            }
        };
        String[] args = new String[]{};
        launcher.dispatch(args);
        this.assertTrue(this.out.toString().contains("Usage:"));
        this.assertTrue(this.out.toString().contains("bare"));
        this.assertTrue(this.out.toString().contains("run"));
        this.assertTrue(this.out.toString().contains("hello"));
    }

    @Test
    public void testRunVerticle() throws Exception {
        this.testRunVerticleMultiple(1);
    }

    @Test
    public void testRunVerticleMultipleInstances() throws Exception {
        this.testRunVerticleMultiple(10);
    }

    public void testRunVerticleMultiple(int instances) throws Exception {
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-instances", String.valueOf(instances)};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == instances);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        launcher.assertHooksInvoked();
    }

    @Test
    public void testRunVerticleClustered() throws Exception {
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        launcher.assertHooksInvoked();
    }

    @Test
    public void testRunVerticleHA() throws Exception {
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-ha"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        launcher.assertHooksInvoked();
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestNoArgs() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher();
        String[] args = new String[]{};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        this.cleanup(launcher);
    }

    private void cleanup(Launcher launcher) {
        Vertx v;
        RunCommand run = (RunCommand)launcher.getExistingCommandInstance("run");
        if (run != null && (v = run.vertx()) != null) {
            v.close();
        }
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestWithArgs() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher();
        String[] args = new String[]{"-cluster", "-worker", "-instances=10"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 10);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        this.cleanup(launcher);
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestWithCustomCommand() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher-hello.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher-hello.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher();
        HelloCommand.called = false;
        String[] args = new String[]{"--name=vert.x"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> HelloCommand.called);
    }

    @Test
    public void testRunVerticleWithoutMainVerticleInManifestButWithCustomCommand() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher-Default-Command.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Default-Command.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher();
        HelloCommand.called = false;
        String[] args = new String[]{"--name=vert.x"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> HelloCommand.called);
    }

    @Test
    public void testRunWithOverriddenDefaultCommand() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher-hello.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher-hello.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        HelloCommand.called = false;
        String[] args = new String[]{"run", TestVerticle.class.getName(), "--name=vert.x"};
        Launcher launcher = new Launcher();
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.cleanup(launcher);
    }

    @Test
    public void testRunWithOverriddenDefaultCommandRequiringArgs() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher-run.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher-run.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String[] args = new String[]{TestVerticle.class.getName()};
        Launcher launcher = new Launcher();
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.cleanup(launcher);
    }

    @Test
    public void testRunVerticleWithExtendedMainVerticleNoArgs() throws Exception {
        MySecondLauncher launcher = new MySecondLauncher();
        String[] args = new String[]{};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
    }

    @Test
    public void testRunVerticleWithExtendedMainVerticleWithArgs() throws Exception {
        MySecondLauncher launcher = new MySecondLauncher();
        String[] args = new String[]{"-cluster", "-worker"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
    }

    @Test
    public void testFatJarWithHelp() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher(){

            public PrintStream getPrintStream() {
                return LauncherTest.this.stream;
            }
        };
        String[] args = new String[]{"--help"};
        launcher.dispatch(args);
        this.assertTrue(this.out.toString().contains("Usage"));
        this.assertTrue(this.out.toString().contains("run"));
        this.assertTrue(this.out.toString().contains("version"));
        this.assertTrue(this.out.toString().contains("bare"));
    }

    @Test
    public void testFatJarWithCommandHelp() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher(){

            public PrintStream getPrintStream() {
                return LauncherTest.this.stream;
            }
        };
        String[] args = new String[]{"hello", "--help"};
        launcher.dispatch(args);
        this.assertTrue(this.out.toString().contains("Usage"));
        this.assertTrue(this.out.toString().contains("hello"));
        this.assertTrue(this.out.toString().contains("A simple command to wish you a good day."));
    }

    @Test
    public void testFatJarWithMissingCommandHelp() throws Exception {
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Launcher.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Launcher.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Launcher launcher = new Launcher(){

            public PrintStream getPrintStream() {
                return LauncherTest.this.stream;
            }
        };
        String[] args = new String[]{"not-a-command", "--help"};
        launcher.dispatch(args);
        this.assertTrue(this.out.toString().contains("The command 'not-a-command' is not a valid command."));
    }

    @Test
    public void testRunVerticleWithConfString() throws Exception {
        MyLauncher launcher = new MyLauncher();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", conf.encode()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(conf, TestVerticle.conf);
    }

    @Test
    public void testRunVerticleWithConfFile() throws Exception {
        Path tempDir = this.testFolder.newFolder().toPath();
        Path tempFile = Files.createTempFile(tempDir, "conf", "json", new FileAttribute[0]);
        MyLauncher launcher = new MyLauncher();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        Files.write(tempFile, conf.encode().getBytes(), new OpenOption[0]);
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", tempFile.toString()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(conf, TestVerticle.conf);
    }

    @Test
    public void testConfigureFromSystemProperties() throws Exception {
        this.testConfigureFromSystemProperties(false);
    }

    @Test
    public void testConfigureFromSystemPropertiesClustered() throws Exception {
        this.testConfigureFromSystemProperties(true);
    }

    private void testConfigureFromSystemProperties(boolean clustered) throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "123");
        System.setProperty("vertx.options.maxEventLoopExecuteTime", "123767667");
        System.setProperty("vertx.metrics.options.enabled", "true");
        System.setProperty("vertx.options.haGroup", "somegroup");
        MyLauncher launcher = new MyLauncher();
        String[] args = clustered ? new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"} : new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = launcher.getVertxOptions();
        this.assertEquals(123.0, (double)opts.getEventLoopPoolSize(), 0.0);
        this.assertEquals(123767667L, opts.getMaxEventLoopExecuteTime());
        this.assertEquals(true, opts.getMetricsOptions().isEnabled());
        this.assertEquals("somegroup", opts.getHAGroup());
    }

    private void clearProperties() {
        HashSet<String> toClear = new HashSet<String>();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith("vertx.options")) continue;
            toClear.add(propName);
        }
        toClear.forEach(System::clearProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomMetricsOptions() throws Exception {
        System.setProperty("vertx.metrics.options.enabled", "true");
        System.setProperty("vertx.metrics.options.customProperty", "customPropertyValue");
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MetricsOptionsTest.createMetricsFromMetaInfLoader("io.vertx.test.core.CustomMetricsFactory"));
        try {
            launcher.dispatch(args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = launcher.getVertxOptions();
        CustomMetricsOptions custom = (CustomMetricsOptions)opts.getMetricsOptions();
        this.assertEquals("customPropertyValue", custom.getCustomProperty());
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyName() throws Exception {
        System.setProperty("vertx.options.nosuchproperty", "123");
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = launcher.getVertxOptions();
        VertxOptions def = new VertxOptions();
        if (opts.getMetricsOptions().isEnabled()) {
            def.getMetricsOptions().setEnabled(true);
        }
        this.assertEquals(def, opts);
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyType() throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "sausages");
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = launcher.getVertxOptions();
        VertxOptions def = new VertxOptions();
        if (opts.getMetricsOptions().isEnabled()) {
            def.getMetricsOptions().setEnabled(true);
        }
        this.assertEquals(def, opts);
    }

    @Test
    public void testWhenPassingTheMainObject() throws Exception {
        MyLauncher launcher = new MyLauncher();
        int instances = 10;
        launcher.dispatch((Object)launcher, new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-instances", "10"});
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == instances);
    }

    @Test
    public void testBare() throws Exception {
        MyLauncher launcher = new MyLauncher();
        launcher.dispatch(new String[]{"bare"});
        this.assertWaitUntil(() -> launcher.afterStartingVertxInvoked);
    }

    @Test
    public void testBareAlias() throws Exception {
        MyLauncher launcher = new MyLauncher();
        launcher.dispatch(new String[]{"-ha"});
        this.assertWaitUntil(() -> launcher.afterStartingVertxInvoked);
    }

    @Test
    public void testConfigureClusterHostPortFromProperties() throws Exception {
        int clusterPort = TestUtils.randomHighPortInt();
        System.setProperty("vertx.options.clusterHost", "127.0.0.1");
        System.setProperty("vertx.options.clusterPort", Integer.toString(clusterPort));
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals("127.0.0.1", launcher.options.getClusterHost());
        this.assertEquals(clusterPort, launcher.options.getClusterPort());
        this.assertNull(launcher.options.getClusterPublicHost());
        this.assertEquals(-1L, launcher.options.getClusterPublicPort());
    }

    @Test
    public void testConfigureClusterHostPortFromCommandLine() throws Exception {
        int clusterPort = TestUtils.randomHighPortInt();
        MyLauncher launcher = new MyLauncher();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster", "--cluster-host", "127.0.0.1", "--cluster-port", Integer.toString(clusterPort)};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals("127.0.0.1", launcher.options.getClusterHost());
        this.assertEquals(clusterPort, launcher.options.getClusterPort());
        this.assertNull(launcher.options.getClusterPublicHost());
        this.assertEquals(-1L, launcher.options.getClusterPublicPort());
    }

    @Test
    public void testOverrideClusterHostPortFromProperties() throws Exception {
        int clusterPort = TestUtils.randomHighPortInt();
        int newClusterPort = TestUtils.randomHighPortInt();
        int newClusterPublicPort = TestUtils.randomHighPortInt();
        System.setProperty("vertx.options.clusterHost", "127.0.0.2");
        System.setProperty("vertx.options.clusterPort", Integer.toString(clusterPort));
        MyLauncher launcher = new MyLauncher();
        launcher.clusterHost = "127.0.0.1";
        launcher.clusterPort = newClusterPort;
        launcher.clusterPublicHost = "127.0.0.3";
        launcher.clusterPublicPort = newClusterPublicPort;
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals("127.0.0.1", launcher.options.getClusterHost());
        this.assertEquals(newClusterPort, launcher.options.getClusterPort());
        this.assertEquals("127.0.0.3", launcher.options.getClusterPublicHost());
        this.assertEquals(newClusterPublicPort, launcher.options.getClusterPublicPort());
    }

    @Test
    public void testOverrideClusterHostPortFromCommandLine() throws Exception {
        int clusterPort = TestUtils.randomHighPortInt();
        int newClusterPort = TestUtils.randomHighPortInt();
        int newClusterPublicPort = TestUtils.randomHighPortInt();
        MyLauncher launcher = new MyLauncher();
        launcher.clusterHost = "127.0.0.1";
        launcher.clusterPort = newClusterPort;
        launcher.clusterPublicHost = "127.0.0.3";
        launcher.clusterPublicPort = newClusterPublicPort;
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster", "--cluster-host", "127.0.0.2", "--cluster-port", Integer.toString(clusterPort)};
        launcher.dispatch(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals("127.0.0.1", launcher.options.getClusterHost());
        this.assertEquals(newClusterPort, launcher.options.getClusterPort());
        this.assertEquals("127.0.0.3", launcher.options.getClusterPublicHost());
        this.assertEquals(newClusterPublicPort, launcher.options.getClusterPublicPort());
    }

    static /* synthetic */ ByteArrayOutputStream access$100(LauncherTest x0) {
        return x0.out;
    }

    class MySecondLauncher
    extends MyLauncher {
        MySecondLauncher() {
        }

        public String getMainVerticle() {
            return "java:io.vertx.test.core.TestVerticle";
        }
    }

    class MyLauncher
    extends Launcher {
        boolean afterConfigParsed = false;
        boolean beforeStartingVertxInvoked = false;
        boolean afterStartingVertxInvoked = false;
        boolean beforeDeployingVerticle = false;
        VertxOptions options;
        DeploymentOptions deploymentOptions;
        JsonObject config;
        String clusterHost;
        int clusterPort;
        String clusterPublicHost;
        int clusterPublicPort;
        PrintStream stream = new PrintStream(LauncherTest.access$100(LauncherTest.this));

        MyLauncher() {
        }

        public PrintStream getPrintStream() {
            return this.stream;
        }

        public Vertx getVertx() {
            return LauncherTest.this.vertx;
        }

        public VertxOptions getVertxOptions() {
            return this.options;
        }

        public void afterConfigParsed(JsonObject config) {
            this.afterConfigParsed = true;
            this.config = config;
        }

        public void beforeStartingVertx(VertxOptions options) {
            this.beforeStartingVertxInvoked = true;
            this.options = options;
            if (this.clusterHost != null) {
                options.setClusterHost(this.clusterHost);
                options.setClusterPort(this.clusterPort);
                options.setClusterPublicHost(this.clusterPublicHost);
                options.setClusterPublicPort(this.clusterPublicPort);
                super.beforeStartingVertx(options);
            }
        }

        public void afterStartingVertx(Vertx vertx) {
            this.afterStartingVertxInvoked = true;
            LauncherTest.this.vertx = vertx;
        }

        public void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
            this.beforeDeployingVerticle = true;
            this.deploymentOptions = deploymentOptions;
        }

        public void assertHooksInvoked() {
            LauncherTest.this.assertTrue(this.afterConfigParsed);
            LauncherTest.this.assertTrue(this.beforeStartingVertxInvoked);
            LauncherTest.this.assertTrue(this.afterStartingVertxInvoked);
            LauncherTest.this.assertTrue(this.beforeDeployingVerticle);
            LauncherTest.this.assertNotNull(LauncherTest.this.vertx);
        }
    }
}

