/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.test.core.HttpProxy;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakedns.FakeDNSServer;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class ProxyErrorTest
extends VertxTestBase {
    private static final Logger log = LoggerFactory.getLogger(ProxyErrorTest.class);
    private HttpProxy proxy = null;
    private FakeDNSServer dnsServer;
    private InetSocketAddress dnsServerAddress;

    @Override
    public void setUp() throws Exception {
        this.dnsServer = FakeDNSServer.testLookupNonExisting();
        this.dnsServer.start();
        this.dnsServerAddress = this.dnsServer.localAddress();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.dnsServer.isStarted()) {
            this.dnsServer.stop();
        }
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort());
        options.getAddressResolverOptions().setOptResourceEnabled(false);
        return options;
    }

    private void startProxy(int error, String username) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.proxy = new HttpProxy(username);
        this.proxy.setError(error);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> latch.countDown()));
        latch.await();
    }

    @Test
    public void testProxyHttpsError() throws Exception {
        this.expectProxyException(403, null, "https://localhost/");
    }

    @Test
    public void testProxyHttpsAuthFail() throws Exception {
        this.expectProxyException(0, "user", "https://localhost/");
    }

    @Test
    public void testProxyHttpsHostUnknown() throws Exception {
        this.expectProxyException(0, null, "https://unknown.hostname/");
    }

    @Test
    public void testProxyError() throws Exception {
        this.expectStatusError(403, 403, null, "http://localhost/");
    }

    @Test
    public void testProxyAuthFail() throws Exception {
        this.expectStatusError(0, 407, "user", "http://localhost/");
    }

    @Test
    public void testProxyHostUnknown() throws Exception {
        this.expectStatusError(0, 504, null, "http://unknown.hostname/");
    }

    private void expectProxyException(int error, String username, String url) throws Exception {
        this.proxyTest(error, username, url, (Handler<HttpClientResponse>)((Handler)resp -> {
            log.info((Object)("request is supposed to fail but response is " + resp.statusCode() + " " + resp.statusMessage()));
            this.fail("request is supposed to fail");
        }), true);
    }

    private void expectStatusError(int error, int responseStatus, String username, String url) throws Exception {
        this.proxyTest(error, username, url, (Handler<HttpClientResponse>)((Handler)resp -> {
            this.assertEquals(responseStatus, resp.statusCode());
            this.testComplete();
        }), false);
    }

    private void proxyTest(int error, String username, String url, Handler<HttpClientResponse> assertResponse, boolean completeOnException) throws Exception {
        this.startProxy(error, username);
        HttpClientOptions options = new HttpClientOptions().setSsl(url.startsWith("https")).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()));
        HttpClient client = this.vertx.createHttpClient(options);
        client.getAbs(url, assertResponse).exceptionHandler(e -> {
            if (completeOnException) {
                this.testComplete();
            } else {
                this.fail((Throwable)e);
            }
        }).end();
        this.await();
    }
}

