/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.test.fakemetrics.EndpointMetric;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FakeHttpClientMetrics
extends FakeMetricsBase
implements HttpClientMetrics<HttpClientMetric, WebSocketMetric, SocketMetric, EndpointMetric, Void> {
    private final String name;
    private final ConcurrentMap<WebSocketBase, WebSocketMetric> webSockets = new ConcurrentHashMap<WebSocketBase, WebSocketMetric>();
    private final ConcurrentMap<HttpClientRequest, HttpClientMetric> requests = new ConcurrentHashMap<HttpClientRequest, HttpClientMetric>();
    private final ConcurrentHashMap<String, EndpointMetric> endpoints = new ConcurrentHashMap();

    public FakeHttpClientMetrics(Measured measured, String name) {
        super(measured);
        this.name = name;
    }

    public WebSocketMetric getMetric(WebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws);
    }

    public HttpClientMetric getMetric(HttpClientRequest request) {
        return (HttpClientMetric)this.requests.get(request);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> endpoints() {
        return new HashSet<String>(this.endpoints.keySet());
    }

    public EndpointMetric endpoint(String name) {
        return this.endpoints.get(name);
    }

    public Integer queueSize(String name) {
        EndpointMetric server = this.endpoints.get(name);
        return server != null ? Integer.valueOf(server.queueSize.get()) : null;
    }

    public Integer connectionCount(String name) {
        EndpointMetric server = this.endpoints.get(name);
        return server != null ? Integer.valueOf(server.connectionCount.get()) : null;
    }

    public EndpointMetric createEndpoint(String host, int port, int maxPoolSize) {
        EndpointMetric metric = new EndpointMetric();
        this.endpoints.put(host + ":" + port, metric);
        return metric;
    }

    public Void enqueueRequest(EndpointMetric endpointMetric) {
        endpointMetric.queueSize.incrementAndGet();
        return null;
    }

    public void dequeueRequest(EndpointMetric endpointMetric, Void v) {
        endpointMetric.queueSize.decrementAndGet();
    }

    public void closeEndpoint(String host, int port, EndpointMetric endpointMetric) {
        this.endpoints.remove(host + ":" + port);
    }

    public void endpointConnected(EndpointMetric endpointMetric, SocketMetric socketMetric) {
        endpointMetric.connectionCount.incrementAndGet();
    }

    public void endpointDisconnected(EndpointMetric endpointMetric, SocketMetric socketMetric) {
        endpointMetric.connectionCount.decrementAndGet();
    }

    public WebSocketMetric connected(EndpointMetric endpointMetric, SocketMetric socketMetric, WebSocket webSocket) {
        WebSocketMetric metric = new WebSocketMetric(socketMetric, (WebSocketBase)webSocket);
        this.webSockets.put((WebSocketBase)webSocket, metric);
        return metric;
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.webSockets.remove(webSocketMetric.ws);
    }

    public HttpClientMetric requestBegin(EndpointMetric endpointMetric, SocketMetric socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        endpointMetric.requests.incrementAndGet();
        HttpClientMetric metric = new HttpClientMetric(endpointMetric, request, socketMetric);
        this.requests.put(request, metric);
        return metric;
    }

    public void requestEnd(HttpClientMetric requestMetric) {
        requestMetric.requestEnded.incrementAndGet();
    }

    public void responseBegin(HttpClientMetric requestMetric, HttpClientResponse response) {
        requestMetric.responseBegin.incrementAndGet();
    }

    public HttpClientMetric responsePushed(EndpointMetric endpointMetric, SocketMetric socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        endpointMetric.requests.incrementAndGet();
        HttpClientMetric metric = new HttpClientMetric(endpointMetric, request, socketMetric);
        this.requests.put(request, metric);
        return metric;
    }

    public void requestReset(HttpClientMetric requestMetric) {
        requestMetric.endpoint.requests.decrementAndGet();
        requestMetric.failed.set(true);
        this.requests.remove(requestMetric.request);
    }

    public void responseEnd(HttpClientMetric requestMetric, HttpClientResponse response) {
        requestMetric.endpoint.requests.decrementAndGet();
        this.requests.remove(requestMetric.request);
    }

    public SocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        return new SocketMetric(remoteAddress, remoteName);
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.connected.set(false);
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

