/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ListTransferTest {
    private static final int CONNECTING = 0;
    private static final int WRITING = 1;
    private static final int CONNECTED = 2;

    @Test
    public void doTheTest() throws Exception {
        AtomicInteger status = new AtomicInteger();
        ArrayList array = new ArrayList();
        AtomicInteger expectedCount = new AtomicInteger();
        Thread t1 = new Thread(() -> {
            int count = 0;
            while (true) {
                switch (status.get()) {
                    case 0: {
                        if (!status.compareAndSet(0, 1)) break;
                        array.add(count++);
                        status.set(0);
                        break;
                    }
                    case 2: {
                        expectedCount.set(count);
                        return;
                    }
                }
            }
        });
        AtomicReference expectedArray = new AtomicReference();
        AtomicInteger expectedSpin = new AtomicInteger();
        Thread t2 = new Thread(() -> {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignore) {
                return;
            }
            int spin = 0;
            while (true) {
                if (status.compareAndSet(0, 2)) {
                    expectedArray.set(new ArrayList(array));
                    expectedSpin.set(spin);
                    return;
                }
                ++spin;
                Thread.yield();
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals((long)expectedCount.get(), (long)((ArrayList)expectedArray.get()).size());
        System.out.println(expectedCount.get());
        System.out.println(expectedSpin.get());
    }
}

