/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.codec.TooLongFrameException;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.HttpTest;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.SimpleServer;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.junit.Test;

public class Http1xTest
extends HttpTest {
    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host0\n127.0.0.1 host1\n127.0.0.1 host2\n"));
        return options;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions());
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost").setHandle100ContinueAutomatically(true));
    }

    @Test
    public void testClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(10L, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        this.assertTrue(options.isVerifyHost());
        this.assertEquals(options, options.setVerifyHost(false));
        this.assertFalse(options.isVerifyHost());
        this.assertEquals(5L, options.getMaxPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxPoolSize(rand));
        this.assertEquals(rand, options.getMaxPoolSize());
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(-1));
        this.assertTrue(options.isKeepAlive());
        this.assertEquals(options, options.setKeepAlive(false));
        this.assertFalse(options.isKeepAlive());
        this.assertFalse(options.isPipelining());
        this.assertEquals(options, options.setPipelining(true));
        this.assertTrue(options.isPipelining());
        this.assertEquals(10L, options.getPipeliningLimit());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setPipeliningLimit(rand));
        this.assertEquals(rand, options.getPipeliningLimit());
        TestUtils.assertIllegalArgumentException(() -> options.setPipeliningLimit(0));
        TestUtils.assertIllegalArgumentException(() -> options.setPipeliningLimit(-1));
        this.assertEquals(1L, options.getHttp2MaxPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2MaxPoolSize(rand));
        this.assertEquals(rand, options.getHttp2MaxPoolSize());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MaxPoolSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MaxPoolSize(-1));
        this.assertEquals(-1L, options.getHttp2MultiplexingLimit());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2MultiplexingLimit(rand));
        this.assertEquals(rand, options.getHttp2MultiplexingLimit());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2MultiplexingLimit(0));
        this.assertEquals(options, options.setHttp2MultiplexingLimit(-1));
        this.assertEquals(-1L, options.getHttp2MultiplexingLimit());
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(rand));
        this.assertEquals(rand, options.getHttp2ConnectionWindowSize());
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(-1));
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        this.assertEquals(60000L, options.getConnectTimeout());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setConnectTimeout(rand));
        this.assertEquals(rand, options.getConnectTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setConnectTimeout(-2));
        this.assertFalse(options.isTryUseCompression());
        this.assertEquals(options, options.setTryUseCompression(true));
        this.assertEquals(true, options.isTryUseCompression());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(HttpVersion.HTTP_1_1, options.getProtocolVersion());
        this.assertEquals(options, options.setProtocolVersion(HttpVersion.HTTP_1_0));
        this.assertEquals(HttpVersion.HTTP_1_0, options.getProtocolVersion());
        TestUtils.assertIllegalArgumentException(() -> options.setProtocolVersion(null));
        this.assertEquals(8192L, options.getMaxChunkSize());
        this.assertEquals(options, options.setMaxChunkSize(100));
        this.assertEquals(100L, options.getMaxChunkSize());
        this.assertEquals(4096L, options.getMaxInitialLineLength());
        this.assertEquals(options, options.setMaxInitialLineLength(100));
        this.assertEquals(100L, options.getMaxInitialLineLength());
        this.assertEquals(8192L, options.getMaxHeaderSize());
        this.assertEquals(options, options.setMaxHeaderSize(100));
        this.assertEquals(100L, options.getMaxHeaderSize());
        this.assertEquals(-1L, options.getMaxWaitQueueSize());
        this.assertEquals(options, options.setMaxWaitQueueSize(100));
        this.assertEquals(100L, options.getMaxWaitQueueSize());
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        this.assertEquals(new Http2Settings(), options.getInitialSettings());
        this.assertEquals(options, options.setInitialSettings(initialSettings));
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setJdkSslEngineOptions(new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.HTTP_1_1);
        this.assertEquals(HttpClientOptions.DEFAULT_ALPN_VERSIONS, options.getAlpnVersions());
        this.assertEquals(options, options.setAlpnVersions(alpnVersions));
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(true, options.isHttp2ClearTextUpgrade());
        this.assertEquals(options, options.setHttp2ClearTextUpgrade(false));
        this.assertEquals(false, options.isHttp2ClearTextUpgrade());
        this.assertEquals(null, options.getLocalAddress());
        this.assertEquals(false, options.isSendUnmaskedFrames());
        this.assertEquals(options, options.setSendUnmaskedFrames(true));
        this.assertEquals(true, options.isSendUnmaskedFrames());
        this.assertEquals(128L, options.getDecoderInitialBufferSize());
        this.assertEquals(options, options.setDecoderInitialBufferSize(256));
        this.assertEquals(256L, options.getDecoderInitialBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setDecoderInitialBufferSize(-1));
        this.assertEquals(60L, options.getKeepAliveTimeout());
        this.assertEquals(options, options.setKeepAliveTimeout(10));
        this.assertEquals(10L, options.getKeepAliveTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setKeepAliveTimeout(-1));
        this.assertEquals(60L, options.getHttp2KeepAliveTimeout());
        this.assertEquals(options, options.setHttp2KeepAliveTimeout(10));
        this.assertEquals(10L, options.getHttp2KeepAliveTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setHttp2KeepAliveTimeout(-1));
    }

    @Test
    public void testServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(10L, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(-1L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertFalse(options.isCompressionSupported());
        this.assertEquals(options, options.setCompressionSupported(true));
        this.assertTrue(options.isCompressionSupported());
        this.assertEquals(65536L, options.getMaxWebsocketFrameSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxWebsocketFrameSize(rand));
        this.assertEquals(rand, options.getMaxWebsocketFrameSize());
        this.assertEquals(80L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertNull(options.getWebsocketSubProtocols());
        this.assertEquals(options, options.setWebsocketSubProtocols("foo"));
        this.assertEquals("foo", options.getWebsocketSubProtocols());
        HttpServerOptions optionsCopy = new HttpServerOptions(options);
        this.assertEquals(options, optionsCopy.setWebsocketSubProtocols(new String(options.getWebsocketSubProtocols())));
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertFalse(options.isHandle100ContinueAutomatically());
        this.assertEquals(options, options.setHandle100ContinueAutomatically(true));
        this.assertTrue(options.isHandle100ContinueAutomatically());
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setJdkSslEngineOptions(new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        this.assertEquals(new Http2Settings().setMaxConcurrentStreams(100L), options.getInitialSettings());
        this.assertEquals(options, options.setInitialSettings(initialSettings));
        this.assertEquals(initialSettings, options.getInitialSettings());
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.HTTP_1_1);
        this.assertEquals(HttpServerOptions.DEFAULT_ALPN_VERSIONS, options.getAlpnVersions());
        this.assertEquals(options, options.setAlpnVersions(alpnVersions));
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(rand));
        this.assertEquals(rand, options.getHttp2ConnectionWindowSize());
        this.assertEquals(options, options.setHttp2ConnectionWindowSize(-1));
        this.assertEquals(-1L, options.getHttp2ConnectionWindowSize());
        this.assertFalse(options.isDecompressionSupported());
        this.assertEquals(options, options.setDecompressionSupported(true));
        this.assertTrue(options.isDecompressionSupported());
        this.assertEquals(128L, options.getDecoderInitialBufferSize());
        this.assertEquals(options, options.setDecoderInitialBufferSize(256));
        this.assertEquals(256L, options.getDecoderInitialBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setDecoderInitialBufferSize(-1));
    }

    @Test
    public void testCopyClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        KeyCertOptions keyCertOptions = TestUtils.randomKeyCertOptions();
        TrustOptions trustOptions = TestUtils.randomTrustOptions();
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int keepAliveTimeout = TestUtils.randomPositiveInt();
        int http2KeepAliveTimeout = TestUtils.randomPositiveInt();
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        int pipeliningLimit = TestUtils.randomPositiveInt();
        int http2MaxPoolSize = TestUtils.randomPositiveInt();
        int http2MultiplexingLimit = TestUtils.randomPositiveInt();
        int http2ConnectionWindowSize = TestUtils.randomPositiveInt();
        boolean tryUseCompression = rand.nextBoolean();
        HttpVersion protocolVersion = HttpVersion.HTTP_1_0;
        int maxChunkSize = TestUtils.randomPositiveInt();
        int maxInitialLineLength = TestUtils.randomPositiveInt();
        int maxHeaderSize = TestUtils.randomPositiveInt();
        int maxWaitQueueSize = TestUtils.randomPositiveInt();
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean h2cUpgrade = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        boolean sendUnmaskedFrame = rand.nextBoolean();
        String localAddress = TestUtils.randomAlphaString(10);
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setKeyCertOptions(keyCertOptions);
        options.setTrustOptions(trustOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setVerifyHost(verifyHost);
        options.setMaxPoolSize(maxPoolSize);
        options.setKeepAlive(keepAlive);
        options.setPipelining(pipelining);
        options.setPipeliningLimit(pipeliningLimit);
        options.setHttp2MaxPoolSize(http2MaxPoolSize);
        options.setHttp2MultiplexingLimit(http2MultiplexingLimit);
        options.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
        options.setTryUseCompression(tryUseCompression);
        options.setProtocolVersion(protocolVersion);
        options.setMaxChunkSize(maxChunkSize);
        options.setMaxInitialLineLength(maxInitialLineLength);
        options.setMaxHeaderSize(maxHeaderSize);
        options.setMaxWaitQueueSize(maxWaitQueueSize);
        options.setInitialSettings(initialSettings);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setAlpnVersions(alpnVersions);
        options.setHttp2ClearTextUpgrade(h2cUpgrade);
        options.setLocalAddress(localAddress);
        options.setSendUnmaskedFrames(sendUnmaskedFrame);
        options.setDecoderInitialBufferSize(decoderInitialBufferSize);
        options.setKeepAliveTimeout(keepAliveTimeout);
        options.setHttp2KeepAliveTimeout(http2KeepAliveTimeout);
        HttpClientOptions copy = new HttpClientOptions(options);
        this.checkCopyHttpClientOptions(options, copy);
        HttpClientOptions copy2 = new HttpClientOptions(options.toJson());
        this.checkCopyHttpClientOptions(options, copy2);
    }

    private void checkCopyHttpClientOptions(HttpClientOptions options, HttpClientOptions copy) {
        this.assertEquals(options.getSendBufferSize(), copy.getSendBufferSize());
        this.assertEquals(options.getReceiveBufferSize(), copy.getReceiveBufferSize());
        this.assertEquals(options.isReuseAddress(), copy.isReuseAddress());
        this.assertEquals(options.getTrafficClass(), copy.getTrafficClass());
        this.assertEquals(options.isTcpNoDelay(), copy.isTcpNoDelay());
        this.assertEquals(options.isTcpKeepAlive(), copy.isTcpKeepAlive());
        this.assertEquals(options.getSoLinger(), copy.getSoLinger());
        this.assertEquals(options.isUsePooledBuffers(), copy.isUsePooledBuffers());
        this.assertEquals(options.getIdleTimeout(), copy.getIdleTimeout());
        this.assertEquals(options.isSsl(), copy.isSsl());
        this.assertNotSame(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertEquals(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertNotSame(options.getTrustOptions(), copy.getTrustOptions());
        if (copy.getTrustOptions() instanceof PemTrustOptions) {
            this.assertEquals(((PemTrustOptions)options.getTrustOptions()).getCertValues(), ((PemTrustOptions)copy.getTrustOptions()).getCertValues());
        } else {
            this.assertEquals(options.getTrustOptions(), copy.getTrustOptions());
        }
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertEquals(options.getEnabledCipherSuites(), copy.getEnabledCipherSuites());
        this.assertEquals(options.getConnectTimeout(), copy.getConnectTimeout());
        this.assertEquals(options.isTrustAll(), copy.isTrustAll());
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(options.getCrlPaths().get(0), copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(options.getCrlValues().get(0), copy.getCrlValues().get(0));
        this.assertEquals(options.isVerifyHost(), copy.isVerifyHost());
        this.assertEquals(options.getMaxPoolSize(), copy.getMaxPoolSize());
        this.assertEquals(options.isKeepAlive(), copy.isKeepAlive());
        this.assertEquals(options.isPipelining(), copy.isPipelining());
        this.assertEquals(options.getPipeliningLimit(), copy.getPipeliningLimit());
        this.assertEquals(options.getHttp2MaxPoolSize(), copy.getHttp2MaxPoolSize());
        this.assertEquals(options.getHttp2MultiplexingLimit(), copy.getHttp2MultiplexingLimit());
        this.assertEquals(options.getHttp2ConnectionWindowSize(), copy.getHttp2ConnectionWindowSize());
        this.assertEquals(options.isTryUseCompression(), copy.isTryUseCompression());
        this.assertEquals(options.getProtocolVersion(), copy.getProtocolVersion());
        this.assertEquals(options.getMaxChunkSize(), copy.getMaxChunkSize());
        this.assertEquals(options.getMaxInitialLineLength(), copy.getMaxInitialLineLength());
        this.assertEquals(options.getMaxHeaderSize(), copy.getMaxHeaderSize());
        this.assertEquals(options.getMaxWaitQueueSize(), copy.getMaxWaitQueueSize());
        this.assertEquals(options.getInitialSettings(), copy.getInitialSettings());
        this.assertEquals(options.isUseAlpn(), copy.isUseAlpn());
        this.assertEquals(options.getSslEngineOptions(), copy.getSslEngineOptions());
        this.assertEquals(options.getAlpnVersions(), copy.getAlpnVersions());
        this.assertEquals(options.isHttp2ClearTextUpgrade(), copy.isHttp2ClearTextUpgrade());
        this.assertEquals(options.getLocalAddress(), copy.getLocalAddress());
        this.assertEquals(options.isSendUnmaskedFrames(), copy.isSendUnmaskedFrames());
        this.assertEquals(options.getKeepAliveTimeout(), copy.getKeepAliveTimeout());
        this.assertEquals(options.getHttp2KeepAliveTimeout(), copy.getHttp2KeepAliveTimeout());
    }

    @Test
    public void testDefaultClientOptionsJson() {
        HttpClientOptions def = new HttpClientOptions();
        HttpClientOptions json = new HttpClientOptions(new JsonObject());
        this.assertEquals(def.getMaxPoolSize(), json.getMaxPoolSize());
        this.assertEquals(def.isKeepAlive(), json.isKeepAlive());
        this.assertEquals(def.isPipelining(), json.isPipelining());
        this.assertEquals(def.getPipeliningLimit(), json.getPipeliningLimit());
        this.assertEquals(def.getHttp2MaxPoolSize(), json.getHttp2MaxPoolSize());
        this.assertEquals(def.getHttp2MultiplexingLimit(), json.getHttp2MultiplexingLimit());
        this.assertEquals(def.getHttp2ConnectionWindowSize(), json.getHttp2ConnectionWindowSize());
        this.assertEquals(def.isVerifyHost(), json.isVerifyHost());
        this.assertEquals(def.isTryUseCompression(), json.isTryUseCompression());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.getProtocolVersion(), json.getProtocolVersion());
        this.assertEquals(def.getMaxWaitQueueSize(), json.getMaxWaitQueueSize());
        this.assertEquals(def.getMaxChunkSize(), json.getMaxChunkSize());
        this.assertEquals(def.getMaxInitialLineLength(), json.getMaxInitialLineLength());
        this.assertEquals(def.getMaxHeaderSize(), json.getMaxHeaderSize());
        this.assertEquals(def.getInitialSettings(), json.getInitialSettings());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getAlpnVersions(), json.getAlpnVersions());
        this.assertEquals(def.isHttp2ClearTextUpgrade(), json.isHttp2ClearTextUpgrade());
        this.assertEquals(def.getLocalAddress(), json.getLocalAddress());
        this.assertEquals(def.getDecoderInitialBufferSize(), json.getDecoderInitialBufferSize());
        this.assertEquals(def.getKeepAliveTimeout(), json.getKeepAliveTimeout());
        this.assertEquals(def.getHttp2KeepAliveTimeout(), json.getHttp2KeepAliveTimeout());
    }

    @Test
    public void testClientOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        int pipeliningLimit = TestUtils.randomPositiveInt();
        int http2MaxPoolSize = TestUtils.randomPositiveInt();
        int http2MultiplexingLimit = TestUtils.randomPositiveInt();
        int http2ConnectionWindowSize = TestUtils.randomPositiveInt();
        boolean tryUseCompression = rand.nextBoolean();
        HttpVersion protocolVersion = HttpVersion.HTTP_1_1;
        int maxChunkSize = TestUtils.randomPositiveInt();
        int maxInitialLineLength = TestUtils.randomPositiveInt();
        int maxHeaderSize = TestUtils.randomPositiveInt();
        int maxWaitQueueSize = TestUtils.randomPositiveInt();
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean h2cUpgrade = rand.nextBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        String localAddress = TestUtils.randomAlphaString(10);
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        int keepAliveTimeout = TestUtils.randomPositiveInt();
        int http2KeepAliveTimeout = TestUtils.randomPositiveInt();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("connectTimeout", Integer.valueOf(connectTimeout)).put("trustAll", Boolean.valueOf(trustAll)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("verifyHost", Boolean.valueOf(verifyHost)).put("maxPoolSize", Integer.valueOf(maxPoolSize)).put("keepAlive", Boolean.valueOf(keepAlive)).put("pipelining", Boolean.valueOf(pipelining)).put("pipeliningLimit", Integer.valueOf(pipeliningLimit)).put("http2MaxPoolSize", Integer.valueOf(http2MaxPoolSize)).put("http2MultiplexingLimit", Integer.valueOf(http2MultiplexingLimit)).put("http2ConnectionWindowSize", Integer.valueOf(http2ConnectionWindowSize)).put("tryUseCompression", Boolean.valueOf(tryUseCompression)).put("protocolVersion", protocolVersion.name()).put("maxChunkSize", Integer.valueOf(maxChunkSize)).put("maxInitialLineLength", Integer.valueOf(maxInitialLineLength)).put("maxHeaderSize", Integer.valueOf(maxHeaderSize)).put("maxWaitQueueSize", Integer.valueOf(maxWaitQueueSize)).put("initialSettings", new JsonObject().put("pushEnabled", Boolean.valueOf(initialSettings.isPushEnabled())).put("headerTableSize", Long.valueOf(initialSettings.getHeaderTableSize())).put("maxHeaderListSize", Long.valueOf(initialSettings.getMaxHeaderListSize())).put("maxConcurrentStreams", Long.valueOf(initialSettings.getMaxConcurrentStreams())).put("initialWindowSize", Integer.valueOf(initialSettings.getInitialWindowSize())).put("maxFrameSize", Integer.valueOf(initialSettings.getMaxFrameSize()))).put("useAlpn", Boolean.valueOf(useAlpn)).put(sslEngine, new JsonObject()).put("alpnVersions", new JsonArray().add(alpnVersions.get(0).name())).put("http2ClearTextUpgrade", Boolean.valueOf(h2cUpgrade)).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled)).put("localAddress", localAddress).put("decoderInitialBufferSize", Integer.valueOf(decoderInitialBufferSize)).put("keepAliveTimeout", Integer.valueOf(keepAliveTimeout)).put("http2KeepAliveTimeout", Integer.valueOf(http2KeepAliveTimeout));
        HttpClientOptions options = new HttpClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(verifyHost, options.isVerifyHost());
        this.assertEquals(maxPoolSize, options.getMaxPoolSize());
        this.assertEquals(keepAlive, options.isKeepAlive());
        this.assertEquals(pipelining, options.isPipelining());
        this.assertEquals(pipeliningLimit, options.getPipeliningLimit());
        this.assertEquals(http2MaxPoolSize, options.getHttp2MaxPoolSize());
        this.assertEquals(http2MultiplexingLimit, options.getHttp2MultiplexingLimit());
        this.assertEquals(http2ConnectionWindowSize, options.getHttp2ConnectionWindowSize());
        this.assertEquals(tryUseCompression, options.isTryUseCompression());
        this.assertEquals(protocolVersion, options.getProtocolVersion());
        this.assertEquals(maxChunkSize, options.getMaxChunkSize());
        this.assertEquals(maxInitialLineLength, options.getMaxInitialLineLength());
        this.assertEquals(maxHeaderSize, options.getMaxHeaderSize());
        this.assertEquals(maxWaitQueueSize, options.getMaxWaitQueueSize());
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(h2cUpgrade, options.isHttp2ClearTextUpgrade());
        this.assertEquals(localAddress, options.getLocalAddress());
        this.assertEquals(decoderInitialBufferSize, options.getDecoderInitialBufferSize());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
        json.put("protocolVersion", "invalidProtocolVersion");
        TestUtils.assertIllegalArgumentException(() -> new HttpClientOptions(json));
        this.assertEquals(keepAliveTimeout, options.getKeepAliveTimeout());
        this.assertEquals(http2KeepAliveTimeout, options.getHttp2KeepAliveTimeout());
    }

    @Test
    public void testCopyServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        KeyCertOptions keyCertOptions = TestUtils.randomKeyCertOptions();
        TrustOptions trustOptions = TestUtils.randomTrustOptions();
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebsocketFrameSize = TestUtils.randomPositiveInt();
        String wsSubProtocol = TestUtils.randomAlphaString(10);
        boolean is100ContinueHandledAutomatically = rand.nextBoolean();
        int maxChunkSize = rand.nextInt(10000);
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        int http2ConnectionWindowSize = TestUtils.randomInt();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean decompressionSupported = rand.nextBoolean();
        boolean acceptUnmaskedFrames = rand.nextBoolean();
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyCertOptions(keyCertOptions);
        options.setTrustOptions(trustOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setCompressionSupported(compressionSupported);
        options.setMaxWebsocketFrameSize(maxWebsocketFrameSize);
        options.setWebsocketSubProtocols(wsSubProtocol);
        options.setHandle100ContinueAutomatically(is100ContinueHandledAutomatically);
        options.setMaxChunkSize(maxChunkSize);
        options.setUseAlpn(useAlpn);
        options.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setInitialSettings(initialSettings);
        options.setAlpnVersions(alpnVersions);
        options.setDecompressionSupported(decompressionSupported);
        options.setAcceptUnmaskedFrames(acceptUnmaskedFrames);
        options.setDecoderInitialBufferSize(decoderInitialBufferSize);
        HttpServerOptions copy = new HttpServerOptions(options);
        this.checkCopyHttpServerOptions(options, copy);
        HttpServerOptions copy2 = new HttpServerOptions(options.toJson());
        this.checkCopyHttpServerOptions(options, copy2);
    }

    private void checkCopyHttpServerOptions(HttpServerOptions options, HttpServerOptions copy) {
        this.assertEquals(options.getSendBufferSize(), copy.getSendBufferSize());
        this.assertEquals(options.getReceiveBufferSize(), copy.getReceiveBufferSize());
        this.assertEquals(options.isReuseAddress(), copy.isReuseAddress());
        this.assertEquals(options.getTrafficClass(), copy.getTrafficClass());
        this.assertEquals(options.isTcpNoDelay(), copy.isTcpNoDelay());
        this.assertEquals(options.isTcpKeepAlive(), copy.isTcpKeepAlive());
        this.assertEquals(options.getSoLinger(), copy.getSoLinger());
        this.assertEquals(options.isUsePooledBuffers(), copy.isUsePooledBuffers());
        this.assertEquals(options.getIdleTimeout(), copy.getIdleTimeout());
        this.assertEquals(options.isSsl(), copy.isSsl());
        this.assertNotSame(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertEquals(options.getKeyCertOptions(), copy.getKeyCertOptions());
        this.assertNotSame(options.getTrustOptions(), copy.getTrustOptions());
        if (copy.getTrustOptions() instanceof PemTrustOptions) {
            this.assertEquals(((PemTrustOptions)options.getTrustOptions()).getCertValues(), ((PemTrustOptions)copy.getTrustOptions()).getCertValues());
        } else {
            this.assertEquals(options.getTrustOptions(), copy.getTrustOptions());
        }
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertEquals(options.getEnabledCipherSuites(), copy.getEnabledCipherSuites());
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(options.getCrlPaths().get(0), copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(options.getCrlValues().get(0), copy.getCrlValues().get(0));
        this.assertEquals(options.getPort(), copy.getPort());
        this.assertEquals(options.getHost(), copy.getHost());
        this.assertEquals(options.getAcceptBacklog(), copy.getAcceptBacklog());
        this.assertEquals(options.isCompressionSupported(), copy.isCompressionSupported());
        this.assertEquals(options.getMaxWebsocketFrameSize(), copy.getMaxWebsocketFrameSize());
        this.assertEquals(options.getWebsocketSubProtocols(), copy.getWebsocketSubProtocols());
        this.assertEquals(options.isHandle100ContinueAutomatically(), copy.isHandle100ContinueAutomatically());
        this.assertEquals(options.getMaxChunkSize(), copy.getMaxChunkSize());
        this.assertEquals(options.getInitialSettings(), copy.getInitialSettings());
        this.assertEquals(options.isUseAlpn(), copy.isUseAlpn());
        this.assertEquals(options.getHttp2ConnectionWindowSize(), copy.getHttp2ConnectionWindowSize());
        this.assertEquals(options.getSslEngineOptions(), copy.getSslEngineOptions());
        this.assertEquals(options.getAlpnVersions(), copy.getAlpnVersions());
        this.assertEquals(options.isDecompressionSupported(), copy.isDecompressionSupported());
        this.assertEquals(options.isAcceptUnmaskedFrames(), copy.isAcceptUnmaskedFrames());
        this.assertEquals(options.getDecoderInitialBufferSize(), copy.getDecoderInitialBufferSize());
    }

    @Test
    public void testDefaultServerOptionsJson() {
        HttpServerOptions def = new HttpServerOptions();
        HttpServerOptions json = new HttpServerOptions(new JsonObject());
        this.assertEquals(def.getMaxWebsocketFrameSize(), json.getMaxWebsocketFrameSize());
        this.assertEquals(def.getWebsocketSubProtocols(), json.getWebsocketSubProtocols());
        this.assertEquals(def.isCompressionSupported(), json.isCompressionSupported());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isHandle100ContinueAutomatically(), json.isHandle100ContinueAutomatically());
        this.assertEquals(def.getMaxChunkSize(), json.getMaxChunkSize());
        this.assertEquals(def.getMaxInitialLineLength(), json.getMaxInitialLineLength());
        this.assertEquals(def.getMaxHeaderSize(), json.getMaxHeaderSize());
        this.assertEquals(def.getInitialSettings(), json.getInitialSettings());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getAlpnVersions(), json.getAlpnVersions());
        this.assertEquals(def.getHttp2ConnectionWindowSize(), json.getHttp2ConnectionWindowSize());
        this.assertEquals(def.isDecompressionSupported(), json.isDecompressionSupported());
        this.assertEquals(def.isAcceptUnmaskedFrames(), json.isAcceptUnmaskedFrames());
        this.assertEquals(def.getDecoderInitialBufferSize(), json.getDecoderInitialBufferSize());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebsocketFrameSize = TestUtils.randomPositiveInt();
        String wsSubProtocol = TestUtils.randomAlphaString(10);
        boolean is100ContinueHandledAutomatically = rand.nextBoolean();
        int maxChunkSize = rand.nextInt(10000);
        int maxInitialLineLength = rand.nextInt(10000);
        int maxHeaderSize = rand.nextInt(10000);
        HttpVersion enabledProtocol = HttpVersion.values()[rand.nextInt(HttpVersion.values().length)];
        Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        boolean useAlpn = TestUtils.randomBoolean();
        int http2ConnectionWindowSize = TestUtils.randomInt();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        List<HttpVersion> alpnVersions = Collections.singletonList(HttpVersion.values()[TestUtils.randomPositiveInt() % 3]);
        boolean openSslSessionCacheEnabled = TestUtils.randomBoolean();
        boolean decompressionSupported = TestUtils.randomBoolean();
        boolean acceptUnmaskedFrames = TestUtils.randomBoolean();
        int decoderInitialBufferSize = TestUtils.randomPositiveInt();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("port", Integer.valueOf(port)).put("host", host).put("acceptBacklog", Integer.valueOf(acceptBacklog)).put("compressionSupported", Boolean.valueOf(compressionSupported)).put("maxWebsocketFrameSize", Integer.valueOf(maxWebsocketFrameSize)).put("websocketSubProtocols", wsSubProtocol).put("handle100ContinueAutomatically", Boolean.valueOf(is100ContinueHandledAutomatically)).put("maxChunkSize", Integer.valueOf(maxChunkSize)).put("maxInitialLineLength", Integer.valueOf(maxInitialLineLength)).put("maxHeaderSize", Integer.valueOf(maxHeaderSize)).put("enabledProtocols", new JsonArray().add(enabledProtocol.name())).put("initialSettings", new JsonObject().put("pushEnabled", Boolean.valueOf(initialSettings.isPushEnabled())).put("headerTableSize", Long.valueOf(initialSettings.getHeaderTableSize())).put("maxHeaderListSize", Long.valueOf(initialSettings.getMaxHeaderListSize())).put("maxConcurrentStreams", Long.valueOf(initialSettings.getMaxConcurrentStreams())).put("initialWindowSize", Integer.valueOf(initialSettings.getInitialWindowSize())).put("maxFrameSize", Integer.valueOf(initialSettings.getMaxFrameSize()))).put("useAlpn", Boolean.valueOf(useAlpn)).put("http2ConnectionWindowSize", Integer.valueOf(http2ConnectionWindowSize)).put(sslEngine, new JsonObject()).put("alpnVersions", new JsonArray().add(alpnVersions.get(0).name())).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled)).put("decompressionSupported", Boolean.valueOf(decompressionSupported)).put("acceptUnmaskedFrames", Boolean.valueOf(acceptUnmaskedFrames)).put("decoderInitialBufferSize", Integer.valueOf(decoderInitialBufferSize));
        HttpServerOptions options = new HttpServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(compressionSupported, options.isCompressionSupported());
        this.assertEquals(maxWebsocketFrameSize, options.getMaxWebsocketFrameSize());
        this.assertEquals(wsSubProtocol, options.getWebsocketSubProtocols());
        this.assertEquals(is100ContinueHandledAutomatically, options.isHandle100ContinueAutomatically());
        this.assertEquals(maxChunkSize, options.getMaxChunkSize());
        this.assertEquals(maxInitialLineLength, options.getMaxInitialLineLength());
        this.assertEquals(maxHeaderSize, options.getMaxHeaderSize());
        this.assertEquals(initialSettings, options.getInitialSettings());
        this.assertEquals(useAlpn, options.isUseAlpn());
        this.assertEquals(http2ConnectionWindowSize, options.getHttp2ConnectionWindowSize());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(alpnVersions, options.getAlpnVersions());
        this.assertEquals(decompressionSupported, options.isDecompressionSupported());
        this.assertEquals(acceptUnmaskedFrames, options.isAcceptUnmaskedFrames());
        this.assertEquals(decoderInitialBufferSize, options.getDecoderInitialBufferSize());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Override
    @Test
    public void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception {
        this.testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(0);
    }

    @Test
    public void testTimedOutWaiterDoesntConnect() throws Exception {
        long responseDelay = 300L;
        int requests = 6;
        this.client.close();
        CountDownLatch firstCloseLatch = new CountDownLatch(1);
        this.server.close(this.onSuccess(v -> firstCloseLatch.countDown()));
        this.awaitLatch(firstCloseLatch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setMaxPoolSize(1));
        AtomicInteger connectCount = new AtomicInteger(0);
        NetServer server = this.vertx.createNetServer(new NetServerOptions().setHost("localhost").setPort(8080));
        server.connectHandler(socket -> {
            connectCount.incrementAndGet();
            this.vertx.setTimer(responseDelay, time -> socket.write("HTTP/1.1 200 OK\r\nContent-Length: 2\r\n\r\nOK"));
        });
        CountDownLatch latch = new CountDownLatch(requests);
        server.listen(this.onSuccess(s -> {
            for (int count = 0; count < requests; ++count) {
                HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
                    this.assertEquals("OK", buff.toString());
                    latch.countDown();
                }));
                if (count % 2 == 1) {
                    req.setTimeout(responseDelay / 2L);
                    req.exceptionHandler(ex -> latch.countDown());
                }
                req.end();
            }
        }));
        this.awaitLatch(latch);
        this.assertEquals("Incorrect number of connect attempts.", (requests + 1) / 2, connectCount.get());
        server.close();
    }

    @Test
    public void testPipeliningOrder() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
        int requests = 100;
        AtomicInteger reqCount = new AtomicInteger(0);
        this.server.requestHandler(req -> {
            int theCount = reqCount.get();
            this.assertEquals(theCount, Integer.parseInt(req.headers().get("count")));
            reqCount.incrementAndGet();
            req.response().setChunked(true);
            req.bodyHandler(buff -> {
                this.assertEquals("This is content " + theCount, buff.toString());
                this.vertx.setTimer(1L + (long)(10.0 * Math.random()), id -> {
                    req.response().headers().set("count", String.valueOf(theCount));
                    req.response().write(buff);
                    req.response().end();
                });
            });
        });
        CountDownLatch latch = new CountDownLatch(requests);
        this.server.listen(this.onSuccess(s -> this.vertx.setTimer(500L, id -> {
            for (int count = 0; count < requests; ++count) {
                int theCount = count;
                HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> {
                    this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                    resp.bodyHandler(buff -> {
                        this.assertEquals("This is content " + theCount, buff.toString());
                        latch.countDown();
                    });
                });
                req.setChunked(true);
                req.headers().set("count", String.valueOf(count));
                req.write("This is content " + count);
                req.end();
            }
        })));
        this.awaitLatch(latch);
    }

    @Test
    public void testPipeliningLimit() throws Exception {
        int limit = 25;
        int requests = limit * 4;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setPipeliningLimit(limit).setMaxPoolSize(1));
        AtomicInteger count = new AtomicInteger();
        String data = "GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n";
        NetServer server = this.vertx.createNetServer(new NetServerOptions().setPort(8080).setHost("localhost"));
        server.connectHandler(so -> {
            StringBuilder total = new StringBuilder();
            so.handler(buff -> {
                total.append(buff);
                while (total.indexOf(data) == 0) {
                    total.delete(0, data.length());
                    if (count.incrementAndGet() != limit) continue;
                    this.vertx.setTimer(100L, timerID -> {
                        this.assertEquals(limit, count.get());
                        count.set(0);
                        for (int i = 0; i < limit; ++i) {
                            so.write("HTTP/1.1 200 OK\r\nContent-Length : 0\r\n\r\n");
                        }
                    });
                }
            });
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.listen(this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicInteger responses = new AtomicInteger();
        for (int i = 0; i < requests; ++i) {
            this.client.getNow(8080, "localhost", "/somepath", resp -> {
                this.assertEquals(200L, resp.statusCode());
                if (responses.incrementAndGet() == requests) {
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Repeat(times=10)
    @Test
    public void testCloseServerConnectionWithPendingMessages() throws Exception {
        int n = 5;
        this.server.requestHandler(req -> this.vertx.setTimer(100L, id -> req.response().close()));
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(n).setPipelining(true));
        AtomicBoolean completed = new AtomicBoolean();
        for (int i = 0; i < n * 2; ++i) {
            this.client.get(8080, "localhost", "some-uri", resp -> this.fail()).connectionHandler(conn -> conn.closeHandler(v -> {
                if (completed.compareAndSet(false, true)) {
                    this.testComplete();
                }
            })).end();
        }
        this.await();
    }

    @Test
    public void testPipeliningFailure() throws Exception {
        int n = 5;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setPipeliningLimit(n).setMaxPoolSize(1));
        CompletableFuture<Object> closeFuture = new CompletableFuture<Object>();
        AtomicBoolean first = new AtomicBoolean(true);
        this.server.requestHandler(req -> {
            if (first.compareAndSet(true, false)) {
                closeFuture.thenAccept(v -> req.response().close());
            } else {
                req.response().end();
            }
        });
        this.startServer();
        AtomicInteger succeeded = new AtomicInteger();
        ArrayList<HttpClientRequest> requests = new ArrayList<HttpClientRequest>();
        for (int i = 0; i < n * 2; ++i) {
            HttpClientRequest req2 = this.client.get(8080, "localhost", "/" + i);
            req2.handler(resp -> {
                succeeded.incrementAndGet();
                requests.remove(req2);
                if (requests.isEmpty()) {
                    this.assertEquals(n * 2 - 1, succeeded.get());
                    this.testComplete();
                }
            });
            req2.exceptionHandler(err -> {
                requests.remove(req2);
                for (HttpClientRequest r : requests) {
                    r.end();
                }
            }).sendHead();
            requests.add(req2);
        }
        closeFuture.complete(null);
        this.await();
    }

    @Test
    public void testServerPipeliningConnectionConcurrency() throws Exception {
        int n = 5;
        boolean[] processing = new boolean[]{false};
        int[] count = new int[]{0};
        this.server.requestHandler(req -> {
            count[0] = count[0] + 1;
            this.assertFalse(processing[0]);
            processing[0] = true;
            this.vertx.setTimer(20L, id -> {
                processing[0] = false;
                HttpServerResponse resp = req.response();
                resp.end();
                if (count[0] == n) {
                    resp.close();
                }
            });
        });
        this.startServer();
        Buffer requests = Buffer.buffer();
        for (int i = 0; i < n; ++i) {
            requests.appendString("GET some-uri HTTP/1.1\r\n\r\n");
        }
        NetClient client = this.vertx.createNetClient();
        client.connect(8080, "localhost", this.onSuccess(so -> {
            so.closeHandler(v -> this.testComplete());
            so.write(requests);
        }));
        this.await();
    }

    @Test
    public void testKeepAlive() throws Exception {
        this.testKeepAlive(true, 5, 10, 5);
    }

    @Test
    public void testNoKeepAlive() throws Exception {
        this.testKeepAlive(false, 5, 10, 10);
    }

    private void testKeepAlive(boolean keepAlive, int poolSize, int numServers, int expectedConnectedServers) throws Exception {
        this.client.close();
        CountDownLatch firstCloseLatch = new CountDownLatch(1);
        this.server.close(this.onSuccess(v -> firstCloseLatch.countDown()));
        this.awaitLatch(firstCloseLatch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(keepAlive).setPipelining(false).setMaxPoolSize(poolSize));
        int requests = 100;
        HttpServer[] servers = new HttpServer[numServers];
        CountDownLatch startServerLatch = new CountDownLatch(numServers);
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        for (int i = 0; i < numServers; ++i) {
            HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080));
            server.requestHandler(arg_0 -> Http1xTest.lambda$testKeepAlive$65((Set)connectedServers, server, arg_0));
            server.listen(ar -> {
                this.assertTrue(ar.succeeded());
                startServerLatch.countDown();
            });
            servers[i] = server;
        }
        this.awaitLatch(startServerLatch);
        CountDownLatch reqLatch = new CountDownLatch(requests);
        this.vertx.runOnContext(v -> {
            for (int count = 0; count < requests; ++count) {
                this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    reqLatch.countDown();
                }).end();
            }
        });
        this.awaitLatch(reqLatch);
        this.assertEquals(expectedConnectedServers, connectedServers.size());
        CountDownLatch serverCloseLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                serverCloseLatch.countDown();
            });
        }
        this.awaitLatch(serverCloseLatch);
    }

    @Test
    public void testPoolingKeepAliveAndPipelining() {
        this.testPooling(true, true);
    }

    @Test
    public void testPoolingKeepAliveNoPipelining() {
        this.testPooling(true, false);
    }

    @Test
    public void testPoolingNoKeepAliveNoPipelining() {
        this.testPooling(false, false);
    }

    private void testPooling(boolean keepAlive, boolean pipelining) {
        String path = "foo.txt";
        int numGets = 100;
        int maxPoolSize = 10;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(keepAlive).setPipelining(pipelining).setMaxPoolSize(maxPoolSize));
        this.server.requestHandler(req -> {
            String cnt = req.headers().get("count");
            req.response().headers().set("count", cnt);
            req.response().end();
        });
        AtomicBoolean completeAlready = new AtomicBoolean();
        this.server.listen(this.onSuccess(s -> {
            AtomicInteger cnt = new AtomicInteger(0);
            for (int i = 0; i < numGets; ++i) {
                int theCount = i;
                HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path, resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                    if (cnt.incrementAndGet() == numGets) {
                        this.testComplete();
                    }
                });
                req.exceptionHandler(t -> this.fail("Should not throw exception: " + t.getMessage()));
                req.headers().set("count", String.valueOf(i));
                req.end();
            }
        }));
        this.await();
    }

    @Test
    public void testPoolingNoKeepAliveAndPipelining() {
        try {
            this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setPipelining(true));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxWaitQueueSizeIsRespected() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultHost("localhost").setDefaultPort(8080).setPipelining(false).setMaxWaitQueueSize(0).setMaxPoolSize(2));
        this.waitFor(3);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("/1", "/2"));
        this.server.requestHandler(req -> {
            this.assertTrue(expected.contains(req.path()));
            this.complete();
        });
        this.startServer();
        HttpClientRequest req1 = this.client.get("/1", resp -> this.fail("Should not be called."));
        HttpClientRequest req2 = this.client.get("/2", resp -> this.fail("Should not be called."));
        HttpClientRequest req3 = this.client.get("/3", resp -> this.fail("Should not be called."));
        req3.exceptionHandler(t -> {
            this.assertTrue("Incorrect exception: " + t.getClass().getName(), t instanceof ConnectionPoolTooBusyException);
            this.complete();
        });
        req1.end();
        req2.end();
        req3.end();
        this.await();
    }

    @Test
    public void testRequestTimeoutExtendedWhenResponseChunksReceived() {
        long timeout = 2000L;
        int numChunks = 100;
        AtomicInteger count = new AtomicInteger(0);
        long interval = timeout * 2L / (long)numChunks;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.vertx.setPeriodic(interval, timerID -> {
                req.response().write("foo");
                if (count.incrementAndGet() == numChunks) {
                    req.response().end();
                    this.vertx.cancelTimer(timerID.longValue());
                }
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.endHandler(v -> this.testComplete());
            });
            req.exceptionHandler(t -> this.fail("Should not be called"));
            req.setTimeout(timeout);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerWebsocketIdleTimeout() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost"));
        this.server.websocketHandler(ws -> {}).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", "/", ws -> ws.closeHandler(v -> this.testComplete()));
        });
        this.await();
    }

    @Test
    public void testClientWebsocketIdleTimeout() {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setIdleTimeout(1));
        this.server.websocketHandler(ws -> {}).listen(ar -> this.client.websocket(8080, "localhost", "/", ws -> ws.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        this.client.close();
        this.server.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false));
        int numServers = 5;
        int numRequests = numServers * 100;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        Set connectedServers = Collections.newSetFromMap(new ConcurrentHashMap());
        ConcurrentHashMap requestCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numRequests);
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        for (int i = 0; i < numServers; ++i) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
            servers.add(theServer);
            AtomicReference context = new AtomicReference();
            theServer.requestHandler(arg_0 -> this.lambda$testSharedServersRoundRobin$93(context, (Set)contexts, connectedServers, theServer, requestCount, latchConns, arg_0)).listen(this.onSuccess(s -> {
                this.assertEquals(8080L, s.actualPort());
                latchListen.countDown();
            }));
        }
        this.awaitLatch(latchListen);
        CountDownLatch latchClient = new CountDownLatch(numRequests);
        for (int i = 0; i < numRequests; ++i) {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", res -> latchClient.countDown()).end();
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, requestCount.size());
        Iterator<Object> i = requestCount.values().iterator();
        while (i.hasNext()) {
            int cnt = (Integer)i.next();
            this.assertEquals(numRequests / numServers, cnt);
        }
        this.assertEquals(numServers, contexts.size());
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8081));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        theServer.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testDefaultHttpVersion() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testIncorrectHttpVersion() throws Exception {
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.write(Buffer.buffer((String)"HTTP/1.2 200 OK\r\nContent-Length:5\r\n\r\nHELLO"));
            so.close();
        });
        this.startServer();
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not be called"));
        req2.exceptionHandler(err -> {
            this.assertTrue("message " + err.getMessage() + " should contain HTTP/1.2", err.getMessage().contains("HTTP/1.2"));
            req2.connection().closeHandler(v -> this.testComplete());
        }).putHeader("connection", "close").end();
        this.await();
    }

    @Test
    public void testHttp11PersistentConnectionNotClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            this.assertNull(req.getHeader("Connection"));
            req.response().end();
            this.assertFalse(req.response().closed());
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setKeepAlive(true));
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertNull(resp.getHeader("Connection"));
                this.assertEquals(resp.getHeader("Content-Length"), "0");
                this.testComplete();
            }));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testHttp11NonPersistentConnectionClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            this.assertEquals(req.getHeader("Connection"), "close");
            req.response().end();
            this.assertTrue(req.response().closed());
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setKeepAlive(false));
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertEquals(resp.getHeader("Connection"), "close");
                this.testComplete();
            }));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testHttp10KeepAliveConnectionNotClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_0, req.version());
            this.assertEquals(req.getHeader("Connection"), "keep-alive");
            req.response().end();
            this.assertFalse(req.response().closed());
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0).setKeepAlive(true));
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertEquals(resp.getHeader("Connection"), "keep-alive");
                this.assertEquals(resp.getHeader("Content-Length"), "0");
                this.testComplete();
            }));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testHttp10NonKeepAliveConnectionClosed() throws Exception {
        this.client.close();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_0, req.version());
            this.assertNull(req.getHeader("Connection"));
            req.response().end();
            this.assertTrue(req.response().closed());
        });
        this.server.listen(this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0).setKeepAlive(false));
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertNull(resp.getHeader("Connection"));
                this.testComplete();
            }));
            req.end();
        }));
        this.await();
    }

    @Test
    public void requestAbsNoPort() {
        this.client.requestAbs(HttpMethod.GET, "http://www.google.com", res -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testAccessNetSocket() throws Exception {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().headers().set("HTTP/1.1", "101 Upgrade");
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertNotNull(resp.netSocket());
                this.testComplete();
            }));
            req.headers().set("content-length", String.valueOf(toSend.length()));
            req.write(toSend);
        }));
        this.await();
    }

    @Test
    public void testHttpConnect() {
        Buffer buffer = TestUtils.randomBuffer(128);
        Buffer received = Buffer.buffer();
        this.vertx.createNetServer(new NetServerOptions().setPort(1235)).connectHandler(socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0))).listen(this.onSuccess(netServer -> {
            this.server.requestHandler(req -> this.vertx.createNetClient(new NetClientOptions()).connect(netServer.actualPort(), "localhost", this.onSuccess(socket -> {
                req.response().setStatusCode(200);
                req.response().setStatusMessage("Connection established");
                req.response().end();
                Pump.pump((ReadStream)req.netSocket(), (WriteStream)socket).start();
                Pump.pump((ReadStream)socket, (WriteStream)req.netSocket()).start();
                req.netSocket().closeHandler(v -> socket.close());
            })));
            this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.CONNECT, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                NetSocket socket = resp.netSocket();
                socket.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == buffer.length()) {
                        netServer.close();
                        this.assertEquals(buffer, received);
                        this.testComplete();
                    }
                });
                socket.write(buffer);
            }).end()));
        }));
        this.await();
    }

    @Test
    public void testRequestsTimeoutInQueue() {
        this.server.requestHandler(req -> this.vertx.setTimer(1000L, id -> req.response().end()));
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setMaxPoolSize(1));
        this.server.listen(this.onSuccess(s -> {
            for (int i = 0; i < 5; ++i) {
                HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not be called"));
                req.exceptionHandler(t -> this.assertTrue(t instanceof TimeoutException));
                req.setTimeout(500L);
                req.end();
            }
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
            req.exceptionHandler(t -> this.fail("Should not throw exception"));
            req.setTimeout(3000L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        HttpServerOptions options = new HttpServerOptions().setHost("localhost").setPort(8080);
        HttpServer server = this.vertx.createHttpServer(options);
        options.setPort(8081);
        server.requestHandler(req -> req.response().end());
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.request(HttpMethod.GET, 8080, "localhost", "/uri", res -> {
                this.assertEquals(200L, res.statusCode());
                this.testComplete();
            }).end();
        });
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientOptions options = new HttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
            options.setSsl(true);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/uri", res -> {
                this.assertEquals(200L, res.statusCode());
                this.testComplete();
            }).end();
        });
        this.await();
    }

    @Test
    public void testClientContextWithKeepAlive() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(false).setMaxPoolSize(1));
        this.testClientContext();
    }

    @Test
    public void testClientContextWithPipelining() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
        this.testClientContext();
    }

    private void testClientContext() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        Set contexts = Collections.synchronizedSet(new HashSet());
        Set connections = Collections.synchronizedSet(new HashSet());
        Handler checker = response -> {
            contexts.add(Vertx.currentContext());
            connections.add(response.request().connection());
        };
        HttpClientRequest req1 = this.client.get(8080, "localhost", "/2");
        req1.handler(checker).exceptionHandler(this::fail);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/3");
        req2.handler(checker).exceptionHandler(this::fail);
        CompletableFuture fut = new CompletableFuture();
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            HttpClientRequest req3 = this.client.get(8080, "localhost", "/4");
            req3.handler(resp -> {
                this.assertEquals(1L, contexts.size());
                this.assertEquals(1L, connections.size());
                this.assertNotSame(Vertx.currentContext(), ctx);
                this.testComplete();
            });
            req3.exceptionHandler(this::fail);
            fut.complete(req3);
        });
        HttpClientRequest req3 = (HttpClientRequest)fut.get(10L, TimeUnit.SECONDS);
        req1.end();
        req2.end();
        req3.end();
        this.await();
    }

    @Test
    public void testContexts() throws Exception {
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        AtomicInteger cnt = new AtomicInteger();
        AtomicReference serverRequestContext = new AtomicReference();
        this.server.requestHandler(req -> {
            ContextImpl serverContext = ((VertxInternal)this.vertx).getContext();
            if (serverRequestContext.get() != null) {
                this.assertSame(serverRequestContext.get(), serverContext);
            } else {
                serverRequestContext.set(serverContext);
            }
            req.response().end();
        });
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference listenContext = new AtomicReference();
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            listenContext.set(((VertxInternal)this.vertx).getContext());
            latch.countDown();
        });
        this.awaitLatch(latch);
        CountDownLatch latch2 = new CountDownLatch(1);
        int numReqs = 16;
        int numConns = 8;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(numConns));
        for (int i = 0; i < numReqs; ++i) {
            this.client.request(HttpMethod.GET, 8080, "localhost", "/", arg_0 -> this.lambda$testContexts$159((Set)contexts, cnt, numReqs, numConns, latch2, arg_0)).exceptionHandler(this::fail).end();
        }
        this.awaitLatch(latch2);
        this.server.close(arg_0 -> this.lambda$testContexts$160((Set)contexts, serverRequestContext, listenContext, arg_0));
        this.server = null;
        this.await();
    }

    @Test
    public void testRequestHandlerNotCalledInvalidRequest() {
        this.server.requestHandler(req -> this.fail());
        this.server.listen(this.onSuccess(s -> this.vertx.createNetClient(new NetClientOptions()).connect(8080, "127.0.0.1", this.onSuccess(socket -> {
            socket.closeHandler(r -> this.testComplete());
            socket.write("GET HTTP1/1\r\n");
            socket.write("X-Header: test\r\n");
        }))));
        this.await();
    }

    @Test
    public void testTwoServersSameAddressDifferentContext() throws Exception {
        this.vertx.deployVerticle(SimpleServer.class.getName(), new DeploymentOptions().setInstances(2), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testInWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                Http1xTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                Http1xTest.this.assertTrue(Context.isOnWorkerThread());
                HttpServer server1 = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080));
                server1.requestHandler(req -> {
                    Http1xTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    Http1xTest.this.assertTrue(Context.isOnWorkerThread());
                    Buffer buf = Buffer.buffer();
                    req.handler(arg_0 -> ((Buffer)buf).appendBuffer(arg_0));
                    req.endHandler(v -> {
                        Http1xTest.this.assertEquals("hello", buf.toString());
                        req.response().end("bye");
                    });
                }).listen(Http1xTest.this.onSuccess(s -> {
                    Http1xTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    Http1xTest.this.assertTrue(Context.isOnWorkerThread());
                    HttpClient client = this.vertx.createHttpClient();
                    client.put(8080, "localhost", "/blah", resp -> {
                        Http1xTest.this.assertEquals(200L, resp.statusCode());
                        Http1xTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        Http1xTest.this.assertTrue(Context.isOnWorkerThread());
                        resp.handler(buf -> {
                            Http1xTest.this.assertEquals("bye", buf.toString());
                            resp.endHandler(v -> Http1xTest.this.testComplete());
                        });
                    }).setChunked(true).write(Buffer.buffer((String)"hello")).end();
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testPauseResumeClientResponse() {
        byte[] data = new byte[0x4000000];
        new Random().nextBytes(data);
        Buffer buffer = Buffer.buffer((byte[])data);
        Buffer readBuffer = Buffer.buffer((int)0x4000000);
        this.server.requestHandler(request -> {
            request.response().setChunked(true);
            for (int i = 0; i < buffer.length() / 8192; ++i) {
                request.response().write(buffer.slice(i * 8192, (i + 1) * 8192));
            }
            request.response().end();
        });
        this.server.listen(10000, this.onSuccess(hs -> {
            HttpClient httpClient = this.vertx.createHttpClient();
            HttpClientRequest clientRequest = httpClient.get(10000, "localhost", "/");
            clientRequest.handler(resp -> resp.handler(b -> {
                readBuffer.appendBuffer(b);
                for (int i = 0; i < 64; ++i) {
                    this.vertx.setTimer(1L, n -> {
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    });
                }
                resp.endHandler(v -> {
                    byte[] expectedData = buffer.getBytes();
                    byte[] actualData = readBuffer.getBytes();
                    this.assertTrue(Arrays.equals(expectedData, actualData));
                    this.testComplete();
                });
            }));
            clientRequest.end();
        }));
        this.await();
    }

    @Test
    public void testPauseResumeServerRequestFromAnotherThread() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Buffer buffer = TestUtils.randomBuffer(0x4000000);
        Buffer readBuffer = Buffer.buffer((int)0x4000000);
        this.server.requestHandler(request -> {
            request.handler(b -> {
                readBuffer.appendBuffer(b);
                request.pause();
                exec.execute(() -> {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    request.resume();
                });
            });
            request.endHandler(v -> {
                byte[] expectedData = buffer.getBytes();
                byte[] actualData = readBuffer.getBytes();
                this.assertTrue(Arrays.equals(expectedData, actualData));
                this.testComplete();
            });
        });
        this.startServer();
        HttpClientRequest req = this.client.get(8080, "localhost", "/", resp -> this.fail());
        req.setChunked(true);
        for (int i = 0; i < buffer.length() / 8192; ++i) {
            req.write(buffer.slice(i * 8192, (i + 1) * 8192));
            Thread.sleep(0L, 100);
        }
        req.end();
    }

    @Test
    public void testEndServerResponseResumeTheConnection() throws Exception {
        this.server.requestHandler(req -> req.endHandler(v -> {
            req.pause();
            req.response().end();
        }));
        this.startServer();
        this.client.close();
        this.waitFor(2);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setMaxPoolSize(1));
        this.client.getNow(8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        });
        this.client.getNow(8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        });
        this.await();
    }

    @Test
    public void testEndServerRequestResumeTheConnection() throws Exception {
        this.server.requestHandler(req -> {
            req.response().end();
            req.endHandler(v -> req.pause());
        });
        this.startServer();
        this.client.close();
        this.waitFor(2);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setMaxPoolSize(1));
        this.client.put(8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }).end("1");
        this.client.put(8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.complete();
        }).end("2");
        this.await();
    }

    @Test
    public void testMultipleRecursiveCallsAndPipelining() throws Exception {
        int sendRequests = 100;
        AtomicInteger receivedRequests = new AtomicInteger();
        this.server.requestHandler(x -> x.response().end("hello")).listen(8080, r -> {
            if (r.succeeded()) {
                HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setDefaultPort(8080));
                IntStream.range(0, 5).forEach(i -> this.recursiveCall(client, receivedRequests, sendRequests));
            }
        });
        this.await();
    }

    private void recursiveCall(HttpClient client, AtomicInteger receivedRequests, int sendRequests) {
        client.getNow("/", r -> {
            int numRequests = receivedRequests.incrementAndGet();
            if (numRequests == sendRequests) {
                this.testComplete();
            } else if (numRequests < sendRequests) {
                this.recursiveCall(client, receivedRequests, sendRequests);
            }
        });
    }

    @Test
    public void testUnsupportedHttpVersion() throws Exception {
        this.testUnsupported("GET /someuri HTTP/1.7\r\nHost: localhost\r\n\r\n", false);
    }

    private void testUnsupported(String rawReq, boolean method) throws Exception {
        this.server.requestHandler(req -> {
            try {
                if (method) {
                    req.method();
                } else {
                    req.version();
                }
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }).listen(8080, r -> {
            if (r.succeeded()) {
                NetClient client = this.vertx.createNetClient();
                client.connect(8080, "localhost", this.onSuccess(conn -> {
                    conn.write(rawReq);
                    Buffer respBuff = Buffer.buffer();
                    conn.handler(arg_0 -> ((Buffer)respBuff).appendBuffer(arg_0));
                    conn.closeHandler(v -> {
                        this.assertTrue(respBuff.toString().contains("501 Not Implemented"));
                        client.close();
                        this.testComplete();
                    });
                }));
            }
        });
        this.await();
    }

    @Test
    public void testTwoServersDifferentEventLoopsCloseOne() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(2);
        AtomicInteger server1Count = new AtomicInteger();
        AtomicInteger server2Count = new AtomicInteger();
        this.server.requestHandler(req -> {
            server1Count.incrementAndGet();
            req.response().end();
        }).listen(8080, this.onSuccess(s -> latch1.countDown()));
        HttpServer server2 = this.vertx.createHttpServer().requestHandler(req -> {
            server2Count.incrementAndGet();
            req.response().end();
        }).listen(8080, this.onSuccess(s -> latch1.countDown()));
        this.awaitLatch(latch1);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setDefaultPort(8080));
        for (int i = 0; i < 2; ++i) {
            CountDownLatch latch2 = new CountDownLatch(1);
            client.getNow("/", resp -> {
                this.assertEquals(200L, resp.statusCode());
                latch2.countDown();
            });
            this.awaitLatch(latch2);
        }
        CountDownLatch latch3 = new CountDownLatch(1);
        server2.close(this.onSuccess(v -> latch3.countDown()));
        this.awaitLatch(latch3);
        for (int i = 0; i < 2; ++i) {
            CountDownLatch latch2 = new CountDownLatch(1);
            client.getNow("/", resp -> {
                this.assertEquals(200L, resp.statusCode());
                latch2.countDown();
            });
            this.awaitLatch(latch2);
        }
        this.assertEquals(3L, server1Count.get());
        this.assertEquals(1L, server2Count.get());
    }

    @Test
    public void testSetWriteQueueMaxSize() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setWriteQueueMaxSize(262144);
            resp.setWriteQueueMaxSize(524288);
            resp.setWriteQueueMaxSize(131072);
            resp.setWriteQueueMaxSize(132096);
            resp.end();
        }).listen(8080, this.onSuccess(s -> this.client.getNow(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testServerMaxInitialLineLength() {
        this.testServerMaxInitialLineLength(4096);
    }

    @Test
    public void testServerMaxInitialLineLengthOption() {
        this.testServerMaxInitialLineLength(5017);
    }

    private void testServerMaxInitialLineLength(int maxInitialLength) {
        String longParam = TestUtils.randomAlphaString(5000);
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setMaxInitialLineLength(maxInitialLength).setHost("localhost").setPort(8080)).requestHandler(req -> {
            this.assertEquals(req.getParam("t"), longParam);
            req.response().end();
        }).listen(this.onSuccess(res -> {
            HttpClientRequest req = this.vertx.createHttpClient(new HttpClientOptions()).request(HttpMethod.GET, 8080, "localhost", "/?t=" + longParam);
            req.handler(resp -> {
                if (maxInitialLength > 4096) {
                    this.assertEquals(200L, resp.statusCode());
                    this.testComplete();
                } else {
                    this.assertEquals(414L, resp.statusCode());
                    req.connection().closeHandler(v -> this.testComplete());
                }
            });
            req.end();
        }));
        this.await();
    }

    @Test
    public void testClientMaxInitialLineLengthOption() {
        String longParam = TestUtils.randomAlphaString(5000);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> so.write("HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\nA; name=\"" + longParam + "\"\r\n0123456789\r\n0\r\n\r\n"));
        try {
            server.listen(8080, "localhost", this.onSuccess(v -> this.vertx.createHttpClient(new HttpClientOptions().setMaxInitialLineLength(6000)).request(HttpMethod.GET, 8080, "localhost", "/?t=" + longParam, resp -> resp.bodyHandler(body -> {
                this.assertEquals("0123456789", body.toString());
                this.testComplete();
            })).end()));
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testClientMaxHeaderSizeOption() {
        String longHeader = TestUtils.randomAlphaString(9000);
        this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080)).requestHandler(req -> req.response().putHeader("t", longHeader).end()).listen(this.onSuccess(res -> {
            HttpClientRequest req = this.vertx.createHttpClient(new HttpClientOptions().setMaxHeaderSize(10000)).request(HttpMethod.GET, 8080, "localhost", "/", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals(resp.getHeader("t"), longHeader);
                this.testComplete();
            });
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerMaxHeaderSize() {
        this.testServerMaxHeaderSize(8192);
    }

    @Test
    public void testServerMaxHeaderSizeOption() {
        this.testServerMaxHeaderSize(10000);
    }

    private void testServerMaxHeaderSize(int maxHeaderSize) {
        String longHeader = TestUtils.randomAlphaString(9000);
        this.vertx.createHttpServer(new HttpServerOptions().setMaxHeaderSize(maxHeaderSize).setHost("localhost").setPort(8080)).requestHandler(req -> {
            this.assertEquals(req.getHeader("t"), longHeader);
            req.response().end();
        }).listen(this.onSuccess(res -> {
            HttpClientRequest req = this.vertx.createHttpClient(new HttpClientOptions()).request(HttpMethod.GET, 8080, "localhost", "/");
            req.handler(resp -> {
                if (maxHeaderSize > 8192) {
                    this.assertEquals(200L, resp.statusCode());
                    this.testComplete();
                } else {
                    this.assertEquals(400L, resp.statusCode());
                    req.connection().closeHandler(v -> this.testComplete());
                }
            });
            req.putHeader("t", longHeader);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testInvalidHttpResponse() {
        this.waitFor(2);
        AtomicInteger count = new AtomicInteger(0);
        CompletableFuture sendResp = new CompletableFuture();
        NetServer server = this.vertx.createNetServer();
        String match = "GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n";
        server.connectHandler(so -> {
            StringBuilder content = new StringBuilder();
            so.handler(buff -> {
                content.append(buff);
                block4: while (content.toString().startsWith(match)) {
                    content.delete(0, match.length());
                    switch (count.getAndIncrement()) {
                        case 0: {
                            sendResp.thenAccept(v -> {});
                            continue block4;
                        }
                        case 1: {
                            Buffer resp1 = Buffer.buffer((String)(TestUtils.randomAlphaString(40) + "\r\n"));
                            Buffer resp2 = Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n");
                            so.write(Buffer.buffer().appendBuffer(resp1).appendBuffer(resp2));
                            continue block4;
                        }
                    }
                    this.fail();
                }
            });
        }).listen(8080, "localhost", this.onSuccess(s -> {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
            AtomicBoolean fail1 = new AtomicBoolean();
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/somepath", resp -> this.fail()).exceptionHandler(err -> {
                if (fail1.compareAndSet(false, true)) {
                    this.assertEquals(IllegalArgumentException.class, err.getClass());
                    this.complete();
                }
            });
            AtomicBoolean fail2 = new AtomicBoolean();
            HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath", resp -> resp.bodyHandler(buff -> {
                this.assertEquals("okusa", buff.toString());
                this.testComplete();
            })).exceptionHandler(err -> {
                if (fail2.compareAndSet(false, true)) {
                    this.assertEquals(VertxException.class, err.getClass());
                    this.complete();
                }
            });
            req1.end();
            req2.end();
        }));
        this.await();
    }

    @Test
    public void testHandleInvalid204Response() throws Exception {
        int numReq = 3;
        this.waitFor(3);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setPipelining(true).setKeepAlive(true).setMaxPoolSize(1));
        ArrayList received = new ArrayList();
        this.server.requestHandler(r -> r.response().setChunked(true).setStatusCode(204).end()).listen(8080, "localhost", this.onSuccess(v1 -> {
            for (int i = 0; i < numReq; ++i) {
                HttpClientRequest post = this.client.post(8080, "localhost", "/somepath");
                post.handler(r -> r.endHandler(v2 -> this.complete())).exceptionHandler(err -> this.complete()).end();
            }
        }));
        this.await();
    }

    @Test
    public void testConnectionCloseHttp_1_0_NoClose() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)req -> {
            req.putHeader("Connection", "close");
            req.end();
        }), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.0 200 OK\nContent-Type: text/plain\nContent-Length: 4\nConnection: keep-alive\n\nxxx\n");
                } else {
                    socket.write("HTTP/1.0 200 OK\nContent-Type: text/plain\nContent-Length: 1\n\n\n");
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_0_Close() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)req -> {
            req.putHeader("Connection", "close");
            req.end();
        }), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.0 200 OK\nContent-Type: text/plain\nContent-Length: 4\nConnection: keep-alive\n\nxxx\n");
                } else {
                    socket.write("HTTP/1.0 200 OK\nContent-Type: text/plain\nContent-Length: 1\n\n\n");
                    socket.close();
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_1_NoClose() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)HttpClientRequest::end), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 4\r\n\r\nxxx\n");
                } else {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 1\r\nConnection: close\r\n\r\n\r\n");
                }
            }));
        }));
    }

    @Test
    public void testConnectionCloseHttp_1_1_Close() throws Exception {
        this.testConnectionClose((Handler<HttpClientRequest>)((Handler)HttpClientRequest::end), (Handler<NetSocket>)((Handler)socket -> {
            AtomicBoolean firstRequest = new AtomicBoolean(true);
            socket.handler((Handler)RecordParser.newDelimited((String)"\r\n\r\n", buffer -> {
                if (firstRequest.getAndSet(false)) {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 3\r\n\r\nxxx");
                } else {
                    socket.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 0\r\nConnection: close\r\n\r\n");
                    socket.close();
                }
            }));
        }));
    }

    private void testConnectionClose(Handler<HttpClientRequest> clientRequest, Handler<NetSocket> connectHandler) throws Exception {
        this.client.close();
        this.server.close();
        NetServerOptions serverOptions = new NetServerOptions();
        CountDownLatch serverLatch = new CountDownLatch(1);
        this.vertx.createNetServer(serverOptions).connectHandler(connectHandler).listen(8080, result -> {
            if (result.succeeded()) {
                serverLatch.countDown();
            } else {
                this.fail();
            }
        });
        this.awaitLatch(serverLatch);
        HttpClientOptions clientOptions = new HttpClientOptions().setDefaultHost("localhost").setDefaultPort(8080).setKeepAlive(true).setPipelining(false);
        this.client = this.vertx.createHttpClient(clientOptions);
        int requests = 11;
        AtomicInteger count = new AtomicInteger(requests);
        for (int i = 0; i < requests; ++i) {
            HttpClientRequest req = this.client.get("/", resp -> {
                resp.bodyHandler(buffer -> {});
                resp.endHandler(v -> {
                    if (count.decrementAndGet() == 0) {
                        this.complete();
                    }
                });
                resp.exceptionHandler(th -> this.fail());
            }).exceptionHandler(th -> this.fail());
            clientRequest.handle((Object)req);
        }
        this.await();
    }

    @Test
    public void testDontReuseConnectionWhenResponseEndsDuringAnOngoingRequest() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
        this.server.requestHandler(req -> req.response().end());
        CountDownLatch serverLatch = new CountDownLatch(1);
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            serverLatch.countDown();
        });
        this.awaitLatch(serverLatch);
        HttpClientRequest req1 = this.client.get(8080, "localhost", "/");
        req1.handler(resp -> resp.endHandler(v1 -> this.vertx.setTimer(100L, v2 -> req1.end())));
        req1.sendHead();
        this.client.get(8080, "localhost", "/", resp -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testRecyclePipelinedConnection() throws Exception {
        CountDownLatch listenLatch = new CountDownLatch(1);
        CountDownLatch doneLatch = new CountDownLatch(2);
        ArrayList responses = new ArrayList();
        this.server.requestHandler(req -> {
            responses.add(req.path());
            req.response().end();
            doneLatch.countDown();
        });
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
        CountDownLatch respLatch = new CountDownLatch(2);
        HttpClientRequestImpl req2 = (HttpClientRequestImpl)this.client.get(8080, "localhost", "/first", resp -> this.fail());
        req2.handleException(new Throwable());
        req2.end();
        this.client.get(8080, "localhost", "/second", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v -> respLatch.countDown());
        }).exceptionHandler(this::fail).end();
        this.client.get(8080, "localhost", "/third", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v -> respLatch.countDown());
        }).exceptionHandler(this::fail).end();
        this.awaitLatch(doneLatch);
        this.assertEquals(Arrays.asList("/second", "/third"), responses);
        this.awaitLatch(respLatch);
        this.server.close();
    }

    @Test
    public void testClientConnectionExceptionHandler() throws Exception {
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.write(Buffer.buffer((String)(TestUtils.randomAlphaString(40) + "\r\n")));
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> {});
        req2.connectionHandler(conn -> conn.exceptionHandler(err -> this.testComplete()));
        req2.sendHead();
        this.await();
    }

    @Test
    public void testServerConnectionExceptionHandler() throws Exception {
        this.server.connectionHandler(conn -> conn.exceptionHandler(err -> {
            this.assertTrue(err instanceof TooLongFrameException);
            this.testComplete();
        }));
        this.server.requestHandler(req -> req.response().end());
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1));
        this.client.getNow(8080, "localhost", "/somepath", resp1 -> {
            HttpClientRequest req = this.client.post(8080, "localhost", "/somepath", resp2 -> {});
            req.putHeader("the_header", TestUtils.randomAlphaString(10000));
            req.sendHead();
        });
        this.await();
    }

    @Test
    public void testServerExceptionHandler() throws Exception {
        this.server.exceptionHandler(err -> {
            this.assertTrue(err instanceof TooLongFrameException);
            this.testComplete();
        });
        this.server.requestHandler(req -> this.fail());
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> {});
        req2.putHeader("the_header", TestUtils.randomAlphaString(10000));
        req2.sendHead();
        this.await();
    }

    @Test
    public void testHttpProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(this.client.get(8080, "localhost", "/"));
    }

    @Test
    public void testHttpProxyRequestOverrideClientSsl() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(this.client.get(new RequestOptions().setSsl(false).setHost("localhost").setPort(8080)));
    }

    private void testHttpProxyRequest2(HttpClientRequest clientReq) throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            clientReq.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
                this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
                this.testComplete();
            });
            clientReq.exceptionHandler(this::fail);
            clientReq.end();
        }));
        this.await();
    }

    @Test
    public void testHttpProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }

    @Test
    public void testHttpProxyFtpRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        String url = "ftp://ftp.gnu.org/gnu/";
        this.proxy.setForceUri("http://localhost:8080/");
        HttpClientRequest clientReq = this.client.getAbs("ftp://ftp.gnu.org/gnu/");
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            clientReq.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals("request did sent the expected url", "ftp://ftp.gnu.org/gnu/", this.proxy.getLastUri());
                this.testComplete();
            });
            clientReq.exceptionHandler(this::fail);
            clientReq.end();
        }));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort())));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.SOCKS5);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }

    @Test
    public void testRandomPorts() throws Exception {
        int numServers = 10;
        HashSet ports = new HashSet();
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numServers; ++i) {
            this.vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(0, "localhost", this.onSuccess(s -> {
                int port = s.actualPort();
                ports.add(port);
                this.client.getNow(port, "localhost", "/somepath", resp -> {
                    if (count.incrementAndGet() == numServers) {
                        this.assertEquals(numServers, ports.size());
                        this.testComplete();
                    }
                });
            }));
        }
        this.await();
    }

    @Test
    public void testContentDecompression() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setDecompressionSupported(true));
        String expected = TestUtils.randomAlphaString(1000);
        byte[] dataGzipped = TestUtils.compressGzip(expected);
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:8080", req.headers().get("host"));
            req.bodyHandler(buffer -> {
                this.assertEquals(expected, buffer.toString());
                req.response().end();
            });
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> this.testComplete()).putHeader("Content-Encoding", "gzip").end(Buffer.buffer((byte[])dataGzipped))));
        this.await();
    }

    @Test
    public void testResetClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(false, false);
    }

    @Test
    public void testResetKeepAliveClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(true, false);
    }

    @Test
    public void testResetPipelinedClientRequestNotYetSent() throws Exception {
        this.testResetClientRequestNotYetSent(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResetClientRequestNotYetSent(boolean keepAlive, boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger numReq = new AtomicInteger();
            server.connectHandler(conn -> {
                this.assertEquals(0L, numReq.getAndIncrement());
                StringBuilder sb = new StringBuilder();
                conn.handler(buff -> {
                    sb.append(buff);
                    String content = sb.toString();
                    if (content.startsWith("GET some-uri HTTP/1.1\r\n") && content.endsWith("\r\n\r\n")) {
                        conn.write("HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n");
                        this.complete();
                    }
                });
            });
            CountDownLatch latch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(keepAlive).setPipelining(pipelined));
            HttpClientRequest post = this.client.post(8080, "localhost", "some-uri", resp -> this.fail());
            post.setChunked(true).write(TestUtils.randomBuffer(1024));
            this.assertTrue(post.reset());
            this.client.getNow(8080, "localhost", "some-uri", resp -> {
                this.assertEquals(1L, numReq.get());
                this.complete();
            });
            this.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetKeepAliveClientRequest() throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            server.connectHandler(so -> {
                this.assertEquals(0L, count.getAndIncrement());
                Buffer total = Buffer.buffer();
                so.handler(buff -> {
                    total.appendBuffer(buff);
                    if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                        so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                        so.closeHandler(v -> this.complete());
                    }
                });
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(false).setKeepAlive(true));
            AtomicInteger status = new AtomicInteger();
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/somepath", resp -> this.assertEquals(0L, status.getAndIncrement()));
            req1.connectionHandler(conn -> conn.closeHandler(v -> {
                this.assertEquals(1L, status.getAndIncrement());
                this.complete();
            }));
            req1.end();
            HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> this.fail());
            req2.sendHead(v -> this.assertTrue(req2.reset()));
            this.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetPipelinedClientRequest() throws Exception {
        this.waitFor(2);
        CompletableFuture doReset = new CompletableFuture();
        this.server.close();
        NetServer server = this.vertx.createNetServer();
        AtomicInteger count = new AtomicInteger();
        server.connectHandler(so -> {
            this.assertEquals(0L, count.getAndIncrement());
            Buffer total = Buffer.buffer();
            so.handler(buff -> {
                total.appendBuffer(buff);
                if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\nPOST /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                    doReset.complete(null);
                    so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                }
            });
            so.closeHandler(v -> this.complete());
        });
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(true).setKeepAlive(true));
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/somepath", resp -> {});
            req1.connectionHandler(conn -> conn.closeHandler(v -> this.complete()));
            req1.end();
            HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> this.fail());
            req2.sendHead();
            doReset.thenAccept(v -> this.assertTrue(req2.reset()));
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetKeepAliveClientRequest() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientRequest(false);
    }

    @Test
    public void testCloseTheConnectionAfterResetPipelinedClientRequest() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientRequest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetPersistentClientRequest(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/somepath", resp -> this.fail());
            if (pipelined) {
                req1.sendHead(v -> {
                    this.assertTrue(req1.reset());
                    this.client.getNow(8080, "localhost", "/somepath", resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    });
                });
            } else {
                req1.sendHead(v -> this.assertTrue(req1.reset()));
                this.client.getNow(8080, "localhost", "/somepath", resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    });
                });
            }
            this.await();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetKeepAliveClientResponse() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientResponse(false);
    }

    @Test
    public void testCloseTheConnectionAfterResetPipelinedClientResponse() throws Exception {
        this.testCloseTheConnectionAfterResetPersistentClientResponse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetPersistentClientResponse(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                so.write(Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 200\r\n\r\nSome-Buffer"));
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /somepath HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/somepath");
            if (pipelined) {
                req1.handler(resp1 -> resp1.handler(buff -> {
                    req1.reset();
                    this.client.getNow(8080, "localhost", "/somepath", resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    });
                }));
                req1.end();
            } else {
                req1.handler(resp -> resp.handler(buff -> req1.reset()));
                req1.end();
                this.client.getNow(8080, "localhost", "/somepath", resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    });
                });
            }
            this.await();
        }
    }

    @Test
    public void testCloseTheConnectionAfterResetBeforePipelinedResponseReceived() throws Exception {
        this.testCloseTheConnectionAfterResetBeforeResponseReceived(true);
    }

    @Test
    public void testCloseTheConnectionAfterResetBeforeKeepAliveResponseReceived() throws Exception {
        this.testCloseTheConnectionAfterResetBeforeResponseReceived(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseTheConnectionAfterResetBeforeResponseReceived(boolean pipelined) throws Exception {
        this.waitFor(2);
        this.server.close();
        CompletableFuture requestReceived = new CompletableFuture();
        try (NetServer server = this.vertx.createNetServer();){
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean closed = new AtomicBoolean();
            server.connectHandler(so -> {
                Buffer total = Buffer.buffer();
                switch (count.getAndIncrement()) {
                    case 0: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /1 HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                requestReceived.complete(null);
                                so.write(Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 11\r\n\r\nSome-Buffer"));
                                so.closeHandler(v -> closed.set(true));
                            }
                        });
                        break;
                    }
                    case 1: {
                        so.handler(buff -> {
                            total.appendBuffer(buff);
                            if (total.toString().equals("GET /2 HTTP/1.1\r\nHost: localhost:8080\r\n\r\n")) {
                                so.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 11\r\n\r\nHello world");
                                this.complete();
                            }
                        });
                        break;
                    }
                    default: {
                        this.fail("Invalid count");
                    }
                }
            });
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "localhost", this.onSuccess(v -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            this.client.close();
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setPipelining(pipelined).setKeepAlive(true));
            HttpClientRequest req1 = this.client.get(8080, "localhost", "/1");
            if (pipelined) {
                requestReceived.thenAccept(v -> {
                    req1.reset();
                    this.client.getNow(8080, "localhost", "/2", resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp.bodyHandler(body -> {
                            this.assertEquals("Hello world", body.toString());
                            this.complete();
                        });
                    });
                });
                req1.handler(resp1 -> this.fail());
                req1.end();
            } else {
                requestReceived.thenAccept(v -> req1.reset());
                req1.handler(resp -> this.fail());
                req1.end();
                this.client.getNow(8080, "localhost", "/2", resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> {
                        this.assertEquals("Hello world", body.toString());
                        this.complete();
                    });
                });
            }
            this.await();
        }
    }

    @Test
    public void testTooLongContentInHttpServerRequest() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.server.connectionHandler(conn -> conn.exceptionHandler(error -> {
            this.assertEquals(IllegalArgumentException.class, error.getClass());
            this.testComplete();
        }));
        this.startServer();
        try (NetClient client = this.vertx.createNetClient();){
            client.connect(8080, "localhost", this.onSuccess(so -> so.write("POST / HTTP/1.1\r\nContent-Length: 4\r\n\r\ntoolong\r\n")));
            this.await();
        }
    }

    @Test
    public void testInvalidTrailerInHttpServerRequest() throws Exception {
        this.testHttpServerRequestDecodeError((Handler<NetSocket>)((Handler)so -> {
            so.write("0\r\n");
            for (int i = 0; i < 2000; ++i) {
                so.write("01234567");
            }
        }), (Handler<List<Throwable>>)((Handler)errors -> {
            this.assertEquals(2L, errors.size());
            this.assertEquals(TooLongFrameException.class, ((Throwable)errors.get(0)).getClass());
        }));
    }

    @Test
    public void testInvalidChunkInHttpServerRequest() throws Exception {
        this.testHttpServerRequestDecodeError((Handler<NetSocket>)((Handler)so -> so.write("invalid\r\n")), (Handler<List<Throwable>>)((Handler)errors -> {
            this.assertEquals(2L, errors.size());
            this.assertEquals(NumberFormatException.class, ((Throwable)errors.get(0)).getClass());
        }));
    }

    private void testHttpServerRequestDecodeError(Handler<NetSocket> bodySender, Handler<List<Throwable>> errorsChecker) throws Exception {
        AtomicReference current = new AtomicReference();
        this.server.requestHandler(req -> {
            ArrayList errors = new ArrayList();
            req.exceptionHandler(errors::add);
            req.response().closeHandler(v -> {
                errorsChecker.handle((Object)errors);
                this.testComplete();
            });
            bodySender.handle(current.get());
        });
        this.startServer();
        NetClient client = this.vertx.createNetClient();
        client.connect(8080, "localhost", this.onSuccess(so -> {
            current.set(so);
            so.write("POST /somepath HTTP/1.1\r\n");
            so.write("Transfer-Encoding: chunked\r\n");
            so.write("\r\n");
        }));
        this.await();
    }

    @Test
    public void testInvalidChunkInHttpClientResponse() throws Exception {
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.write("HTTP/1.1 200 OK\r\n");
            so.write("Transfer-Encoding: chunked\r\n");
            so.write("\r\n");
            so.write("invalid\r\n");
        });
        AtomicInteger status = new AtomicInteger();
        this.testHttpClientResponseDecodeError((Handler<Throwable>)((Handler)err -> {
            switch (status.incrementAndGet()) {
                case 1: {
                    this.assertTrue(err instanceof NumberFormatException);
                    break;
                }
                case 2: {
                    this.assertTrue(err instanceof VertxException);
                    this.assertTrue(err.getMessage().equals("Connection was closed"));
                    this.testComplete();
                }
            }
        }));
    }

    @Test
    public void testInvalidTrailersInHttpClientResponse() throws Exception {
        this.server.requestHandler(req -> {
            NetSocket so = req.netSocket();
            so.write("HTTP/1.1 200 OK\r\n");
            so.write("Transfer-Encoding: chunked\r\n");
            so.write("\r\n");
            so.write("0\r\n");
            for (int i = 0; i < 2000; ++i) {
                so.write("01234567");
            }
        });
        AtomicInteger status = new AtomicInteger();
        this.testHttpClientResponseDecodeError((Handler<Throwable>)((Handler)err -> {
            switch (status.incrementAndGet()) {
                case 1: {
                    this.assertTrue(err instanceof TooLongFrameException);
                    break;
                }
                case 2: {
                    this.assertTrue(err instanceof VertxException);
                    this.assertTrue(err.getMessage().equals("Connection was closed"));
                    this.testComplete();
                }
            }
        }));
    }

    private void testHttpClientResponseDecodeError(Handler<Throwable> errorHandler) throws Exception {
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> resp.exceptionHandler(errorHandler));
        this.await();
    }

    @Test
    public void testRequestTimeoutIsNotDelayedAfterResponseIsReceived() throws Exception {
        final int n = 6;
        this.waitFor(n);
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(n));
                for (int i = 0; i < n; ++i) {
                    AtomicBoolean responseReceived = new AtomicBoolean();
                    client.get(8080, "localhost", "some-uri", resp -> {
                        try {
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException e) {
                            Http1xTest.this.fail(e);
                        }
                        responseReceived.set(true);
                        this.vertx.runOnContext(v -> Http1xTest.this.complete());
                    }).exceptionHandler(err -> Http1xTest.this.fail("Was not expecting to get a timeout after the response is received")).setTimeout(500L).end();
                }
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testPerHostPooling() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false));
        this.testPerXXXPooling(i -> this.client.get(8080, "host" + i, "/somepath").setHost("host:8080").putHeader("key", "host" + i), req -> req.getHeader("key"));
    }

    @Test
    public void testPerPeerPooling() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false));
        this.testPerXXXPooling(i -> this.client.get(8080, "localhost", "/somepath").setHost("host" + i + ":8080"), HttpServerRequest::host);
    }

    @Test
    public void testPerPeerPoolingWithProxy() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(1).setKeepAlive(true).setPipelining(false).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(8080)));
        this.testPerXXXPooling(i -> this.client.get(80, "host" + i, "/somepath"), HttpServerRequest::host);
    }

    private void testPerXXXPooling(Function<Integer, HttpClientRequest> requestProvider, Function<HttpServerRequest, String> keyExtractor) throws Exception {
        this.waitFor(2);
        int numPeers = 3;
        int numRequests = 5;
        HashMap map = new HashMap();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            String key = (String)keyExtractor.apply((HttpServerRequest)req);
            this.assertFalse(map.containsKey(key));
            map.put(key, req.response());
            if (map.size() == numPeers) {
                map.values().forEach(HttpServerResponse::end);
                map.clear();
                if (count.incrementAndGet() == numRequests) {
                    this.complete();
                }
            }
        });
        this.startServer();
        AtomicInteger remaining = new AtomicInteger(numPeers * numRequests);
        for (int i = 0; i < numPeers; ++i) {
            for (int j = 0; j < numRequests; ++j) {
                HttpClientRequest req2 = requestProvider.apply(i);
                req2.handler(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    if (remaining.decrementAndGet() == 0) {
                        this.complete();
                    }
                });
                req2.end();
            }
        }
        this.await();
    }

    @Test
    public void testSendFileFailsWhenClientClosesConnection() throws Exception {
        File f = this.setupFile("file.pdf", TestUtils.randomUnicodeString(1000000));
        this.server.requestHandler(req -> {
            try {
                req.response().sendFile(f.getAbsolutePath(), event -> {
                    if (event.failed()) {
                        this.testComplete();
                    } else {
                        this.fail("It should not reach this point");
                    }
                });
            }
            catch (Exception e) {
                this.fail(e);
            }
        });
        this.startServer();
        this.vertx.createNetClient().connect(8080, "localhost", socket -> ((NetSocket)socket.result()).write("GET / HTTP/1.1\r\n\r\n").close());
        this.await();
    }

    @Test
    public void testHeadMustNotAutomaticallySetContentHeaders() throws Exception {
        this.testHeadAutomaticallySet(MultiMap.caseInsensitiveMultiMap(), respHeaders -> {
            this.assertFalse(respHeaders.contains("Content-Length"));
            this.assertFalse(respHeaders.contains("Transfer-Encoding"));
        });
    }

    @Test
    public void testHeadMustNotSendBodyWhenContentLengthSet() throws Exception {
        MultiMap reqHeaders = MultiMap.caseInsensitiveMultiMap();
        reqHeaders.set("Content-Length", "10");
        this.testHeadAutomaticallySet(reqHeaders, respHeaders -> {
            this.assertEquals(" 10", respHeaders.get("Content-Length"));
            this.assertNull(respHeaders.get("Transfer-Encoding"));
        });
    }

    @Test
    public void testHeadMustNotSendBodyWhenTransferEncodingSet() throws Exception {
        MultiMap reqHeaders = MultiMap.caseInsensitiveMultiMap();
        reqHeaders.set("Transfer-Encoding", "chunked");
        this.testHeadAutomaticallySet(reqHeaders, respHeaders -> {
            this.assertNull(respHeaders.get("Content-Length"));
            this.assertEquals(" chunked", respHeaders.get("Transfer-Encoding"));
        });
    }

    private void testHeadAutomaticallySet(MultiMap reqHeaders, Consumer<MultiMap> headersChecker) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.headers().addAll(reqHeaders);
            resp.end();
        });
        this.startServer();
        NetClient client = this.vertx.createNetClient();
        client.connect(8080, "localhost", this.onSuccess(so -> {
            so.write("HEAD / HTTP/1.1\r\nConnection: close\r\n\r\n");
            Buffer buff = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
            so.endHandler(v -> {
                String content = buff.toString();
                int idx = content.indexOf("\r\n\r\n");
                LinkedList<String> records = new LinkedList<String>(Arrays.asList(content.substring(0, idx).split("\\r\\n")));
                this.assertEquals("HTTP/1.1 200 OK", records.removeFirst());
                this.assertEquals("", content.substring(idx + 4));
                MultiMap respHeaders = MultiMap.caseInsensitiveMultiMap();
                records.forEach(record -> {
                    int index = record.indexOf(":");
                    String value = record.substring(0, index);
                    respHeaders.add(value, record.substring(index + 1));
                });
                headersChecker.accept(respHeaders);
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testUnknownContentLengthIsSetToZeroWithHTTP_1_0() throws Exception {
        this.server.requestHandler(req -> req.response().write("Some-String").end());
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_1_0));
        this.client.getNow(8080, "localhost", "some-uri", resp -> {
            this.assertNull(resp.getHeader("Content-Length"));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPartialH2CAmbiguousRequest() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("POST", req.rawMethod());
            this.testComplete();
        });
        Buffer fullRequest = Buffer.buffer((String)"POST /whatever HTTP/1.1\r\n\r\n");
        this.startServer();
        NetClient client = this.vertx.createNetClient();
        client.connect(8080, "localhost", this.onSuccess(so -> {
            so.write(fullRequest.slice(0, 1));
            this.vertx.setTimer(1000L, id -> so.write(fullRequest.slice(1, fullRequest.length())));
        }));
        this.await();
    }

    @Test
    public void testIdleTimeoutWithPartialH2CRequest() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost").setIdleTimeout(1));
        this.server.requestHandler(req -> this.testComplete());
        this.startServer();
        NetClient client = this.vertx.createNetClient();
        client.connect(8080, "localhost", this.onSuccess(so -> so.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testCompressedResponseWithConnectionCloseAndNoCompressionHeader() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost").setCompressionSupported(true));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer();
        this.client.get(8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(expected, buff);
            this.complete();
        })).putHeader("Connection", "close").exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testKeepAliveTimeout() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(3), 1);
    }

    @Test
    public void testKeepAliveTimeoutHeader() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            if (sent.compareAndSet(false, true)) {
                req.response().putHeader("keep-alive", "timeout=3").end();
            }
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 1);
    }

    @Test
    public void testKeepAliveTimeoutHeaderReusePrevious() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (sent.compareAndSet(false, true)) {
                resp.putHeader("keep-alive", "timeout=3");
            }
            resp.end();
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 2);
    }

    @Test
    public void testKeepAliveTimeoutHeaderOverwritePrevious() throws Exception {
        AtomicBoolean sent = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            int timeout = sent.compareAndSet(false, true) ? 15 : 3;
            resp.putHeader("keep-alive", "timeout=" + timeout);
            resp.end();
        });
        this.testKeepAliveTimeout(new HttpClientOptions().setMaxPoolSize(1).setKeepAliveTimeout(30), 2);
    }

    private void testKeepAliveTimeout(HttpClientOptions options, int numReqs) throws Exception {
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(options.setPoolCleanerPeriod(1));
        AtomicInteger respCount = new AtomicInteger();
        for (int i = 0; i < numReqs; ++i) {
            int current = 1 + i;
            this.client.getNow(8080, "localhost", "some-uri", resp -> {
                respCount.incrementAndGet();
                if (current == numReqs) {
                    long now = System.currentTimeMillis();
                    resp.request().connection().closeHandler(v -> {
                        long timeout = System.currentTimeMillis() - now;
                        int delta = 500;
                        int low = 3000 - delta;
                        int high = 3000 + delta;
                        this.assertTrue("Expected actual close timeout " + timeout + " to be > " + low, (long)low < timeout);
                        this.assertTrue("Expected actual close timeout " + timeout + " + to be < " + high, timeout < (long)high);
                        this.testComplete();
                    });
                }
            });
        }
        this.await();
    }

    @Test
    public void testPoolNotExpiring() throws Exception {
        this.server.requestHandler(req -> {
            req.response().end();
            this.vertx.setTimer(2000L, id -> req.connection().close());
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setPoolCleanerPeriod(0).setKeepAliveTimeout(100));
        this.client.getNow(8080, "localhost", "some-uri", resp -> resp.endHandler(v1 -> {
            long now = System.currentTimeMillis();
            resp.request().connection().closeHandler(v2 -> {
                long time = System.currentTimeMillis() - now;
                this.assertTrue("Was expecting " + time + " to be > 2000", time >= 2000L);
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testPausedHttpServerRequestUnpauseTheConnectionAtRequestEnd() throws Exception {
        int numRequests = 20;
        this.waitFor(numRequests);
        this.server.requestHandler(req -> {
            req.handler(buff -> {
                this.assertEquals("small", buff.toString());
                req.pause();
            });
            req.endHandler(v -> req.response().end());
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1));
        for (int i = 0; i < numRequests; ++i) {
            this.client.put(8080, "localhost", "/someuri", resp -> this.complete()).end("small");
        }
        this.await();
    }

    @Test
    public void testPoolLIFOPolicy() throws Exception {
        ArrayList requests = new ArrayList();
        this.server.requestHandler(req -> {
            requests.add(req);
            switch (requests.size()) {
                case 2: {
                    requests.forEach(r -> r.response().end());
                    break;
                }
                case 3: {
                    req.response().end();
                }
            }
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(2));
        List connections = Collections.synchronizedList(new ArrayList());
        CountDownLatch latch = new CountDownLatch(2);
        this.vertx.runOnContext(v0 -> {
            for (int i = 0; i < 2; ++i) {
                this.client.getNow(8080, "localhost", "/someuri", resp -> resp.endHandler(v1 -> this.vertx.runOnContext(v2 -> {
                    connections.add(resp.request().connection());
                    latch.countDown();
                })));
            }
        });
        this.awaitLatch(latch);
        this.client.getNow(8080, "localhost", "/someuri", resp -> {
            this.assertSame(resp.request().connection(), connections.get(1));
            this.testComplete();
        });
        this.await();
    }

    private /* synthetic */ void lambda$testContexts$160(Set contexts, AtomicReference serverRequestContext, AtomicReference listenContext, AsyncResult ar) {
        this.assertTrue(ar.succeeded());
        ContextImpl closeContext = ((VertxInternal)this.vertx).getContext();
        this.assertFalse(contexts.contains(closeContext));
        this.assertNotSame(serverRequestContext.get(), closeContext);
        this.assertFalse(contexts.contains(listenContext.get()));
        this.assertSame(serverRequestContext.get(), listenContext.get());
        this.testComplete();
    }

    private /* synthetic */ void lambda$testContexts$159(Set contexts, AtomicInteger cnt, int numReqs, int numConns, CountDownLatch latch2, HttpClientResponse resp) {
        this.assertEquals(200L, resp.statusCode());
        contexts.add(((VertxInternal)this.vertx).getContext());
        if (cnt.incrementAndGet() == numReqs) {
            this.assertTrue(contexts.size() >= numConns);
            latch2.countDown();
        }
    }

    private /* synthetic */ void lambda$testSharedServersRoundRobin$93(AtomicReference context, Set contexts, Set connectedServers, HttpServer theServer, Map requestCount, CountDownLatch latchConns, HttpServerRequest req) {
        Context ctx = Vertx.currentContext();
        if (context.get() != null) {
            this.assertSame(ctx, context.get());
        } else {
            context.set(ctx);
            contexts.add(ctx);
        }
        connectedServers.add(theServer);
        Integer cnt = (Integer)requestCount.get(theServer);
        int icnt = cnt == null ? 0 : cnt;
        requestCount.put(theServer, ++icnt);
        latchConns.countDown();
        req.response().end();
    }

    private static /* synthetic */ void lambda$testKeepAlive$65(Set connectedServers, HttpServer server, HttpServerRequest req) {
        connectedServers.add(server);
        req.response().end();
    }
}

