/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.test.core.Http2TestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.tls.Cert;
import io.vertx.test.core.tls.Trust;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.zip.GZIPOutputStream;
import org.junit.Test;

public class Http2ClientTest
extends Http2TestBase {
    private List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (EventLoopGroup eventLoopGroup : this.eventLoopGroups) {
            eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void setUp() throws Exception {
        this.eventLoopGroups.clear();
        super.setUp();
        this.clientOptions = new HttpClientOptions().setUseAlpn(true).setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()).setProtocolVersion(HttpVersion.HTTP_2);
        this.client = this.vertx.createHttpClient(this.clientOptions);
    }

    @Test
    public void testClientSettings() throws Exception {
        this.waitFor(2);
        io.vertx.core.http.Http2Settings initialSettings = TestUtils.randomHttp2Settings();
        io.vertx.core.http.Http2Settings updatedSettings = TestUtils.randomHttp2Settings();
        updatedSettings.setHeaderTableSize(initialSettings.getHeaderTableSize());
        AtomicInteger count = new AtomicInteger();
        Future end = Future.future();
        this.server.requestHandler(req -> end.setHandler(v -> req.response().end())).connectionHandler(conn -> {
            io.vertx.core.http.Http2Settings initialRemoteSettings = conn.remoteSettings();
            this.assertEquals(initialSettings.isPushEnabled(), initialRemoteSettings.isPushEnabled());
            this.assertEquals(initialSettings.getMaxHeaderListSize(), initialRemoteSettings.getMaxHeaderListSize());
            this.assertEquals(initialSettings.getMaxFrameSize(), initialRemoteSettings.getMaxFrameSize());
            this.assertEquals(initialSettings.getInitialWindowSize(), initialRemoteSettings.getInitialWindowSize());
            this.assertEquals(initialSettings.getHeaderTableSize(), initialRemoteSettings.getHeaderTableSize());
            this.assertEquals(initialSettings.get(7), initialRemoteSettings.get(7));
            Context ctx = Vertx.currentContext();
            conn.remoteSettingsHandler(settings -> {
                this.assertOnIOContext(ctx);
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(updatedSettings.getMaxHeaderListSize(), settings.getMaxHeaderListSize());
                        this.assertEquals(updatedSettings.getMaxFrameSize(), settings.getMaxFrameSize());
                        this.assertEquals(updatedSettings.getInitialWindowSize(), settings.getInitialWindowSize());
                        this.assertEquals(updatedSettings.getHeaderTableSize(), settings.getHeaderTableSize());
                        this.assertEquals(updatedSettings.get(7), settings.get(7));
                        this.complete();
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setInitialSettings(initialSettings));
        this.client.get(4043, "localhost", "/somepath", resp -> this.complete()).exceptionHandler(this::fail).connectionHandler(conn -> this.vertx.runOnContext(v -> conn.updateSettings(updatedSettings, ar -> end.complete()))).end();
        this.await();
    }

    @Test
    public void testInvalidSettings() throws Exception {
        io.vertx.core.http.Http2Settings settings = new io.vertx.core.http.Http2Settings();
        try {
            settings.set(Integer.MAX_VALUE, 0L);
            this.fail("max id should be 0-0xFFFF");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            settings.set(7, -1L);
            this.fail("max value should be 0-0xFFFFFFFF");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testServerSettings() throws Exception {
        io.vertx.core.http.Http2Settings expectedSettings = TestUtils.randomHttp2Settings();
        expectedSettings.setHeaderTableSize(4096L);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions);
        Context otherContext = this.vertx.getOrCreateContext();
        this.server.connectionHandler(conn -> otherContext.runOnContext(v -> conn.updateSettings(expectedSettings)));
        this.server.requestHandler(req -> {});
        this.startServer();
        AtomicInteger count = new AtomicInteger();
        this.client.get(4043, "localhost", "/somepath", resp -> this.fail()).connectionHandler(conn -> conn.remoteSettingsHandler(settings -> {
            switch (count.getAndIncrement()) {
                case 0: {
                    this.assertEquals(expectedSettings.getMaxHeaderListSize(), settings.getMaxHeaderListSize());
                    this.assertEquals(expectedSettings.getMaxFrameSize(), settings.getMaxFrameSize());
                    this.assertEquals(expectedSettings.getInitialWindowSize(), settings.getInitialWindowSize());
                    this.assertEquals(expectedSettings.getMaxConcurrentStreams(), settings.getMaxConcurrentStreams());
                    this.assertEquals(expectedSettings.getHeaderTableSize(), settings.getHeaderTableSize());
                    this.assertEquals(expectedSettings.get(7), settings.get(7));
                    this.testComplete();
                }
            }
        })).end();
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter((Http2ConnectionEncoder)encoder){
            final /* synthetic */ Http2ConnectionEncoder val$encoder;
            {
                this.val$encoder = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertTrue(endStream);
                    this.val$encoder.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, true, ctx.newPromise());
                    ctx.flush();
                });
            }

            public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> Http2ClientTest.this.testComplete());
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            HttpClientRequest req = this.client.get(4043, "localhost", "/somepath");
            req.handler(resp -> {
                Context ctx = this.vertx.getOrCreateContext();
                this.assertOnIOContext(ctx);
                resp.endHandler(v -> {
                    this.assertOnIOContext(ctx);
                    req.connection().close();
                });
            }).end();
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testHeaders() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            this.assertEquals("https", req.scheme());
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("/somepath", req.path());
            this.assertEquals("localhost:4043", req.host());
            this.assertEquals("foo_request_value", req.getHeader("Foo_request"));
            this.assertEquals("bar_request_value", req.getHeader("bar_request"));
            this.assertEquals(2L, req.headers().getAll("juu_request").size());
            this.assertEquals("juu_request_value_1", req.headers().getAll("juu_request").get(0));
            this.assertEquals("juu_request_value_2", req.headers().getAll("juu_request").get(1));
            reqCount.incrementAndGet();
            HttpServerResponse resp = req.response();
            resp.putHeader("content-type", "text/plain");
            resp.putHeader("Foo_response", "foo_value");
            resp.putHeader("bar_response", "bar_value");
            resp.putHeader("juu_response", Arrays.asList("juu_value_1", "juu_value_2"));
            resp.end();
        });
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath");
        req2.handler(resp -> {
            Context ctx = this.vertx.getOrCreateContext();
            this.assertOnIOContext(ctx);
            this.assertEquals(1L, req2.streamId());
            this.assertEquals(1L, reqCount.get());
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("OK", resp.statusMessage());
            this.assertEquals("text/plain", resp.getHeader("content-type"));
            this.assertEquals("200", resp.getHeader(":status"));
            this.assertEquals("foo_value", resp.getHeader("foo_response"));
            this.assertEquals("bar_value", resp.getHeader("bar_response"));
            this.assertEquals(2L, resp.headers().getAll("juu_response").size());
            this.assertEquals("juu_value_1", resp.headers().getAll("juu_response").get(0));
            this.assertEquals("juu_value_2", resp.headers().getAll("juu_response").get(1));
            resp.endHandler(v -> {
                this.assertOnIOContext(ctx);
                this.testComplete();
            });
        }).putHeader("Foo_request", "foo_request_value").putHeader("bar_request", "bar_request_value").putHeader((CharSequence)"juu_request", Arrays.asList("juu_request_value_1", "juu_request_value_2")).exceptionHandler(err -> this.fail()).end();
        this.await();
    }

    @Test
    public void testResponseBody() throws Exception {
        this.testResponseBody(TestUtils.randomAlphaString(100));
    }

    @Test
    public void testEmptyResponseBody() throws Exception {
        this.testResponseBody("");
    }

    private void testResponseBody(String expected) throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.end(expected);
        });
        this.startServer();
        this.client.get(4043, "localhost", "/somepath", resp -> {
            AtomicInteger count = new AtomicInteger();
            Buffer content = Buffer.buffer();
            resp.handler(buff -> {
                content.appendBuffer(buff);
                count.incrementAndGet();
            });
            resp.endHandler(v -> {
                this.assertTrue(count.get() > 0);
                this.assertEquals(expected, content.toString());
                this.testComplete();
            });
        }).exceptionHandler(err -> this.fail()).end();
        this.await();
    }

    @Test
    public void testOverrideAuthority() throws Exception {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.host());
            req.response().end();
        });
        this.startServer();
        this.client.get(4043, "localhost", "/somepath", resp -> this.testComplete()).setHost("localhost:4444").exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testTrailers() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            resp.write("some-content");
            resp.putTrailer("Foo", "foo_value");
            resp.putTrailer("bar", "bar_value");
            resp.putTrailer("juu", Arrays.asList("juu_value_1", "juu_value_2"));
            resp.end();
        });
        this.startServer();
        this.client.getNow(4043, "localhost", "/somepeth", resp -> {
            this.assertEquals(null, resp.getTrailer("foo"));
            resp.exceptionHandler(this::fail);
            resp.endHandler(v -> {
                this.assertEquals("foo_value", resp.getTrailer("foo"));
                this.assertEquals("foo_value", resp.getTrailer("Foo"));
                this.assertEquals("bar_value", resp.getTrailer("bar"));
                this.assertEquals(2L, resp.trailers().getAll("juu").size());
                this.assertEquals("juu_value_1", resp.trailers().getAll("juu").get(0));
                this.assertEquals("juu_value_2", resp.trailers().getAll("juu").get(1));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testBodyEndHandler() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(131072));
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.end(expected);
        });
        this.startServer();
        this.client.getNow(4043, "localhost", "/somepath", resp -> {
            Context ctx = this.vertx.getOrCreateContext();
            resp.exceptionHandler(this::fail);
            resp.bodyHandler(body -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(expected, body);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testPost() throws Exception {
        this.testPost(TestUtils.randomAlphaString(100));
    }

    @Test
    public void testEmptyPost() throws Exception {
        this.testPost("");
    }

    private void testPost(String expected) throws Exception {
        Buffer content = Buffer.buffer();
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.POST, req.method());
            req.handler(buff -> {
                content.appendBuffer(buff);
                count.getAndIncrement();
            });
            req.endHandler(v -> {
                this.assertTrue(count.get() > 0);
                req.response().end();
            });
        });
        this.startServer();
        this.client.post(4043, "localhost", "/somepath", resp -> resp.endHandler(v -> {
            this.assertEquals(expected, content.toString());
            this.testComplete();
        })).exceptionHandler(err -> this.fail()).end(expected);
        this.await();
    }

    @Test
    public void testClientRequestWriteability() throws Exception {
        Buffer content = Buffer.buffer();
        Buffer expected = Buffer.buffer();
        String chunk = TestUtils.randomAlphaString(100);
        CompletableFuture done = new CompletableFuture();
        AtomicBoolean paused = new AtomicBoolean();
        AtomicInteger numPause = new AtomicInteger();
        this.server.requestHandler(req -> {
            Context ctx = this.vertx.getOrCreateContext();
            done.thenAccept(v1 -> {
                paused.set(false);
                ctx.runOnContext(v2 -> req.resume());
            });
            numPause.incrementAndGet();
            req.pause();
            paused.set(true);
            req.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
            req.endHandler(v -> {
                this.assertEquals(expected, content);
                req.response().end();
            });
        });
        this.startServer();
        HttpClientRequest req2 = this.client.post(4043, "localhost", "/somepath", resp -> this.testComplete()).setChunked(true).exceptionHandler(err -> this.fail());
        AtomicInteger sent = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        AtomicInteger drained = new AtomicInteger();
        this.vertx.setPeriodic(1L, timerID -> {
            Context ctx = this.vertx.getOrCreateContext();
            if (req2.writeQueueFull()) {
                this.assertTrue(paused.get());
                this.assertEquals(1L, numPause.get());
                req2.drainHandler(v -> {
                    this.assertOnIOContext(ctx);
                    this.assertEquals(0L, drained.getAndIncrement());
                    this.assertEquals(1L, numPause.get());
                    this.assertFalse(paused.get());
                    req2.end();
                });
                this.vertx.cancelTimer(timerID.longValue());
                done.complete(null);
            } else {
                count.incrementAndGet();
                expected.appendString(chunk);
                req2.write(chunk);
                sent.addAndGet(chunk.length());
            }
        });
        this.await();
    }

    @Test
    public void testClientResponsePauseResume() throws Exception {
        String content = TestUtils.randomAlphaString(1024);
        Buffer expected = Buffer.buffer();
        Future whenFull = Future.future();
        AtomicBoolean drain = new AtomicBoolean();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.putHeader("content-type", "text/plain");
            resp.setChunked(true);
            this.vertx.setPeriodic(1L, timerID -> {
                if (resp.writeQueueFull()) {
                    resp.drainHandler(v -> {
                        Buffer last = Buffer.buffer((String)"last");
                        expected.appendBuffer(last);
                        resp.end(last);
                        this.assertEquals(expected.toString().getBytes().length, resp.bytesWritten());
                    });
                    this.vertx.cancelTimer(timerID.longValue());
                    drain.set(true);
                    whenFull.complete();
                } else {
                    Buffer chunk = Buffer.buffer((String)content);
                    expected.appendBuffer(chunk);
                    resp.write(chunk);
                }
            });
        });
        this.startServer();
        this.client.getNow(4043, "localhost", "/somepath", resp -> {
            Context ctx = this.vertx.getOrCreateContext();
            Buffer received = Buffer.buffer();
            resp.pause();
            resp.handler(buff -> {
                if (whenFull.isComplete()) {
                    this.assertSame(ctx, Vertx.currentContext());
                } else {
                    this.assertOnIOContext(ctx);
                }
                received.appendBuffer(buff);
            });
            resp.endHandler(v -> {
                this.assertEquals(expected.toString().length(), received.toString().length());
                this.testComplete();
            });
            whenFull.setHandler(v -> resp.resume());
        });
        this.await();
    }

    @Test
    public void testQueueingRequests() throws Exception {
        this.testQueueingRequests(100, null);
    }

    @Test
    public void testQueueingRequestsMaxConcurrentStream() throws Exception {
        this.testQueueingRequests(100, 10L);
    }

    private void testQueueingRequests(int numReq, Long max) throws Exception {
        this.waitFor(numReq);
        String expected = TestUtils.randomAlphaString(100);
        this.server.close();
        io.vertx.core.http.Http2Settings serverSettings = new io.vertx.core.http.Http2Settings();
        if (max != null) {
            serverSettings.setMaxConcurrentStreams(max.longValue());
        }
        this.server = this.vertx.createHttpServer(this.serverOptions.setInitialSettings(serverSettings));
        this.server.requestHandler(req -> req.response().end(expected));
        this.startServer();
        CountDownLatch latch = new CountDownLatch(1);
        this.client.get(4043, "localhost", "/somepath", resp -> {}).connectionHandler(conn -> {
            this.assertEquals(max == null ? 0xFFFFFFFFL : max, conn.remoteSettings().getMaxConcurrentStreams());
            latch.countDown();
        }).exceptionHandler(err -> this.fail()).end();
        this.awaitLatch(latch);
        for (int i = 0; i < numReq; ++i) {
            this.client.get(4043, "localhost", "/somepath", resp -> {
                Buffer content = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
                resp.endHandler(v -> {
                    this.assertEquals(expected, content.toString());
                    this.complete();
                });
            }).exceptionHandler(err -> this.fail()).end();
        }
        this.await();
    }

    @Test
    public void testReuseConnection() throws Exception {
        ArrayList ports = new ArrayList();
        this.server.requestHandler(req -> {
            SocketAddress address = req.remoteAddress();
            this.assertNotNull(address);
            ports.add(address);
            req.response().end();
        });
        this.startServer();
        CountDownLatch doReq = new CountDownLatch(1);
        this.client.get(4043, "localhost", "/somepath", resp -> resp.endHandler(v -> doReq.countDown())).exceptionHandler(err -> this.fail()).end();
        this.awaitLatch(doReq);
        this.client.get(4043, "localhost", "/somepath", resp -> resp.endHandler(v -> {
            this.assertEquals(2L, ports.size());
            this.assertEquals(ports.get(0), ports.get(1));
            this.testComplete();
        })).exceptionHandler(err -> this.fail()).end();
        this.await();
    }

    @Test
    public void testConnectionFailed() throws Exception {
        this.client.get(4044, "localhost", "/somepath", resp -> {}).exceptionHandler(err -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            this.assertTrue(err instanceof ConnectException);
            this.testComplete();
        }).end();
        this.await();
    }

    @Test
    public void testFallbackOnHttp1() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setUseAlpn(false));
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.startServer();
        this.client.get(4043, "localhost", "/somepath", resp -> this.testComplete()).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testServerResetClientStreamDuringRequest() throws Exception {
        String chunk = TestUtils.randomAlphaString(1024);
        this.server.requestHandler(req -> req.handler(buf -> req.response().reset(8L)));
        this.startServer();
        this.client.post(4043, "localhost", "/somepath", resp -> this.fail()).exceptionHandler(err -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            this.assertTrue(err instanceof StreamResetException);
            StreamResetException reset = (StreamResetException)err;
            this.assertEquals(8L, reset.getCode());
            this.testComplete();
        }).setChunked(true).write(chunk);
        this.await();
    }

    @Test
    public void testServerResetClientStreamDuringResponse() throws Exception {
        this.waitFor(2);
        String chunk = TestUtils.randomAlphaString(1024);
        Future doReset = Future.future();
        this.server.requestHandler(req -> {
            doReset.setHandler(this.onSuccess(v -> req.response().reset(8L)));
            req.response().setChunked(true).write(Buffer.buffer((String)chunk));
        });
        this.startServer();
        Context ctx = this.vertx.getOrCreateContext();
        Handler resetHandler = err -> {
            this.assertOnIOContext(ctx);
            this.assertTrue(err instanceof StreamResetException);
            StreamResetException reset = (StreamResetException)err;
            this.assertEquals(8L, reset.getCode());
            this.complete();
        };
        ctx.runOnContext(v -> this.client.post(4043, "localhost", "/somepath", resp -> {
            resp.exceptionHandler(resetHandler);
            resp.handler(buff -> doReset.complete());
        }).exceptionHandler(resetHandler).setChunked(true).write(chunk));
        this.await();
    }

    @Test
    public void testClientResetServerStreamDuringRequest() throws Exception {
        Future bufReceived = Future.future();
        this.server.requestHandler(req -> {
            req.handler(buf -> bufReceived.complete());
            req.exceptionHandler(err -> this.assertEquals(err.getClass(), StreamResetException.class));
            AtomicLong reset = new AtomicLong();
            req.response().exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    reset.set(((StreamResetException)err).getCode());
                }
            });
            req.response().closeHandler(v -> {
                this.assertEquals(10L, reset.get());
                this.testComplete();
            });
        });
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> this.fail()).setChunked(true).write(Buffer.buffer((String)"hello"));
        bufReceived.setHandler(ar -> req2.reset(10L));
        this.await();
    }

    @Test
    public void testClientResetServerStreamDuringResponse() throws Exception {
        this.server.requestHandler(req -> {
            req.exceptionHandler(err -> this.assertEquals(err.getClass(), StreamResetException.class));
            AtomicLong reset = new AtomicLong();
            req.response().exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    reset.set(((StreamResetException)err).getCode());
                }
            });
            req.response().closeHandler(v -> {
                this.assertEquals(10L, reset.get());
                this.testComplete();
            });
            req.response().setChunked(true).write(Buffer.buffer((String)"some-data"));
        });
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath");
        req2.handler(resp -> {
            resp.exceptionHandler(this::fail);
            req2.reset(10L);
            TestUtils.assertIllegalStateException(() -> req2.write(Buffer.buffer()));
            TestUtils.assertIllegalStateException(() -> ((HttpClientRequest)req2).end());
        }).end(Buffer.buffer((String)"hello"));
        this.await();
    }

    @Test
    public void testPushPromise() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble?a=b", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse response = (HttpServerResponse)ar.result();
            response.end("the_content");
        }).end());
        this.startServer();
        AtomicReference ctx = new AtomicReference();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {
            Context current = Vertx.currentContext();
            if (ctx.get() == null) {
                ctx.set(current);
            } else {
                this.assertEquals(ctx.get(), current);
            }
            resp.endHandler(v -> this.complete());
        });
        req2.pushHandler(pushedReq -> {
            Context current = Vertx.currentContext();
            if (ctx.get() == null) {
                ctx.set(current);
            } else {
                this.assertEquals(ctx.get(), current);
            }
            this.assertOnIOContext(current);
            this.assertEquals(HttpMethod.GET, pushedReq.method());
            this.assertEquals("/wibble?a=b", pushedReq.uri());
            this.assertEquals("/wibble", pushedReq.path());
            this.assertEquals("a=b", pushedReq.query());
            pushedReq.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                Buffer content = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)content).appendBuffer(arg_0));
                resp.endHandler(v -> this.complete());
            });
        });
        req2.end();
        this.await();
    }

    @Test
    public void testResetActivePushPromise() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse response = (HttpServerResponse)ar.result();
            response.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    this.assertEquals(Http2Error.CANCEL.code(), ((StreamResetException)err).getCode());
                    this.testComplete();
                }
            });
            response.setChunked(true).write("some_content");
        }));
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> this.fail());
        req2.pushHandler(pushedReq -> pushedReq.handler(pushedResp -> pushedResp.handler(buff -> pushedReq.reset(Http2Error.CANCEL.code()))));
        req2.end();
        this.await();
    }

    @Test
    public void testResetPendingPushPromise() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertFalse(ar.succeeded());
            this.testComplete();
        }));
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setInitialSettings(new io.vertx.core.http.Http2Settings().setMaxConcurrentStreams(0L)));
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> this.fail());
        req2.pushHandler(pushedReq -> pushedReq.reset(Http2Error.CANCEL.code()));
        req2.end();
        this.await();
    }

    @Test
    public void testResetPushPromiseNoHandler() throws Exception {
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            this.assertTrue(ar.succeeded());
            HttpServerResponse resp = (HttpServerResponse)ar.result();
            resp.setChunked(true).write("content");
            AtomicLong reset = new AtomicLong();
            resp.exceptionHandler(err -> {
                if (err instanceof StreamResetException) {
                    reset.set(((StreamResetException)err).getCode());
                }
            });
            resp.closeHandler(v -> {
                this.assertEquals(Http2Error.CANCEL.code(), reset.get());
                this.testComplete();
            });
        }));
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {});
        req2.end();
        this.await();
    }

    @Test
    public void testConnectionHandler() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        AtomicReference connection = new AtomicReference();
        HttpClientRequest req1 = this.client.get(4043, "localhost", "/somepath");
        req1.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            this.assertTrue(connection.compareAndSet(null, conn));
        });
        req1.handler(resp -> {
            this.assertSame(connection.get(), req1.connection());
            this.complete();
        });
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath");
        req2.connectionHandler(conn -> this.fail());
        req2.handler(resp -> {
            this.assertSame(connection.get(), req2.connection());
            this.complete();
        });
        req1.end();
        req2.end();
        this.await();
    }

    @Test
    public void testConnectionShutdownInConnectionHandler() throws Exception {
        this.waitFor(2);
        AtomicInteger serverStatus = new AtomicInteger();
        this.server.connectionHandler(conn -> {
            if (serverStatus.getAndIncrement() == 0) {
                conn.goAwayHandler(ga -> {
                    this.assertEquals(0L, ga.getErrorCode());
                    this.assertEquals(1L, serverStatus.getAndIncrement());
                });
                conn.shutdownHandler(v -> this.assertEquals(2L, serverStatus.getAndIncrement()));
                conn.closeHandler(v -> this.assertEquals(3L, serverStatus.getAndIncrement()));
            }
        });
        this.server.requestHandler(req -> {
            this.assertEquals(5L, serverStatus.getAndIncrement());
            req.response().end("" + serverStatus.get());
        });
        this.startServer();
        AtomicInteger clientStatus = new AtomicInteger();
        HttpClientRequest req1 = this.client.get(4043, "localhost", "/somepath");
        req1.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            if (clientStatus.getAndIncrement() == 0) {
                conn.shutdownHandler(v -> {
                    this.assertOnIOContext(ctx);
                    clientStatus.compareAndSet(1, 2);
                    this.complete();
                });
                conn.shutdown();
            }
        });
        req1.exceptionHandler(err -> this.complete());
        req1.handler(resp -> this.fail("Was not expecting the response to complete"));
        req1.end();
        this.await();
    }

    @Test
    public void testServerShutdownConnection() throws Exception {
        this.waitFor(2);
        this.server.connectionHandler(HttpConnection::shutdown);
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        HttpClientRequest req1 = this.client.get(4043, "localhost", "/somepath");
        req1.connectionHandler(conn -> {
            Context ctx = Vertx.currentContext();
            conn.goAwayHandler(ga -> {
                this.assertOnIOContext(ctx);
                this.complete();
            });
        });
        AtomicInteger count = new AtomicInteger();
        req1.exceptionHandler(err -> {
            if (count.getAndIncrement() == 0) {
                this.complete();
            }
        });
        req1.handler(resp -> this.fail());
        req1.end();
        this.await();
    }

    @Test
    public void testReceivingGoAwayDiscardsTheConnection() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        Set connections = Collections.synchronizedSet(new HashSet());
        this.server.requestHandler(req -> {
            connections.add(req.connection());
            switch (reqCount.getAndIncrement()) {
                case 0: {
                    req.connection().goAway(0L);
                    break;
                }
                case 1: {
                    req.response().end();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        this.startServer();
        HttpClientRequest req1 = this.client.get(4043, "localhost", "/somepath");
        req1.connectionHandler(conn -> {
            AtomicInteger gaCount = new AtomicInteger();
            conn.goAwayHandler(ga -> {
                if (gaCount.getAndIncrement() == 0) {
                    this.client.get(4043, "localhost", "/somepath", resp2 -> {
                        this.assertEquals(2L, connections.size());
                        this.testComplete();
                    }).setTimeout(5000L).exceptionHandler(this::fail).end();
                }
            });
        });
        req1.handler(resp1 -> this.fail()).end();
        this.await();
    }

    @Test
    public void testSendingGoAwayDiscardsTheConnection() throws Exception {
        AtomicInteger reqCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (reqCount.getAndIncrement()) {
                case 0: {
                    req.response().setChunked(true).write("some-data");
                    break;
                }
                case 1: {
                    req.response().end();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        this.startServer();
        HttpClientRequest req1 = this.client.get(4043, "localhost", "/somepath");
        req1.handler(resp1 -> {
            req1.connection().goAway(0L);
            this.client.get(4043, "localhost", "/somepath", resp2 -> this.testComplete()).setTimeout(5000L).exceptionHandler(this::fail).end();
        }).end();
        this.await();
    }

    private Http2ConnectionHandler createHttpConnectionHandler(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler) {
        class Builder
        extends AbstractHttp2ConnectionHandlerBuilder<Handler, Builder> {
            Builder() {
            }

            protected Handler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
                class Handler
                extends Http2ConnectionHandler {
                    final /* synthetic */ BiFunction val$handler;

                    public Handler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
                        this.val$handler = biFunction;
                        super(decoder, encoder, initialSettings);
                        decoder.frameListener((Http2FrameListener)this.val$handler.apply(decoder, encoder));
                    }
                }
                return new Handler(Http2ClientTest.this, decoder, encoder, initialSettings, handler);
            }

            public Handler build() {
                return (Handler)super.build();
            }
        }
        Builder builder = new Builder();
        return builder.build();
    }

    private ServerBootstrap createH2Server(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        this.eventLoopGroups.add((EventLoopGroup)eventLoopGroup);
        bootstrap.group((EventLoopGroup)eventLoopGroup);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                SSLHelper sslHelper = new SSLHelper(Http2ClientTest.this.serverOptions, (KeyCertOptions)Cert.SERVER_JKS.get(), null);
                SslHandler sslHandler = new SslHandler(sslHelper.setApplicationProtocols(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1)).createEngine((VertxInternal)Http2ClientTest.this.vertx, "localhost", 4043));
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("whatever"){

                    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                        if ("h2".equals(protocol)) {
                            ChannelPipeline p = ctx.pipeline();
                            Http2ConnectionHandler clientHandler = Http2ClientTest.this.createHttpConnectionHandler(handler);
                            p.addLast("handler", (ChannelHandler)clientHandler);
                            return;
                        }
                        ctx.close();
                        throw new IllegalStateException("unknown protocol: " + protocol);
                    }
                }});
            }
        });
        return bootstrap;
    }

    private ServerBootstrap createH2CServer(final BiFunction<Http2ConnectionDecoder, Http2ConnectionEncoder, Http2FrameListener> handler, final boolean upgrade) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                if (upgrade) {
                    HttpServerCodec sourceCodec = new HttpServerCodec();
                    HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                            Http2ConnectionHandler httpConnectionHandler = Http2ClientTest.this.createHttpConnectionHandler((a, b) -> new Http2FrameListenerDecorator((Http2FrameListener)handler.apply(a, b), (Http2ConnectionDecoder)a, (Http2ConnectionEncoder)b){
                                final /* synthetic */ Http2ConnectionDecoder val$a;
                                final /* synthetic */ Http2ConnectionEncoder val$b;
                                {
                                    this.val$a = http2ConnectionDecoder;
                                    this.val$b = http2ConnectionEncoder;
                                    super(x0);
                                }

                                public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
                                    super.onSettingsRead(ctx, settings);
                                    Http2Connection conn = this.val$a.connection();
                                    Http2Stream stream = conn.stream(1);
                                    DefaultHttp2Headers blah = new DefaultHttp2Headers();
                                    blah.status((CharSequence)"200");
                                    this.val$b.frameWriter().writeHeaders(ctx, 1, (Http2Headers)blah, 0, true, ctx.voidPromise());
                                }
                            });
                            return new Http2ServerUpgradeCodec(httpConnectionHandler);
                        }
                        return null;
                    };
                    ch.pipeline().addLast(new ChannelHandler[]{sourceCodec});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory)});
                } else {
                    Http2ConnectionHandler clientHandler = Http2ClientTest.this.createHttpConnectionHandler(handler);
                    ch.pipeline().addLast("handler", (ChannelHandler)clientHandler);
                }
            }
        });
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamError() throws Exception {
        this.waitFor(3);
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, false, ctx.newPromise());
                ctx.channel().write((Object)Buffer.buffer((byte[])new byte[]{0, 0, 18, 0, 8, 0, 0, 0, (byte)(streamId & 0xFF), 31, 104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).getByteBuf());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            Context ctx = this.vertx.getOrCreateContext();
            ctx.runOnContext(v -> this.client.get(4043, "localhost", "/somepath", resp -> resp.exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            })).connectionHandler(conn -> conn.exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            })).exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            }).sendHead());
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionDecodeError() throws Exception {
        this.waitFor(3);
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, false, ctx.newPromise());
                this.val$enc.frameWriter().writeRstStream(ctx, 10, 0L, ctx.newPromise());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            Context ctx = this.vertx.getOrCreateContext();
            ctx.runOnContext(v -> this.client.get(4043, "localhost", "/somepath", resp -> resp.exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            })).connectionHandler(conn -> conn.exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            })).exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof Http2Exception) {
                    this.complete();
                }
            }).sendHead());
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidServerResponse() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"xyz"), 0, false, ctx.newPromise());
                ctx.flush();
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        try {
            Context ctx = this.vertx.getOrCreateContext();
            ctx.runOnContext(v -> this.client.get(4043, "localhost", "/somepath", resp -> this.fail()).connectionHandler(conn -> conn.exceptionHandler(err -> this.fail())).exceptionHandler(err -> {
                this.assertOnIOContext(ctx);
                if (err instanceof NumberFormatException) {
                    this.testComplete();
                }
            }).end());
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testResponseCompressionEnabled() throws Exception {
        this.testResponseCompression(true);
    }

    @Test
    public void testResponseCompressionDisabled() throws Exception {
        this.testResponseCompression(false);
    }

    private void testResponseCompression(boolean enabled) throws Exception {
        byte[] expected = TestUtils.randomAlphaString(1000).getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream in = new GZIPOutputStream(baos);
        in.write(expected);
        in.close();
        byte[] compressed = baos.toByteArray();
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions);
        this.server.requestHandler(req -> {
            this.assertEquals(enabled ? "deflate, gzip" : null, req.getHeader((CharSequence)HttpHeaderNames.ACCEPT_ENCODING));
            req.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING.toLowerCase(), (CharSequence)"gzip").end(Buffer.buffer((byte[])compressed));
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setTryUseCompression(enabled));
        this.client.get(4043, "localhost", "/somepath", resp -> {
            String encoding = resp.getHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            this.assertEquals(enabled ? null : "gzip", encoding);
            resp.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((byte[])(enabled ? expected : compressed)), buff);
                this.testComplete();
            });
        }).end();
        this.await();
    }

    @Test
    public void test100Continue() throws Exception {
        AtomicInteger status = new AtomicInteger();
        this.server.close();
        this.server = this.vertx.createHttpServer(this.serverOptions.setHandle100ContinueAutomatically(true));
        this.server.requestHandler(req -> {
            status.getAndIncrement();
            HttpServerResponse resp = req.response();
            req.bodyHandler(body -> {
                this.assertEquals(2L, status.getAndIncrement());
                this.assertEquals("request-body", body.toString());
                resp.putHeader("wibble", "wibble-value").end("response-body");
            });
        });
        this.startServer();
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {
            this.assertEquals(3L, status.getAndIncrement());
            resp.bodyHandler(body -> {
                this.assertEquals(4L, status.getAndIncrement());
                this.assertEquals("response-body", body.toString());
                this.testComplete();
            });
        });
        req2.putHeader("expect", "100-continue");
        req2.continueHandler(v -> {
            Context ctx = Vertx.currentContext();
            this.assertOnIOContext(ctx);
            status.getAndIncrement();
            req2.end(Buffer.buffer((String)"request-body"));
        });
        req2.sendHead(version -> this.assertEquals(1L, req2.streamId()));
        this.await();
    }

    @Test
    public void testNetSocketConnect() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            AtomicInteger status = new AtomicInteger();
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.write(buff);
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> {
                this.assertEquals(2L, status.getAndIncrement());
                socket.write(Buffer.buffer((String)"last-data"));
            });
            socket.closeHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.complete();
            });
        });
        this.startServer();
        this.client.request(HttpMethod.CONNECT, 4043, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            NetSocket socket = resp.netSocket();
            StringBuilder received = new StringBuilder();
            AtomicInteger count = new AtomicInteger();
            socket.handler(buff -> {
                if (buff.length() > 0) {
                    received.append(buff.toString());
                    if (received.toString().equals("some-data")) {
                        received.setLength(0);
                        socket.end((Object)Buffer.buffer((String)"last-data"));
                    } else if (received.toString().equals("last-data")) {
                        this.assertEquals(0L, count.getAndIncrement());
                    }
                }
            });
            socket.endHandler(v -> this.assertEquals(1L, count.getAndIncrement()));
            socket.closeHandler(v -> {
                this.assertEquals(2L, count.getAndIncrement());
                this.complete();
            });
            socket.write(Buffer.buffer((String)"some-data"));
        }).sendHead();
        this.await();
    }

    @Test
    public void testServerCloseNetSocket() throws Exception {
        this.waitFor(2);
        AtomicInteger status = new AtomicInteger();
        this.server.requestHandler(req -> {
            NetSocket socket = req.netSocket();
            socket.handler(buff -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertEquals(Buffer.buffer((String)"some-data"), buff);
                        socket.end(buff);
                        break;
                    }
                    case 1: {
                        this.assertEquals(Buffer.buffer((String)"last-data"), buff);
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> this.assertEquals(2L, status.getAndIncrement()));
            socket.closeHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.complete();
            });
        });
        this.startServer();
        this.client.request(HttpMethod.CONNECT, 4043, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            NetSocket socket = resp.netSocket();
            AtomicInteger count = new AtomicInteger();
            socket.handler(buff -> {
                switch (count.getAndIncrement()) {
                    case 0: {
                        this.assertEquals("some-data", buff.toString());
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            socket.endHandler(v -> {
                this.assertEquals(1L, count.getAndIncrement());
                socket.end((Object)Buffer.buffer((String)"last-data"));
            });
            socket.closeHandler(v -> {
                this.assertEquals(2L, count.getAndIncrement());
                this.complete();
            });
            socket.write(Buffer.buffer((String)"some-data"));
        }).sendHead();
        this.await();
    }

    @Test
    public void testSendHeadersCompletionHandler() throws Exception {
        AtomicInteger status = new AtomicInteger();
        this.server.requestHandler(req -> req.response().end());
        this.startServer();
        HttpClientRequest req2 = this.client.request(HttpMethod.CONNECT, 4043, "localhost", "/somepath", resp -> {
            this.assertEquals(1L, status.getAndIncrement());
            resp.endHandler(v -> {
                this.assertEquals(3L, status.getAndIncrement());
                this.testComplete();
            });
        });
        req2.endHandler(v -> this.assertEquals(2L, status.getAndIncrement()));
        req2.sendHead(version -> {
            this.assertEquals(0L, status.getAndIncrement());
            this.assertSame(HttpVersion.HTTP_2, version);
            req2.end();
        });
        this.await();
    }

    @Test
    public void testUnknownFrame() throws Exception {
        Buffer expectedSend = TestUtils.randomBuffer(500);
        Buffer expectedRecv = TestUtils.randomBuffer(500);
        this.server.requestHandler(req -> req.customFrameHandler(frame -> {
            this.assertEquals(10L, frame.type());
            this.assertEquals(253L, frame.flags());
            this.assertEquals(expectedSend, frame.payload());
            req.response().writeCustomFrame(12, 134, expectedRecv).end();
        }));
        this.startServer();
        AtomicInteger status = new AtomicInteger();
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 4043, "localhost", "/somepath", resp -> {
            Context ctx = Vertx.currentContext();
            this.assertEquals(0L, status.getAndIncrement());
            resp.customFrameHandler(frame -> {
                this.assertOnIOContext(ctx);
                this.assertEquals(1L, status.getAndIncrement());
                this.assertEquals(12L, frame.type());
                this.assertEquals(134L, frame.flags());
                this.assertEquals(expectedRecv, frame.payload());
            });
            resp.endHandler(v -> {
                this.assertEquals(2L, status.getAndIncrement());
                this.testComplete();
            });
        });
        req2.sendHead(version -> {
            this.assertSame(HttpVersion.HTTP_2, version);
            req2.writeCustomFrame(10, 253, expectedSend);
            req2.end();
        });
        this.await();
    }

    @Test
    public void testClearTextUpgrade() throws Exception {
        this.testClearText(true);
    }

    @Test
    public void testClearTextWithPriorKnowledge() throws Exception {
        this.testClearText(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testClearText(boolean upgrade) throws Exception {
        ServerBootstrap bootstrap = this.createH2CServer((dec, enc) -> new Http2EventAdapter((Http2ConnectionEncoder)enc){
            final /* synthetic */ Http2ConnectionEncoder val$enc;
            {
                this.val$enc = http2ConnectionEncoder;
            }

            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                this.val$enc.writeHeaders(ctx, streamId, new DefaultHttp2Headers().status((CharSequence)"200"), 0, true, ctx.newPromise());
                ctx.flush();
            }
        }, upgrade);
        ChannelFuture s = bootstrap.bind("localhost", 8080).sync();
        try {
            this.client.close();
            this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(upgrade));
            this.client.get(8080, "localhost", "/somepath", resp1 -> {
                HttpConnection conn = resp1.request().connection();
                this.assertEquals(HttpVersion.HTTP_2, resp1.version());
                this.client.get(8080, "localhost", "/somepath", resp2 -> {
                    this.assertSame(conn, resp2.request().connection());
                    this.testComplete();
                }).exceptionHandler(this::fail).end();
            }).connectionHandler(conn -> System.out.println("CONNECTED " + conn)).exceptionHandler(this::fail).end();
            this.await();
        }
        finally {
            s.channel().close().sync();
        }
    }

    @Test
    public void testRejectClearTextUpgrade() throws Exception {
        System.setProperty("vertx.disableH2c", "true");
        try {
            this.server.close();
            this.server = this.vertx.createHttpServer(this.serverOptions.setUseAlpn(false).setSsl(false).setHost("localhost").setPort(8080));
            this.server.requestHandler(req -> {
                MultiMap headers = req.headers();
                String upgrade = headers.get("upgrade");
                this.assertEquals("localhost:8080", req.host());
                if ("h2c".equals(upgrade)) {
                    req.response().setStatusCode(400).end();
                } else {
                    req.response().end("wibble");
                }
                this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            });
            this.startServer();
            this.client.close();
            this.client = this.vertx.createHttpClient(this.clientOptions.setUseAlpn(false).setSsl(false));
            this.client.get(8080, "localhost", "/somepath", resp -> {
                this.assertEquals(400L, resp.statusCode());
                this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
                resp.bodyHandler(body -> this.testComplete());
            }).exceptionHandler(this::fail).end();
            this.await();
        }
        finally {
            System.clearProperty("vertx.disableH2c");
        }
    }

    @Test
    public void testIdleTimeout() throws Exception {
        this.testIdleTimeout(this.serverOptions, this.clientOptions.setDefaultPort(4043));
    }

    @Test
    public void testIdleTimeoutClearText() throws Exception {
        this.testIdleTimeout(new HttpServerOptions().setPort(8080).setHost("localhost"), this.clientOptions.setDefaultPort(8080).setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(true));
    }

    @Test
    public void testIdleTimeoutClearTextDirect() throws Exception {
        this.testIdleTimeout(new HttpServerOptions().setPort(8080).setHost("localhost"), this.clientOptions.setDefaultPort(8080).setUseAlpn(false).setSsl(false).setHttp2ClearTextUpgrade(false));
    }

    private void testIdleTimeout(HttpServerOptions serverOptions, HttpClientOptions clientOptions) throws Exception {
        this.waitFor(4);
        this.server.close();
        this.server = this.vertx.createHttpServer(serverOptions);
        this.server.requestHandler(req -> {
            req.connection().closeHandler(v -> this.complete());
            req.response().setChunked(true).write("somedata");
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(clientOptions.setIdleTimeout(2));
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            HttpClientRequest req = this.client.get("/somepath", resp -> resp.exceptionHandler(err -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertOnIOContext(ctx);
                this.complete();
            }));
            req.exceptionHandler(err -> this.complete());
            req.connectionHandler(conn -> conn.closeHandler(v2 -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.complete();
            }));
            req.sendHead();
        });
        this.await();
    }

    @Test
    public void testIdleTimoutNoConnections() throws Exception {
        this.waitFor(4);
        AtomicLong time = new AtomicLong();
        this.server.requestHandler(req -> {
            req.connection().closeHandler(v -> this.complete());
            req.response().end("somedata");
            this.complete();
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.clientOptions.setIdleTimeout(2));
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {
            resp.exceptionHandler(err -> this.fail());
            resp.endHandler(v -> {
                time.set(System.currentTimeMillis());
                this.complete();
            });
        });
        req2.exceptionHandler(err -> this.fail());
        req2.connectionHandler(conn -> conn.closeHandler(v -> {
            this.assertTrue(System.currentTimeMillis() - time.get() > 1000L);
            this.complete();
        }));
        req2.end();
        this.await();
    }

    @Test
    public void testSendPing() throws Exception {
        this.waitFor(2);
        Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.close();
        this.server.connectionHandler(conn -> conn.pingHandler(data -> {
            this.assertEquals(expected, data);
            this.complete();
        }));
        this.server.requestHandler(req -> {});
        this.startServer(ctx);
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {});
        req2.connectionHandler(conn -> conn.ping(expected, ar -> {
            this.assertTrue(ar.succeeded());
            Buffer buff = (Buffer)ar.result();
            this.assertEquals(expected, buff);
            this.complete();
        }));
        req2.end();
        this.await();
    }

    @Test
    public void testReceivePing() throws Exception {
        Buffer expected = TestUtils.randomBuffer(8);
        Context ctx = this.vertx.getOrCreateContext();
        this.server.close();
        this.server.connectionHandler(conn -> conn.ping(expected, ar -> {}));
        this.server.requestHandler(req -> {});
        this.startServer(ctx);
        HttpClientRequest req2 = this.client.get(4043, "localhost", "/somepath", resp -> {});
        req2.connectionHandler(conn -> conn.pingHandler(data -> {
            this.assertEquals(expected, data);
            this.complete();
        }));
        req2.end();
        this.await();
    }

    @Test
    public void testMaxConcurrencySingleConnection() throws Exception {
        this.testMaxConcurrency(1, 5);
    }

    @Test
    public void testMaxConcurrencyMultipleConnections() throws Exception {
        this.testMaxConcurrency(2, 1);
    }

    private void testMaxConcurrency(int poolSize, int maxConcurrency) throws Exception {
        int rounds = 1 + poolSize;
        int maxRequests = poolSize * maxConcurrency;
        int totalRequests = maxRequests + maxConcurrency;
        HashSet serverConns = new HashSet();
        this.server.connectionHandler(conn -> {
            serverConns.add(conn);
            this.assertTrue(serverConns.size() <= poolSize);
        });
        ArrayList requests = new ArrayList();
        this.server.requestHandler(req -> {
            if (requests.size() < maxRequests) {
                requests.add(req);
                if (requests.size() == maxRequests) {
                    this.vertx.setTimer(300L, v -> {
                        this.assertEquals(maxRequests, requests.size());
                        requests.forEach(r -> r.response().end());
                    });
                }
            } else {
                req.response().end();
            }
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions(this.clientOptions).setHttp2MaxPoolSize(poolSize).setHttp2MultiplexingLimit(maxConcurrency));
        AtomicInteger respCount = new AtomicInteger();
        Set clientConnections = Collections.synchronizedSet(new HashSet());
        for (int j = 0; j < rounds; ++j) {
            for (int i = 0; i < maxConcurrency; ++i) {
                this.client.get(4043, "localhost", "/somepath", resp -> resp.endHandler(v -> {
                    if (respCount.incrementAndGet() == totalRequests) {
                        this.testComplete();
                    }
                })).connectionHandler(clientConnections::add).end();
            }
            if (j >= poolSize) continue;
            int threshold = j + 1;
            Http2ClientTest.assertWaitUntil(() -> clientConnections.size() == threshold);
        }
        this.await();
    }

    @Test
    public void testConnectionWindowSize() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ClientTest.this.testComplete();
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions(this.clientOptions).setHttp2ConnectionWindowSize(131070));
        this.client.get(4043, "localhost", "/somepath", resp -> {}).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testUpdateConnectionWindowSize() throws Exception {
        ServerBootstrap bootstrap = this.createH2Server((decoder, encoder) -> new Http2EventAdapter(){

            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                Http2ClientTest.this.vertx.runOnContext(v -> {
                    Http2ClientTest.this.assertEquals(65535L, windowSizeIncrement);
                    Http2ClientTest.this.testComplete();
                });
            }
        });
        ChannelFuture s = bootstrap.bind("localhost", 4043).sync();
        this.client.get(4043, "localhost", "/somepath", resp -> {}).connectionHandler(conn -> {
            this.assertEquals(65535L, conn.getWindowSize());
            conn.setWindowSize(75535);
            this.assertEquals(75535L, conn.getWindowSize());
            conn.setWindowSize(131070);
            this.assertEquals(131070L, conn.getWindowSize());
        }).end();
        this.await();
    }

    @Test
    public void testWorkerVerticleException() throws Exception {
        AbstractVerticle workerVerticle = new AbstractVerticle(){

            public void start() throws Exception {
                try {
                    this.vertx.createHttpClient(Http2TestBase.createHttp2ClientOptions());
                    Http2ClientTest.this.fail("HttpClient should not work with HTTP_2");
                }
                catch (Exception ex) {
                    Http2ClientTest.this.assertEquals("Cannot use HttpClient with HTTP_2 in a worker", ex.getMessage());
                    Http2ClientTest.this.complete();
                }
            }
        };
        this.vertx.deployVerticle((Verticle)workerVerticle, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testExecuteBlockingException() throws Exception {
        this.vertx.executeBlocking(fut -> {
            try {
                this.vertx.createHttpClient(Http2ClientTest.createHttp2ClientOptions());
                this.fail("HttpClient should not work with HTTP_2 inside executeBlocking");
            }
            catch (Exception ex) {
                this.assertEquals("Cannot use HttpClient with HTTP_2 in a worker", ex.getMessage());
                this.complete();
            }
        }, null);
        this.await();
    }
}

