/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.metrics.Measured;
import io.vertx.test.core.Http2TestBase;
import io.vertx.test.core.HttpMetricsTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class Http2MetricsTest
extends HttpMetricsTestBase {
    public Http2MetricsTest() {
        super(HttpVersion.HTTP_2);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHandle100ContinueAutomatically(true));
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(8080, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Test
    public void testPushPromise() throws Exception {
        this.waitFor(2);
        int numBuffers = 10;
        int contentLength = numBuffers * 1000;
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
            FakeHttpServerMetrics serverMetrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric serverMetric = serverMetrics.getMetric(pushedResp);
            this.assertNotNull(serverMetric);
            pushedResp.putHeader("content-length", "" + contentLength);
            AtomicInteger numBuffer = new AtomicInteger(numBuffers);
            this.vertx.setPeriodic(1L, timerID -> {
                if (numBuffer.getAndDecrement() == 0) {
                    pushedResp.end();
                    this.assertNull(serverMetrics.getMetric(pushedResp));
                    this.vertx.cancelTimer(timerID.longValue());
                    this.complete();
                } else {
                    pushedResp.write(TestUtils.randomBuffer(1000));
                }
            });
        }));
        this.startServer();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath", resp -> {});
        req2.pushHandler(pushedReq -> {
            HttpClientMetric metric = metrics.getMetric((HttpClientRequest)pushedReq);
            this.assertNotNull(metric);
            this.assertSame(pushedReq, metric.request);
            pushedReq.handler(resp -> resp.endHandler(v -> {
                this.assertNull(metrics.getMetric((HttpClientRequest)pushedReq));
                this.complete();
            }));
        });
        req2.end();
        this.await();
    }
}

