/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.TestProxyBase;

public class SocksProxy
extends TestProxyBase {
    private static final Logger log = LoggerFactory.getLogger(SocksProxy.class);
    private static final Buffer clientInit = Buffer.buffer((byte[])new byte[]{5, 1, 0});
    private static final Buffer serverReply = Buffer.buffer((byte[])new byte[]{5, 0});
    private static final Buffer clientRequest = Buffer.buffer((byte[])new byte[]{5, 1, 0});
    private static final Buffer connectResponse = Buffer.buffer((byte[])new byte[]{5, 0, 0, 1, 127, 0, 0, 1, 39, 16});
    private static final Buffer errorResponse = Buffer.buffer((byte[])new byte[]{5, 4, 0, 1, 0, 0, 0, 0, 0, 0});
    private static final Buffer clientInitAuth = Buffer.buffer((byte[])new byte[]{5, 2, 0, 2});
    private static final Buffer serverReplyAuth = Buffer.buffer((byte[])new byte[]{5, 2});
    private static final Buffer authSuccess = Buffer.buffer((byte[])new byte[]{1, 0});
    private static final Buffer authFailed = Buffer.buffer((byte[])new byte[]{1, 1});
    private static final int PORT = 11080;
    private NetServer server;

    public SocksProxy(String username) {
        super(username);
    }

    @Override
    public void start(Vertx vertx, Handler<Void> finishedHandler) {
        NetServerOptions options = new NetServerOptions();
        options.setHost("localhost").setPort(11080);
        this.server = vertx.createNetServer(options);
        this.server.connectHandler(socket -> socket.handler(buffer -> {
            Buffer expectedInit;
            Buffer buffer4 = expectedInit = this.username == null ? clientInit : clientInitAuth;
            if (!buffer.equals(expectedInit)) {
                throw new IllegalStateException("expected " + this.toHex(expectedInit) + ", got " + this.toHex((Buffer)buffer));
            }
            boolean useAuth = buffer.equals(clientInitAuth);
            log.debug((Object)("got request: " + this.toHex((Buffer)buffer)));
            Handler handler = buffer2 -> {
                int port;
                String host;
                if (!buffer2.getBuffer(0, clientRequest.length()).equals(clientRequest)) {
                    throw new IllegalStateException("expected " + this.toHex(clientRequest) + ", got " + this.toHex((Buffer)buffer2));
                }
                short addressType = buffer2.getUnsignedByte(3);
                if (addressType == 1) {
                    if (buffer2.length() != 10) {
                        throw new IllegalStateException("format error in client request (attribute type ipv4), got " + this.toHex((Buffer)buffer2));
                    }
                    host = buffer2.getUnsignedByte(4) + "." + buffer2.getUnsignedByte(5) + "." + buffer2.getUnsignedByte(6) + "." + buffer2.getUnsignedByte(7);
                    port = buffer2.getUnsignedShort(8);
                } else if (addressType == 3) {
                    short stringLen = buffer2.getUnsignedByte(4);
                    log.debug((Object)("string len " + stringLen));
                    if (buffer2.length() != 7 + stringLen) {
                        throw new IllegalStateException("format error in client request (attribute type domain name), got " + this.toHex((Buffer)buffer2));
                    }
                    host = buffer2.getString(5, 5 + stringLen);
                    port = buffer2.getUnsignedShort(5 + stringLen);
                } else {
                    throw new IllegalStateException("expected address type ip (v4) or name, got " + addressType);
                }
                log.debug((Object)("got request: " + this.toHex((Buffer)buffer2)));
                log.debug((Object)("connect: " + host + ":" + port));
                socket.handler(null);
                this.lastUri = host + ":" + port;
                if (this.forceUri != null) {
                    host = this.forceUri.substring(0, this.forceUri.indexOf(58));
                    port = Integer.valueOf(this.forceUri.substring(this.forceUri.indexOf(58) + 1));
                }
                log.debug((Object)("connecting to " + host + ":" + port));
                NetClient netClient = vertx.createNetClient(new NetClientOptions());
                netClient.connect(port, host, result -> {
                    if (result.succeeded()) {
                        log.debug((Object)("writing: " + this.toHex(connectResponse)));
                        socket.write(connectResponse);
                        log.debug((Object)"connected, starting pump");
                        NetSocket clientSocket = (NetSocket)result.result();
                        socket.closeHandler(v -> clientSocket.close());
                        clientSocket.closeHandler(v -> socket.close());
                        Pump.pump((ReadStream)socket, (WriteStream)clientSocket).start();
                        Pump.pump((ReadStream)clientSocket, (WriteStream)socket).start();
                    } else {
                        log.error((Object)"exception", result.cause());
                        socket.handler(null);
                        log.debug((Object)("writing: " + this.toHex(errorResponse)));
                        socket.write(errorResponse);
                        socket.close();
                    }
                });
            };
            if (useAuth) {
                socket.handler(buffer3 -> {
                    log.debug((Object)"auth handler");
                    log.debug((Object)("got request: " + this.toHex((Buffer)buffer3)));
                    Buffer authReply = Buffer.buffer((byte[])new byte[]{1, (byte)this.username.length()});
                    authReply.appendString(this.username);
                    authReply.appendByte((byte)this.username.length());
                    authReply.appendString(this.username);
                    if (!buffer3.equals(authReply)) {
                        log.debug((Object)("expected " + this.toHex(authReply) + ", got " + this.toHex((Buffer)buffer3)));
                        socket.handler(null);
                        log.debug((Object)("writing: " + this.toHex(authFailed)));
                        socket.write(authFailed);
                        socket.close();
                    } else {
                        socket.handler(handler);
                        log.debug((Object)("writing: " + this.toHex(authSuccess)));
                        socket.write(authSuccess);
                    }
                });
                log.debug((Object)("writing: " + this.toHex(serverReplyAuth)));
                socket.write(serverReplyAuth);
            } else {
                socket.handler(handler);
                log.debug((Object)("writing: " + this.toHex(serverReply)));
                socket.write(serverReply);
            }
        }));
        this.server.listen(result -> {
            log.debug((Object)"socks5 server started");
            finishedHandler.handle(null);
        });
    }

    private String toHex(Buffer buffer) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            sb.append(String.format("%02X ", buffer.getByte(i)));
        }
        return sb.toString();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Override
    public int getPort() {
        return 11080;
    }
}

