/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core.net;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.pool.ConnectResult;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextImpl;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ConnectionPoolTest
extends VertxTestBase {
    @Test
    public void testConnectSuccess() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        final FakeConnectionManager mgr = new FakeConnectionManager(3, 4, connector);
        final AtomicReference handleLock = new AtomicReference();
        FakeWaiter waiter = new FakeWaiter(){

            @Override
            public synchronized void handleConnection(FakeConnection conn) {
                ConnectionPoolTest.this.assertNull(Vertx.currentContext());
                ConnectionPoolTest.this.assertSame(conn.context, this.context);
                Pool<FakeConnection> pool = mgr.pool();
                handleLock.set(Thread.holdsLock(pool));
                super.handleConnection(conn);
            }
        };
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertEquals(Boolean.FALSE, handleLock.get());
        waiter.assertSuccess(conn);
        waiter.recycle();
        this.assertEquals(0L, mgr.size());
        this.assertTrue(mgr.closed());
    }

    @Test
    public void testConnectFailure() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        final FakeConnectionManager mgr = new FakeConnectionManager(3, 4, connector);
        final AtomicReference holdsLock = new AtomicReference();
        FakeWaiter waiter = new FakeWaiter(){

            @Override
            public synchronized void handleFailure(Throwable failure) {
                ConnectionPoolTest.this.assertNull(Vertx.currentContext());
                Pool<FakeConnection> pool = mgr.pool();
                holdsLock.set(Thread.holdsLock(pool));
                super.handleFailure(failure);
            }
        };
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        Throwable failure = new Throwable();
        conn.fail(failure);
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertEquals(Boolean.FALSE, holdsLock.get());
        waiter.assertFailure(failure);
    }

    @Test
    public void testConnectPoolEmptyWaiterCancelledAfterConnectRequest() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        FakeWaiter waiter = new FakeWaiter();
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        waiter.cancel();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        this.assertFalse(waiter.isSuccess());
        this.assertFalse(waiter.isFailure());
        this.assertFalse(mgr.contains(conn));
    }

    @Test
    public void testConnectionFailure() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        FakeWaiter waiter = new FakeWaiter();
        mgr.getConnection(waiter);
        FakeConnection conn = connector.assertRequest();
        Exception expected = new Exception();
        conn.fail(expected);
        ConnectionPoolTest.assertWaitUntil(waiter::isComplete);
        waiter.assertFailure(expected);
        this.assertTrue(waiter.isFailure());
        ConnectionPoolTest.assertWaitUntil(mgr::closed);
    }

    @Test
    public void testSynchronousConnectionFailure() {
        final Throwable cause = new Throwable();
        FakeConnectionProviderBase connector = new FakeConnectionProviderBase(){

            public void connect(ConnectionListener<FakeConnection> listener, ContextImpl context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
                handler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        };
        FakeConnectionManager mgr = new FakeConnectionManager(3, 3, connector);
        for (int i = 0; i < 4; ++i) {
            FakeWaiter waiter = new FakeWaiter();
            mgr.getConnection(waiter);
            ConnectionPoolTest.waitUntil(waiter::isFailure);
            waiter.assertFailure(cause);
            this.assertEquals(0L, mgr.pool().weight());
        }
        this.assertTrue(mgr.closed());
    }

    @Test
    public void testRecycleConnection() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        connector.assertRequests(0);
        waiter1.recycle();
        ConnectionPoolTest.assertWaitUntil(waiter2::isComplete);
        waiter2.assertSuccess(conn);
    }

    @Test
    public void testRecycleDiscardedConnection() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        conn.close();
        waiter1.recycle();
        ConnectionPoolTest.assertWaitUntil(() -> connector.requests() == 1);
        this.assertFalse(mgr.closed());
        FakeConnection conn2 = connector.assertRequest();
        conn2.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
    }

    @Test
    public void testEndpointLifecycle() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.close();
        ConnectionPoolTest.assertWaitUntil(mgr::closed);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        this.assertEquals(2L, mgr.sequence());
    }

    @Test
    public void testDontCloseEndpointWithInflightRequest() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(3, 2, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isComplete);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        conn.close();
        ConnectionPoolTest.assertWaitUntil(() -> !mgr.contains(conn));
        this.assertFalse(mgr.closed());
    }

    @Test
    public void testInitialConcurrency() {
        int n = 10;
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        ArrayList<FakeWaiter> waiters = new ArrayList<FakeWaiter>();
        for (int i = 0; i < n; ++i) {
            FakeWaiter waiter2 = new FakeWaiter();
            mgr.getConnection(waiter2);
            waiters.add(waiter2);
        }
        FakeConnection conn = connector.assertRequest();
        conn.concurrency(n).connect();
        waiters.forEach(waiter -> ConnectionPoolTest.assertWaitUntil(waiter::isSuccess));
        waiters.forEach(FakeWaiter::recycle);
    }

    @Test
    public void testInitialNoConcurrency() {
        int n = 10;
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        ArrayList<FakeWaiter> waiters = new ArrayList<FakeWaiter>();
        for (int i = 0; i < n; ++i) {
            FakeWaiter waiter2 = new FakeWaiter();
            mgr.getConnection(waiter2);
            waiters.add(waiter2);
        }
        FakeConnection conn = connector.assertRequest();
        conn.concurrency(0L).connect().awaitConnected();
        conn.concurrency(n - 1);
        ConnectionPoolTest.assertWaitUntil(() -> waiters.stream().filter(FakeWaiter::isSuccess).count() == (long)(n - 1));
        waiters.stream().filter(FakeWaiter::isSuccess).findFirst().get().recycle();
        waiters.forEach(waiter -> ConnectionPoolTest.assertWaitUntil(waiter::isSuccess));
    }

    @Test
    public void testRecycleWithoutDispose() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.recycle(false);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(conn);
        conn.recycle(true);
        this.assertEquals(0L, mgr.size());
    }

    @Test
    public void testRecycleFIFO() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 2, connector, true);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection firstInConnection = connector.assertRequest();
        firstInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeConnection lastInConnection = connector.assertRequest();
        lastInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(lastInConnection);
        firstInConnection.recycle(false);
        lastInConnection.recycle(false);
        this.assertEquals(2L, mgr.size());
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        ConnectionPoolTest.assertWaitUntil(waiter3::isSuccess);
        waiter3.assertSuccess(firstInConnection);
    }

    @Test
    public void testRecycleLIFO() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 2, connector, false);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection firstInConnection = connector.assertRequest();
        firstInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeConnection lastInConnection = connector.assertRequest();
        lastInConnection.connect();
        ConnectionPoolTest.assertWaitUntil(waiter2::isSuccess);
        waiter2.assertSuccess(lastInConnection);
        firstInConnection.recycle(false);
        lastInConnection.recycle(false);
        this.assertEquals(2L, mgr.size());
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        ConnectionPoolTest.assertWaitUntil(waiter3::isSuccess);
        waiter3.assertSuccess(lastInConnection);
    }

    @Test
    public void testDiscardWaiterWhenFull() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(2, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        FakeWaiter waiter2 = new FakeWaiter();
        mgr.getConnection(waiter2);
        FakeWaiter waiter3 = new FakeWaiter();
        mgr.getConnection(waiter3);
        FakeWaiter waiter4 = new FakeWaiter();
        mgr.getConnection(waiter4);
        ConnectionPoolTest.assertWaitUntil(waiter4::isFailure);
    }

    @Test
    public void testDiscardExpiredConnections() {
        FakeConnectionProvider connector = new FakeConnectionProvider();
        FakeConnectionManager mgr = new FakeConnectionManager(2, 1, connector);
        FakeWaiter waiter1 = new FakeWaiter();
        mgr.getConnection(waiter1);
        FakeConnection conn = connector.assertRequest();
        conn.connect();
        ConnectionPoolTest.assertWaitUntil(waiter1::isSuccess);
        conn.recycle(2L);
        this.assertEquals(1L, mgr.size());
        this.assertEquals(0L, mgr.removeExpired(1L));
        this.assertEquals(1L, mgr.size());
        this.assertEquals(1L, mgr.removeExpired(2L));
        this.assertEquals(0L, mgr.size());
    }

    @Test
    public void testStress() {
        int i;
        int numActors = 16;
        int numConnections = 1000;
        FakeConnectionProvider connector = new FakeConnectionProvider(){

            @Override
            public void connect(ConnectionListener<FakeConnection> listener, ContextImpl context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
                int i = ThreadLocalRandom.current().nextInt(100);
                FakeConnection conn = new FakeConnection(context, listener, (Future<ConnectResult<FakeConnection>>)Future.future().setHandler(handler));
                if (i < 10) {
                    conn.fail(new Exception("Could not connect"));
                } else {
                    conn.connect();
                }
            }
        };
        FakeConnectionManager mgr = new FakeConnectionManager(-1, 16, connector);
        Thread[] actors = new Thread[numActors];
        for (i = 0; i < numActors; ++i) {
            actors[i] = new Thread(() -> {
                final CountDownLatch latch = new CountDownLatch(numConnections);
                for (int i1 = 0; i1 < numConnections; ++i1) {
                    mgr.getConnection(new FakeWaiter(){

                        @Override
                        public void handleFailure(Throwable failure) {
                            latch.countDown();
                        }

                        @Override
                        public void handleConnection(FakeConnection conn) {
                            int action = ThreadLocalRandom.current().nextInt(100);
                            if (action < -1) {
                                latch.countDown();
                                conn.listener.onRecycle(0L);
                            } else {
                                ConnectionPoolTest.this.vertx.setTimer(10L, id -> {
                                    if (action < 15) {
                                        conn.close();
                                    } else {
                                        conn.recycle();
                                    }
                                    latch.countDown();
                                });
                            }
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            actors[i].start();
        }
        for (i = 0; i < actors.length; ++i) {
            try {
                actors[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ConnectionPoolTest.assertWaitUntil(() -> mgr.closed());
        this.assertEquals(0L, mgr.size());
        this.assertEquals(0L, mgr.pool.waitersCount());
        this.assertEquals(0L, mgr.pool.waitersInQueue());
        this.assertEquals(0L, mgr.pool.weight());
        this.assertEquals(0L, mgr.pool.capacity());
    }

    class FakeConnectionProvider
    extends FakeConnectionProviderBase {
        private final Deque<FakeConnection> pendingRequests;

        FakeConnectionProvider() {
            this.pendingRequests = new ConcurrentLinkedDeque<FakeConnection>();
        }

        void assertRequests(int expectedSize) {
            ConnectionPoolTest.this.assertEquals(expectedSize, this.pendingRequests.size());
        }

        int requests() {
            return this.pendingRequests.size();
        }

        FakeConnection assertRequest() {
            AsyncTestBase.waitUntil(() -> this.pendingRequests.size() > 0);
            FakeConnection request = this.pendingRequests.poll();
            ConnectionPoolTest.this.assertNotNull(request);
            return request;
        }

        public void connect(ConnectionListener<FakeConnection> listener, ContextImpl context, Handler<AsyncResult<ConnectResult<FakeConnection>>> handler) {
            this.pendingRequests.add(new FakeConnection(context, listener, (Future<ConnectResult<FakeConnection>>)Future.future().setHandler(handler)));
        }
    }

    abstract class FakeConnectionProviderBase
    implements ConnectionProvider<FakeConnection> {
        FakeConnectionProviderBase() {
        }

        public void close(FakeConnection conn) {
            conn.listener.onDiscard();
        }
    }

    class FakeConnection {
        private static final int DISCONNECTED = 0;
        private static final int CONNECTING = 1;
        private static final int CONNECTED = 2;
        private static final int CLOSED = 3;
        private final ContextImpl context;
        private final ConnectionListener<FakeConnection> listener;
        private final Future<ConnectResult<FakeConnection>> future;
        private final Channel channel = new EmbeddedChannel();
        private long inflight;
        private long concurrency = 1L;
        private int status = 0;

        FakeConnection(ContextImpl context, ConnectionListener<FakeConnection> listener, Future<ConnectResult<FakeConnection>> future) {
            this.context = context;
            this.listener = listener;
            this.future = future;
        }

        synchronized void close() {
            if (this.status != 2) {
                throw new IllegalStateException();
            }
            this.status = 3;
            this.listener.onDiscard();
        }

        synchronized long recycle(boolean dispose) {
            return this.recycle(dispose ? 0L : Long.MAX_VALUE);
        }

        synchronized long recycle() {
            return this.recycle(true);
        }

        synchronized long recycle(long timestamp) {
            --this.inflight;
            this.listener.onRecycle(timestamp);
            return this.inflight;
        }

        synchronized FakeConnection concurrency(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("Invalid concurrency");
            }
            if (this.status == 2) {
                if (this.concurrency != value) {
                    this.concurrency = value;
                    this.listener.onConcurrencyChange(value);
                }
            } else {
                this.concurrency = value;
            }
            return this;
        }

        FakeConnection awaitConnected() {
            AsyncTestBase.waitUntil(() -> {
                FakeConnection fakeConnection = this;
                synchronized (fakeConnection) {
                    return this.status == 2;
                }
            });
            return this;
        }

        synchronized FakeConnection connect() {
            if (this.status != 0) {
                throw new IllegalStateException();
            }
            this.status = 1;
            this.context.nettyEventLoop().execute(() -> {
                FakeConnection fakeConnection = this;
                synchronized (fakeConnection) {
                    this.status = 2;
                    this.future.complete((Object)new ConnectResult((Object)this, this.concurrency, this.channel, this.context, 1L));
                }
            });
            return this;
        }

        void fail(Throwable err) {
            this.context.nettyEventLoop().execute(() -> this.future.tryFail(err));
        }
    }

    class FakeWaiter {
        protected final ContextImpl context;
        private boolean cancelled;
        private boolean completed;
        private Object result;
        private final Handler<AsyncResult<FakeConnection>> handler;

        FakeWaiter() {
            this.context = (ContextImpl)ConnectionPoolTest.this.vertx.getOrCreateContext();
            this.handler = ar -> {
                if (ar.succeeded()) {
                    this.handleConnection((FakeConnection)ar.result());
                } else {
                    this.handleFailure(ar.cause());
                }
            };
        }

        synchronized boolean cancel() {
            if (this.completed) {
                return false;
            }
            this.cancelled = true;
            return true;
        }

        synchronized void assertSuccess(FakeConnection conn) {
            ConnectionPoolTest.this.assertSame(conn, this.result);
        }

        synchronized void assertFailure(Throwable failure) {
            ConnectionPoolTest.this.assertSame(failure, this.result);
        }

        synchronized boolean isComplete() {
            return this.completed;
        }

        synchronized boolean isSuccess() {
            return this.completed && this.result instanceof FakeConnection;
        }

        synchronized boolean isFailure() {
            return this.completed && this.result instanceof Throwable;
        }

        public synchronized void handleFailure(Throwable failure) {
            ConnectionPoolTest.this.assertFalse(this.completed);
            this.completed = true;
            this.result = failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void handleConnection(FakeConnection conn) {
            ConnectionPoolTest.this.assertFalse(this.completed);
            this.completed = true;
            if (this.cancelled) {
                conn.listener.onRecycle(0L);
            } else {
                FakeConnection fakeConnection = conn;
                synchronized (fakeConnection) {
                    conn.inflight++;
                }
                this.result = conn;
            }
        }

        long recycle() {
            FakeConnection conn = (FakeConnection)this.result;
            return conn.recycle();
        }
    }

    class FakeConnectionManager {
        private final ConnectionProvider<FakeConnection> connector;
        private final int queueMaxSize;
        private final int maxPoolSize;
        private Pool<FakeConnection> pool;
        private Set<FakeConnection> active = new HashSet<FakeConnection>();
        private boolean closed = true;
        private int seq;
        private final boolean fifo;

        FakeConnectionManager(int queueMaxSize, int maxPoolSize, ConnectionProvider<FakeConnection> connector) {
            this(queueMaxSize, maxPoolSize, connector, false);
        }

        FakeConnectionManager(int queueMaxSize, int maxPoolSize, ConnectionProvider<FakeConnection> connector, boolean fifo) {
            this.queueMaxSize = queueMaxSize;
            this.maxPoolSize = maxPoolSize;
            this.connector = connector;
            this.fifo = fifo;
        }

        synchronized int sequence() {
            return this.seq;
        }

        synchronized boolean closed() {
            return this.closed;
        }

        synchronized boolean contains(FakeConnection conn) {
            return this.active.contains(conn);
        }

        synchronized int size() {
            return this.active.size();
        }

        int removeExpired(long timestamp) {
            return this.pool.closeIdle(timestamp);
        }

        synchronized Pool<FakeConnection> pool() {
            return this.pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getConnection(FakeWaiter waiter) {
            FakeConnectionManager fakeConnectionManager = this;
            synchronized (fakeConnectionManager) {
                if (this.closed) {
                    ++this.seq;
                    this.closed = false;
                    this.pool = new Pool(this.connector, this.queueMaxSize, 1L, (long)this.maxPoolSize, v -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.closed = true;
                        }
                    }, (channel, conn) -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.active.add((FakeConnection)conn);
                        }
                    }, (channel, conn) -> {
                        FakeConnectionManager fakeConnectionManager = this;
                        synchronized (fakeConnectionManager) {
                            this.active.remove(conn);
                        }
                    }, this.fifo);
                }
            }
            this.pool.getConnection(waiter.context, waiter.handler);
        }
    }
}

