/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FakeHttpServerMetrics
extends FakeMetricsBase
implements HttpServerMetrics<HttpServerMetric, WebSocketMetric, SocketMetric> {
    private final ConcurrentMap<WebSocketBase, WebSocketMetric> webSockets = new ConcurrentHashMap<WebSocketBase, WebSocketMetric>();
    private final ConcurrentHashSet<HttpServerMetric> requests = new ConcurrentHashSet();
    public final HttpServer server;

    public FakeHttpServerMetrics(HttpServer server) {
        super((Measured)server);
        this.server = server;
    }

    public WebSocketMetric getMetric(ServerWebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws);
    }

    public HttpServerMetric getMetric(HttpServerRequest request) {
        return this.requests.stream().filter(m -> m.request == request).findFirst().orElse(null);
    }

    public HttpServerMetric getMetric(HttpServerResponse response) {
        return this.requests.stream().filter(m -> m.response.get() == response).findFirst().orElse(null);
    }

    public HttpServerMetric requestBegin(SocketMetric socketMetric, HttpServerRequest request) {
        HttpServerMetric metric = new HttpServerMetric(request, socketMetric);
        this.requests.add((Object)metric);
        return metric;
    }

    public HttpServerMetric responsePushed(SocketMetric socketMetric, HttpMethod method, String uri, HttpServerResponse response) {
        HttpServerMetric requestMetric = new HttpServerMetric(null, socketMetric);
        requestMetric.response.set(response);
        this.requests.add((Object)requestMetric);
        return requestMetric;
    }

    public void requestReset(HttpServerMetric requestMetric) {
        requestMetric.failed.set(true);
        this.requests.remove((Object)requestMetric);
    }

    public void responseEnd(HttpServerMetric requestMetric, HttpServerResponse response) {
        this.requests.remove((Object)requestMetric);
    }

    public WebSocketMetric upgrade(HttpServerMetric requestMetric, ServerWebSocket serverWebSocket) {
        this.requests.remove((Object)requestMetric);
        WebSocketMetric metric = new WebSocketMetric(requestMetric.socket, (WebSocketBase)serverWebSocket);
        this.webSockets.put((WebSocketBase)serverWebSocket, metric);
        return metric;
    }

    public WebSocketMetric connected(SocketMetric socketMetric, ServerWebSocket serverWebSocket) {
        WebSocketMetric metric = new WebSocketMetric(socketMetric, (WebSocketBase)serverWebSocket);
        this.webSockets.put((WebSocketBase)serverWebSocket, metric);
        return metric;
    }

    public void disconnected(WebSocketMetric serverWebSocketMetric) {
        this.webSockets.remove(serverWebSocketMetric.ws);
    }

    public SocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        return new SocketMetric(remoteAddress, remoteName);
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.connected.set(false);
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

