/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.spi.metrics.HttpClientMetrics;

class Http1xClientHandler
extends VertxHttpHandler<Http1xClientConnection> {
    private boolean closeFrameSent;
    private ContextImpl context;
    private ChannelHandlerContext chctx;
    private final HttpVersion version;
    private final String peerHost;
    private final String host;
    private final int port;
    private final boolean ssl;
    private final HttpClientImpl client;
    private final HttpClientMetrics metrics;
    private final ConnectionListener<HttpClientConnection> listener;
    private final Object endpointMetric;

    public Http1xClientHandler(ConnectionListener<HttpClientConnection> listener, ContextImpl context, HttpVersion version, String peerHost, String host, int port, boolean ssl, HttpClientImpl client, Object endpointMetric, HttpClientMetrics metrics) {
        this.context = context;
        this.version = version;
        this.client = client;
        this.peerHost = peerHost;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.endpointMetric = endpointMetric;
        this.metrics = metrics;
        this.listener = listener;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        Http1xClientConnection conn = new Http1xClientConnection(this.listener, this.version, this.client, this.endpointMetric, ctx, this.ssl, this.peerHost, this.host, this.port, this.context, this.metrics);
        if (this.metrics != null) {
            this.context.executeFromIO(() -> {
                Object metric = this.metrics.connected(conn.remoteAddress(), conn.remoteName());
                conn.metric(metric);
                this.metrics.endpointConnected(this.endpointMetric, metric);
            });
        }
        this.setConnection(conn);
    }

    public ChannelHandlerContext context() {
        return this.chctx;
    }

    @Override
    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        if (this.metrics != null) {
            this.metrics.endpointDisconnected(this.endpointMetric, ((Http1xClientConnection)this.getConnection()).metric());
        }
        super.channelInactive(chctx);
    }

    @Override
    protected void handleMessage(Http1xClientConnection conn, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (msg instanceof HttpObject) {
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                conn.handleException(result.cause());
                conn.close();
                return;
            }
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)obj;
                conn.handleResponse(response);
                return;
            }
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)obj;
                if (chunk.content().isReadable()) {
                    Buffer buff = Buffer.buffer(chunk.content().slice());
                    conn.handleResponseChunk(buff);
                }
                if (chunk instanceof LastHttpContent) {
                    conn.handleResponseEnd((LastHttpContent)chunk);
                }
                return;
            }
        } else if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            switch (frame.type()) {
                case BINARY: 
                case CONTINUATION: 
                case TEXT: 
                case PONG: {
                    conn.handleWsFrame(frame);
                    break;
                }
                case PING: {
                    chctx.writeAndFlush((Object)new PongWebSocketFrame(frame.getBinaryData().copy()));
                    break;
                }
                case CLOSE: {
                    conn.handleWsFrame(frame);
                    if (this.closeFrameSent) break;
                    chctx.writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.closeFrameSent = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type: " + (Object)((Object)frame.type()));
                }
            }
            return;
        }
        throw new IllegalStateException("Invalid object " + msg);
    }
}

