/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.VertxHttpRequestDecoder;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.VertxHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HttpServerHandlerBenchmark
extends BenchmarkBase {
    ByteBuf GET;
    int readerIndex;
    int writeIndex;
    VertxInternal vertx;
    EmbeddedChannel vertxChannel;
    EmbeddedChannel nettyChannel;
    private static final CharSequence RESPONSE_TYPE_PLAIN = HttpHeaders.createOptimized((String)"text/plain");
    private static final String HELLO_WORLD = "Hello, world!";
    private static final Buffer HELLO_WORLD_BUFFER = Buffer.buffer((String)"Hello, world!");
    private static final CharSequence HEADER_SERVER = HttpHeaders.createOptimized((String)"server");
    private static final CharSequence HEADER_DATE = HttpHeaders.createOptimized((String)"date");
    private static final CharSequence HEADER_CONTENT_TYPE = HttpHeaders.createOptimized((String)"content-type");
    private static final CharSequence HEADER_CONTENT_LENGTH = HttpHeaders.createOptimized((String)"content-length");
    private static final CharSequence HELLO_WORLD_LENGTH = HttpHeaders.createOptimized((String)("" + "Hello, world!".length()));
    private static final CharSequence SERVER = HttpHeaders.createOptimized((String)"vert.x");
    private static final CharSequence DATE_STRING = HttpHeaders.createOptimized((String)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(ByteBuf buf) {
    }

    @Setup
    public void setup() {
        this.vertx = (VertxInternal)Vertx.vertx();
        HttpServerOptions options = new HttpServerOptions();
        this.vertxChannel = new EmbeddedChannel(new ChannelHandler[]{new VertxHttpRequestDecoder(options), new HttpResponseEncoder(){

            protected void encodeHeaders(io.netty.handler.codec.http.HttpHeaders headers, ByteBuf buf) {
                ((VertxHttpHeaders)headers).encode(buf);
            }
        }});
        this.vertxChannel.config().setAllocator((ByteBufAllocator)new Alloc());
        EventLoopContext context = new EventLoopContext(this.vertx, this.vertxChannel.eventLoop(), null, null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
        Handler app = request -> {
            HttpServerResponse response = request.response();
            MultiMap headers = response.headers();
            headers.add(HEADER_CONTENT_TYPE, RESPONSE_TYPE_PLAIN).add(HEADER_SERVER, SERVER).add(HEADER_DATE, DATE_STRING).add(HEADER_CONTENT_LENGTH, HELLO_WORLD_LENGTH);
            response.end(HELLO_WORLD_BUFFER);
        };
        HandlerHolder holder = new HandlerHolder((ContextInternal)context, (Object)new HttpHandlers(null, app, null, null, null));
        VertxHandler handler = VertxHandler.create((ContextInternal)holder.context, chctx -> new Http1xServerConnection(holder.context.owner(), null, new HttpServerOptions(), chctx, holder.context, "localhost", (HttpHandlers)holder.handler, null));
        this.vertxChannel.pipeline().addLast("handler", (ChannelHandler)handler);
        this.nettyChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(options.getMaxInitialLineLength(), options.getMaxHeaderSize(), options.getMaxChunkSize(), false, options.getDecoderInitialBufferSize()), new HttpResponseEncoder(), new SimpleChannelInboundHandler<HttpRequest>(){
            private final byte[] STATIC_PLAINTEXT = "Hello, World!".getBytes(CharsetUtil.UTF_8);
            private final int STATIC_PLAINTEXT_LEN = this.STATIC_PLAINTEXT.length;
            private final ByteBuf PLAINTEXT_CONTENT_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().writeBytes(this.STATIC_PLAINTEXT));
            private final CharSequence PLAINTEXT_CLHEADER_VALUE = new AsciiString((CharSequence)String.valueOf(this.STATIC_PLAINTEXT_LEN));
            private final CharSequence TYPE_PLAIN = new AsciiString((CharSequence)"text/plain");
            private final CharSequence SERVER_NAME = new AsciiString((CharSequence)"Netty");
            private final CharSequence CONTENT_TYPE_ENTITY = HttpHeaderNames.CONTENT_TYPE;
            private final CharSequence DATE_ENTITY = HttpHeaderNames.DATE;
            private final CharSequence CONTENT_LENGTH_ENTITY = HttpHeaderNames.CONTENT_LENGTH;
            private final CharSequence SERVER_ENTITY = HttpHeaderNames.SERVER;
            private final DateFormat FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");
            private final CharSequence date = new AsciiString((CharSequence)this.FORMAT.format(new Date()));

            protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
                this.writeResponse(ctx, msg, this.PLAINTEXT_CONTENT_BUFFER.duplicate(), this.TYPE_PLAIN, this.PLAINTEXT_CLHEADER_VALUE);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                ctx.flush();
            }

            private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, ByteBuf buf, CharSequence contentType, CharSequence contentLength) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf, false);
                io.netty.handler.codec.http.HttpHeaders headers = response.headers();
                headers.set(this.CONTENT_TYPE_ENTITY, (Object)contentType);
                headers.set(this.SERVER_ENTITY, (Object)this.SERVER_NAME);
                headers.set(this.DATE_ENTITY, (Object)this.date);
                headers.set(this.CONTENT_LENGTH_ENTITY, (Object)contentLength);
                ctx.write((Object)response, ctx.voidPromise());
            }
        }});
        this.nettyChannel.config().setAllocator((ByteBufAllocator)new Alloc());
        this.GET = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])"GET / HTTP/1.1\r\n\r\n".getBytes()));
        this.readerIndex = this.GET.readerIndex();
        this.writeIndex = this.GET.writerIndex();
    }

    @Benchmark
    public void vertx() {
        this.GET.setIndex(this.readerIndex, this.writeIndex);
        this.vertxChannel.writeInbound(new Object[]{this.GET});
        ByteBuf result = (ByteBuf)this.vertxChannel.outboundMessages().poll();
        HttpServerHandlerBenchmark.consume(result);
    }

    @Fork(value=1, jvmArgsAppend={"-Dvertx.threadChecks=false", "-Dvertx.disableContextTimings=true", "-Dvertx.disableTCCL=true", "-Dvertx.disableHttpHeadersValidation=true"})
    @Benchmark
    public void vertxOpt() {
        this.GET.setIndex(this.readerIndex, this.writeIndex);
        this.vertxChannel.writeInbound(new Object[]{this.GET});
        ByteBuf result = (ByteBuf)this.vertxChannel.outboundMessages().poll();
        HttpServerHandlerBenchmark.consume(result);
    }

    @Benchmark
    public void netty() {
        this.GET.setIndex(this.readerIndex, this.writeIndex);
        this.nettyChannel.writeInbound(new Object[]{this.GET});
        ByteBuf result = (ByteBuf)this.nettyChannel.outboundMessages().poll();
        HttpServerHandlerBenchmark.consume(result);
    }

    static class Alloc
    implements ByteBufAllocator {
        private final ByteBuf buf = Unpooled.buffer();
        private final int capacity = this.buf.capacity();

        Alloc() {
        }

        public ByteBuf buffer() {
            this.buf.clear();
            return this.buf;
        }

        public ByteBuf buffer(int initialCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException();
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException();
        }

        public ByteBuf ioBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectBufferPooled() {
            throw new UnsupportedOperationException();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }
    }
}

