/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Test;

public class CreateVertxTest
extends VertxTestBase {
    @Test
    public void testCreateSimpleVertx() {
        Vertx vertx = this.vertx();
        this.assertNotNull(vertx);
    }

    @Test
    public void testCreateVertxWithOptions() {
        VertxOptions options = new VertxOptions();
        Vertx vertx = this.vertx(options);
        this.assertNotNull(vertx);
        this.assertFalse(vertx.isClustered());
    }

    @Test
    public void testFailCreateClusteredVertxSynchronously() {
        VertxOptions options = new VertxOptions();
        options.setClustered(true);
        try {
            Vertx.vertx((VertxOptions)options);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateClusteredVertxAsync() {
        VertxOptions options = new VertxOptions();
        options.setClustered(true);
        this.clusteredVertx(options, (Handler<AsyncResult<Vertx>>)((Handler)ar -> {
            this.assertTrue(ar.succeeded());
            this.assertNotNull(ar.result());
            this.assertTrue(((Vertx)ar.result()).isClustered());
            Vertx v = (Vertx)ar.result();
            v.close(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testCreateClusteredVertxAsyncDontSetClustered() {
        VertxOptions options = new VertxOptions();
        this.clusteredVertx(options, (Handler<AsyncResult<Vertx>>)((Handler)ar -> {
            this.assertTrue(ar.succeeded());
            this.assertNotNull(ar.result());
            this.assertTrue(options.isClustered());
            this.assertTrue(((Vertx)ar.result()).isClustered());
            Vertx v = (Vertx)ar.result();
            v.close(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testCreateClusteredVertxAsyncDetectJoinFailure() {
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)new FakeClusterManager(){

            @Override
            public void join(Handler<AsyncResult<Void>> resultHandler) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)new Exception("joinfailure")));
            }
        });
        this.clusteredVertx(options, (Handler<AsyncResult<Vertx>>)((Handler)ar -> {
            this.assertTrue(ar.failed());
            this.assertEquals("joinfailure", ar.cause().getMessage());
            this.testComplete();
        }));
        this.await();
    }
}

