/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Test;

public class TimerTest
extends VertxTestBase {
    @Test
    public void testTimer() throws Exception {
        this.timer(1L);
    }

    @Test
    public void testPeriodic() throws Exception {
        this.periodic(10L);
    }

    @Test
    public void testTimings() throws Exception {
        long start = System.currentTimeMillis();
        long delay = 2000L;
        this.vertx.setTimer(2000L, timerID -> {
            long dur = System.currentTimeMillis() - start;
            this.assertTrue(dur >= 2000L);
            long maxDelay = 4000L;
            this.assertTrue("Timer accuracy: " + dur + " vs " + maxDelay, dur < maxDelay);
            this.vertx.cancelTimer(timerID.longValue());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInVerticle() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            AtomicInteger cnt = new AtomicInteger();

            MyVerticle() {
            }

            public void start() {
                Thread thr = Thread.currentThread();
                this.vertx.setTimer(1L, id -> {
                    TimerTest.this.assertSame(thr, Thread.currentThread());
                    if (this.cnt.incrementAndGet() == 5) {
                        TimerTest.this.testComplete();
                    }
                });
                this.vertx.setPeriodic(2L, id -> {
                    TimerTest.this.assertSame(thr, Thread.currentThread());
                    if (this.cnt.incrementAndGet() == 5) {
                        TimerTest.this.testComplete();
                    }
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle);
        this.await();
    }

    private void periodic(long delay) throws Exception {
        int numFires = 10;
        final AtomicLong id = new AtomicLong(-1L);
        id.set(this.vertx.setPeriodic(delay, (Handler)new Handler<Long>(){
            int count;

            public void handle(Long timerID) {
                TimerTest.this.assertEquals(id.get(), timerID);
                ++this.count;
                if (this.count == 10) {
                    TimerTest.this.vertx.cancelTimer(timerID.longValue());
                    TimerTest.this.setEndTimer();
                }
                if (this.count > 10) {
                    TimerTest.this.fail("Fired too many times");
                }
            }
        }));
        this.await();
    }

    private void timer(long delay) throws Exception {
        final AtomicLong id = new AtomicLong(-1L);
        id.set(this.vertx.setTimer(delay, (Handler)new Handler<Long>(){
            int count;
            boolean fired;

            public void handle(Long timerID) {
                TimerTest.this.assertFalse(this.fired);
                this.fired = true;
                TimerTest.this.assertEquals(id.get(), timerID);
                TimerTest.this.assertEquals(0L, this.count);
                ++this.count;
                TimerTest.this.setEndTimer();
            }
        }));
        this.await();
    }

    private void setEndTimer() {
        this.vertx.setTimer(10L, id -> this.testComplete());
    }

    @Test
    public void testTimerStreamSetHandlerSchedulesTheTimer() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean handled = new AtomicBoolean();
            timer.handler(l -> {
                this.assertFalse(handled.get());
                handled.set(true);
            });
            timer.endHandler(v2 -> {
                this.assertTrue(handled.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerStreamExceptionDuringHandle() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean handled = new AtomicBoolean();
            timer.handler(l -> {
                this.assertFalse(handled.get());
                handled.set(true);
                throw new RuntimeException();
            });
            timer.endHandler(v2 -> {
                this.assertTrue(handled.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerStreamCallingWithNullHandlerCancelsTheTimer() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicInteger count = new AtomicInteger();
            timer.handler(arg_0 -> this.lambda$null$9(count, (ReadStream)timer, arg_0));
        });
        this.await();
    }

    @Test
    public void testTimerStreamCancellation() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            AtomicBoolean called = new AtomicBoolean();
            timer.handler(l -> called.set(true));
            timer.cancel();
            this.vertx.setTimer(500L, id -> {
                this.assertFalse(called.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTimerSetHandlerTwice() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(200L);
            timer.handler(l -> this.testComplete());
            try {
                timer.handler(l -> this.fail());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.await();
    }

    @Test
    public void testTimerPauseResume() throws Exception {
        TimeoutStream timer = this.vertx.timerStream(10L);
        timer.handler(l -> this.testComplete());
        timer.pause();
        timer.resume();
        this.await();
    }

    @Test
    public void testTimerPause() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.timerStream(10L);
            timer.handler(l -> this.fail());
            timer.endHandler(l -> this.testComplete());
            timer.pause();
        });
        this.await();
    }

    @Test
    public void testPeriodicStreamHandler() throws Exception {
        TimeoutStream timer = this.vertx.periodicStream(10L);
        AtomicInteger count = new AtomicInteger();
        timer.handler(l -> {
            int value = count.incrementAndGet();
            switch (value) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new RuntimeException();
                }
                case 2: {
                    timer.cancel();
                    this.testComplete();
                    break;
                }
                default: {
                    this.fail();
                }
            }
        });
        timer.endHandler(v -> this.fail());
        this.await();
    }

    @Test
    public void testPeriodicSetHandlerTwice() throws Exception {
        this.vertx.runOnContext(v -> {
            TimeoutStream timer = this.vertx.periodicStream(200L);
            timer.handler(l -> this.testComplete());
            try {
                timer.handler(l -> this.fail());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.await();
    }

    @Test
    public void testPeriodicPauseResume() throws Exception {
        TimeoutStream timer = this.vertx.periodicStream(200L);
        AtomicInteger count = new AtomicInteger();
        timer.handler(arg_0 -> this.lambda$testPeriodicPauseResume$27(count, (ReadStream)timer, arg_0));
        this.await();
    }

    @Test
    public void testTimeoutStreamEndCallbackAsynchronously() {
        TimeoutStream stream = this.vertx.timerStream(200L);
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v2 -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            this.testComplete();
        });
        stream.handler(id -> {});
        this.await();
    }

    @Test
    public void testCancelTimerWhenScheduledOnWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                long id = this.vertx.setTimer(100L, id_ -> TimerTest.this.fail());
                Thread.sleep(200L);
                TimerTest.this.assertTrue(this.vertx.cancelTimer(id));
                TimerTest.this.testComplete();
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    private /* synthetic */ void lambda$testPeriodicPauseResume$27(AtomicInteger count, ReadStream timer, Long id) {
        int cnt = count.incrementAndGet();
        if (cnt == 2) {
            timer.pause();
            this.vertx.setTimer(500L, id2 -> {
                this.assertEquals(2L, count.get());
                timer.resume();
            });
        } else if (cnt == 3) {
            this.testComplete();
        }
    }

    private /* synthetic */ void lambda$null$9(AtomicInteger count, ReadStream timer, Long l) {
        if (count.incrementAndGet() == 1) {
            timer.handler(null);
            this.vertx.setTimer(200L, id -> {
                this.assertEquals(1L, count.get());
                this.testComplete();
            });
        } else {
            this.fail();
        }
    }
}

