/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class VertxOptionsTest
extends VertxTestBase {
    @Test
    public void testOptions() {
        VertxOptions options = new VertxOptions();
        this.assertEquals(2 * Runtime.getRuntime().availableProcessors(), options.getEventLoopPoolSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setEventLoopPoolSize(rand));
        this.assertEquals(rand, options.getEventLoopPoolSize());
        try {
            options.setEventLoopPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(20L, options.getWorkerPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setWorkerPoolSize(rand));
        this.assertEquals(rand, options.getWorkerPoolSize());
        try {
            options.setWorkerPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(20L, options.getInternalBlockingPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setInternalBlockingPoolSize(rand));
        this.assertEquals(rand, options.getInternalBlockingPoolSize());
        try {
            options.setInternalBlockingPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertFalse(options.isClustered());
        this.assertEquals(options, options.setClustered(true));
        this.assertTrue(options.isClustered());
        this.assertEquals(0L, options.getClusterPort());
        this.assertEquals(options, options.setClusterPort(1234));
        this.assertEquals(1234L, options.getClusterPort());
        try {
            options.setClusterPort(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setClusterPort(65536);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(-1L, options.getClusterPublicPort());
        this.assertEquals(options, options.setClusterPublicPort(1234));
        this.assertEquals(1234L, options.getClusterPublicPort());
        try {
            options.setClusterPublicPort(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setClusterPublicPort(65536);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals("localhost", options.getClusterHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setClusterHost(randString));
        this.assertEquals(randString, options.getClusterHost());
        this.assertEquals(null, options.getClusterPublicHost());
        randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setClusterPublicHost(randString));
        this.assertEquals(randString, options.getClusterPublicHost());
        this.assertEquals(20000L, options.getClusterPingInterval());
        long randomLong = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setClusterPingInterval(randomLong));
        this.assertEquals(randomLong, options.getClusterPingInterval());
        try {
            options.setClusterPingInterval(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            this.assertEquals(randomLong, options.getClusterPingInterval());
        }
        this.assertEquals(20000L, options.getClusterPingReplyInterval());
        randomLong = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setClusterPingReplyInterval(randomLong));
        this.assertEquals(randomLong, options.getClusterPingReplyInterval());
        try {
            options.setClusterPingReplyInterval(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            this.assertEquals(randomLong, options.getClusterPingReplyInterval());
        }
        this.assertEquals(1000L, options.getBlockedThreadCheckInterval());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setBlockedThreadCheckInterval((long)rand));
        this.assertEquals(rand, options.getBlockedThreadCheckInterval());
        try {
            options.setBlockedThreadCheckInterval(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.assertEquals(2000000000L, options.getMaxEventLoopExecuteTime());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxEventLoopExecuteTime((long)rand));
        this.assertEquals(rand, options.getMaxEventLoopExecuteTime());
        try {
            options.setMaxEventLoopExecuteTime(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.assertEquals(60000000000L, options.getMaxWorkerExecuteTime());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxWorkerExecuteTime((long)rand));
        this.assertEquals(rand, options.getMaxWorkerExecuteTime());
        try {
            options.setMaxWorkerExecuteTime(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        FakeClusterManager mgr = new FakeClusterManager();
        this.assertNull(options.getClusterManager());
        this.assertEquals(options, options.setClusterManager((ClusterManager)mgr));
        this.assertSame(mgr, options.getClusterManager());
        this.assertFalse(options.isHAEnabled());
        this.assertEquals(options, options.setHAEnabled(true));
        this.assertTrue(options.isHAEnabled());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(1L, options.getQuorumSize());
        this.assertEquals(options, options.setQuorumSize(rand));
        this.assertEquals(rand, options.getQuorumSize());
        try {
            options.setQuorumSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setQuorumSize(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals("__DEFAULT__", options.getHAGroup());
        randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHAGroup(randString));
        this.assertEquals(randString, options.getHAGroup());
        try {
            options.setHAGroup(null);
            this.fail("Should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.assertNotNull(options.getMetricsOptions());
        try {
            options.setWarningExceptionTime(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(options, options.setWarningExceptionTime(1000000000L));
        this.assertEquals(1000000000L, options.getWarningExceptionTime());
        this.assertEquals(options, options.setMaxEventLoopExecuteTimeUnit(TimeUnit.SECONDS));
        this.assertEquals((Object)TimeUnit.SECONDS, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals(options, options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS));
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals(options, options.setWarningExceptionTimeUnit(TimeUnit.MINUTES));
        this.assertEquals((Object)TimeUnit.MINUTES, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals(options, options.setBlockedThreadCheckIntervalUnit(TimeUnit.MILLISECONDS));
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getBlockedThreadCheckIntervalUnit());
    }

    @Test
    public void testCopyOptions() {
        VertxOptions options = new VertxOptions();
        int clusterPort = TestUtils.randomPortInt();
        int clusterPublicPort = TestUtils.randomPortInt();
        int eventLoopPoolSize = TestUtils.randomPositiveInt();
        int internalBlockingPoolSize = TestUtils.randomPositiveInt();
        int workerPoolSize = TestUtils.randomPositiveInt();
        int blockedThreadCheckInterval = TestUtils.randomPositiveInt();
        String clusterHost = TestUtils.randomAlphaString(100);
        String clusterPublicHost = TestUtils.randomAlphaString(100);
        long clusterPingInterval = TestUtils.randomPositiveLong();
        long clusterPingReplyInterval = TestUtils.randomPositiveLong();
        int maxEventLoopExecuteTime = TestUtils.randomPositiveInt();
        int maxWorkerExecuteTime = TestUtils.randomPositiveInt();
        Random rand = new Random();
        boolean haEnabled = rand.nextBoolean();
        boolean fileResolverCachingEnabled = rand.nextBoolean();
        boolean metricsEnabled = rand.nextBoolean();
        int quorumSize = 51214;
        String haGroup = TestUtils.randomAlphaString(100);
        long warningExceptionTime = TestUtils.randomPositiveLong();
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        TimeUnit warningExceptionTimeUnit = TimeUnit.MINUTES;
        TimeUnit blockedThreadCheckIntervalUnit = TimeUnit.MINUTES;
        options.setClusterPort(clusterPort);
        options.setClusterPublicPort(clusterPublicPort);
        options.setEventLoopPoolSize(eventLoopPoolSize);
        options.setInternalBlockingPoolSize(internalBlockingPoolSize);
        options.setWorkerPoolSize(workerPoolSize);
        options.setBlockedThreadCheckInterval((long)blockedThreadCheckInterval);
        options.setClusterHost(clusterHost);
        options.setClusterPublicHost(clusterPublicHost);
        options.setClusterPingInterval(clusterPingInterval);
        options.setClusterPingReplyInterval(clusterPingReplyInterval);
        options.setMaxEventLoopExecuteTime((long)maxEventLoopExecuteTime);
        options.setMaxWorkerExecuteTime((long)maxWorkerExecuteTime);
        options.setHAEnabled(haEnabled);
        options.setFileResolverCachingEnabled(fileResolverCachingEnabled);
        options.setQuorumSize(quorumSize);
        options.setHAGroup(haGroup);
        options.setMetricsOptions(new MetricsOptions().setEnabled(metricsEnabled));
        options.setWarningExceptionTime(warningExceptionTime);
        options.setMaxEventLoopExecuteTimeUnit(maxEventLoopExecuteTimeUnit);
        options.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        options.setWarningExceptionTimeUnit(warningExceptionTimeUnit);
        options.setBlockedThreadCheckIntervalUnit(blockedThreadCheckIntervalUnit);
        options = new VertxOptions(options);
        this.assertEquals(clusterPort, options.getClusterPort());
        this.assertEquals(clusterPublicPort, options.getClusterPublicPort());
        this.assertEquals(clusterPingInterval, options.getClusterPingInterval());
        this.assertEquals(clusterPingReplyInterval, options.getClusterPingReplyInterval());
        this.assertEquals(eventLoopPoolSize, options.getEventLoopPoolSize());
        this.assertEquals(internalBlockingPoolSize, options.getInternalBlockingPoolSize());
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        this.assertEquals(blockedThreadCheckInterval, options.getBlockedThreadCheckInterval());
        this.assertEquals(clusterHost, options.getClusterHost());
        this.assertEquals(clusterPublicHost, options.getClusterPublicHost());
        this.assertEquals(maxEventLoopExecuteTime, options.getMaxEventLoopExecuteTime());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals(haEnabled, options.isHAEnabled());
        this.assertEquals(fileResolverCachingEnabled, options.isFileResolverCachingEnabled());
        this.assertEquals(quorumSize, options.getQuorumSize());
        this.assertEquals(haGroup, options.getHAGroup());
        MetricsOptions metricsOptions = options.getMetricsOptions();
        this.assertNotNull(metricsOptions);
        this.assertEquals(metricsEnabled, metricsOptions.isEnabled());
        this.assertEquals(warningExceptionTime, options.getWarningExceptionTime());
        this.assertEquals((Object)maxEventLoopExecuteTimeUnit, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)warningExceptionTimeUnit, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)blockedThreadCheckIntervalUnit, (Object)options.getBlockedThreadCheckIntervalUnit());
    }

    @Test
    public void testDefaultJsonOptions() {
        VertxOptions def = new VertxOptions();
        VertxOptions json = new VertxOptions(new JsonObject());
        this.assertEquals(def.getEventLoopPoolSize(), json.getEventLoopPoolSize());
        this.assertEquals(def.getWorkerPoolSize(), json.getWorkerPoolSize());
        this.assertEquals(def.isClustered(), json.isClustered());
        this.assertEquals(def.getClusterHost(), json.getClusterHost());
        this.assertEquals(def.getClusterPublicHost(), json.getClusterPublicHost());
        this.assertEquals(def.getClusterPublicPort(), json.getClusterPublicPort());
        this.assertEquals(def.getClusterPingInterval(), json.getClusterPingInterval());
        this.assertEquals(def.getClusterPingReplyInterval(), json.getClusterPingReplyInterval());
        this.assertEquals(def.getBlockedThreadCheckInterval(), json.getBlockedThreadCheckInterval());
        this.assertEquals(def.getMaxEventLoopExecuteTime(), json.getMaxEventLoopExecuteTime());
        this.assertEquals(def.getMaxWorkerExecuteTime(), json.getMaxWorkerExecuteTime());
        this.assertEquals(def.getInternalBlockingPoolSize(), json.getInternalBlockingPoolSize());
        this.assertEquals(def.isHAEnabled(), json.isHAEnabled());
        this.assertEquals(def.getQuorumSize(), json.getQuorumSize());
        this.assertEquals(def.getHAGroup(), json.getHAGroup());
        this.assertEquals(def.getWarningExceptionTime(), json.getWarningExceptionTime());
        this.assertEquals(def.isFileResolverCachingEnabled(), json.isFileResolverCachingEnabled());
        this.assertEquals((Object)def.getMaxEventLoopExecuteTimeUnit(), (Object)json.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)def.getMaxWorkerExecuteTimeUnit(), (Object)json.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)def.getWarningExceptionTimeUnit(), (Object)json.getWarningExceptionTimeUnit());
        this.assertEquals((Object)def.getBlockedThreadCheckIntervalUnit(), (Object)json.getBlockedThreadCheckIntervalUnit());
    }

    @Test
    public void testJsonOptions() {
        VertxOptions options = new VertxOptions(new JsonObject());
        this.assertEquals(0L, options.getClusterPort());
        this.assertEquals(-1L, options.getClusterPublicPort());
        this.assertEquals(20000L, options.getClusterPingInterval());
        this.assertEquals(20000L, options.getClusterPingReplyInterval());
        this.assertEquals(2 * Runtime.getRuntime().availableProcessors(), options.getEventLoopPoolSize());
        this.assertEquals(20L, options.getInternalBlockingPoolSize());
        this.assertEquals(20L, options.getWorkerPoolSize());
        this.assertEquals(1000L, options.getBlockedThreadCheckInterval());
        this.assertEquals("localhost", options.getClusterHost());
        this.assertNull(options.getClusterPublicHost());
        this.assertEquals(null, options.getClusterManager());
        this.assertEquals(2000000000L, options.getMaxEventLoopExecuteTime());
        this.assertEquals(60000000000L, options.getMaxWorkerExecuteTime());
        this.assertFalse(options.isHAEnabled());
        this.assertEquals(1L, options.getQuorumSize());
        this.assertEquals("__DEFAULT__", options.getHAGroup());
        this.assertNotNull(options.getMetricsOptions());
        this.assertEquals(5000000000L, options.getWarningExceptionTime());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getBlockedThreadCheckIntervalUnit());
        int clusterPort = TestUtils.randomPortInt();
        int clusterPublicPort = TestUtils.randomPortInt();
        int eventLoopPoolSize = TestUtils.randomPositiveInt();
        int internalBlockingPoolSize = TestUtils.randomPositiveInt();
        int workerPoolSize = TestUtils.randomPositiveInt();
        int blockedThreadCheckInterval = TestUtils.randomPositiveInt();
        String clusterHost = TestUtils.randomAlphaString(100);
        String clusterPublicHost = TestUtils.randomAlphaString(100);
        long clusterPingInterval = TestUtils.randomPositiveLong();
        long clusterPingReplyInterval = TestUtils.randomPositiveLong();
        int maxEventLoopExecuteTime = TestUtils.randomPositiveInt();
        int maxWorkerExecuteTime = TestUtils.randomPositiveInt();
        int proxyOperationTimeout = TestUtils.randomPositiveInt();
        long warningExceptionTime = TestUtils.randomPositiveLong();
        Random rand = new Random();
        boolean haEnabled = rand.nextBoolean();
        boolean fileResolverCachingEnabled = rand.nextBoolean();
        int quorumSize = TestUtils.randomShort() + 1;
        String haGroup = TestUtils.randomAlphaString(100);
        boolean classPathResolvingEnabled = rand.nextBoolean();
        boolean metricsEnabled = rand.nextBoolean();
        boolean jmxEnabled = rand.nextBoolean();
        String jmxDomain = TestUtils.randomAlphaString(100);
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        TimeUnit warningExceptionTimeUnit = TimeUnit.MINUTES;
        TimeUnit blockedThreadCheckIntervalUnit = TimeUnit.MINUTES;
        options = new VertxOptions(new JsonObject().put("clusterPort", Integer.valueOf(clusterPort)).put("clusterPublicPort", Integer.valueOf(clusterPublicPort)).put("eventLoopPoolSize", Integer.valueOf(eventLoopPoolSize)).put("internalBlockingPoolSize", Integer.valueOf(internalBlockingPoolSize)).put("workerPoolSize", Integer.valueOf(workerPoolSize)).put("blockedThreadCheckInterval", Integer.valueOf(blockedThreadCheckInterval)).put("clusterHost", clusterHost).put("clusterPublicHost", clusterPublicHost).put("clusterPingInterval", Long.valueOf(clusterPingInterval)).put("clusterPingReplyInterval", Long.valueOf(clusterPingReplyInterval)).put("maxEventLoopExecuteTime", Integer.valueOf(maxEventLoopExecuteTime)).put("maxWorkerExecuteTime", Integer.valueOf(maxWorkerExecuteTime)).put("proxyOperationTimeout", Integer.valueOf(proxyOperationTimeout)).put("haEnabled", Boolean.valueOf(haEnabled)).put("fileResolverCachingEnabled", Boolean.valueOf(fileResolverCachingEnabled)).put("quorumSize", Integer.valueOf(quorumSize)).put("haGroup", haGroup).put("warningExceptionTime", Long.valueOf(warningExceptionTime)).put("fileSystemOptions", new JsonObject().put("classPathResolvingEnabled", Boolean.valueOf(classPathResolvingEnabled)).put("fileCachingEnabled", Boolean.valueOf(fileResolverCachingEnabled))).put("metricsOptions", new JsonObject().put("enabled", Boolean.valueOf(metricsEnabled)).put("jmxEnabled", Boolean.valueOf(jmxEnabled)).put("jmxDomain", jmxDomain)).put("maxEventLoopExecuteTimeUnit", (Enum)maxEventLoopExecuteTimeUnit).put("maxWorkerExecuteTimeUnit", (Enum)maxWorkerExecuteTimeUnit).put("warningExceptionTimeUnit", (Enum)warningExceptionTimeUnit).put("blockedThreadCheckIntervalUnit", (Enum)blockedThreadCheckIntervalUnit));
        this.assertEquals(clusterPort, options.getClusterPort());
        this.assertEquals(clusterPublicPort, options.getClusterPublicPort());
        this.assertEquals(clusterPublicHost, options.getClusterPublicHost());
        this.assertEquals(clusterPingInterval, options.getClusterPingInterval());
        this.assertEquals(clusterPingReplyInterval, options.getClusterPingReplyInterval());
        this.assertEquals(eventLoopPoolSize, options.getEventLoopPoolSize());
        this.assertEquals(internalBlockingPoolSize, options.getInternalBlockingPoolSize());
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        this.assertEquals(blockedThreadCheckInterval, options.getBlockedThreadCheckInterval());
        this.assertEquals(clusterHost, options.getClusterHost());
        this.assertEquals(null, options.getClusterManager());
        this.assertEquals(maxEventLoopExecuteTime, options.getMaxEventLoopExecuteTime());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals(haEnabled, options.isHAEnabled());
        this.assertEquals(fileResolverCachingEnabled, options.isFileResolverCachingEnabled());
        this.assertEquals(quorumSize, options.getQuorumSize());
        this.assertEquals(haGroup, options.getHAGroup());
        FileSystemOptions fileSystemOptions = options.getFileSystemOptions();
        this.assertEquals(classPathResolvingEnabled, fileSystemOptions.isClassPathResolvingEnabled());
        this.assertEquals(fileResolverCachingEnabled, fileSystemOptions.isFileCachingEnabled());
        MetricsOptions metricsOptions = options.getMetricsOptions();
        this.assertEquals(metricsEnabled, metricsOptions.isEnabled());
        this.assertEquals(warningExceptionTime, options.getWarningExceptionTime());
        this.assertEquals((Object)maxEventLoopExecuteTimeUnit, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)warningExceptionTimeUnit, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)blockedThreadCheckIntervalUnit, (Object)options.getBlockedThreadCheckIntervalUnit());
    }

    @Test
    public void testNullFileSystemOptions() {
        VertxOptions options = new VertxOptions().setFileSystemOptions(null);
        options.isFileResolverCachingEnabled();
        options.setFileResolverCachingEnabled(true);
    }
}

