/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.netty.util.CharsetUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class EventBusTestBase
extends VertxTestBase {
    protected static final String ADDRESS1 = "some-address1";
    protected static final String ADDRESS2 = "some-address2";

    @Test
    public void testSendNull() {
        this.testSend(null);
    }

    @Test
    public void testReplyNull() {
        this.testReply(null);
    }

    @Test
    public void testPublishNull() {
        this.testPublish(null);
    }

    @Test
    public void testSendString() {
        String str = TestUtils.randomUnicodeString(100);
        this.testSend(str);
    }

    @Test
    public void testReplyString() {
        String str = TestUtils.randomUnicodeString(100);
        this.testReply(str);
    }

    @Test
    public void testPublishString() {
        String str = TestUtils.randomUnicodeString(100);
        this.testPublish(str);
    }

    @Test
    public void testSendBooleanTrue() {
        this.testSend(true);
    }

    @Test
    public void testSendBooleanFalse() {
        this.testSend(false);
    }

    @Test
    public void testReplyBooleanTrue() {
        this.testReply(true);
    }

    @Test
    public void testReplyBooleanFalse() {
        this.testReply(false);
    }

    @Test
    public void testPublishBooleanTrue() {
        this.testPublish(true);
    }

    @Test
    public void testPublishBooleanFalse() {
        this.testPublish(false);
    }

    @Test
    public void testSendBuffer() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testSend(sent, buffer -> {
            this.assertEquals(sent, buffer);
            this.assertFalse(sent == buffer);
        });
    }

    @Test
    public void testReplyBuffer() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testReply(sent, bytes -> {
            this.assertEquals(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testPublishBuffer() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testPublish(sent, buffer -> {
            this.assertEquals(sent, buffer);
            this.assertFalse(sent == buffer);
        });
    }

    @Test
    public void testSendByte() {
        this.testSend(TestUtils.randomByte());
    }

    @Test
    public void testReplyByte() {
        this.testReply(TestUtils.randomByte());
    }

    @Test
    public void testPublishByte() {
        this.testPublish(TestUtils.randomByte());
    }

    @Test
    public void testSendByteArray() {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testSend(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testReplyByteArray() {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testReply(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testPublishByteArray() {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testPublish(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testSendCharacter() {
        this.testSend(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testReplyCharacter() {
        this.testReply(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testPublishCharacter() {
        this.testPublish(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testSendDouble() {
        this.testSend(TestUtils.randomDouble());
    }

    @Test
    public void testReplyDouble() {
        this.testReply(TestUtils.randomDouble());
    }

    @Test
    public void testPublishDouble() {
        this.testPublish(TestUtils.randomDouble());
    }

    @Test
    public void testSendFloat() {
        this.testSend(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testReplyFloat() {
        this.testReply(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testPublishFloat() {
        this.testPublish(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testSendInteger() {
        this.testSend(TestUtils.randomInt());
    }

    @Test
    public void testReplyInteger() {
        this.testReply(TestUtils.randomInt());
    }

    @Test
    public void testPublishInteger() {
        this.testPublish(TestUtils.randomInt());
    }

    @Test
    public void testSendLong() {
        this.testSend(TestUtils.randomLong());
    }

    @Test
    public void testReplyLong() {
        this.testReply(TestUtils.randomLong());
    }

    @Test
    public void testPublishLong() {
        this.testPublish(TestUtils.randomLong());
    }

    @Test
    public void testSendShort() {
        this.testSend(TestUtils.randomShort());
    }

    @Test
    public void testReplyShort() {
        this.testReply(TestUtils.randomShort());
    }

    @Test
    public void testPublishShort() {
        this.testPublish(TestUtils.randomShort());
    }

    @Test
    public void testSendJsonArray() {
        JsonArray arr = new JsonArray();
        arr.add(TestUtils.randomUnicodeString(100)).add(Integer.valueOf(TestUtils.randomInt())).add(Boolean.valueOf(TestUtils.randomBoolean()));
        this.testSend(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testReplyJsonArray() {
        JsonArray arr = new JsonArray();
        arr.add(TestUtils.randomUnicodeString(100)).add(Integer.valueOf(TestUtils.randomInt())).add(Boolean.valueOf(TestUtils.randomBoolean()));
        this.testReply(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testPublishJsonArray() {
        JsonArray arr = new JsonArray();
        arr.add(TestUtils.randomUnicodeString(100)).add(Integer.valueOf(TestUtils.randomInt())).add(Boolean.valueOf(TestUtils.randomBoolean()));
        this.testPublish(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testSendJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), Integer.valueOf(TestUtils.randomInt()));
        this.testSend(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testReplyJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), Integer.valueOf(TestUtils.randomInt()));
        this.testReply(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testPublishJsonObject() {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), Integer.valueOf(TestUtils.randomInt()));
        this.testPublish(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testSendWithHeaders() {
        this.testSend("foo", "foo", null, new DeliveryOptions().addHeader("uhqwduh", "qijwdqiuwd").addHeader("iojdijef", "iqjwddh"));
    }

    @Test
    public void testSendWithDeliveryOptionsButNoHeaders() {
        this.testSend("foo", "foo", null, new DeliveryOptions());
    }

    @Test
    public void testReplyWithHeaders() {
        this.testReply("foo", "foo", null, new DeliveryOptions().addHeader("uhqwduh", "qijwdqiuwd").addHeader("iojdijef", "iqjwddh"));
    }

    @Test
    public void testReplyFromWorker() throws Exception {
        final String expectedBody = TestUtils.randomAlphaString(20);
        this.startNodes(2);
        final CountDownLatch latch = new CountDownLatch(1);
        this.vertices[0].deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                EventBusTestBase.this.vertices[1].eventBus().consumer(EventBusTestBase.ADDRESS1, msg -> msg.reply((Object)expectedBody)).completionHandler(ar -> {
                    EventBusTestBase.this.assertTrue(ar.succeeded());
                    latch.countDown();
                });
            }
        }, new DeploymentOptions().setWorker(true));
        this.awaitLatch(latch);
        this.vertices[0].eventBus().send(ADDRESS1, (Object)"whatever", reply -> {
            this.assertTrue(reply.succeeded());
            this.assertEquals(expectedBody, ((Message)reply.result()).body());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSendFromExecuteBlocking() throws Exception {
        String expectedBody = TestUtils.randomAlphaString(20);
        CountDownLatch receivedLatch = new CountDownLatch(1);
        this.startNodes(2);
        this.vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(expectedBody, msg.body());
            receivedLatch.countDown();
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.vertices[0].executeBlocking(fut -> {
                this.vertices[0].eventBus().send(ADDRESS1, (Object)expectedBody);
                try {
                    this.awaitLatch(receivedLatch);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    fut.fail((Throwable)e);
                }
                fut.complete();
            }, ar2 -> {
                if (ar2.succeeded()) {
                    this.testComplete();
                } else {
                    this.fail(ar2.cause());
                }
            });
        });
        this.await();
    }

    @Test
    public void testNoHandlersCallbackContext() {
        this.startNodes(2);
        this.waitFor(4);
        this.vertices[0].eventBus().send("blah", (Object)"blah", ar -> {
            this.assertTrue(ar.failed());
            if (ar.cause() instanceof ReplyException) {
                ReplyException cause = (ReplyException)ar.cause();
                this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
            } else {
                this.fail(ar.cause());
            }
            this.assertTrue("Not an EL thread", Context.isOnEventLoopThread());
            this.complete();
        });
        this.vertices[0].runOnContext(v -> {
            Context ctx = this.vertices[0].getOrCreateContext();
            this.vertices[0].eventBus().send("blah", (Object)"blah", ar -> {
                this.assertTrue(ar.failed());
                if (ar.cause() instanceof ReplyException) {
                    ReplyException cause = (ReplyException)ar.cause();
                    this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                } else {
                    this.fail(ar.cause());
                }
                this.assertSame(ctx, this.vertices[0].getOrCreateContext());
                this.complete();
            });
        });
        this.vertices[0].deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                Context ctx = this.getVertx().getOrCreateContext();
                EventBusTestBase.this.vertices[0].eventBus().send("blah", (Object)"blah", ar -> {
                    EventBusTestBase.this.assertTrue(ar.failed());
                    if (ar.cause() instanceof ReplyException) {
                        ReplyException cause = (ReplyException)ar.cause();
                        EventBusTestBase.this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                    } else {
                        EventBusTestBase.this.fail(ar.cause());
                    }
                    EventBusTestBase.this.assertSame(ctx, this.getVertx().getOrCreateContext());
                    EventBusTestBase.this.complete();
                });
            }
        }, new DeploymentOptions().setWorker(true));
        this.vertices[0].executeBlocking(fut -> {
            this.vertices[0].eventBus().send("blah", (Object)"blah", ar -> {
                this.assertTrue(ar.failed());
                if (ar.cause() instanceof ReplyException) {
                    ReplyException cause = (ReplyException)ar.cause();
                    this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                } else {
                    this.fail(ar.cause());
                }
                this.assertTrue("Not an EL thread", Context.isOnEventLoopThread());
                this.complete();
            });
            fut.complete();
        }, false, null);
        this.await();
    }

    protected <T> void testSend(T val) {
        this.testSend(val, null);
    }

    protected abstract <T, R> void testSend(T var1, R var2, Consumer<T> var3, DeliveryOptions var4);

    protected abstract <T> void testSend(T var1, Consumer<T> var2);

    protected <T> void testReply(T val) {
        this.testReply(val, null);
    }

    protected abstract <T> void testReply(T var1, Consumer<T> var2);

    protected abstract <T, R> void testReply(T var1, R var2, Consumer<R> var3, DeliveryOptions var4);

    protected <T> void testPublish(T val) {
        this.testPublish(val, null);
    }

    protected abstract <T> void testPublish(T var1, Consumer<T> var2);

    public static class StringLengthCodec
    implements MessageCodec<String, Integer> {
        public void encodeToWire(Buffer buffer, String s) {
            buffer.appendInt(s.length());
        }

        public Integer decodeFromWire(int pos, Buffer buffer) {
            return buffer.getInt(pos);
        }

        public Integer transform(String s) {
            return s.length();
        }

        public String name() {
            return this.getClass().getName();
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyReplyExceptionMessageCodec
    implements MessageCodec<MyReplyException, MyReplyException> {
        public void encodeToWire(Buffer buffer, MyReplyException body) {
            buffer.appendInt(body.failureCode());
            if (body.getMessage() == null) {
                buffer.appendByte((byte)0);
            } else {
                buffer.appendByte((byte)1);
                byte[] encoded = body.getMessage().getBytes(CharsetUtil.UTF_8);
                buffer.appendInt(encoded.length);
                buffer.appendBytes(encoded);
            }
        }

        public MyReplyException decodeFromWire(int pos, Buffer buffer) {
            String message;
            boolean isNull;
            int failureCode = buffer.getInt(pos);
            boolean bl = isNull = buffer.getByte(pos += 4) == 0;
            if (!isNull) {
                int strLength = buffer.getInt(++pos);
                byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
                message = new String(bytes, CharsetUtil.UTF_8);
            } else {
                message = null;
            }
            return new MyReplyException(failureCode, message);
        }

        public MyReplyException transform(MyReplyException obj) {
            return obj;
        }

        public String name() {
            return "myReplyException";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyReplyException
    extends ReplyException {
        public MyReplyException(int failureCode, String message) {
            super(ReplyFailure.RECIPIENT_FAILURE, failureCode, message);
        }
    }

    public static class MyPOJO {
        private String str;

        public MyPOJO(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPOJO myPOJO = (MyPOJO)o;
            return !(this.str != null ? !this.str.equals(myPOJO.str) : myPOJO.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }
    }

    public static class MyPOJOEncoder2
    implements MessageCodec<MyPOJO, MyPOJO> {
        public void encodeToWire(Buffer buffer, MyPOJO myPOJO) {
            byte[] bytes = myPOJO.getStr().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
        }

        public MyPOJO decodeFromWire(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            String str = new String(bytes, CharsetUtil.UTF_8);
            return new MyPOJO(str);
        }

        public MyPOJO transform(MyPOJO myPOJO) {
            return new MyPOJO(myPOJO.getStr());
        }

        public String name() {
            return "mypojoencoder2";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyPOJOEncoder1
    implements MessageCodec<MyPOJO, String> {
        public void encodeToWire(Buffer buffer, MyPOJO myPOJO) {
            byte[] bytes = myPOJO.getStr().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            return new String(bytes, CharsetUtil.UTF_8);
        }

        public String transform(MyPOJO myPOJO) {
            return myPOJO.getStr();
        }

        public String name() {
            return "mypojoencoder1";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class NullNameCodec
    implements MessageCodec<String, String> {
        public void encodeToWire(Buffer buffer, String s) {
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            return null;
        }

        public String transform(String s) {
            return null;
        }

        public String name() {
            return null;
        }

        public byte systemCodecID() {
            return 0;
        }
    }

    public static class MySystemDecoder
    implements MessageCodec<MyPOJO, String> {
        public void encodeToWire(Buffer buffer, MyPOJO s) {
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            return null;
        }

        public String transform(MyPOJO s) {
            return null;
        }

        public String name() {
            return "mysystemdecoder";
        }

        public byte systemCodecID() {
            return 0;
        }
    }
}

