/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTLSTest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import org.junit.Test;

public class Http1xTLSTest
extends HttpTLSTest {
    @Override
    HttpServer createHttpServer(HttpServerOptions options) {
        return this.vertx.createHttpServer(options);
    }

    @Override
    HttpClient createHttpClient(HttpClientOptions options) {
        return this.vertx.createHttpClient(options);
    }

    @Test
    public void testAlpn() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).serverUsesAlpn().clientUsesAlpn().pass();
    }

    @Test
    public void testClearClientRequestOptionsSetSSL() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setPort(4043).setURI("some-uri").setSsl(true);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testSSLClientRequestOptionsSetSSL() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setPort(4043).setURI("some-uri").setSsl(true);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).requestOptions(options).pass();
    }

    @Test
    public void testClearClientRequestOptionsSetClear() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(4043).setSsl(false);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testSSLClientRequestOptionsSetClear() throws Exception {
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(4043).setSsl(false);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).serverSSL(false).requestOptions(options).pass();
    }

    @Test
    public void testClearClientRequestAbsSetSSL() throws Exception {
        String absoluteURI = "https://localhost:4043/some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).requestProvider(c -> c.requestAbs(HttpMethod.POST, absoluteURI)).pass();
    }

    @Test
    public void testSSLClientRequestAbsSetSSL() throws Exception {
        String absoluteURI = "https://localhost:4043/some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).requestProvider(c -> c.requestAbs(HttpMethod.POST, absoluteURI)).pass();
    }

    @Test
    public void testClearClientRequestAbsSetClear() throws Exception {
        String absoluteURI = "http://localhost:4043/some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(false).requestProvider(c -> c.requestAbs(HttpMethod.POST, absoluteURI)).pass();
    }

    @Test
    public void testSSLClientRequestAbsSetClear() throws Exception {
        String absoluteURI = "http://localhost:4043/some-uri";
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(true).serverSSL(false).requestProvider(c -> c.requestAbs(HttpMethod.POST, absoluteURI)).pass();
    }

    @Test
    public void testRedirectToSSL() throws Exception {
        HttpServer redirectServer = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080)).requestHandler(req -> req.response().setStatusCode(303).putHeader("location", "https://localhost:4043/some-uri").end());
        this.startServer(redirectServer);
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(8080);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientSSL(false).serverSSL(true).requestOptions(options).followRedirects(true).pass();
    }

    @Test
    public void testRedirectFromSSL() throws Exception {
        HttpServer redirectServer = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setHost("localhost").setPort(8080)).requestHandler(req -> req.response().setStatusCode(303).putHeader("location", "http://localhost:4043/some-uri").end());
        this.startServer(redirectServer);
        RequestOptions options = new RequestOptions().setHost("localhost").setURI("some-uri").setPort(4043);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.NONE, Trust.NONE).clientSSL(true).serverSSL(false).requestOptions(options).followRedirects(true).pass();
    }
}

