/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.util.CharsetUtil;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import org.junit.Test;

public class HttpCompressionTest
extends HttpTestBase {
    private static final String COMPRESS_TEST_STRING = "/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */";
    private HttpServer serverWithMinCompressionLevel;
    private HttpServer serverWithMaxCompressionLevel = null;
    private HttpClient clientraw = null;
    private static boolean minCompressionTestPassed = false;
    private static boolean maxCompressionTestPassed = false;
    private static Integer rawMaxCompressionResponseByteCount = null;
    private static Integer rawMinCompressionResponseByteCount = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setTryUseCompression(true));
        this.clientraw = this.vertx.createHttpClient(new HttpClientOptions().setTryUseCompression(false));
        HttpServerOptions serverOpts = new HttpServerOptions().setPort(8080).setCompressionSupported(true);
        this.serverWithMinCompressionLevel = this.vertx.createHttpServer(serverOpts.setPort(8079).setCompressionLevel(1));
        this.serverWithMaxCompressionLevel = this.vertx.createHttpServer(serverOpts.setPort(8081).setCompressionLevel(9));
    }

    @Test
    public void testSkipEncoding() throws Exception {
        this.serverWithMaxCompressionLevel.requestHandler(req -> {
            this.assertNotNull(req.headers().get("Accept-Encoding"));
            req.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY).end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        });
        this.startServer(this.serverWithMaxCompressionLevel);
        this.clientraw.get(8081, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
            this.assertEquals(COMPRESS_TEST_STRING, responseBody);
            this.testComplete();
        })).putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP).end();
        this.await();
    }

    @Test
    public void testDefaultRequestHeaders() {
        Handler requestHandler = req -> {
            this.assertEquals(2L, req.headers().size());
            this.assertNotNull(req.headers().get("Accept-Encoding"));
            req.response().end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        };
        this.serverWithMinCompressionLevel.requestHandler(requestHandler);
        this.serverWithMaxCompressionLevel.requestHandler(requestHandler);
        this.serverWithMinCompressionLevel.listen(this.onSuccess(serverReady -> {
            this.testMinCompression();
            this.testRawMinCompression();
        }));
        this.serverWithMaxCompressionLevel.listen(this.onSuccess(serverReady -> {
            this.testMaxCompression();
            this.testRawMaxCompression();
        }));
        this.await();
    }

    private void testMinCompression() {
        this.client.request(HttpMethod.GET, 8079, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
            this.assertEquals(COMPRESS_TEST_STRING, responseBody);
            minCompressionTestPassed = true;
            this.terminateTestWhenAllPassed();
        })).end();
    }

    private void testMaxCompression() {
        this.client.request(HttpMethod.GET, 8081, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
            this.assertEquals(COMPRESS_TEST_STRING, responseBody);
            maxCompressionTestPassed = true;
            this.terminateTestWhenAllPassed();
        })).end();
    }

    private void testRawMaxCompression() {
        this.clientraw.request(HttpMethod.GET, 8081, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            Integer responseByteCount;
            String responseCompressedBody = responseBuffer.toString(CharsetUtil.UTF_8);
            rawMaxCompressionResponseByteCount = responseByteCount = Integer.valueOf(responseCompressedBody.getBytes(CharsetUtil.UTF_8).length);
            this.terminateTestWhenAllPassed();
        })).putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP).end();
    }

    private void testRawMinCompression() {
        this.clientraw.request(HttpMethod.GET, 8079, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            Integer responseByteCount;
            String responseCompressedBody = responseBuffer.toString(CharsetUtil.UTF_8);
            rawMinCompressionResponseByteCount = responseByteCount = Integer.valueOf(responseCompressedBody.getBytes(CharsetUtil.UTF_8).length);
            this.terminateTestWhenAllPassed();
        })).putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP).end();
    }

    private void terminateTestWhenAllPassed() {
        if (maxCompressionTestPassed && minCompressionTestPassed && rawMinCompressionResponseByteCount != null && rawMaxCompressionResponseByteCount != null) {
            this.assertTrue("Checking compression byte size difference", rawMaxCompressionResponseByteCount > 0 && rawMinCompressionResponseByteCount > rawMaxCompressionResponseByteCount);
            this.testComplete();
        }
    }
}

