/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Utils;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonObjectTest;
import io.vertx.test.core.TestUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonArrayTest {
    private JsonArray jsonArray;

    @Before
    public void setUp() {
        this.jsonArray = new JsonArray();
    }

    @Test
    public void testGetInteger() {
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(0));
        try {
            this.jsonArray.getInteger(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getInteger(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Long.valueOf(123L));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(1));
        this.jsonArray.add(Float.valueOf(123.0f));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(2));
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(3));
        this.jsonArray.add("foo");
        try {
            this.jsonArray.getInteger(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getInteger(5));
    }

    @Test
    public void testGetLong() {
        this.jsonArray.add(Long.valueOf(123L));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(0));
        try {
            this.jsonArray.getLong(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getLong(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(1));
        this.jsonArray.add(Float.valueOf(123.0f));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(2));
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(3));
        this.jsonArray.add("foo");
        try {
            this.jsonArray.getLong(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getLong(5));
    }

    @Test
    public void testGetFloat() {
        this.jsonArray.add(Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(0));
        try {
            this.jsonArray.getFloat(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getFloat(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(1));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(2));
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(3));
        this.jsonArray.add("foo");
        try {
            this.jsonArray.getFloat(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getFloat(5));
    }

    @Test
    public void testGetDouble() {
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(0));
        try {
            this.jsonArray.getDouble(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getDouble(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(1));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(2));
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(3));
        this.jsonArray.add("foo");
        try {
            this.jsonArray.getDouble(4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getDouble(5));
    }

    @Test
    public void testGetString() {
        this.jsonArray.add("foo");
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        try {
            this.jsonArray.getString(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getString(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getString(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getString(2));
    }

    @Test
    public void testGetBoolean() {
        this.jsonArray.add(Boolean.valueOf(true));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(0));
        this.jsonArray.add(Boolean.valueOf(false));
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getBoolean(1));
        try {
            this.jsonArray.getBoolean(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getBoolean(2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getBoolean(2);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getBoolean(3));
    }

    @Test
    public void testGetBinary() {
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add(bytes);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, this.jsonArray.getBinary(0)));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, Base64.getDecoder().decode(this.jsonArray.getString(0))));
        try {
            this.jsonArray.getBinary(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getBinary(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getBinary(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getBinary(2));
    }

    @Test
    public void testGetInstant() {
        Instant now = Instant.now();
        this.jsonArray.add(now);
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(0));
        Assert.assertEquals((Object)now, (Object)Instant.from(DateTimeFormatter.ISO_INSTANT.parse(this.jsonArray.getString(0))));
        try {
            this.jsonArray.getInstant(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getInstant(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getInstant(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getInstant(2));
    }

    @Test
    public void testGetJsonObject() {
        JsonObject obj = new JsonObject().put("foo", "bar");
        this.jsonArray.add(obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(0));
        try {
            this.jsonArray.getJsonObject(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getJsonObject(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getJsonObject(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getJsonObject(2));
    }

    @Test
    public void testGetJsonArray() {
        JsonArray arr = new JsonArray().add("foo");
        this.jsonArray.add(arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(0));
        try {
            this.jsonArray.getJsonArray(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getJsonArray(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.jsonArray.add(Integer.valueOf(123));
        try {
            this.jsonArray.getJsonArray(1);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getJsonArray(2));
    }

    @Test
    public void testGetValue() {
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getValue(0));
        this.jsonArray.add(Long.valueOf(123L));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getValue(1));
        this.jsonArray.add(Float.valueOf(123.0f));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getValue(2));
        this.jsonArray.add(Double.valueOf(123.0));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getValue(3));
        this.jsonArray.add(Boolean.valueOf(false));
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getValue(4));
        this.jsonArray.add(Boolean.valueOf(true));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getValue(5));
        this.jsonArray.add("bar");
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getValue(6));
        JsonObject obj = new JsonObject().put("blah", "wibble");
        this.jsonArray.add(obj);
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getValue(7));
        JsonArray arr = new JsonArray().add("blah").add("wibble");
        this.jsonArray.add(arr);
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getValue(8));
        byte[] bytes = TestUtils.randomByteArray(100);
        this.jsonArray.add(bytes);
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, Base64.getDecoder().decode((String)this.jsonArray.getValue(9))));
        Instant now = Instant.now();
        this.jsonArray.add(now);
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(10));
        this.jsonArray.addNull();
        Assert.assertNull((Object)this.jsonArray.getValue(11));
        try {
            this.jsonArray.getValue(-1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.jsonArray.getValue(12);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayList<Cloneable> list = new ArrayList<Cloneable>();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("blah", "wibble");
        list.add(innerMap);
        this.jsonArray = new JsonArray(list);
        obj = (JsonObject)this.jsonArray.getValue(0);
        Assert.assertEquals((Object)"wibble", (Object)obj.getString("blah"));
        list = new ArrayList();
        ArrayList<String> innerList = new ArrayList<String>();
        innerList.add("blah");
        list.add(innerList);
        this.jsonArray = new JsonArray(list);
        arr = (JsonArray)this.jsonArray.getValue(0);
        Assert.assertEquals((Object)"blah", (Object)arr.getString(0));
    }

    @Test
    public void testAddEnum() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((Enum)JsonObjectTest.SomeEnum.FOO));
        Assert.assertEquals((Object)JsonObjectTest.SomeEnum.FOO.toString(), (Object)this.jsonArray.getString(0));
        try {
            this.jsonArray.add((Enum)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddString() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add("foo"));
        Assert.assertEquals((Object)"foo", (Object)this.jsonArray.getString(0));
        try {
            this.jsonArray.add((String)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddCharSequence() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add((CharSequence)new StringBuilder("bar")));
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getString(0));
        try {
            this.jsonArray.add((CharSequence)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddInteger() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(Integer.valueOf(123)));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(0));
        try {
            this.jsonArray.add((Integer)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddLong() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(Long.valueOf(123L)));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(0));
        try {
            this.jsonArray.add((Long)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddFloat() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(Float.valueOf(123.0f)));
        Assert.assertEquals((Object)Float.valueOf(123.0f), (Object)this.jsonArray.getFloat(0));
        try {
            this.jsonArray.add((Float)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddDouble() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(Double.valueOf(123.0)));
        Assert.assertEquals((Object)123.0, (Object)this.jsonArray.getDouble(0));
        try {
            this.jsonArray.add((Double)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddBoolean() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(Boolean.valueOf(true)));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(0));
        this.jsonArray.add(Boolean.valueOf(false));
        Assert.assertEquals((Object)false, (Object)this.jsonArray.getBoolean(1));
        try {
            this.jsonArray.add((Boolean)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddJsonObject() {
        JsonObject obj = new JsonObject().put("foo", "bar");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(obj));
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(0));
        try {
            this.jsonArray.add((JsonObject)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddJsonArray() {
        JsonArray arr = new JsonArray().add("foo");
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(arr));
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(0));
        try {
            this.jsonArray.add((JsonArray)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddBinary() {
        byte[] bytes = TestUtils.randomByteArray(10);
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(bytes));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, this.jsonArray.getBinary(0)));
        try {
            this.jsonArray.add((byte[])null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddInstant() {
        Instant now = Instant.now();
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.add(now));
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(0));
        try {
            this.jsonArray.add((Instant)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddObject() {
        this.jsonArray.add((Object)"bar");
        this.jsonArray.add((Object)123);
        this.jsonArray.add((Object)123L);
        this.jsonArray.add((Object)Float.valueOf(1.23f));
        this.jsonArray.add((Object)1.23);
        this.jsonArray.add((Object)true);
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add((Object)bytes);
        Instant now = Instant.now();
        this.jsonArray.add(now);
        JsonObject obj = new JsonObject().put("foo", "blah");
        JsonArray arr = new JsonArray().add("quux");
        this.jsonArray.add((Object)obj);
        this.jsonArray.add((Object)arr);
        Assert.assertEquals((Object)"bar", (Object)this.jsonArray.getString(0));
        Assert.assertEquals((Object)123, (Object)this.jsonArray.getInteger(1));
        Assert.assertEquals((Object)123L, (Object)this.jsonArray.getLong(2));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.jsonArray.getFloat(3));
        Assert.assertEquals((Object)1.23, (Object)this.jsonArray.getDouble(4));
        Assert.assertEquals((Object)true, (Object)this.jsonArray.getBoolean(5));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, this.jsonArray.getBinary(6)));
        Assert.assertEquals((Object)now, (Object)this.jsonArray.getInstant(7));
        Assert.assertEquals((Object)obj, (Object)this.jsonArray.getJsonObject(8));
        Assert.assertEquals((Object)arr, (Object)this.jsonArray.getJsonArray(9));
        try {
            this.jsonArray.add((Object)new SomeClass());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.jsonArray.add((Object)new BigDecimal(123));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.jsonArray.add((Object)new Date());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAllJsonArray() {
        this.jsonArray.add("bar");
        JsonArray arr = new JsonArray().add("foo").add(Integer.valueOf(48));
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.addAll(arr));
        Assert.assertEquals((Object)arr.getString(0), (Object)this.jsonArray.getString(1));
        Assert.assertEquals((Object)arr.getInteger(1), (Object)this.jsonArray.getInteger(2));
        try {
            this.jsonArray.add((JsonArray)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNull() {
        Assert.assertSame((Object)this.jsonArray, (Object)this.jsonArray.addNull());
        Assert.assertEquals(null, (Object)this.jsonArray.getString(0));
        Assert.assertTrue((boolean)this.jsonArray.hasNull(0));
    }

    @Test
    public void testHasNull() {
        this.jsonArray.addNull();
        this.jsonArray.add("foo");
        Assert.assertEquals(null, (Object)this.jsonArray.getString(0));
        Assert.assertTrue((boolean)this.jsonArray.hasNull(0));
        Assert.assertFalse((boolean)this.jsonArray.hasNull(1));
    }

    @Test
    public void testContains() {
        this.jsonArray.add("wibble");
        this.jsonArray.add(Boolean.valueOf(true));
        this.jsonArray.add(Integer.valueOf(123));
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        this.jsonArray.add(obj);
        this.jsonArray.add(arr);
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)"eek"));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)false));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)321));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)new JsonObject().put("blah", "flib")));
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)new JsonArray().add("oob")));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)"wibble"));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)true));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)123));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)obj));
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)arr));
    }

    @Test
    public void testRemoveByObject() {
        this.jsonArray.add("wibble");
        this.jsonArray.add(Boolean.valueOf(true));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)"wibble"));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
        Assert.assertFalse((boolean)this.jsonArray.remove((Object)"notthere"));
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)true));
        Assert.assertTrue((boolean)this.jsonArray.remove((Object)123));
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testRemoveByPos() {
        this.jsonArray.add("wibble");
        this.jsonArray.add(Boolean.valueOf(true));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)"wibble", (Object)this.jsonArray.remove(0));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)123, (Object)this.jsonArray.remove(1));
        Assert.assertEquals((long)1L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)true, (Object)this.jsonArray.remove(0));
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testSize() {
        this.jsonArray.add("wibble");
        this.jsonArray.add(Boolean.valueOf(true));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
    }

    @Test
    public void testClear() {
        this.jsonArray.add("wibble");
        this.jsonArray.add(Boolean.valueOf(true));
        this.jsonArray.add(Integer.valueOf(123));
        Assert.assertEquals((long)3L, (long)this.jsonArray.size());
        Assert.assertEquals((Object)this.jsonArray, (Object)this.jsonArray.clear());
        Assert.assertEquals((long)0L, (long)this.jsonArray.size());
        Assert.assertTrue((boolean)this.jsonArray.isEmpty());
    }

    @Test
    public void testIterator() {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        JsonObject obj = new JsonObject().put("foo", "bar");
        this.jsonArray.add(obj);
        Iterator iter = this.jsonArray.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Object entry = iter.next();
        Assert.assertEquals((Object)"foo", entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)123, entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)obj, entry);
        Assert.assertFalse((boolean)iter.hasNext());
        iter.remove();
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)obj));
        Assert.assertEquals((long)2L, (long)this.jsonArray.size());
    }

    @Test
    public void testStream() {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        JsonObject obj = new JsonObject().put("foo", "bar");
        this.jsonArray.add(obj);
        List list = this.jsonArray.stream().collect(Collectors.toList());
        Iterator iter = list.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Object entry = iter.next();
        Assert.assertEquals((Object)"foo", entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)123, entry);
        Assert.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        Assert.assertEquals((Object)obj, entry);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testCopy() {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        JsonObject obj = new JsonObject().put("foo", "bar");
        this.jsonArray.add(obj);
        this.jsonArray.add((CharSequence)new StringBuilder("eeek"));
        JsonArray copy = this.jsonArray.copy();
        Assert.assertEquals((Object)"eeek", (Object)copy.getString(3));
        Assert.assertNotSame((Object)this.jsonArray, (Object)copy);
        Assert.assertEquals((Object)this.jsonArray, (Object)copy);
        Assert.assertEquals((long)4L, (long)copy.size());
        Assert.assertEquals((Object)"foo", (Object)copy.getString(0));
        Assert.assertEquals((Object)123, (Object)copy.getInteger(1));
        Assert.assertEquals((Object)obj, (Object)copy.getJsonObject(2));
        Assert.assertNotSame((Object)obj, (Object)copy.getJsonObject(2));
        copy.add("foo");
        Assert.assertEquals((long)4L, (long)this.jsonArray.size());
        this.jsonArray.add("bar");
        Assert.assertEquals((long)5L, (long)copy.size());
    }

    @Test
    public void testInvalidValsOnCopy() {
        ArrayList<SomeClass> invalid = new ArrayList<SomeClass>();
        invalid.add(new SomeClass());
        JsonArray arr = new JsonArray(invalid);
        try {
            arr.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidValsOnCopy2() {
        ArrayList invalid = new ArrayList();
        ArrayList<SomeClass> invalid2 = new ArrayList<SomeClass>();
        invalid2.add(new SomeClass());
        invalid.add(invalid2);
        JsonArray arr = new JsonArray(invalid);
        try {
            arr.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidValsOnCopy3() {
        ArrayList invalid = new ArrayList();
        HashMap<String, SomeClass> invalid2 = new HashMap<String, SomeClass>();
        invalid2.put("foo", new SomeClass());
        invalid.add(invalid2);
        JsonArray arr = new JsonArray(invalid);
        try {
            arr.copy();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEncode() throws Exception {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        this.jsonArray.add(Long.valueOf(1234L));
        this.jsonArray.add(Float.valueOf(1.23f));
        this.jsonArray.add(Double.valueOf(2.34));
        this.jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add(bytes);
        this.jsonArray.addNull();
        this.jsonArray.add(new JsonObject().put("foo", "bar"));
        this.jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String expected = "[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        String json = this.jsonArray.encode();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeToBuffer() throws Exception {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        this.jsonArray.add(Long.valueOf(1234L));
        this.jsonArray.add(Float.valueOf(1.23f));
        this.jsonArray.add(Double.valueOf(2.34));
        this.jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add(bytes);
        this.jsonArray.addNull();
        this.jsonArray.add(new JsonObject().put("foo", "bar"));
        this.jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Buffer expected = Buffer.buffer((String)("[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]"), (String)"UTF-8");
        Buffer json = this.jsonArray.toBuffer();
        Assert.assertArrayEquals((byte[])expected.getBytes(), (byte[])json.getBytes());
    }

    @Test
    public void testDecode() {
        byte[] bytes = TestUtils.randomByteArray(10);
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Instant now = Instant.now();
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String json = "[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",\"" + strInstant + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        JsonArray arr = new JsonArray(json);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertEquals((Object)1234L, (Object)arr.getLong(2));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)arr.getFloat(3));
        Assert.assertEquals((Object)2.34, (Object)arr.getDouble(4));
        Assert.assertEquals((Object)true, (Object)arr.getBoolean(5));
        Assert.assertTrue((boolean)TestUtils.byteArraysEqual(bytes, arr.getBinary(6)));
        Assert.assertEquals((Object)now, (Object)arr.getInstant(7));
        Assert.assertTrue((boolean)arr.hasNull(8));
        JsonObject obj = arr.getJsonObject(9);
        Assert.assertEquals((Object)"bar", (Object)obj.getString("foo"));
        JsonArray arr2 = arr.getJsonArray(10);
        Assert.assertEquals((Object)"foo", (Object)arr2.getString(0));
        Assert.assertEquals((Object)123, (Object)arr2.getInteger(1));
    }

    @Test
    public void testEncodePrettily() throws Exception {
        this.jsonArray.add("foo");
        this.jsonArray.add(Integer.valueOf(123));
        this.jsonArray.add(Long.valueOf(1234L));
        this.jsonArray.add(Float.valueOf(1.23f));
        this.jsonArray.add(Double.valueOf(2.34));
        this.jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        this.jsonArray.add(bytes);
        this.jsonArray.addNull();
        this.jsonArray.add(new JsonObject().put("foo", "bar"));
        this.jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String expected = "[ \"foo\", 123, 1234, 1.23, 2.34, true, \"" + strBytes + "\", null, {" + Utils.LINE_SEPARATOR + "  \"foo\" : \"bar\"" + Utils.LINE_SEPARATOR + "}, [ \"foo\", 123 ] ]";
        String json = this.jsonArray.encodePrettily();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testToString() {
        this.jsonArray.add("foo").add(Integer.valueOf(123));
        Assert.assertEquals((Object)this.jsonArray.encode(), (Object)this.jsonArray.toString());
    }

    @Test
    public void testCommentsInJson() {
        String jsonWithComments = "// single line comment\n/*\n  This is a multi \n  line comment\n*/\n[\n// another single line comment this time inside the JSON array itself\n  \"foo\", \"bar\" // and a single line comment at end of line \n/*\n  This is a another multi \n  line comment this time inside the JSON array itself\n*/\n]";
        JsonArray json = new JsonArray(jsonWithComments);
        Assert.assertEquals((Object)"[\"foo\",\"bar\"]", (Object)json.encode());
    }

    @Test
    public void testInvalidJson() {
        String invalid = "qiwjdoiqwjdiqwjd";
        try {
            new JsonArray(invalid);
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetList() {
        JsonObject obj = new JsonObject().put("quux", "wibble");
        this.jsonArray.add("foo").add(Integer.valueOf(123)).add(obj);
        List list = this.jsonArray.getList();
        list.remove("foo");
        Assert.assertFalse((boolean)this.jsonArray.contains((Object)"foo"));
        list.add("floob");
        Assert.assertTrue((boolean)this.jsonArray.contains((Object)"floob"));
        Assert.assertSame((Object)obj, list.get(1));
        obj.remove("quux");
    }

    @Test
    public void testCreateFromList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
    }

    @Test
    public void testCreateFromListCharSequence() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        list.add(new StringBuilder("eek"));
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertEquals((Object)"eek", (Object)arr.getString(2));
        Assert.assertSame(list, (Object)arr.getList());
    }

    @Test
    public void testCreateFromListNestedJsonObject() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonObject obj = new JsonObject().put("blah", "wibble");
        list.add(obj);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        Assert.assertSame((Object)obj, (Object)arr.getJsonObject(2));
    }

    @Test
    public void testCreateFromListNestedMap() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("blah", "wibble");
        list.add(map);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        JsonObject obj = arr.getJsonObject(2);
        Assert.assertSame(map, (Object)obj.getMap());
    }

    @Test
    public void testCreateFromListNestedJsonArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        JsonArray arr2 = new JsonArray().add("blah").add("wibble");
        list.add(arr2);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        Assert.assertSame((Object)arr2, (Object)arr.getJsonArray(2));
    }

    @Test
    public void testCreateFromListNestedList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add(123);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("blah");
        list2.add("wibble");
        list.add(list2);
        JsonArray arr = new JsonArray(list);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertSame(list, (Object)arr.getList());
        JsonArray arr2 = arr.getJsonArray(2);
        Assert.assertSame(list2, (Object)arr2.getList());
    }

    @Test
    public void testCreateFromBuffer() {
        JsonArray excepted = new JsonArray();
        excepted.add("foobar");
        excepted.add(Integer.valueOf(123));
        Buffer buf = Buffer.buffer((String)excepted.encode());
        Assert.assertEquals((Object)excepted, (Object)new JsonArray(buf));
    }

    @Test
    public void testClusterSerializable() {
        this.jsonArray.add("foo").add(Integer.valueOf(123));
        Buffer buff = Buffer.buffer();
        this.jsonArray.writeToBuffer(buff);
        JsonArray deserialized = new JsonArray();
        deserialized.readFromBuffer(0, buff);
        Assert.assertEquals((Object)this.jsonArray, (Object)deserialized);
    }

    @Test
    public void testJsonArrayEquality() {
        JsonObject obj = new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3)));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(3L))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add(Integer.valueOf(3)))));
        Assert.assertEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add(Long.valueOf(3L)))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", Collections.singletonList(4))));
        Assert.assertNotEquals((Object)obj, (Object)new JsonObject(Collections.singletonMap("abc", new JsonArray().add(Integer.valueOf(4)))));
        JsonArray array = new JsonArray(Collections.singletonList(Collections.singletonList(3)));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(3))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(3L))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add(Integer.valueOf(3)))));
        Assert.assertEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add(Long.valueOf(3L)))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(Collections.singletonList(4))));
        Assert.assertNotEquals((Object)array, (Object)new JsonArray(Collections.singletonList(new JsonArray().add(Integer.valueOf(4)))));
    }

    @Test
    public void testStreamCorrectTypes() throws Exception {
        String json = "{\"object1\": [{\"object2\": 12}]}";
        JsonObject object = new JsonObject(json);
        this.testStreamCorrectTypes(object.copy());
        this.testStreamCorrectTypes(object);
    }

    @Test
    public void testRemoveMethodReturnedObject() {
        JsonArray obj = new JsonArray();
        obj.add("bar").add(new JsonObject().put("name", "vert.x").put("count", Integer.valueOf(2))).add(new JsonArray().add(Double.valueOf(1.0)).add(Double.valueOf(2.0)));
        Object removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof String));
        removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof JsonObject));
        Assert.assertEquals((Object)((JsonObject)removed).getString("name"), (Object)"vert.x");
        removed = obj.remove(0);
        Assert.assertTrue((boolean)(removed instanceof JsonArray));
        Assert.assertEquals((double)((JsonArray)removed).getDouble(0), (double)1.0, (double)0.0);
    }

    private void testStreamCorrectTypes(JsonObject object) {
        object.getJsonArray("object1").stream().forEach(innerMap -> Assert.assertTrue((String)("Expecting JsonObject, found: " + innerMap.getClass().getCanonicalName()), (boolean)(innerMap instanceof JsonObject)));
    }

    class SomeClass {
        SomeClass() {
        }
    }

    static enum SomeEnum {
        FOO,
        BAR;

    }
}

