/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.test.core.VertxTestBase;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class JsonMapperTest
extends VertxTestBase {
    private static final TypeReference<Integer> INTEGER_TYPE_REF = new TypeReference<Integer>(){};
    private static final TypeReference<Long> LONG_TYPE_REF = new TypeReference<Long>(){};
    private static final TypeReference<String> STRING_TYPE_REF = new TypeReference<String>(){};
    private static final TypeReference<Float> FLOAT_TYPE_REF = new TypeReference<Float>(){};
    private static final TypeReference<Double> DOUBLE_TYPE_REF = new TypeReference<Double>(){};
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Object>> LIST_TYPE_REF = new TypeReference<List<Object>>(){};
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REF = new TypeReference<Boolean>(){};

    @Test
    public void testGetSetMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.mapper;
        this.assertNotNull(mapper);
        Json.mapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.mapper);
        Json.mapper = mapper;
    }

    @Test
    public void testGetSetPrettyMapper() {
        ObjectMapper newMapper;
        ObjectMapper mapper = Json.prettyMapper;
        this.assertNotNull(mapper);
        Json.prettyMapper = newMapper = new ObjectMapper();
        this.assertSame(newMapper, Json.prettyMapper);
        Json.prettyMapper = mapper;
    }

    @Test
    public void encodeCustomTypeInstant() {
        Instant now = Instant.now();
        String json = Json.encode((Object)now);
        this.assertNotNull(json);
        Instant decoded = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(json.substring(1, json.length() - 1)));
        this.assertEquals(now, decoded);
    }

    @Test
    public void encodeCustomTypeInstantNull() {
        Object now = null;
        String json = Json.encode(now);
        this.assertNotNull(json);
        this.assertEquals("null", json);
    }

    @Test
    public void encodeCustomTypeBinary() {
        byte[] data = new byte[]{104, 101, 108, 108, 111};
        String json = Json.encode((Object)data);
        this.assertNotNull(json);
        this.assertEquals("\"aGVsbG8=\"", json);
    }

    @Test
    public void encodeCustomTypeBinaryNull() {
        Object data = null;
        String json = Json.encode(data);
        this.assertNotNull(json);
        this.assertEquals("null", json);
    }

    @Test
    public void encodeToBuffer() {
        Buffer json = Json.encodeToBuffer((Object)"Hello World!");
        this.assertNotNull(json);
        this.assertEquals("\"Hello World!\"", json.toString("UTF-8"));
    }

    @Test
    public void testGenericDecoding() {
        Pojo original = new Pojo();
        original.value = "test";
        String json = Json.encode(Collections.singletonList(original));
        List correct = (List)Json.decodeValue((String)json, (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        correct = (List)Json.decodeValue((Buffer)Buffer.buffer((String)json, (String)"UTF8"), (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        List incorrect = (List)Json.decodeValue((String)json, List.class);
        this.assertFalse(incorrect.get(0) instanceof Pojo);
        this.assertTrue(incorrect.get(0) instanceof Map);
        this.assertEquals(original.value, ((Map)incorrect.get(0)).get("value"));
    }

    @Test
    public void testDecodeValue() {
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42, INTEGER_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42L, LONG_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"\"foobar\""), "foobar", STRING_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), Float.valueOf(3.4f), FLOAT_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), 3.4, DOUBLE_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"{\"foo\":4}"), Collections.singletonMap("foo", 4), MAP_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"[0,1,2]"), Arrays.asList(0, 1, 2), LIST_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"true"), true, BOOLEAN_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"false"), false, BOOLEAN_TYPE_REF);
    }

    private <T> void assertDecodeValue(Buffer buffer, T expected, TypeReference<T> ref) {
        Type type = ref.getType();
        Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        this.assertEquals(expected, Json.decodeValue((Buffer)buffer, (Class)clazz));
        this.assertEquals(expected, Json.decodeValue((Buffer)buffer, ref));
        this.assertEquals(expected, Json.decodeValue((String)buffer.toString(StandardCharsets.UTF_8), (Class)clazz));
        this.assertEquals(expected, Json.decodeValue((String)buffer.toString(StandardCharsets.UTF_8), ref));
        Buffer nullValue = Buffer.buffer((String)"null");
        this.assertNull(Json.decodeValue((Buffer)nullValue, (Class)clazz));
        this.assertNull(Json.decodeValue((Buffer)nullValue, ref));
        this.assertNull(Json.decodeValue((String)nullValue.toString(StandardCharsets.UTF_8), (Class)clazz));
        this.assertNull(Json.decodeValue((String)nullValue.toString(StandardCharsets.UTF_8), ref));
    }

    private static class Pojo {
        @JsonProperty
        String value;

        private Pojo() {
        }
    }
}

