/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SSLEngineTest
extends VertxTestBase {
    @Test
    public void testOpenSslOptions() {
        OpenSSLEngineOptions options = new OpenSSLEngineOptions();
        this.assertEquals(true, options.isSessionCacheEnabled());
        this.assertEquals(options, options.setSessionCacheEnabled(false));
        this.assertEquals(false, options.isSessionCacheEnabled());
    }

    @Test
    public void testCopyOpenSslOptions() {
        OpenSSLEngineOptions options = new OpenSSLEngineOptions();
        boolean sessionCacheEnabled = TestUtils.randomBoolean();
        options.setSessionCacheEnabled(sessionCacheEnabled);
        OpenSSLEngineOptions copy = new OpenSSLEngineOptions(options);
        this.assertEquals(sessionCacheEnabled, copy.isSessionCacheEnabled());
    }

    @Test
    public void testDefaultOpenSslOptionsJson() {
        OpenSSLEngineOptions def = new OpenSSLEngineOptions();
        OpenSSLEngineOptions json = new OpenSSLEngineOptions(def.toJson());
        this.assertEquals(def.isSessionCacheEnabled(), json.isSessionCacheEnabled());
    }

    @Test
    public void testOpenSslOptionsJson() {
        boolean sessionCacheEnabled = TestUtils.randomBoolean();
        JsonObject json = new JsonObject();
        json.put("sessionCacheEnabled", Boolean.valueOf(sessionCacheEnabled));
        OpenSSLEngineOptions optins = new OpenSSLEngineOptions(json);
        this.assertEquals(sessionCacheEnabled, optins.isSessionCacheEnabled());
    }
}

