/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class AsyncMultiMapTest
extends VertxTestBase {
    protected ClusterManager clusterManager;
    protected volatile AsyncMultiMap<String, ServerID> map;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(1);
        this.clusterManager = ((VertxInternal)this.vertices[0]).getClusterManager();
        CountDownLatch latch = new CountDownLatch(1);
        this.clusterManager.getAsyncMultiMap("mymap", this.onSuccess(res -> {
            this.map = res;
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testMapAddGet() {
        ServerID serverID1 = new ServerID(1234, "foo.com");
        this.map.add((Object)"some-sub", (Object)serverID1, this.onSuccess(res -> {
            this.assertNull(res);
            ServerID serverID2 = new ServerID(4321, "blah.com");
            this.map.add((Object)"some-sub", (Object)serverID2, this.onSuccess(res2 -> {
                this.assertNull(res2);
                ServerID serverID3 = new ServerID(5432, "quux.com");
                this.map.add((Object)"some-sub2", (Object)serverID3, this.onSuccess(res3 -> {
                    this.assertNull(res3);
                    this.map.get((Object)"some-sub", this.onSuccess(res4 -> {
                        HashSet<ServerID> set = new HashSet<ServerID>();
                        for (ServerID sid : res4) {
                            set.add(sid);
                        }
                        this.assertEquals(2L, set.size());
                        this.assertTrue(set.contains(serverID1));
                        this.assertTrue(set.contains(serverID2));
                        this.map.get((Object)"some-sub2", this.onSuccess(res5 -> {
                            HashSet<ServerID> set2 = new HashSet<ServerID>();
                            for (ServerID sid : res5) {
                                set2.add(sid);
                            }
                            this.assertEquals(1L, set2.size());
                            this.assertTrue(set2.contains(serverID3));
                            this.testComplete();
                        }));
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testMapRemove() {
        ServerID serverID1 = new ServerID(1234, "foo.com");
        this.map.add((Object)"some-sub", (Object)serverID1, this.onSuccess(res -> {
            this.assertNull(res);
            ServerID serverID2 = new ServerID(4321, "blah.com");
            this.map.add((Object)"some-sub", (Object)serverID2, this.onSuccess(res2 -> {
                this.assertNull(res2);
                ServerID serverID3 = new ServerID(5432, "quux.com");
                this.map.add((Object)"some-sub2", (Object)serverID3, this.onSuccess(res3 -> {
                    this.assertNull(res3);
                    this.map.get((Object)"some-sub", this.onSuccess(res4 -> {
                        HashSet<ServerID> set = new HashSet<ServerID>();
                        for (ServerID sid : res4) {
                            set.add(sid);
                        }
                        this.assertEquals(2L, set.size());
                        this.assertTrue(set.contains(serverID1));
                        this.assertTrue(set.contains(serverID2));
                        this.map.get((Object)"some-sub2", this.onSuccess(res5 -> {
                            HashSet<ServerID> set2 = new HashSet<ServerID>();
                            for (ServerID sid : res5) {
                                set2.add(sid);
                            }
                            this.assertEquals(1L, set2.size());
                            this.assertTrue(set2.contains(serverID3));
                            this.map.remove((Object)"some-sub2", (Object)serverID1, this.onSuccess(res6 -> {
                                this.assertFalse((boolean)res6);
                                this.map.remove((Object)"some-sub2", (Object)serverID3, this.onSuccess(res7 -> this.map.get((Object)"some-sub2", this.onSuccess(res8 -> {
                                    AsyncMultiMapTest.waitUntil(() -> ((ChoosableIterable)res8).isEmpty());
                                    this.testComplete();
                                }))));
                            }));
                        }));
                    }));
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testRemoveAllForValue() {
        ServerID serverID1 = new ServerID(1234, "foo.com");
        this.map.add((Object)"some-sub", (Object)serverID1, this.onSuccess(res -> {
            this.assertNull(res);
            ServerID serverID2 = new ServerID(4321, "blah.com");
            this.map.add((Object)"some-sub", (Object)serverID2, this.onSuccess(res2 -> {
                this.assertNull(res2);
                this.map.add((Object)"some-sub2", (Object)serverID1, this.onSuccess(res3 -> {
                    this.assertNull(res3);
                    this.map.removeAllForValue((Object)serverID1, this.onSuccess(res4 -> {
                        this.assertNull(res4);
                        this.map.get((Object)"some-sub", this.onSuccess(res5 -> {
                            HashSet<ServerID> set = new HashSet<ServerID>();
                            for (ServerID sid : res5) {
                                set.add(sid);
                            }
                            this.assertEquals(1L, set.size());
                            this.assertTrue(set.contains(serverID2));
                            this.assertFalse(set.contains(serverID1));
                            this.map.get((Object)"some-sub2", this.onSuccess(res6 -> {
                                HashSet<ServerID> set2 = new HashSet<ServerID>();
                                for (ServerID sid : res6) {
                                    set2.add(sid);
                                }
                                this.assertEquals(0L, set2.size());
                                this.testComplete();
                            }));
                        }));
                    }));
                }));
            }));
        }));
        this.await();
    }
}

