/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsynchronousLockTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Ignore;
import org.junit.Test;

public class ClusteredAsynchronousLockTest
extends AsynchronousLockTest {
    protected final int numNodes = 3;
    AtomicInteger pos = new AtomicInteger();

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(3);
    }

    @Override
    protected Vertx getVertx() {
        int i = this.pos.incrementAndGet();
        i = this.mod(i, 3);
        return this.vertices[i];
    }

    private int mod(int idx, int size) {
        int i = idx % size;
        return i < 0 ? i + size : i;
    }

    @Test
    @Ignore
    public void testLockReleasedForClosedNode() throws Exception {
        this.testLockReleased(latch -> this.vertices[0].close(this.onSuccess(v -> latch.countDown())));
    }

    @Test
    @Ignore
    public void testLockReleasedForKilledNode() throws Exception {
        this.testLockReleased(latch -> {
            VertxInternal vi = (VertxInternal)this.vertices[0];
            vi.getClusterManager().leave(this.onSuccess(v -> latch.countDown()));
        });
    }

    private void testLockReleased(Consumer<CountDownLatch> action) throws Exception {
        CountDownLatch lockAquiredLatch = new CountDownLatch(1);
        this.vertices[0].sharedData().getLockWithTimeout("pimpo", this.getLockTimeout(), this.onSuccess(lock -> {
            this.vertices[1].sharedData().getLockWithTimeout("pimpo", this.getLockTimeout(), this.onSuccess(lock2 -> this.testComplete()));
            lockAquiredLatch.countDown();
        }));
        this.awaitLatch(lockAquiredLatch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        action.accept(closeLatch);
        this.awaitLatch(closeLatch);
        this.await();
    }

    protected long getLockTimeout() {
        return 10000L;
    }
}

