/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.test.tls.Cert;
import org.junit.Test;

public class SSLEngineTest
extends HttpTestBase {
    private static final boolean JDK = Boolean.getBoolean("vertx-test-alpn-jdk");
    private static boolean OPEN_SSL = Boolean.getBoolean("vertx-test-alpn-openssl");
    private static final String EXPECTED_SSL_CONTEXT = SSLEngineTest.isJava9() ? "jdk" : System.getProperty("vertx-test-sslcontext");

    private static boolean isJava9() {
        try {
            SSLEngineTest.class.getClassLoader().loadClass("java.lang.invoke.VarHandle");
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    @Test
    public void testDefaultEngineWithAlpn() throws Exception {
        this.doTest(null, true, HttpVersion.HTTP_2, JDK | OPEN_SSL ? "ALPN is not available" : null, EXPECTED_SSL_CONTEXT, false);
    }

    @Test
    public void testJdkEngineWithAlpn() throws Exception {
        this.doTest((SSLEngineOptions)new JdkSSLEngineOptions(), true, HttpVersion.HTTP_2, JDK ? "ALPN not available for JDK SSL/TLS engine" : null, "jdk", false);
    }

    @Test
    public void testOpenSSLEngineWithAlpn() throws Exception {
        this.doTest((SSLEngineOptions)new OpenSSLEngineOptions(), true, HttpVersion.HTTP_2, OPEN_SSL ? "OpenSSL is not available" : null, "openssl", true);
    }

    @Test
    public void testDefaultEngine() throws Exception {
        this.doTest(null, false, HttpVersion.HTTP_1_1, null, "jdk", false);
    }

    @Test
    public void testJdkEngine() throws Exception {
        this.doTest((SSLEngineOptions)new JdkSSLEngineOptions(), false, HttpVersion.HTTP_1_1, null, "jdk", false);
    }

    @Test
    public void testOpenSSLEngine() throws Exception {
        this.doTest((SSLEngineOptions)new OpenSSLEngineOptions(), false, HttpVersion.HTTP_1_1, "OpenSSL is not available", "openssl", true);
    }

    private void doTest(SSLEngineOptions engine, boolean useAlpn, HttpVersion version, String error, String expectedSslContext, boolean expectCause) {
        this.server.close();
        HttpServerOptions options = new HttpServerOptions().setSslEngineOptions(engine).setPort(8080).setHost("localhost").setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get()).setSsl(true).setUseAlpn(useAlpn);
        try {
            this.server = this.vertx.createHttpServer(options);
        }
        catch (VertxException e) {
            e.printStackTrace();
            if (error == null) {
                this.fail(e);
            } else {
                this.assertEquals(error, e.getMessage());
                if (expectCause) {
                    this.assertNotSame((Object)e, e.getCause());
                }
            }
            return;
        }
        this.server.requestHandler(req -> {
            this.assertEquals(req.version(), version);
            this.assertTrue(req.isSSL());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            HttpServerImpl impl = (HttpServerImpl)s;
            SSLHelper sslHelper = impl.getSslHelper();
            SslContext ctx = sslHelper.getContext((VertxInternal)this.vertx);
            switch (expectedSslContext != null ? expectedSslContext : "jdk") {
                case "jdk": {
                    this.assertTrue(ctx instanceof JdkSslContext);
                    break;
                }
                case "openssl": {
                    this.assertTrue(ctx instanceof OpenSslContext);
                }
            }
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setSslEngineOptions(engine).setSsl(true).setUseAlpn(useAlpn).setTrustAll(true).setProtocolVersion(version));
            this.client.getNow(8080, "localhost", "/somepath", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
        }));
        this.await();
    }
}

