/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakestream;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.impl.Arguments;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Stream;

public class FakeStream<T>
implements ReadStream<T>,
WriteStream<T> {
    private boolean emitting;
    private long highWaterMark = 16L;
    private Handler<Throwable> exceptionHandler;
    private Handler<T> itemHandler;
    private Handler<Void> endHandler;
    private final Deque<T> pending;
    private long demand = Long.MAX_VALUE;
    private boolean ended;
    private boolean overflow;
    private Handler<Void> drainHandler;

    public FakeStream() {
        this.pending = new ArrayDeque<T>();
    }

    public synchronized boolean isPaused() {
        return this.demand == 0L;
    }

    public synchronized boolean isEnded() {
        return this.ended;
    }

    public synchronized long demand() {
        return this.demand;
    }

    public synchronized FakeStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @SafeVarargs
    public final boolean emit(T ... elements) {
        return this.emit(Stream.of(elements));
    }

    public synchronized boolean emit(Stream<T> stream) {
        if (this.ended) {
            throw new IllegalStateException();
        }
        stream.forEach(this.pending::add);
        this.checkPending();
        boolean writable = (long)this.pending.size() <= this.highWaterMark;
        this.overflow |= !writable;
        return writable;
    }

    public synchronized void end() {
        if (this.ended) {
            throw new IllegalStateException();
        }
        this.ended = true;
        if (this.pending.size() > 0) {
            return;
        }
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            handler.handle(null);
        }
    }

    public synchronized void fail(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.exceptionHandler.handle((Object)err);
        }
    }

    public synchronized FakeStream<T> handler(Handler<T> handler) {
        this.itemHandler = handler;
        return this;
    }

    public synchronized Handler<T> handler() {
        return this.itemHandler;
    }

    public synchronized FakeStream<T> pause() {
        this.demand = 0L;
        return this;
    }

    private void checkPending() {
        Object handler;
        T elt;
        if (this.emitting) {
            return;
        }
        this.emitting = true;
        while (this.demand > 0L && (elt = this.pending.poll()) != null) {
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            if ((handler = this.itemHandler) == null) continue;
            handler.handle(elt);
        }
        if (this.pending.isEmpty() && this.overflow) {
            this.overflow = false;
            handler = this.drainHandler;
            if (handler != null) {
                handler.handle(null);
            }
        }
        this.emitting = false;
    }

    public synchronized FakeStream<T> fetch(long amount) {
        Handler<Void> handler;
        Arguments.require((amount > 0L ? 1 : 0) != 0, (String)"Fetch amount must be > 0L");
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        this.checkPending();
        if (this.pending.isEmpty() && this.ended && (handler = this.endHandler) != null) {
            handler.handle(null);
        }
        return this;
    }

    public FakeStream<T> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized FakeStream<T> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public synchronized Handler<Void> endHandler() {
        return this.endHandler;
    }

    public FakeStream<T> write(T data) {
        this.emit(data);
        return this;
    }

    public synchronized FakeStream<T> setWriteQueueMaxSize(int maxSize) {
        this.highWaterMark = maxSize;
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return (long)this.pending.size() > this.highWaterMark;
    }

    public synchronized FakeStream<T> drainHandler(@Nullable Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public synchronized Handler<Void> drainHandler() {
        return this.drainHandler;
    }
}

