/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakestream;

import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakestream.FakeStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class FakeStreamTest
extends AsyncTestBase {
    private FakeStream<Integer> stream;
    private List<Integer> emitted;
    private int drained;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.emitted = new ArrayList<Integer>();
        this.stream = new FakeStream();
        this.stream.handler(this.emitted::add);
        this.stream.drainHandler(v -> ++this.drained);
        this.drained = 0;
    }

    @Test
    public void testEmit() {
        this.assertTrue(this.stream.emit((Integer[])new Integer[]{0}));
        this.assertEquals(Collections.singletonList(0), this.emitted);
        this.assertTrue(this.stream.emit((Integer[])new Integer[]{1, 2}));
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }

    @Test
    public void testPause() {
        this.stream.pause();
        this.assertTrue(this.stream.emit(IntStream.range(0, 16).boxed()));
        this.assertFalse(this.stream.emit((Integer[])new Integer[]{16}));
        this.assertEquals(Collections.emptyList(), this.emitted);
    }

    @Test
    public void testResume() {
        this.stream.pause();
        this.assertFalse(this.stream.emit(IntStream.range(0, 17).boxed()));
        this.stream.resume();
        this.assertEquals(1L, this.drained);
        this.assertEquals(IntStream.range(0, 17).boxed().collect(Collectors.toList()), this.emitted);
    }

    @Test
    public void testFetch() {
        this.stream.pause();
        this.assertFalse(this.stream.emit(IntStream.range(0, 17).boxed()));
        for (int i = 1; i < 17; ++i) {
            this.stream.fetch(1L);
            this.assertEquals(IntStream.range(0, i).boxed().collect(Collectors.toList()), this.emitted);
            this.assertEquals(0L, this.drained);
        }
        this.stream.fetch(1L);
        this.assertEquals(IntStream.range(0, 17).boxed().collect(Collectors.toList()), this.emitted);
        this.assertEquals(1L, this.drained);
    }

    @Test
    public void testWriteQueueFull() {
        this.stream.pause();
        int count = 0;
        while (this.stream.emit((Integer[])new Integer[]{count++})) {
            this.assertFalse(this.stream.writeQueueFull());
        }
        this.assertTrue(this.stream.writeQueueFull());
        this.stream.fetch(1L);
        this.assertFalse(this.stream.writeQueueFull());
    }

    @Test
    public void testEmitReentrancy() {
        AtomicInteger count = new AtomicInteger(2);
        AtomicBoolean emitting = new AtomicBoolean();
        this.stream.pause();
        this.stream.fetch(3L);
        this.stream.handler(item -> {
            this.assertFalse(emitting.getAndSet(true));
            this.emitted.add((Integer)item);
            this.stream.emit((Integer[])new Integer[]{count.getAndIncrement()});
            emitting.set(false);
        });
        this.stream.emit((Integer[])new Integer[]{0, 1});
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }

    @Test
    public void testFetchReentrancy() {
        AtomicInteger count = new AtomicInteger(2);
        this.stream.pause();
        AtomicBoolean emitting = new AtomicBoolean();
        this.stream.handler(item -> {
            this.assertFalse(emitting.getAndSet(true));
            this.emitted.add((Integer)item);
            this.stream.emit((Integer[])new Integer[]{count.getAndIncrement()});
            emitting.set(false);
        });
        this.stream.emit((Integer[])new Integer[]{0, 1});
        this.stream.fetch(3L);
        this.assertEquals(Arrays.asList(0, 1, 2), this.emitted);
    }
}

