/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final VertxInternal vertx;
    private boolean chunked = false;
    private String hostHeader;
    private String rawMethod;
    private Handler<Void> continueHandler;
    private Handler<Void> drainHandler;
    private Handler<HttpClientRequest> pushHandler;
    private Handler<HttpConnection> connectionHandler;
    private Handler<Throwable> exceptionHandler;
    private Promise<Void> endPromise = Promise.promise();
    private Future<Void> endFuture = this.endPromise.future();
    private boolean ended;
    private Throwable reset;
    private ByteBuf pendingChunks;
    private List<Handler<AsyncResult<Void>>> pendingHandlers;
    private int pendingMaxSize = -1;
    private int followRedirects;
    private VertxHttpHeaders headers;
    private StreamPriority priority;
    private HttpClientStream stream;
    private boolean connecting;
    private Handler<HttpClientResponse> respHandler;
    private Handler<Void> endHandler;

    HttpClientRequestImpl(HttpClientImpl client, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String relativeURI, VertxInternal vertx) {
        super(client, ssl, method, server, host, port, relativeURI);
        this.vertx = vertx;
        this.priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
    }

    @Override
    public synchronized int streamId() {
        return this.stream == null ? -1 : this.stream.id();
    }

    @Override
    public synchronized HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.respHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            this.followRedirects = followRedirects ? this.client.getOptions().getMaxRedirects() - 1 : 0;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        Arguments.require(maxRedirects >= 0, "Max redirects must be >= 0");
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            this.followRedirects = maxRedirects;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest endHandler(Handler<Void> handler) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl setChunked(boolean chunked) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            if (this.stream != null) {
                throw new IllegalStateException("Cannot set chunked after data has been written on request");
            }
            if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
                this.chunked = chunked;
            }
            return this;
        }
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized String getRawMethod() {
        return this.rawMethod;
    }

    @Override
    public synchronized HttpClientRequest setRawMethod(String method) {
        this.rawMethod = method;
        return this;
    }

    @Override
    public synchronized HttpClientRequest setHost(String host) {
        this.hostHeader = host;
        return this;
    }

    @Override
    public synchronized String getHost() {
        return this.hostHeader;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new VertxHttpHeaders();
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            s = this.stream;
            if (s == null) {
                this.pendingMaxSize = maxSize;
                return this;
            }
        }
        s.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            s = this.stream;
            if (s == null) {
                return false;
            }
        }
        return s.isNotWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (handler != null) {
                this.checkEnded();
                this.drainHandler = handler;
                HttpClientStream s = this.stream;
                if (s == null) {
                    return this;
                }
                s.getContext().runOnContext(v -> {
                    HttpClientRequestImpl httpClientRequestImpl = this;
                    synchronized (httpClientRequestImpl) {
                        if (!this.stream.isNotWritable()) {
                            this.handleDrained();
                        }
                    }
                });
            } else {
                this.drainHandler = null;
            }
            return this;
        }
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.continueHandler = handler;
        return this;
    }

    @Override
    public HttpClientRequest sendHead() {
        return this.sendHead(null);
    }

    @Override
    public synchronized HttpClientRequest sendHead(Handler<HttpVersion> headersHandler) {
        this.checkEnded();
        this.checkResponseHandler();
        if (this.stream != null) {
            throw new IllegalStateException("Head already written");
        }
        this.connect(headersHandler);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.pushHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean reset(Throwable cause) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.reset != null) {
                return false;
            }
            this.reset = cause;
            s = this.stream;
        }
        if (s != null) {
            s.reset(cause);
        } else {
            this.handleException(cause);
        }
        return true;
    }

    private void tryComplete() {
        this.endPromise.tryComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpConnection connection() {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            s = this.stream;
            if (s == null) {
                return null;
            }
        }
        return s.connection();
    }

    @Override
    public synchronized HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            s = this.stream;
            if (s == null) {
                throw new IllegalStateException("Not yet connected");
            }
        }
        s.writeFrame(type, flags, payload.getByteBuf());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.drainHandler;
            if (handler == null || this.endFuture.isComplete()) {
                return;
            }
        }
        try {
            handler.handle(null);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void handleNextRequest(HttpClientRequest next, long timeoutMs) {
        next.handler((Handler)this.respHandler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.endHandler((Handler)this.endHandler);
        next.pushHandler(this.pushHandler);
        next.setMaxRedirects(this.followRedirects - 1);
        if (next.getHost() == null) {
            next.setHost(this.hostHeader);
        }
        if (this.headers != null) {
            next.headers().addAll(this.headers);
        }
        this.endFuture.setHandler(ar -> {
            if (ar.succeeded()) {
                if (timeoutMs > 0L) {
                    next.setTimeout(timeoutMs);
                }
                next.end();
            } else {
                next.reset(0L);
            }
        });
    }

    @Override
    public void handleException(Throwable t) {
        super.handleException(t);
        this.endPromise.tryFail(t);
    }

    @Override
    void handleResponse(HttpClientResponse resp, long timeoutMs) {
        if (this.reset == null) {
            Future<HttpClientRequest> next;
            int statusCode = resp.statusCode();
            if (this.followRedirects > 0 && statusCode >= 300 && statusCode < 400 && (next = this.client.redirectHandler().apply(resp)) != null) {
                next.setHandler(ar -> {
                    if (ar.succeeded()) {
                        this.handleNextRequest((HttpClientRequest)ar.result(), timeoutMs);
                    } else {
                        this.handleException(ar.cause());
                    }
                });
                return;
            }
            if (this.respHandler != null) {
                this.respHandler.handle(resp);
            }
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    @Override
    protected String hostHeader() {
        return this.hostHeader != null ? this.hostHeader : super.hostHeader();
    }

    private synchronized void connect(Handler<HttpVersion> headersHandler) {
        if (!this.connecting) {
            SocketAddress peerAddress;
            if (this.method == HttpMethod.OTHER && this.rawMethod == null) {
                throw new IllegalStateException("You must provide a rawMethod when using an HttpMethod.OTHER method");
            }
            if (this.hostHeader != null) {
                int idx = this.hostHeader.lastIndexOf(58);
                peerAddress = idx != -1 ? SocketAddress.inetSocketAddress(Integer.parseInt(this.hostHeader.substring(idx + 1)), this.hostHeader.substring(0, idx)) : SocketAddress.inetSocketAddress(80, this.hostHeader);
            } else {
                String peerHost = this.host;
                if (peerHost.endsWith(".")) {
                    peerHost = peerHost.substring(0, peerHost.length() - 1);
                }
                peerAddress = SocketAddress.inetSocketAddress(this.port, peerHost);
            }
            Handler<HttpConnection> h1 = this.connectionHandler;
            Handler<HttpConnection> h2 = this.client.connectionHandler();
            Handler<HttpConnection> initializer = h1 != null ? (h2 != null ? conn -> {
                h1.handle((HttpConnection)conn);
                h2.handle((HttpConnection)conn);
            } : h1) : h2;
            ContextInternal connectCtx = this.vertx.getOrCreateContext();
            this.connecting = true;
            this.client.getConnectionForRequest(connectCtx, peerAddress, this.ssl, this.server, ar1 -> {
                if (ar1.succeeded()) {
                    HttpClientStream stream = (HttpClientStream)ar1.result();
                    ContextInternal ctx = (ContextInternal)stream.getContext();
                    if (stream.id() == 1 && initializer != null) {
                        ctx.executeFromIO(v -> initializer.handle(stream.connection()));
                    }
                    if (this.reset != null) {
                        stream.reset(this.reset);
                    } else {
                        ctx.executeFromIO(v -> this.connected(headersHandler, stream));
                    }
                } else {
                    connectCtx.executeFromIO(v -> this.handleException(ar1.cause()));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(Handler<HttpVersion> headersHandler, HttpClientStream stream) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.stream = stream;
            stream.beginRequest(this);
            if (this.pendingMaxSize != -1) {
                stream.doSetWriteQueueMaxSize(this.pendingMaxSize);
            }
            ByteBuf pending = null;
            Handler<AsyncResult<Void>> handler = null;
            if (this.pendingChunks != null) {
                List<Handler<AsyncResult<Void>>> handlers = this.pendingHandlers;
                this.pendingHandlers = null;
                pending = this.pendingChunks;
                this.pendingChunks = null;
                if (handlers != null) {
                    handler = ar -> handlers.forEach(h -> h.handle(ar));
                }
            }
            stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, pending, this.ended, this.priority, this.continueHandler, handler);
            if (this.ended) {
                stream.endRequest();
                this.tryComplete();
            }
            this.connecting = false;
            this.stream = stream;
        }
        if (headersHandler != null) {
            headersHandler.handle(stream.version());
        }
    }

    @Override
    public void end(String chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)null);
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(chunk, enc, null);
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.end(Buffer.buffer(chunk, enc), handler);
    }

    @Override
    public void end(Buffer chunk) {
        this.write(chunk.getByteBuf(), true, null);
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk.getByteBuf(), true, handler);
    }

    @Override
    public void end() {
        this.write(null, true, null);
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.write(null, true, handler);
    }

    @Override
    public HttpClientRequest write(Buffer chunk) {
        return this.write(chunk, (Handler<AsyncResult<Void>>)null);
    }

    @Override
    public HttpClientRequest write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, handler);
        return this;
    }

    @Override
    public HttpClientRequest write(String chunk) {
        return this.write(chunk, (Handler<AsyncResult<Void>>)null);
    }

    @Override
    public HttpClientRequest write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk).getByteBuf(), false, handler);
        return this;
    }

    @Override
    public HttpClientRequest write(String chunk, String enc) {
        return this.write(chunk, enc, null);
    }

    @Override
    public HttpClientRequest write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, handler);
        return this;
    }

    private boolean requiresContentLength() {
        return !this.chunked && (this.headers == null || !this.headers.contains(HttpHeaders.CONTENT_LENGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> completionHandler) {
        HttpClientStream s;
        if (buff == null && !end) {
            return;
        }
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
            this.checkResponseHandler();
            if (end) {
                if (buff != null && this.requiresContentLength()) {
                    this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buff.readableBytes()));
                }
            } else if (this.requiresContentLength()) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.ended |= end;
            if (this.stream == null) {
                if (buff != null) {
                    if (this.pendingChunks == null) {
                        this.pendingChunks = buff;
                    } else {
                        CompositeByteBuf pending;
                        if (this.pendingChunks instanceof CompositeByteBuf) {
                            pending = (CompositeByteBuf)this.pendingChunks;
                        } else {
                            pending = Unpooled.compositeBuffer();
                            pending.addComponent(true, this.pendingChunks);
                            this.pendingChunks = pending;
                        }
                        pending.addComponent(true, buff);
                    }
                    if (completionHandler != null) {
                        if (this.pendingHandlers == null) {
                            this.pendingHandlers = new ArrayList<Handler<AsyncResult<Void>>>();
                        }
                        this.pendingHandlers.add(completionHandler);
                    }
                }
                this.connect(null);
                return;
            }
            s = this.stream;
        }
        s.writeBuffer(buff, end, completionHandler);
        if (end) {
            s.endRequest();
            this.tryComplete();
        }
    }

    @Override
    protected void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
        if (this.respHandler == null) {
            throw new IllegalStateException("You must set an handler for the HttpClientResponse before connecting");
        }
    }

    synchronized Handler<HttpClientRequest> pushHandler() {
        return this.pushHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpClientRequest setStreamPriority(StreamPriority priority) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.stream != null) {
                this.stream.updatePriority(priority);
            } else {
                this.priority = priority;
            }
        }
        return this;
    }

    @Override
    public synchronized StreamPriority getStreamPriority() {
        HttpClientStream s = this.stream;
        return s != null ? s.priority() : this.priority;
    }
}

