/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2HeadersAdaptor;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.streams.impl.InboundBuffer;

abstract class VertxHttp2Stream<C extends Http2ConnectionBase> {
    private static final MultiMap EMPTY = new Http2HeadersAdaptor((Http2Headers)EmptyHttp2Headers.INSTANCE);
    protected final C conn;
    protected final VertxInternal vertx;
    protected final ContextInternal context;
    protected final ChannelHandlerContext handlerContext;
    protected final Http2Stream stream;
    private final InboundBuffer<Object> pending;
    private int pendingBytes;
    private MultiMap trailers;
    private boolean writable;
    private StreamPriority priority;
    private long bytesRead;
    private long bytesWritten;

    VertxHttp2Stream(C conn, Http2Stream stream, boolean writable) {
        this.conn = conn;
        this.vertx = ((Http2ConnectionBase)conn).vertx();
        this.handlerContext = ((Http2ConnectionBase)conn).handlerContext;
        this.stream = stream;
        this.context = ((ConnectionBase)conn).getContext();
        this.writable = writable;
        this.pending = new InboundBuffer(this.context, 5L);
        this.priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
        this.pending.drainHandler(v -> {
            int numBytes = this.pendingBytes;
            this.pendingBytes = 0;
            conn.handler.consume(stream, numBytes);
        });
        this.pending.handler(buff -> {
            if (buff == InboundBuffer.END_SENTINEL) {
                conn.reportBytesRead(this.bytesRead);
                this.handleEnd(this.trailers);
            } else {
                Buffer data = (Buffer)buff;
                this.bytesRead += (long)data.length();
                this.handleData(data);
            }
        });
        this.pending.exceptionHandler(this.context.exceptionHandler());
        this.pending.resume();
    }

    void onResetRead(long code) {
        this.handleReset(code);
    }

    boolean onDataRead(Buffer data) {
        boolean read = this.pending.write(data);
        if (!read) {
            this.pendingBytes += data.length();
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWritabilityChanged() {
        C c = this.conn;
        synchronized (c) {
            this.writable = !this.writable;
            this.handleInterestedOpsChanged();
        }
    }

    void onEnd() {
        this.onEnd(EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onEnd(MultiMap map) {
        C c = this.conn;
        synchronized (c) {
            this.trailers = map;
        }
        this.pending.write(InboundBuffer.END_SENTINEL);
    }

    int id() {
        return this.stream.id();
    }

    long bytesWritten() {
        return this.bytesWritten;
    }

    long bytesRead() {
        return this.bytesRead;
    }

    public void doPause() {
        this.pending.pause();
    }

    public void doFetch(long amount) {
        this.pending.fetch(amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNotWritable() {
        C c = this.conn;
        synchronized (c) {
            return !this.writable;
        }
    }

    void writeFrame(int type, int flags, ByteBuf payload) {
        ((Http2ConnectionBase)this.conn).handler.writeFrame(this.stream, (byte)type, (short)flags, payload);
    }

    void writeHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        ((Http2ConnectionBase)this.conn).handler.writeHeaders(this.stream, headers, end, this.priority.getDependency(), this.priority.getWeight(), this.priority.isExclusive(), handler);
    }

    private void writePriorityFrame(StreamPriority priority) {
        ((Http2ConnectionBase)this.conn).handler.writePriority(this.stream, priority.getDependency(), priority.getWeight(), priority.isExclusive());
    }

    void writeData(ByteBuf chunk, boolean end) {
        this.writeData(chunk, end, null);
    }

    void writeData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        this.bytesWritten += (long)chunk.readableBytes();
        ((Http2ConnectionBase)this.conn).handler.writeData(this.stream, chunk, end, handler);
    }

    void writeReset(long code) {
        ((Http2ConnectionBase)this.conn).handler.writeReset(this.stream.id(), code);
    }

    void handleInterestedOpsChanged() {
    }

    void handleData(Buffer buf) {
    }

    void handleCustomFrame(int type, int flags, Buffer buff) {
    }

    void handleEnd(MultiMap trailers) {
    }

    void handleReset(long errorCode) {
    }

    void handleException(Throwable cause) {
    }

    void handleClose() {
        ((ConnectionBase)this.conn).reportBytesWritten(this.bytesWritten);
    }

    synchronized void priority(StreamPriority streamPriority) {
        this.priority = streamPriority;
    }

    synchronized StreamPriority priority() {
        return this.priority;
    }

    synchronized void updatePriority(StreamPriority priority) {
        if (!this.priority.equals(priority)) {
            this.priority = priority;
            if (this.stream.isHeadersSent()) {
                this.writePriorityFrame(priority);
            }
        }
    }

    abstract void handlePriorityChange(StreamPriority var1);
}

