/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.test.core.VertxTestBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Test;

public class FutureTest
extends VertxTestBase {
    @Test
    public void testCreateWithHandler() {
        AtomicInteger count = new AtomicInteger();
        AtomicReference ref = new AtomicReference();
        Future f2 = Future.future(p1 -> {
            this.assertFalse(p1.future().isComplete());
            count.incrementAndGet();
            ref.set(p1);
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new Checker(f2).assertNotCompleted();
        ref.set(null);
        count.set(0);
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.complete((Object)"the-value");
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new Checker<String>(f2).assertSucceeded("the-value");
        ref.set(null);
        count.set(0);
        RuntimeException cause = new RuntimeException();
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.fail((Throwable)cause);
        });
        this.assertSame(f2, ((Promise)ref.get()).future());
        this.assertEquals(1L, count.get());
        new Checker(f2).assertFailed(cause);
        Future f3 = Future.future(f -> {
            throw cause;
        });
        this.assertSame(cause, f3.cause());
    }

    @Test
    public void testStateAfterCompletion() {
        Object foo = new Object();
        Future future = Future.succeededFuture((Object)foo);
        this.assertTrue(future.succeeded());
        this.assertFalse(future.failed());
        this.assertTrue(future.isComplete());
        this.assertEquals(foo, future.result());
        this.assertNull(future.cause());
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        this.assertFalse(future.succeeded());
        this.assertTrue(future.failed());
        this.assertTrue(future.isComplete());
        this.assertNull(future.result());
        this.assertEquals(cause, future.cause());
    }

    @Test
    public void testSetResultOnCompletedFuture() {
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        for (Future future : futures) {
            try {
                future.complete(new Object());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryComplete(new Object()));
            try {
                future.complete(null);
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryComplete(null));
            try {
                future.fail((Throwable)new Exception());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryFail((Throwable)new Exception()));
        }
    }

    @Test
    public void testSetNullHandler() throws Exception {
        Promise promise = Promise.promise();
        try {
            promise.future().setHandler(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        promise.complete();
        try {
            promise.future().setHandler(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCallSetHandlerBeforeCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Promise promise = Promise.promise();
        promise.future().setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertFalse(called.get());
        promise.complete(null);
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        promise = Promise.promise();
        promise.future().setHandler(result -> {
            called.set(true);
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
        });
        this.assertFalse(called.get());
        promise.complete(foo);
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        promise = Promise.promise();
        promise.future().setHandler(result -> {
            called.set(true);
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
        });
        this.assertFalse(called.get());
        promise.fail((Throwable)cause);
        this.assertTrue(called.get());
    }

    @Test
    public void testCallSetHandlerAfterCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.succeededFuture();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.succeededFuture((Object)foo);
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        future.setHandler(result -> {
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
    }

    @Test
    public void testResolveFutureToHandler() {
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Promise promise = Promise.promise();
        consumer.accept((Handler)promise);
        this.assertTrue(promise.future().isComplete());
        this.assertTrue(promise.future().succeeded());
        this.assertEquals("the-result", promise.future().result());
    }

    @Test
    public void testFailFutureToHandler() {
        Throwable cause = new Throwable();
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.failedFuture((Throwable)cause));
        Promise promise = Promise.promise();
        consumer.accept((Handler)promise);
        this.assertTrue(promise.future().isComplete());
        this.assertTrue(promise.future().failed());
        this.assertEquals(cause, promise.future().cause());
    }

    @Test
    public void testCreateFailedWithNullFailure() {
        Future future = Future.failedFuture((Throwable)null);
        Checker checker = new Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testFailureFutureWithNullFailure() {
        Promise promise = Promise.promise();
        promise.fail((Throwable)null);
        Checker checker = new Checker(promise.future());
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testCompositeComplete() {
        CompositeFuture composite = CompositeFuture.all((Future)Future.future(), (Future)Future.future());
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        composite.complete((Object)composite);
        checker.assertSucceeded(composite);
        composite = CompositeFuture.all((Future)Future.future(), (Future)Future.future());
        checker = new Checker(composite);
        composite.complete();
        checker.assertSucceeded(composite);
    }

    @Test
    public void testCompositeFail() {
        Throwable cause = new Throwable();
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        Checker checker = new Checker(composite);
        composite.fail(cause);
        checker.assertFailed(cause);
        p1.complete();
        p2.complete();
        checker.assertFailed(cause);
    }

    @Test
    public void testAllSucceeded() {
        this.testAllSucceeded(CompositeFuture::all);
    }

    @Test
    public void testAllSucceededWithList() {
        this.testAllSucceeded((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p1.complete((Object)"something");
        checker.assertNotCompleted();
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(3L, ((Integer)composite.resultAt(1)).intValue());
    }

    @Test
    public void testAllWithEmptyList() {
        CompositeFuture composite = CompositeFuture.all(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAllFailed() {
        this.testAllFailed(CompositeFuture::all);
    }

    @Test
    public void testAllFailedWithList() {
        this.testAllFailed((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        p1.complete((Object)"s");
        Exception cause = new Exception();
        p2.fail((Throwable)cause);
        checker.assertFailed(cause);
        this.assertEquals("s", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
    }

    @Test
    public void testAllLargeList() {
        this.testAllLargeList(63);
        this.testAllLargeList(64);
        this.testAllLargeList(65);
        this.testAllLargeList(100);
    }

    private void testAllLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.succeededFuture());
        }
        CompositeFuture composite = CompositeFuture.all(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertSucceeded(composite);
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            Exception cause = new Exception();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.failedFuture((Throwable)cause) : Future.succeededFuture());
            }
            composite = CompositeFuture.all(list);
            checker = new Checker(composite);
            checker.assertFailed(cause);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.failed(j));
                    continue;
                }
                this.assertTrue(composite.succeeded(j));
            }
        }
    }

    @Test
    public void testAnySucceeded1() {
        this.testAnySucceeded1(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded1WithList() {
        this.testAnySucceeded1((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnySucceeded1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p1.complete((Object)"something");
        checker.assertSucceeded(composite);
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyWithEmptyList() {
        CompositeFuture composite = CompositeFuture.any(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAnySucceeded2() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded2WithList() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    private void testAnySucceeded2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        p1.fail("failure");
        checker.assertNotCompleted();
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyFailed() {
        this.testAnyFailed(CompositeFuture::any);
    }

    @Test
    public void testAnyFailedWithList() {
        this.testAnyFailed((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnyFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        p1.fail("failure");
        checker.assertNotCompleted();
        Exception cause = new Exception();
        p2.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testAnyLargeList() {
        this.testAnyLargeList(63);
        this.testAnyLargeList(64);
        this.testAnyLargeList(65);
        this.testAnyLargeList(100);
    }

    private void testAnyLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.failedFuture((Throwable)new Exception()));
        }
        CompositeFuture composite = CompositeFuture.any(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        this.assertNotNull(checker.assertFailed());
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.succeededFuture() : Future.failedFuture((Throwable)new RuntimeException()));
            }
            composite = CompositeFuture.any(list);
            checker = new Checker(composite);
            checker.assertSucceeded(composite);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.succeeded(j));
                    continue;
                }
                this.assertTrue(composite.failed(j));
            }
        }
    }

    @Test
    public void testJoinSucceeded() {
        this.testJoinSucceeded(CompositeFuture::join);
    }

    @Test
    public void testJoinSucceededWithList() {
        this.testJoinSucceeded((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        p1.complete((Object)"foo");
        checker.assertNotCompleted();
        p2.complete();
        checker.assertSucceeded(composite);
    }

    @Test
    public void testJoinFailed1() {
        this.testJoinFailed1(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed1WithList() {
        this.testJoinFailed1((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        p1.complete((Object)"foo");
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        p2.fail(cause);
        this.assertSame(checker.assertFailed(), cause);
    }

    @Test
    public void testJoinFailed2() {
        this.testJoinFailed2(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed2WithList() {
        this.testJoinFailed2((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        p1.fail(cause);
        checker.assertNotCompleted();
        p2.complete((Object)10);
        this.assertSame(cause, checker.assertFailed());
    }

    @Test
    public void testJoinFailed3() {
        this.testJoinFailed3(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed3WithList() {
        this.testJoinFailed3((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed3(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        Throwable cause1 = new Throwable();
        p1.fail(cause1);
        checker.assertNotCompleted();
        Throwable cause2 = new Throwable();
        p2.fail(cause2);
        this.assertSame(cause1, checker.assertFailed());
    }

    @Test
    public void testJoinWithEmptyList() {
        CompositeFuture composite = CompositeFuture.join(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testCompositeFutureToList() {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        this.assertEquals(Arrays.asList(null, null), composite.list());
        p1.complete((Object)"foo");
        this.assertEquals(Arrays.asList("foo", null), composite.list());
        p2.complete((Object)4);
        this.assertEquals(Arrays.asList("foo", 4), composite.list());
    }

    @Test
    public void testComposeSuccessToSuccess() {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        checker.assertNotCompleted();
        p1.complete((Object)"abcdef");
        checker.assertSucceeded(6);
        AtomicReference ref = new AtomicReference();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        checker = new Checker(f4);
        p3.complete((Object)"abcdef");
        checker.assertNotCompleted();
        this.assertEquals("abcdef", ref.get());
        p.complete((Object)6);
        checker.assertSucceeded(6);
    }

    @Test
    public void testComposeSuccessToFailure() {
        Throwable cause = new Throwable();
        AtomicReference ref = new AtomicReference();
        Promise p = Promise.promise();
        Future c = p.future();
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        Checker checker = new Checker(f4);
        p3.complete((Object)"abcdef");
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFailure() {
        Exception cause = new Exception();
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        p1.fail((Throwable)cause);
        checker.assertFailed(cause);
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> Future.succeededFuture((Object)string.length()));
        checker = new Checker(f4);
        p3.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFails() {
        RuntimeException cause = new RuntimeException();
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> {
            throw cause;
        }, f2);
        p1.complete((Object)"foo");
        checker.assertFailed(cause);
        Promise p3 = Promise.promise();
        Future f3 = p3.future();
        Future f4 = f3.compose(string -> {
            throw cause;
        });
        checker = new Checker(f4);
        p3.complete((Object)"foo");
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFailsAfterCompletion() {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        RuntimeException cause = new RuntimeException();
        f1.compose(string -> {
            f2.complete((Object)46);
            throw cause;
        }, f2);
        try {
            p1.complete((Object)"foo");
            this.fail();
        }
        catch (Exception e) {
            this.assertEquals(cause, e);
        }
        checker.assertSucceeded(46);
    }

    @Test
    public void testComposeWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.compose((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMapSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(Object::toString);
        Checker<String> checker = new Checker<String>(mapped);
        checker.assertNotCompleted();
        p.complete((Object)3);
        checker.assertSucceeded("3");
    }

    @Test
    public void testMapFailure() {
        Throwable cause = new Throwable();
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(Object::toString);
        Checker checker = new Checker(mapped);
        checker.assertNotCompleted();
        p.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapFails() {
        RuntimeException cause = new RuntimeException();
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.map(i -> {
            throw cause;
        });
        Checker checker = new Checker(mapped);
        p.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(f).map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMapEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future mapped = f.mapEmpty();
        Checker checker = new Checker(mapped);
        checker.assertNotCompleted();
        p.complete((Object)3);
        checker.assertSucceeded(null);
    }

    @Test
    public void testRecoverSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            called.set(true);
            throw new AssertionError();
        });
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testRecoverFailureWithSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testRecoverFailureWithFailure() {
        Throwable cause = new Throwable();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.failedFuture((Throwable)cause));
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverFailureFails() {
        RuntimeException cause = new RuntimeException("throw");
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            throw cause;
        });
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverWithNullFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        try {
            f.recover(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testOtherwiseSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(t -> {
            called.set(true);
            throw new AssertionError();
        });
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseFailureWithSuccess() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(Throwable::getMessage);
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testOtherwiseFails() {
        RuntimeException cause = new RuntimeException("throw");
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.otherwise(t -> {
            throw cause;
        });
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        p.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testDefaultCompleter() {
        AsyncResult<Object> succeededAsyncResult = new AsyncResult<Object>(){
            Object result = new Object();

            public Object result() {
                return this.result;
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        AsyncResult<Object> failedAsyncResult = new AsyncResult<Object>(){
            Throwable cause = new Throwable();

            public Object result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                return this.cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        class DefaultCompleterTestFuture<T>
        implements Future<T> {
            boolean succeeded;
            boolean failed;
            T result;
            Throwable cause;

            DefaultCompleterTestFuture() {
            }

            public boolean isComplete() {
                throw new UnsupportedOperationException();
            }

            public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
                throw new UnsupportedOperationException();
            }

            public void complete(T result) {
                if (!this.tryComplete(result)) {
                    throw new IllegalStateException();
                }
            }

            public void complete() {
                if (!this.tryComplete()) {
                    throw new IllegalStateException();
                }
            }

            public void fail(Throwable cause) {
                if (!this.tryFail(cause)) {
                    throw new IllegalStateException();
                }
            }

            public void fail(String failureMessage) {
                if (!this.tryFail(failureMessage)) {
                    throw new IllegalStateException();
                }
            }

            public boolean tryComplete(T result) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.succeeded = true;
                this.result = result;
                return true;
            }

            public boolean tryComplete() {
                throw new UnsupportedOperationException();
            }

            public boolean tryFail(Throwable cause) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.failed = true;
                this.cause = cause;
                return true;
            }

            public boolean tryFail(String failureMessage) {
                throw new UnsupportedOperationException();
            }

            public T result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                throw new UnsupportedOperationException();
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public void handle(AsyncResult<T> asyncResult) {
                if (asyncResult.succeeded()) {
                    this.complete(asyncResult.result());
                } else {
                    this.fail(asyncResult.cause());
                }
            }
        }
        DefaultCompleterTestFuture<Object> successFuture = new DefaultCompleterTestFuture<Object>();
        successFuture.handle(succeededAsyncResult);
        this.assertTrue(successFuture.succeeded);
        this.assertEquals(succeededAsyncResult.result(), successFuture.result);
        DefaultCompleterTestFuture<Object> failureFuture = new DefaultCompleterTestFuture<Object>();
        failureFuture.handle(failedAsyncResult);
        this.assertTrue(failureFuture.failed);
        this.assertEquals(failedAsyncResult.cause(), failureFuture.cause);
    }

    @Test
    public void testUncompletedAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        this.assertNull(map1.result());
        this.assertNull(map1.cause());
        this.assertNull(map2.result());
        this.assertNull(map2.cause());
    }

    @Test
    public void testSucceededAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        p.complete((Object)"foobar");
        this.assertEquals(6L, ((Integer)map1.result()).intValue());
        this.assertNull(map1.cause());
        this.assertEquals(17L, ((Integer)map2.result()).intValue());
        this.assertNull(map2.cause());
    }

    @Test
    public void testFailedAsyncResultMap() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        Throwable cause = new Throwable();
        p.fail(cause);
        this.assertNull(map1.result());
        this.assertSame(cause, map1.cause());
        this.assertNull(map2.result());
        this.assertSame(cause, map2.cause());
    }

    @Test
    public void testAsyncResultMapEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map = res.mapEmpty();
        p.complete((Object)"foobar");
        this.assertNull(null, map.result());
        this.assertNull(map.cause());
    }

    @Test
    public void testSucceededFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        p.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "yeah");
    }

    @Test
    public void testFailedFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        p.fail("recovered");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "recovered");
    }

    @Test
    public void testFailedMapperFutureRecover() {
        Promise p = Promise.promise();
        Future f = p.future();
        Future r = f.recover(t -> {
            throw new RuntimeException("throw");
        });
        p.fail("recovered");
        this.assertTrue(r.failed());
        this.assertEquals(r.cause().getMessage(), "throw");
    }

    @Test
    public void testUncompletedAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedAsyncResultOtherwise(res);
    }

    @Test
    public void testUncompletedFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testUncompletedAsyncResultOtherwise((AsyncResult<String>)f);
    }

    private void testUncompletedAsyncResultOtherwise(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise((Object)"something-else");
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testUncompletedAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedOtherwiseApplyFunction(res);
    }

    @Test
    public void testUncompletedFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testUncompletedOtherwiseApplyFunction((AsyncResult<String>)f);
    }

    private void testUncompletedOtherwiseApplyFunction(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise(Throwable::getMessage);
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwise(res, (Promise<String>)p);
    }

    @Test
    public void testSucceededFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testSucceededOtherwise((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testSucceededOtherwise(AsyncResult<String> res, Promise<String> p) {
        AsyncResult ar = res.otherwise(Throwable::getMessage);
        p.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwiseApplyFunction(res, (Promise<String>)p);
    }

    @Test
    public void testSucceededFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testSucceededOtherwiseApplyFunction((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testSucceededOtherwiseApplyFunction(AsyncResult<String> res, Promise<String> p) {
        AsyncResult ar = res.otherwise((Object)"whatever");
        p.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwise(res, (Promise<String>)p);
    }

    @Test
    public void testFailedFutureOtherwise() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testFailedOtherwise((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testFailedOtherwise(AsyncResult<String> res, Promise<String> p) {
        AsyncResult map1 = res.otherwise((Object)"something-else");
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("something-else", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwiseApplyFunction(res, (Promise<String>)p);
    }

    @Test
    public void testFailedFutureOtherwiseApplyFunction() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testFailedOtherwiseApplyFunction((AsyncResult<String>)f, (Promise<String>)p);
    }

    private void testFailedOtherwiseApplyFunction(AsyncResult<String> res, Promise<String> p) {
        AsyncResult map1 = res.otherwise(Throwable::getMessage);
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("the-failure", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testOtherwiseWithNullFunction() {
        Promise p = Promise.promise();
        Future fut = p.future();
        try {
            fut.otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(fut).otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAsyncResultOtherwiseEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        AsyncResult res = this.asyncResult(f);
        this.testOtherwiseEmpty(res, (Promise<String>)p);
    }

    @Test
    public void testFutureOtherwiseEmpty() {
        Promise p = Promise.promise();
        Future f = p.future();
        this.testOtherwiseEmpty((AsyncResult<String>)f, (Promise<String>)p);
    }

    @Test
    public void testToString() {
        this.assertEquals("Future{unresolved}", Promise.promise().future().toString());
        this.assertEquals("Future{result=abc}", Future.succeededFuture((Object)"abc").toString());
        this.assertEquals("Future{cause=It's like that, and that's the way it is}", Future.failedFuture((String)"It's like that, and that's the way it is").toString());
        Promise p = Promise.promise();
        Future f = p.future();
        p.complete((Object)"abc");
        this.assertEquals("Future{result=abc}", f.toString());
        p = Promise.promise();
        f = p.future();
        p.fail("abc");
        this.assertEquals("Future{cause=abc}", f.toString());
    }

    @Test
    public void testReleaseHandlerAfterCompletion() throws Exception {
        Promise promise = Promise.promise();
        Future f = promise.future();
        Field handlerField = f.getClass().getDeclaredField("handler");
        handlerField.setAccessible(true);
        f.setHandler(ar -> {});
        promise.complete();
        this.assertNull(handlerField.get(f));
        f.setHandler(ar -> {});
        this.assertNull(handlerField.get(f));
        promise = Promise.promise();
        f = promise.future();
        f.setHandler(ar -> {});
        promise.fail("abc");
        this.assertNull(handlerField.get(f));
        f.setHandler(ar -> {});
        this.assertNull(handlerField.get(f));
    }

    private void testOtherwiseEmpty(AsyncResult<String> res, Promise<String> p) {
        AsyncResult otherwise = res.otherwiseEmpty();
        Throwable cause = new Throwable("the-failure");
        p.fail(cause);
        this.assertTrue(otherwise.succeeded());
        this.assertFalse(otherwise.failed());
        this.assertEquals(null, otherwise.result());
        this.assertNull(otherwise.cause());
    }

    private <T> AsyncResult<T> asyncResult(final Future<T> fut) {
        return new AsyncResult<T>(){

            public T result() {
                return fut.result();
            }

            public Throwable cause() {
                return fut.cause();
            }

            public boolean succeeded() {
                return fut.succeeded();
            }

            public boolean failed() {
                return fut.failed();
            }
        };
    }

    @Test
    public void testSeveralHandlers1() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.setHandler(ar -> this.complete());
        fut.setHandler(ar -> this.complete());
        promise.complete();
        this.await();
    }

    @Test
    public void testSeveralHandlers2() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        promise.complete();
        Future fut = promise.future();
        fut.setHandler(ar -> this.complete());
        fut.setHandler(ar -> this.complete());
        this.await();
    }

    @Test
    public void testSeveralHandlers3() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.setHandler(ar -> this.complete());
        promise.complete();
        fut.setHandler(ar -> this.complete());
        this.await();
    }

    @Test
    public void testSuccessNotification() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        fut.onComplete(this.onSuccess(res -> {
            this.assertEquals("foo", res);
            this.complete();
        }));
        fut.onSuccess(res -> {
            this.assertEquals("foo", res);
            this.complete();
        });
        fut.onFailure(err -> this.fail());
        promise.complete((Object)"foo");
        this.await();
    }

    @Test
    public void testFailureNotification() {
        this.waitFor(2);
        Promise promise = Promise.promise();
        Future fut = promise.future();
        Throwable failure = new Throwable();
        fut.onComplete(this.onFailure(err -> {
            this.assertEquals(failure, err);
            this.complete();
        }));
        fut.onSuccess(res -> this.fail());
        fut.onFailure(err -> {
            this.assertEquals(failure, err);
            this.complete();
        });
        promise.fail(failure);
        this.await();
    }

    class Checker<T> {
        private final Future<T> future;
        private final AtomicReference<AsyncResult<T>> result = new AtomicReference();
        private final AtomicInteger count = new AtomicInteger();

        Checker(Future<T> future) {
            future.setHandler(ar -> {
                this.count.incrementAndGet();
                this.result.set((AsyncResult<T>)ar);
            });
            this.future = future;
        }

        void assertNotCompleted() {
            FutureTest.this.assertFalse(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertNull(this.future.result());
            FutureTest.this.assertEquals(0L, this.count.get());
            FutureTest.this.assertNull(this.result.get());
        }

        void assertSucceeded(T expected) {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertTrue(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertTrue(ar.succeeded());
            FutureTest.this.assertFalse(ar.failed());
            FutureTest.this.assertNull(ar.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
        }

        void assertFailed(Throwable expected) {
            FutureTest.this.assertEquals(expected, this.assertFailed());
        }

        Throwable assertFailed() {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertTrue(this.future.failed());
            FutureTest.this.assertEquals(null, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertFalse(ar.succeeded());
            FutureTest.this.assertTrue(ar.failed());
            FutureTest.this.assertNull(ar.result());
            return this.future.cause();
        }
    }
}

