/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ClusteredEventBusStartFailureTest
extends AsyncTestBase {
    @Test
    public void testCallbackInvokedOnFailure() throws Exception {
        String hostName = "zoom.zoom.zen.tld";
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)new FakeClusterManager());
        options.getEventBusOptions().setHost(hostName);
        AtomicReference resultRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            resultRef.set(ar);
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertFalse(resultRef.get() == null);
        this.assertTrue(((AsyncResult)resultRef.get()).failed());
        this.assertTrue("Was expecting failure to be an instance of UnknownHostException", ((AsyncResult)resultRef.get()).cause() instanceof UnknownHostException);
    }
}

