/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpMetricsTestBase;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.metrics.Measured;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Http2MetricsTest
extends HttpMetricsTestBase {
    private HttpClientOptions clientOptions;
    private HttpServerOptions serverOptions;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Http2TestBase.createHttp2ClientOptions(), Http2TestBase.createHttp2ServerOptions(8080, "localhost")});
        params.add(new Object[]{new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2).setHttp2ClearTextUpgrade(true), new HttpServerOptions().setPort(8080).setHost("localhost")});
        params.add(new Object[]{new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2).setHttp2ClearTextUpgrade(false), new HttpServerOptions().setPort(8080).setHost("localhost")});
        return params;
    }

    public Http2MetricsTest(HttpClientOptions clientOptions, HttpServerOptions serverOptions) {
        super(HttpVersion.HTTP_2);
        this.clientOptions = clientOptions;
        this.serverOptions = serverOptions.setHandle100ContinueAutomatically(true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(this.clientOptions);
        this.server = this.vertx.createHttpServer(this.serverOptions);
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return this.serverOptions;
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return this.clientOptions;
    }

    @Test
    public void testPushPromise() throws Exception {
        this.waitFor(2);
        int numBuffers = 10;
        int contentLength = numBuffers * 1000;
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
            FakeHttpServerMetrics serverMetrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric serverMetric = serverMetrics.getMetric(pushedResp);
            this.assertNotNull(serverMetric);
            pushedResp.putHeader("content-length", "" + contentLength);
            AtomicInteger numBuffer = new AtomicInteger(numBuffers);
            this.vertx.setPeriodic(1L, timerID -> {
                if (numBuffer.getAndDecrement() == 0) {
                    pushedResp.end();
                    this.assertNull(serverMetrics.getMetric(pushedResp));
                    this.vertx.cancelTimer(timerID.longValue());
                    this.complete();
                } else {
                    pushedResp.write(TestUtils.randomBuffer(1000));
                }
            });
        }));
        this.startServer();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath", resp -> {});
        req2.pushHandler(pushedReq -> {
            HttpClientMetric metric = metrics.getMetric((HttpClientRequest)pushedReq);
            this.assertNotNull(metric);
            this.assertSame(pushedReq, metric.request);
            pushedReq.handler(resp -> resp.endHandler(v -> {
                this.assertNull(metrics.getMetric((HttpClientRequest)pushedReq));
                this.complete();
            }));
        });
        req2.end();
        this.await();
    }
}

