/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SelfSignedCertificate;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.CheckingSender;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.netty.TestLoggerFactory;
import io.vertx.test.proxy.HttpProxy;
import io.vertx.test.proxy.Socks4Proxy;
import io.vertx.test.proxy.SocksProxy;
import io.vertx.test.proxy.TestProxyBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NetTest
extends VertxTestBase {
    private static final Logger log = LoggerFactory.getLogger(NetTest.class);
    private SocketAddress testAddress;
    private NetServer server;
    private NetClient client;
    private TestProxyBase proxy;
    private File tmp;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
        } else {
            this.testAddress = SocketAddress.inetSocketAddress((int)1234, (String)"localhost");
        }
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
        this.server = this.vertx.createNetServer();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host1\n127.0.0.1 host2.com\n127.0.0.1 example.com"));
        return options;
    }

    protected void awaitClose(NetServer server) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        server.close(asyncResult -> latch.countDown());
        this.awaitLatch(latch);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.tmp != null) {
            this.tmp.delete();
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.awaitClose(this.server);
        }
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    @Test
    public void testClientOptions() {
        NetClientOptions options = new NetClientOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        String randomAlphaString = TestUtils.randomAlphaString(10);
        this.assertTrue(options.getHostnameVerificationAlgorithm().isEmpty());
        this.assertEquals(options, options.setHostnameVerificationAlgorithm(randomAlphaString));
        this.assertEquals(randomAlphaString, options.getHostnameVerificationAlgorithm());
        this.assertEquals(0L, options.getReconnectAttempts());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectAttempts(-2));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectAttempts(rand));
        this.assertEquals(rand, options.getReconnectAttempts());
        this.assertEquals(1000L, options.getReconnectInterval());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectInterval(0L));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectInterval((long)rand));
        this.assertEquals(rand, options.getReconnectInterval());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.assertEquals(10L, options.getSslHandshakeTimeout());
        long randLong = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setSslHandshakeTimeout(randLong));
        this.assertEquals(randLong, options.getSslHandshakeTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setSslHandshakeTimeout(-123L));
        this.testComplete();
    }

    @Test
    public void testServerOptions() {
        NetServerOptions options = new NetServerOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(-1L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertEquals(0L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.assertFalse(options.isSni());
        this.assertEquals(options, options.setSni(true));
        this.assertTrue(options.isSni());
        this.assertEquals(10L, options.getSslHandshakeTimeout());
        long randLong = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setSslHandshakeTimeout(randLong));
        this.assertEquals(randLong, options.getSslHandshakeTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setSslHandshakeTimeout(-123L));
        this.testComplete();
    }

    @Test
    public void testCopyClientOptions() {
        NetClientOptions options = new NetClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setReconnectAttempts(reconnectAttempts);
        options.setReconnectInterval(reconnectInterval);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        options.setSslHandshakeTimeout(sslHandshakeTimeout);
        NetClientOptions copy = new NetClientOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, copy.getConnectTimeout());
        this.assertEquals(trustAll, copy.isTrustAll());
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(reconnectAttempts, copy.getReconnectAttempts());
        this.assertEquals(reconnectInterval, copy.getReconnectInterval());
        this.assertEquals(useAlpn, copy.isUseAlpn());
        this.assertEquals(sslEngine, copy.getSslEngineOptions());
        this.assertEquals(hostnameVerificationAlgorithm, copy.getHostnameVerificationAlgorithm());
    }

    @Test
    public void testDefaultClientOptionsJson() {
        NetClientOptions def = new NetClientOptions();
        NetClientOptions json = new NetClientOptions(new JsonObject());
        this.assertEquals(def.getReconnectAttempts(), json.getReconnectAttempts());
        this.assertEquals(def.getReconnectInterval(), json.getReconnectInterval());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getHostnameVerificationAlgorithm(), json.getHostnameVerificationAlgorithm());
        this.assertEquals(def.getSslHandshakeTimeout(), json.getSslHandshakeTimeout());
    }

    @Test
    public void testClientOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("connectTimeout", Integer.valueOf(connectTimeout)).put("trustAll", Boolean.valueOf(trustAll)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("reconnectAttempts", Integer.valueOf(reconnectAttempts)).put("reconnectInterval", Long.valueOf(reconnectInterval)).put("useAlpn", Boolean.valueOf(useAlpn)).put(sslEngine, new JsonObject()).put("hostnameVerificationAlgorithm", hostnameVerificationAlgorithm).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled)).put("sslHandshakeTimeout", Long.valueOf(sslHandshakeTimeout));
        NetClientOptions options = new NetClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertEquals(sslHandshakeTimeout, options.getSslHandshakeTimeout());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(reconnectAttempts, options.getReconnectAttempts());
        this.assertEquals(reconnectInterval, options.getReconnectInterval());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(hostnameVerificationAlgorithm, options.getHostnameVerificationAlgorithm());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testCopyServerOptions() {
        NetServerOptions options = new NetServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        boolean sni = TestUtils.randomBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setSni(sni);
        options.setSslHandshakeTimeout(sslHandshakeTimeout);
        NetServerOptions copy = new NetServerOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(port, copy.getPort());
        this.assertEquals(host, copy.getHost());
        this.assertEquals(acceptBacklog, copy.getAcceptBacklog());
        this.assertEquals(useAlpn, copy.isUseAlpn());
        this.assertEquals(sslEngine, copy.getSslEngineOptions());
        this.assertEquals(sni, copy.isSni());
    }

    @Test
    public void testDefaultServerOptionsJson() {
        NetServerOptions def = new NetServerOptions();
        NetServerOptions json = new NetServerOptions(new JsonObject());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.isSni(), json.isSni());
        this.assertEquals(def.getSslHandshakeTimeout(), json.getSslHandshakeTimeout());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        boolean sni = TestUtils.randomBoolean();
        long sslHandshakeTimeout = TestUtils.randomPositiveLong();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("port", Integer.valueOf(port)).put("host", host).put("acceptBacklog", Integer.valueOf(acceptBacklog)).put("useAlpn", Boolean.valueOf(useAlpn)).put(sslEngine, new JsonObject()).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled)).put("sni", Boolean.valueOf(sni)).put("sslHandshakeTimeout", Long.valueOf(sslHandshakeTimeout));
        NetServerOptions options = new NetServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertEquals(sslHandshakeTimeout, options.getSslHandshakeTimeout());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(sni, options.isSni());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testSocketAddress() throws Exception {
        TestUtils.assertNullPointerException(() -> new SocketAddressImpl(0, null));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(0, ""));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(-1, "someHost"));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(65536, "someHost"));
    }

    @Test
    public void testWriteHandlerSuccess() throws Exception {
        CompletableFuture close = new CompletableFuture();
        this.server.connectHandler(socket -> {
            socket.pause();
            close.thenAccept(v -> socket.resume());
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.writeUntilFull((NetSocket)so, (Handler<Void>)((Handler)v -> {
            so.write(Buffer.buffer((String)"lost buffer"), this.onSuccess(ack -> this.testComplete()));
            close.complete(null);
        }))));
        this.await();
    }

    @Test
    public void testWriteHandlerFailure() throws Exception {
        CompletableFuture close = new CompletableFuture();
        this.server.connectHandler(socket -> {
            socket.pause();
            close.thenAccept(v -> socket.close());
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.writeUntilFull((NetSocket)so, (Handler<Void>)((Handler)v -> {
            so.write(Buffer.buffer((String)"lost buffer"), this.onFailure(err -> this.testComplete()));
            close.complete(null);
        }))));
        this.await();
    }

    private void writeUntilFull(NetSocket so, Handler<Void> handler) {
        if (so.writeQueueFull()) {
            handler.handle(null);
        } else {
            so.write(TestUtils.randomBuffer(16384));
            this.vertx.setTimer(10L, id -> this.writeUntilFull(so, handler));
        }
    }

    @Test
    public void testEchoBytes() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testEcho(sock -> sock.write(sent), buff -> this.assertEquals(sent, buff), sent.length());
    }

    @Test
    public void testEchoString() {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent);
        this.testEcho(sock -> sock.write(sent), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    @Test
    public void testEchoStringUTF8() {
        this.testEchoStringWithEncoding("UTF-8");
    }

    @Test
    public void testEchoStringUTF16() {
        this.testEchoStringWithEncoding("UTF-16");
    }

    void testEchoStringWithEncoding(String encoding) {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent, (String)encoding);
        this.testEcho(sock -> sock.write(sent, encoding), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    void testEcho(Consumer<NetSocket> writer, Consumer<Buffer> dataChecker, int length) {
        Handler clientHandler = asyncResult -> {
            if (asyncResult.succeeded()) {
                NetSocket sock = (NetSocket)asyncResult.result();
                Buffer buff = Buffer.buffer();
                sock.handler(buffer -> {
                    buff.appendBuffer(buffer);
                    if (buff.length() == length) {
                        dataChecker.accept(buff);
                        this.testComplete();
                    }
                    if (buff.length() > length) {
                        this.fail("Too many bytes received");
                    }
                });
                writer.accept(sock);
            } else {
                this.fail("failed to connect");
            }
        };
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, clientHandler)));
        this.await();
    }

    void startEchoServer(SocketAddress address, Handler<AsyncResult<NetServer>> listenHandler) {
        Handler serverHandler = socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0));
        this.server.connectHandler(serverHandler).listen(address, listenHandler);
    }

    @Test
    public void testConnectLocalHost() {
        this.connect(this.testAddress);
    }

    void connect(SocketAddress address) {
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> {
            int numConnections = 100;
            AtomicInteger connCount = new AtomicInteger(0);
            for (int i = 0; i < 100; ++i) {
                Handler handler = res -> {
                    if (res.succeeded()) {
                        ((NetSocket)res.result()).close();
                        if (connCount.incrementAndGet() == 100) {
                            this.testComplete();
                        }
                    }
                };
                this.client.connect(address, handler);
            }
        }));
        this.await();
    }

    @Test
    public void testConnectInvalidPort() {
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(-1, "localhost", res -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(65536, "localhost", res -> {}));
        this.client.connect(9998, "localhost", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, null, res -> {}));
        this.client.connect(1234, "127.0.0.2", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidConnectHandler() throws Exception {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, "localhost", null));
    }

    @Test
    public void testListenInvalidPort() {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(80));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertTrue(ar.failed());
            this.assertFalse(ar.succeeded());
            this.assertNotNull(ar.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("uhqwduhqwudhqwuidhqwiudhqwudqwiuhd"));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertTrue(ar.failed());
            this.assertFalse(ar.succeeded());
            this.assertNotNull(ar.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenOnWildcardPort() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(0));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertFalse(ar.failed());
            this.assertTrue(ar.succeeded());
            this.assertNull(ar.cause());
            this.assertTrue(this.server.actualPort() > 1024);
            this.assertEquals(this.server, ar.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromClient() {
        this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.clientCloseHandlers(true)));
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromServer() {
        this.server.connectHandler(NetSocket::close).listen(this.testAddress, s -> this.clientCloseHandlers(false));
        this.await();
    }

    void clientCloseHandlers(boolean closeFromClient) {
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            AtomicInteger counter = new AtomicInteger(0);
            so.endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            so.closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromClient) {
                so.close();
            }
        }));
    }

    @Test
    public void testServerCloseHandlersCloseFromClient() {
        this.serverCloseHandlers(false, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, ar -> ((NetSocket)ar.result()).close())));
        this.await();
    }

    @Test
    public void testServerCloseHandlersCloseFromServer() {
        this.serverCloseHandlers(true, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, ar -> {})));
        this.await();
    }

    void serverCloseHandlers(boolean closeFromServer, Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            AtomicInteger counter = new AtomicInteger(0);
            sock.endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            sock.closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromServer) {
                sock.close();
            }
        }).listen(this.testAddress, listenHandler);
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, this.onSuccess(sock -> {
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write(buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.testComplete();
                    });
                    this.vertx.eventBus().send("server_resume", (Object)"");
                }
            });
        }))));
        this.await();
    }

    void pausingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            sock.pause();
            Handler resumeHandler = m -> sock.resume();
            MessageConsumer reg = this.vertx.eventBus().consumer("server_resume").handler(resumeHandler);
            sock.closeHandler(v -> reg.unregister());
        }).listen(this.testAddress, listenHandler);
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(this.testAddress, this.onSuccess(sock -> {
            sock.pause();
            this.setHandlers((NetSocket)sock);
            sock.handler(buf -> {});
        }))));
        this.await();
    }

    void setHandlers(NetSocket sock) {
        Handler resumeHandler = m -> sock.resume();
        MessageConsumer reg = this.vertx.eventBus().consumer("client_resume").handler(resumeHandler);
        sock.closeHandler(v -> reg.unregister());
    }

    void drainingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write(buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.vertx.setTimer(100L, id2 -> this.testComplete());
                    });
                    this.vertx.eventBus().send("client_resume", (Object)"");
                }
            });
        }).listen(this.testAddress, listenHandler);
    }

    @Test
    public void testReconnectAttemptsInfinite() {
        this.reconnectAttempts(-1);
    }

    @Test
    public void testReconnectAttemptsMany() {
        this.reconnectAttempts(100000);
    }

    private void reconnectAttempts(int attempts) {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(attempts).setReconnectInterval(10L));
        this.client.connect(this.testAddress, this.onSuccess(so -> this.testComplete()));
        this.vertx.setTimer(2000L, id -> this.startEchoServer(this.testAddress, (Handler<AsyncResult<NetServer>>)((Handler)s -> {})));
        this.await();
    }

    @Test
    public void testReconnectAttemptsNotEnough() {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(100).setReconnectInterval(10L));
        this.client.connect(this.testAddress, res -> {
            this.assertFalse(res.succeeded());
            this.assertTrue(res.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testServerIdleTimeout() {
        this.server.close();
        NetServerOptions netServerOptions = new NetServerOptions();
        netServerOptions.setIdleTimeout(1000);
        netServerOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server = this.vertx.createNetServer(netServerOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                socket.closeHandler(v -> this.testComplete());
            });
        });
        this.await();
    }

    @Test
    public void testClientIdleTimeout() {
        this.client.close();
        NetClientOptions netClientOptions = new NetClientOptions();
        netClientOptions.setIdleTimeout(1000);
        netClientOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        this.client = this.vertx.createNetClient(netClientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                socket.closeHandler(v -> this.testComplete());
            });
        });
        this.await();
    }

    @Test
    public void testStartTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, true);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, false, false, true, false);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, false, false);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, false, false, true, false);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, true, false);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, true, false, false, false);
    }

    @Test
    public void testStartTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, true);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false, ENABLED_CIPHER_SUITES);
    }

    @Test
    public void testInvalidTlsProtocolVersion() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, false, false, new String[0], new String[]{"TLSv1.999"});
    }

    @Test
    public void testSpecificTlsProtocolVersion() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, true, true, false, new String[0], new String[]{"TLSv1.2"});
    }

    @Test
    public void testTLSTrailingDotHost() throws Exception {
        SelfSignedCertificate cert = SelfSignedCertificate.create((String)"host2.com");
        TLSTest test = new TLSTest().clientTrust(() -> ((SelfSignedCertificate)cert).trustOptions()).connectAddress(SocketAddress.inetSocketAddress((int)4043, (String)"host2.com.")).bindAddress(SocketAddress.inetSocketAddress((int)4043, (String)"host2.com")).serverCert(() -> ((SelfSignedCertificate)cert).keyCertOptions());
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertNull(test.indicatedServerName);
    }

    @Test
    public void testSniWithoutServerNameUsesTheFirstKeyStoreEntry1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithoutServerNameUsesTheFirstKeyStoreEntry2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).serverCert(Cert.SNI_JKS).sni(true);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniImplicitServerName() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).address(SocketAddress.inetSocketAddress((int)4043, (String)"host2.com")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("host2.com", test.indicatedServerName);
    }

    @Test
    public void testSniImplicitServerNameDisabledForShortname1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).address(SocketAddress.inetSocketAddress((int)4043, (String)"host1")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniImplicitServerNameDisabledForShortname2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).address(SocketAddress.inetSocketAddress((int)4043, (String)"host1")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniForceShortname() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).address(SocketAddress.inetSocketAddress((int)4043, (String)"host1")).serverName("host1").serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host1", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniOverrideServerName() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).address(SocketAddress.inetSocketAddress((int)4043, (String)"example.com")).serverName("host2.com").serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithUnknownServer1() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SERVER_JKS).serverCert(Cert.SNI_JKS).sni(true).serverName("unknown");
        test.run(true);
        this.await();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithUnknownServer2() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).serverCert(Cert.SNI_JKS).sni(true).serverName("unknown");
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithServerNameStartTLS() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST1).startTLS(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host1");
        test.run(true);
        this.await();
        this.assertEquals("host1", TestUtils.cnOf(test.clientPeerCert()));
    }

    @Test
    public void testSniWithServerNameTrust() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_AND_OTHER_CA_1);
        test.run(true);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFallback() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_FALLBACK);
        test.run(true);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFallbackFail() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_OTHER_CA_FALLBACK);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithServerNameTrustFail() {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).clientCert(Cert.CLIENT_PEM_ROOT_CA).requireClientAuth(true).serverCert(Cert.SNI_JKS).sni(true).serverName("host2.com").serverTrust(Trust.SNI_SERVER_ROOT_CA_AND_OTHER_CA_2);
        test.run(false);
        this.await();
    }

    @Test
    public void testSniWithTrailingDotHost() throws Exception {
        TLSTest test = new TLSTest().clientTrust(Trust.SNI_JKS_HOST2).connectAddress(SocketAddress.inetSocketAddress((int)4043, (String)"host2.com.")).bindAddress(SocketAddress.inetSocketAddress((int)4043, (String)"host2.com")).serverCert(Cert.SNI_JKS).sni(true);
        test.run(true);
        this.await();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("host2.com", test.indicatedServerName);
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, new String[0], new String[0]);
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, enabledCipherSuites, new String[0]);
    }

    void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites, String[] enabledSecureTransportProtocols) throws Exception {
        TLSTest test = new TLSTest().clientCert(clientCert).clientTrust(clientTrust).serverCert(serverCert).serverTrust(serverTrust).requireClientAuth(requireClientAuth).clientTrustAll(clientTrustAll).startTLS(startTLS).enabledCipherSuites(enabledCipherSuites).enabledSecureTransportProtocols(enabledSecureTransportProtocols);
        test.run(shouldPass);
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        boolean domainSocket = this.testAddress.path() != null;
        int numServers = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE / 2 - 1;
        int numConnections = numServers * (domainSocket ? 10 : 20);
        ArrayList<NetServer> servers = new ArrayList<NetServer>();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            NetServer theServer = this.vertx.createNetServer();
            servers.add(theServer);
            theServer.connectHandler(sock -> {
                connectCount.compute(theServer, (s, cur) -> cur == null ? 1 : cur + 1);
                latchConns.countDown();
            }).listen(this.testAddress, ar -> {
                if (ar.succeeded()) {
                    latchListen.countDown();
                } else {
                    this.fail("Failed to bind server");
                }
            });
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions());
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(this.testAddress, res -> {
                if (res.succeeded()) {
                    latchClient.countDown();
                } else {
                    res.cause().printStackTrace();
                    this.fail("Failed to connect");
                }
            });
        }
        this.awaitLatch(latchClient);
        this.awaitLatch(latchConns);
        this.assertEquals(numServers, connectCount.size());
        for (NetServer server : servers) {
            this.assertTrue(connectCount.containsKey(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> iterator = connectCount.values().iterator();
        while (iterator.hasNext()) {
            int cnt = (Integer)iterator.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(4321));
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(ar2 -> {
            if (ar2.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        this.server.close();
        CountDownLatch latch = new CountDownLatch(1);
        this.server = this.vertx.createNetServer();
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(this.testAddress, ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.server.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testClosingVertxCloseSharedServers() throws Exception {
        int numServers = 2;
        Vertx vertx = Vertx.vertx((VertxOptions)this.getOptions());
        ArrayList<NetServerImpl> servers = new ArrayList<NetServerImpl>();
        for (int i = 0; i < numServers; ++i) {
            NetServer server2 = vertx.createNetServer().connectHandler(so -> this.fail());
            this.startServer(server2);
            servers.add((NetServerImpl)server2);
        }
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        servers.forEach(server -> this.assertTrue(server.isClosed()));
    }

    @Test
    public void testFanout() throws Exception {
        int numConnections = 10;
        ConcurrentHashSet connections = new ConcurrentHashSet();
        this.server.connectHandler(arg_0 -> this.lambda$testFanout$117((Set)connections, numConnections, arg_0));
        this.startServer();
        CountDownLatch receivedLatch = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(data -> receivedLatch.countDown())));
        }
        this.assertTrue(receivedLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testRemoteAddress() {
        this.server.connectHandler(socket -> {
            SocketAddress addr = socket.remoteAddress();
            this.assertEquals("127.0.0.1", addr.host());
            socket.close();
        }).listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.createNetClient(new NetClientOptions()).connect(1234, "localhost", this.onSuccess(socket -> {
                SocketAddress addr = socket.remoteAddress();
                this.assertEquals("127.0.0.1", addr.host());
                this.assertEquals(addr.port(), 1234L);
                socket.closeHandler(v -> this.testComplete());
            }));
        });
        this.await();
    }

    @Test
    public void testWriteSameBufferMoreThanOnce() throws Exception {
        this.server.connectHandler(socket -> {
            Buffer received = Buffer.buffer();
            socket.handler(buff -> {
                received.appendBuffer(buff);
                if (received.toString().equals("foofoo")) {
                    this.testComplete();
                }
            });
        }).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, result -> {
                NetSocket socket = (NetSocket)result.result();
                Buffer buff = Buffer.buffer((String)"foo");
                socket.write(buff);
                socket.write(buff);
            });
        });
        this.await();
    }

    @Test
    public void sendFileClientToServer() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> {
            sock.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == expected.length()) {
                    this.assertEquals(expected, received);
                    this.testComplete();
                }
            });
            sock.write("foo");
        });
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buf -> sock.sendFile(file.getAbsolutePath()));
            });
        });
        this.await();
    }

    @Test
    public void sendFileServerToClient() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> sock.handler(buf -> sock.sendFile(file.getAbsolutePath())));
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == expected.length()) {
                        this.assertEquals(expected, received);
                        this.testComplete();
                    }
                });
                sock.write("foo");
            });
        });
        this.await();
    }

    @Test
    public void testSendFileDirectory() throws Exception {
        File fDir = this.testFolder.newFolder();
        this.server.connectHandler(socket -> socket.handler(buff -> this.fail("Should not receive any data"))).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, result -> {
                this.assertTrue(result.succeeded());
                NetSocket socket = (NetSocket)result.result();
                try {
                    socket.sendFile(fDir.getAbsolutePath().toString());
                    this.fail("Should throw exception");
                }
                catch (IllegalArgumentException e) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234);
        this.server = this.vertx.createNetServer(options);
        options.setPort(1235);
        this.server.connectHandler(sock -> this.testComplete());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        NetClientOptions options = new NetClientOptions();
        this.client = this.vertx.createNetClient(options);
        options.setSsl(true);
        this.server.connectHandler(sock -> this.testComplete());
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testListenWithNoHandler() {
        try {
            this.server.listen(this.testAddress);
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testListenWithNoHandler2() {
        try {
            this.server.listen(this.testAddress, ar -> this.assertFalse(ar.succeeded()));
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSetHandlerAfterListen() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, this.onSuccess(v -> this.testComplete()));
        try {
            this.server.connectHandler(sock -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.await();
    }

    @Test
    public void testSetHandlerAfterListen2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.connectHandler(sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenTwice() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, this.onSuccess(s -> {
            try {
                this.server.listen(this.testAddress, res -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException e) {
                this.testComplete();
            }
            catch (Exception e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testListenOnPortNoHandler() {
        this.server.connectHandler(NetSocket::close);
        this.server.listen(1234, this.onSuccess(ns -> this.client.connect(1234, "localhost", this.onSuccess(so -> so.closeHandler(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testListen() {
        this.server.connectHandler(NetSocket::close);
        this.server.listen(this.testAddress, this.onSuccess(ns -> this.client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testListenTwice2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.listen(this.testAddress, sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseTwice() {
        this.client.close();
        this.client.close();
    }

    @Test
    public void testAttemptConnectAfterClose() {
        this.client.close();
        try {
            this.client.connect(this.testAddress, ar -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseWithHandler() {
        this.waitFor(2);
        this.server.connectHandler(so -> so.closeHandler(v -> this.complete())).listen(this.testAddress, this.onSuccess(s -> this.client.connect(this.testAddress, this.onSuccess(so -> so.close(this.onSuccess(v -> this.complete()))))));
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.connectHandler(socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0))).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            for (int i = 0; i < numThreads; ++i) {
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        NetTest.this.client.connect(NetTest.this.testAddress, result -> {
                            NetTest.this.assertTrue(result.succeeded());
                            Buffer buff = TestUtils.randomBuffer(100000);
                            NetSocket sock = (NetSocket)result.result();
                            sock.write(buff);
                            Buffer received = Buffer.buffer();
                            sock.handler(rec -> {
                                received.appendBuffer(rec);
                                if (received.length() == buff.length()) {
                                    NetTest.this.assertEquals(buff, received);
                                    latch.countDown();
                                }
                            });
                        });
                    }
                };
                threads[i].start();
            }
        });
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) throws Exception {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = this.context;
                if (worker) {
                    NetTest.this.assertTrue(this.ctx.isWorkerContext());
                } else {
                    NetTest.this.assertTrue(this.ctx.isEventLoopContext());
                }
                Thread thr = Thread.currentThread();
                NetTest.this.server = this.vertx.createNetServer();
                NetTest.this.server.connectHandler(sock -> {
                    sock.handler(buff -> sock.write(buff));
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                NetTest.this.server.listen(NetTest.this.testAddress, ar -> {
                    NetTest.this.assertTrue(ar.succeeded());
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                    NetTest.this.client = this.vertx.createNetClient(new NetClientOptions());
                    NetTest.this.client.connect(NetTest.this.testAddress, ar2 -> {
                        NetTest.this.assertSame(this.ctx, this.context);
                        if (!worker) {
                            NetTest.this.assertSame(thr, Thread.currentThread());
                        }
                        NetTest.this.assertTrue(ar2.succeeded());
                        NetSocket sock = (NetSocket)ar2.result();
                        Buffer buff = TestUtils.randomBuffer(10000);
                        sock.write(buff);
                        Buffer brec = Buffer.buffer();
                        sock.handler(rec -> {
                            NetTest.this.assertSame(this.ctx, this.context);
                            if (!worker) {
                                NetTest.this.assertSame(thr, Thread.currentThread());
                            }
                            brec.appendBuffer(rec);
                            if (brec.length() == buff.length()) {
                                NetTest.this.testComplete();
                            }
                        });
                    });
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                try {
                    NetTest.this.server = this.vertx.createNetServer(new NetServerOptions());
                    NetTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    NetTest.this.client = this.vertx.createNetClient(new NetClientOptions());
                    NetTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                NetTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testContexts() throws Exception {
        int numConnections = 10;
        CountDownLatch serverLatch = new CountDownLatch(numConnections);
        AtomicReference serverConnectContext = new AtomicReference();
        this.server.connectHandler(sock -> {
            Context serverContext = Vertx.currentContext();
            if (serverConnectContext.get() != null) {
                this.assertSame(serverConnectContext.get(), serverContext);
            } else {
                serverConnectContext.set(serverContext);
            }
            serverLatch.countDown();
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        AtomicReference listenContext = new AtomicReference();
        this.server.listen(this.testAddress, this.onSuccess(v -> {
            listenContext.set(Vertx.currentContext());
            listenLatch.countDown();
        }));
        this.awaitLatch(listenLatch);
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        AtomicInteger connectCount = new AtomicInteger();
        CountDownLatch clientLatch = new CountDownLatch(1);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(this.testAddress, arg_0 -> this.lambda$testContexts$177((Set)contexts, connectCount, numConnections, clientLatch, arg_0));
        }
        this.awaitLatch(clientLatch);
        this.awaitLatch(serverLatch);
        this.server.close(arg_0 -> this.lambda$testContexts$178((Set)contexts, serverConnectContext, listenContext, arg_0));
        this.await();
    }

    @Test
    public void testReadStreamPauseResume() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setAcceptBacklog(1));
        ReadStream socketStream = this.server.connectStream();
        AtomicBoolean paused = new AtomicBoolean();
        socketStream.handler(so -> {
            this.assertTrue(!paused.get());
            so.write("hello");
            so.close();
        });
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            paused.set(true);
            socketStream.pause();
            this.client.connect(this.testAddress, ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket so2 = (NetSocket)ar2.result();
                so2.handler(buffer -> this.fail());
                so2.closeHandler(v -> {
                    paused.set(false);
                    socketStream.resume();
                    this.client.connect(this.testAddress, ar3 -> {
                        this.assertTrue(ar3.succeeded());
                        NetSocket so3 = (NetSocket)ar3.result();
                        Buffer buffer = Buffer.buffer();
                        so3.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                        so3.closeHandler(v3 -> {
                            this.assertEquals("hello", buffer.toString("utf-8"));
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testNetSocketStreamCallbackIsAsync() {
        this.server = this.vertx.createNetServer(new NetServerOptions());
        AtomicInteger done = new AtomicInteger();
        ReadStream stream = this.server.connectStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(this.testAddress, ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            ThreadLocal<Boolean> stack2 = new ThreadLocal<Boolean>();
            stack2.set(true);
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                this.assertNull(stack2.get());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            stack2.set(null);
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createNetServer();
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.connectStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testInWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                NetTest.this.assertTrue(Context.isOnWorkerThread());
                Context context = Vertx.currentContext();
                NetServer server1 = this.vertx.createNetServer();
                server1.connectHandler(conn -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    conn.handler(arg_0 -> ((NetSocket)conn).write(arg_0));
                    conn.closeHandler(v -> NetTest.this.testComplete());
                }).listen(NetTest.this.testAddress, NetTest.this.onSuccess(s -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    NetClient client = this.vertx.createNetClient();
                    client.connect(NetTest.this.testAddress, NetTest.this.onSuccess(res -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        res.write("foo");
                        res.handler(buff -> {
                            NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                            NetTest.this.assertTrue(Context.isOnWorkerThread());
                            NetTest.this.assertSame(context, Vertx.currentContext());
                            res.close();
                        });
                    }));
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncWriteIsFlushed() throws Exception {
        int num = 128;
        Buffer expected = TestUtils.randomBuffer(1024);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        try {
            this.server.connectHandler(so -> so.handler(buff -> {
                this.assertEquals(256L, buff.length());
                CountDownLatch latch = new CountDownLatch(1);
                exec.execute(() -> {
                    latch.countDown();
                    so.write(expected);
                });
                try {
                    this.awaitLatch(latch);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                }
            }));
            this.startServer();
            AtomicInteger done = new AtomicInteger();
            for (int i = 0; i < num; ++i) {
                this.client.connect(this.testAddress, ar -> {
                    if (ar.succeeded()) {
                        NetSocket so = (NetSocket)ar.result();
                        so.handler(buff -> {
                            this.assertEquals(expected, buff);
                            so.close();
                            int val = done.incrementAndGet();
                            if (val == num) {
                                this.testComplete();
                            }
                        });
                        so.write(TestUtils.randomBuffer(256));
                    } else {
                        ar.cause().printStackTrace();
                    }
                });
            }
            this.await();
        }
        finally {
            exec.shutdown();
        }
    }

    private File setupFile(String testDir, String fileName, String content) throws Exception {
        File file = new File(testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    @Test
    public void testServerWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(workers.size() - 1);
        workers.get(0).runOnContext(v -> {
            NetServer server = this.vertx.createNetServer();
            server.connectHandler(so -> so.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            }));
            server.listen(this.testAddress, ar -> {
                this.assertTrue(ar.succeeded());
                for (int i = 1; i < workers.size(); ++i) {
                    ((Context)workers.get(i)).runOnContext(v2 -> {
                        latch1.countDown();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                }
            });
        });
        this.awaitLatch(latch1);
        NetClient client = this.vertx.createNetClient();
        client.connect(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            NetSocket so = (NetSocket)ar.result();
            so.write(Buffer.buffer((String)"hello"));
        });
        this.await();
    }

    @Test
    public void testClientWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(size);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {
            try {
                this.awaitLatch(latch2);
            }
            catch (InterruptedException e) {
                this.fail(e.getMessage());
                return;
            }
            so.write(Buffer.buffer((String)"hello"));
        });
        server.listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        workers.get(0).runOnContext(v -> {
            NetClient client = this.vertx.createNetClient();
            client.connect(this.testAddress, ar -> {
                this.assertTrue(ar.succeeded());
                NetSocket so = (NetSocket)ar.result();
                so.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.testComplete();
                });
            });
            for (int i = 1; i < workers.size(); ++i) {
                ((Context)workers.get(i)).runOnContext(v2 -> {
                    latch2.countDown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsNotMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/mim-server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.failed());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    private TestLoggerFactory testLogging() throws Exception {
        return TestUtils.testLogging(() -> {
            this.server.connectHandler(so -> so.write("fizzbuzz").end());
            this.server.listen(this.testAddress, this.onSuccess(v1 -> this.client.connect(this.testAddress, this.onSuccess(so -> so.closeHandler(v2 -> this.testComplete())))));
            this.await();
        });
    }

    @Test
    public void testWithSocks5Proxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy(null);
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks5ProxyAuth() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080).setUsername("username").setPassword("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new SocksProxy("username");
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testConnectSSLWithSocks5Proxy() throws Exception {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get());
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("127.0.0.1").setPort(11080)).setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new SocksProxy(null);
        this.proxy.start(this.vertx);
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testUpgradeSSLWithSocks5Proxy() throws Exception {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get());
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("127.0.0.1").setPort(11080)).setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new SocksProxy(null);
        this.proxy.start(this.vertx);
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket ns = (NetSocket)ar2.result();
                ns.exceptionHandler(th -> this.fail((Throwable)th));
                ns.upgradeToSsl(v2 -> this.testComplete());
            });
        });
        this.await();
    }

    @Test
    public void testWithHttpConnectProxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setPort(13128));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new HttpProxy(null);
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4aProxy() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy(null);
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4aProxyAuth() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080).setUsername("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy("username");
        this.proxy.start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWithSocks4LocalResolver() throws Exception {
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy(null).start(this.vertx);
        this.server.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "127.0.0.1", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("127.0.0.1:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testTLSHostnameCertCheckCorrect() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPort(4043).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()));
        this.server.connectHandler(netSocket -> netSocket.close()).listen(ar -> {
            NetClientOptions options = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
            NetClient client = this.vertx.createNetClient(options);
            client.connect(4043, "localhost", arSocket -> {
                if (arSocket.succeeded()) {
                    NetSocket ns = (NetSocket)arSocket.result();
                    ns.exceptionHandler(th -> this.fail((Throwable)th));
                    ns.upgradeToSsl(v -> this.testComplete());
                } else {
                    this.fail(ar.cause());
                }
            });
        });
        this.await();
    }

    @Test
    public void testTLSHostnameCertCheckIncorrect() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPort(4043).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS_ROOT_CA.get()));
        this.server.connectHandler(netSocket -> netSocket.close()).listen(ar -> {
            NetClientOptions options = new NetClientOptions().setHostnameVerificationAlgorithm("HTTPS").setTrustOptions((TrustOptions)Trust.SERVER_JKS_ROOT_CA.get());
            NetClient client = this.vertx.createNetClient(options);
            client.connect(4043, "127.0.0.1", arSocket -> {
                if (arSocket.succeeded()) {
                    NetSocket ns = (NetSocket)arSocket.result();
                    ns.closeHandler(v -> this.testComplete());
                    ns.upgradeToSsl(v -> this.fail("this test should fail"));
                } else {
                    this.fail(ar.cause());
                }
            });
        });
        this.await();
    }

    @Test
    public void testClientLocalAddress() {
        String expectedAddress = TestUtils.loopbackAddress();
        NetClientOptions clientOptions = new NetClientOptions().setLocalAddress(expectedAddress);
        this.client.close();
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(sock -> {
            this.assertEquals(expectedAddress, sock.remoteAddress().host());
            sock.close();
        });
        this.server.listen(1234, "localhost", this.onSuccess(v -> this.client.connect(1234, "localhost", this.onSuccess(socket -> socket.closeHandler(v2 -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testSelfSignedCertificate() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        SelfSignedCertificate certificate = SelfSignedCertificate.create();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)certificate.keyCertOptions()).setTrustOptions((TrustOptions)certificate.trustOptions());
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)certificate.keyCertOptions()).setTrustOptions((TrustOptions)certificate.trustOptions());
        NetClientOptions clientTrustAllOptions = new NetClientOptions().setSsl(true).setTrustAll(true);
        this.server = this.vertx.createNetServer(serverOptions).connectHandler(socket -> socket.write("123").end()).listen(this.testAddress, this.onSuccess(s -> {
            this.client = this.vertx.createNetClient(clientOptions);
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(buffer -> {
                this.assertEquals("123", buffer.toString());
                latch.countDown();
            })));
            this.client = this.vertx.createNetClient(clientTrustAllOptions);
            this.client.connect(this.testAddress, this.onSuccess(socket -> socket.handler(buffer -> {
                this.assertEquals("123", buffer.toString());
                latch.countDown();
            })));
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testWorkerClient() throws Exception {
        final String expected = TestUtils.randomAlphaString(2000);
        this.server.connectHandler(so -> so.write(expected).close());
        this.startServer();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                NetClient client = this.vertx.createNetClient();
                client.connect(NetTest.this.testAddress, NetTest.this.onSuccess(so -> {
                    Buffer received = Buffer.buffer();
                    so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
                    so.closeHandler(v -> {
                        NetTest.this.assertEquals(expected, received.toString());
                        NetTest.this.testComplete();
                    });
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testWorkerServer() throws Exception {
        final String expected = TestUtils.randomAlphaString(2000);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startFuture) throws Exception {
                NetServer server = this.vertx.createNetServer();
                server.connectHandler(so -> {
                    Buffer received = Buffer.buffer();
                    so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
                    so.closeHandler(v -> {
                        NetTest.this.assertEquals(expected, received.toString());
                        NetTest.this.testComplete();
                    });
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                server.listen(NetTest.this.testAddress, ar -> startFuture.handle(ar.mapEmpty()));
            }
        }, new DeploymentOptions().setWorker(true), this.onSuccess(v -> this.client.connect(this.testAddress, this.onSuccess(so -> so.write(expected).close()))));
        this.await();
    }

    @Test
    public void testNetServerInternal() throws Exception {
        this.testNetServerInternal_(new HttpClientOptions(), false);
    }

    @Test
    public void testNetServerInternalTLS() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()));
        this.testNetServerInternal_(new HttpClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()), true);
    }

    private void testNetServerInternal_(HttpClientOptions clientOptions, boolean expectSSL) throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            NetSocketInternal internal = (NetSocketInternal)so;
            this.assertEquals(expectSSL, internal.isSsl());
            ChannelHandlerContext chctx = internal.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpServerCodec());
            internal.handler(buff -> this.fail());
            internal.messageHandler(obj -> {
                if (obj instanceof LastHttpContent) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)StandardCharsets.UTF_8));
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"11");
                    internal.writeMessage((Object)response, this.onSuccess(v -> this.complete()));
                }
            });
        });
        this.startServer(SocketAddress.inetSocketAddress((int)1234, (String)"localhost"));
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        client.getNow(1234, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.bodyHandler(buff -> {
                this.assertEquals("Hello World", buff.toString());
                this.complete();
            });
        });
        this.await();
    }

    @Test
    public void testNetClientInternal() throws Exception {
        this.testNetClientInternal_(new HttpServerOptions().setHost("localhost").setPort(1234), false);
    }

    @Test
    public void testNetClientInternalTLS() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
        this.testNetClientInternal_(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true);
    }

    private void testNetClientInternal_(HttpServerOptions options, boolean expectSSL) throws Exception {
        this.waitFor(2);
        HttpServer server = this.vertx.createHttpServer(options);
        server.requestHandler(req -> req.response().end("Hello World"));
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.connect(1234, "localhost", this.onSuccess(so -> {
            NetSocketInternal soInt = (NetSocketInternal)so;
            this.assertEquals(expectSSL, soInt.isSsl());
            ChannelHandlerContext chctx = soInt.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpClientCodec());
            AtomicInteger status = new AtomicInteger();
            soInt.handler(buff -> this.fail());
            soInt.messageHandler(obj -> {
                switch (status.getAndIncrement()) {
                    case 0: {
                        this.assertTrue(obj instanceof HttpResponse);
                        HttpResponse resp = (HttpResponse)obj;
                        this.assertEquals(200L, resp.status().code());
                        break;
                    }
                    case 1: {
                        this.assertTrue(obj instanceof LastHttpContent);
                        ByteBuf content = ((LastHttpContent)obj).content();
                        this.assertEquals(!expectSSL, content.isDirect());
                        this.assertEquals(1L, content.refCnt());
                        String val = content.toString(StandardCharsets.UTF_8);
                        this.assertTrue(content.release());
                        this.assertEquals("Hello World", val);
                        this.complete();
                        break;
                    }
                    default: {
                        this.fail();
                    }
                }
            });
            soInt.writeMessage((Object)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/somepath"), this.onSuccess(v -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testNetSocketInternalBuffer() throws Exception {
        this.server.connectHandler(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.messageHandler(msg -> this.fail("Unexpected"));
            soi.handler(msg -> {
                ByteBuf byteBuf = msg.getByteBuf();
                this.assertFalse(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertFalse(byteBuf.release());
                this.assertEquals(1L, byteBuf.refCnt());
                soi.write(msg);
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.write(Buffer.buffer((String)"Hello World"));
            soi.messageHandler(msg -> this.fail("Unexpected"));
            soi.handler(msg -> {
                ByteBuf byteBuf = msg.getByteBuf();
                this.assertFalse(byteBuf.isDirect());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertFalse(byteBuf.release());
                this.assertEquals(1L, byteBuf.refCnt());
                this.assertEquals("Hello World", msg.toString());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testCloseCompletionHandlerNotCalledWhenActualServerFailed() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setSsl(true).setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath("invalid"))).connectHandler(c -> {});
        try {
            this.server.listen(10000, r -> this.fail());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.close(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testServerNetSocketShouldBeClosedWhenTheClosedHandlerIsCalled() throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), 2, (WriteStream<Buffer>)so);
            sender.send();
            so.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.complete();
                }
            });
            so.endHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.complete();
                }
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, this.onSuccess(so -> this.vertx.setTimer(1000L, id -> so.close())));
        this.await();
    }

    @Test
    public void testServerWithIdleTimeoutSendChunkedFile() throws Exception {
        this.testIdleTimeoutSendChunkedFile(true);
    }

    @Test
    public void testClientWithIdleTimeoutSendChunkedFile() throws Exception {
        this.testIdleTimeoutSendChunkedFile(false);
    }

    private void testIdleTimeoutSendChunkedFile(boolean idleOnServer) throws Exception {
        int expected = 0x1000000;
        File sent = TestUtils.tmpFile(".dat", expected);
        this.server.close();
        AtomicReference sendResult = new AtomicReference();
        AtomicReference remaining = new AtomicReference();
        AtomicLong now = new AtomicLong();
        Runnable testChecker = () -> {
            if (sendResult.get() != null && remaining.get() != null) {
                if ((Integer)remaining.get() > 0) {
                    this.assertTrue(((AsyncResult)sendResult.get()).failed());
                } else {
                    this.assertTrue(((AsyncResult)sendResult.get()).succeeded());
                    this.assertTrue(System.currentTimeMillis() - now.get() > 200L);
                }
                this.testComplete();
            }
        };
        Consumer<NetSocket> sender = so -> so.sendFile(sent.getAbsolutePath(), ar -> {
            sendResult.set(ar);
            testChecker.run();
        });
        Consumer<NetSocket> receiver = so -> {
            now.set(System.currentTimeMillis());
            int[] len = new int[]{0};
            so.handler(buff -> {
                len[0] = len[0] + buff.length();
                so.pause();
                this.vertx.setTimer(1L, id -> so.resume());
            });
            so.exceptionHandler(this::fail);
            so.endHandler(v -> {
                remaining.set(expected - len[0]);
                testChecker.run();
            });
        };
        this.server = this.vertx.createNetServer(new NetServerOptions().setIdleTimeout(200).setIdleTimeoutUnit(TimeUnit.MILLISECONDS)).connectHandler((idleOnServer ? sender : receiver)::accept);
        this.startServer();
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setIdleTimeout(200).setIdleTimeoutUnit(TimeUnit.MILLISECONDS));
        this.client.connect(this.testAddress, this.onSuccess(idleOnServer ? receiver : sender));
        this.await();
    }

    @Test
    public void testHalfCloseCallsEndHandlerAfterBuffersAreDelivered() throws Exception {
        StringBuffer expected = new StringBuffer();
        this.server.connectHandler(so -> {
            Context ctx = this.vertx.getOrCreateContext();
            int i = 0;
            while (i < 8) {
                int val = i++;
                ctx.runOnContext(v -> {
                    String chunk = "chunk-" + val + "\r\n";
                    so.write(chunk);
                    expected.append(chunk);
                });
            }
            ctx.runOnContext(v -> so.close());
        });
        this.startServer();
        this.client.connect(this.testAddress, "localhost", this.onSuccess(so -> {
            so.pause();
            AtomicBoolean closed = new AtomicBoolean();
            AtomicBoolean ended = new AtomicBoolean();
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.closeHandler(v -> {
                this.assertFalse(ended.get());
                this.assertEquals(Buffer.buffer(), received);
                closed.set(true);
                so.resume();
            });
            so.endHandler(v -> {
                this.assertEquals(expected.toString(), received.toString());
                ended.set(true);
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutHappened() throws Exception {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(false);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setSslHandshakeTimeout(200L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, this.onFailure(err -> {
                this.assertTrue(err instanceof SSLHandshakeException);
                this.assertEquals("handshake timed out", err.getCause().getMessage());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutNotHappened() throws Exception {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()).setSslHandshakeTimeout(100L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true);
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSslHandshakeTimeoutHappenedWhenUpgradeSsl() {
        this.server.close();
        this.client.close();
        NetServerOptions serverOptions = new NetServerOptions().setSsl(false);
        this.server = this.vertx.createNetServer(serverOptions);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(false).setTrustAll(true).setSslHandshakeTimeout(200L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.client = this.vertx.createNetClient(clientOptions);
        this.server.connectHandler(s -> {}).listen(this.testAddress, ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(this.testAddress, res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                this.assertFalse(socket.isSsl());
                socket.upgradeToSsl(v -> this.fail("this should never be called because of failure of handshake"));
                socket.exceptionHandler(err -> {
                    this.assertTrue(err instanceof SSLException);
                    this.assertEquals("handshake timed out", err.getMessage());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    protected void startServer(SocketAddress remoteAddress) throws Exception {
        this.startServer(remoteAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(SocketAddress remoteAddress, NetServer server) throws Exception {
        this.startServer(remoteAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(SocketAddress remoteAddress, Context context) throws Exception {
        this.startServer(remoteAddress, context, this.server);
    }

    protected void startServer(SocketAddress remoteAddress, Context context, NetServer server) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        context.runOnContext(v -> server.listen(remoteAddress, this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
    }

    @Test
    public void testPausedDuringLastChunk() throws Exception {
        this.server.connectHandler(so -> {
            AtomicBoolean paused = new AtomicBoolean();
            paused.set(true);
            so.pause();
            so.closeHandler(v -> {
                paused.set(false);
                so.resume();
            });
            so.endHandler(v -> {
                this.assertFalse(paused.get());
                this.testComplete();
            });
        });
        this.startServer();
        this.client.connect(this.testAddress, "localhost", this.onSuccess(so -> so.close()));
        this.await();
    }

    protected void startServer() throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(NetServer server) throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(Context context) throws Exception {
        this.startServer(this.testAddress, context, this.server);
    }

    protected void startServer(Context context, NetServer server) throws Exception {
        this.startServer(this.testAddress, context, server);
    }

    private /* synthetic */ void lambda$testContexts$178(Set contexts, AtomicReference serverConnectContext, AtomicReference listenContext, AsyncResult ar) {
        this.assertTrue(ar.succeeded());
        Context closeContext = Vertx.currentContext();
        this.assertFalse(contexts.contains(closeContext));
        this.assertNotSame(serverConnectContext.get(), closeContext);
        this.assertFalse(contexts.contains(listenContext.get()));
        this.assertSame(serverConnectContext.get(), listenContext.get());
        this.testComplete();
    }

    private /* synthetic */ void lambda$testContexts$177(Set contexts, AtomicInteger connectCount, int numConnections, CountDownLatch clientLatch, AsyncResult conn) {
        contexts.add(Vertx.currentContext());
        if (connectCount.incrementAndGet() == numConnections) {
            this.assertEquals(numConnections, contexts.size());
            clientLatch.countDown();
        }
    }

    private /* synthetic */ void lambda$testFanout$117(Set connections, int numConnections, NetSocket socket) {
        connections.add(socket.writeHandlerID());
        if (connections.size() == numConnections) {
            for (String actorID : connections) {
                this.vertx.eventBus().publish(actorID, (Object)Buffer.buffer((String)"some data"));
            }
        }
        socket.closeHandler(v -> connections.remove(socket.writeHandlerID()));
    }

    class TLSTest {
        Cert<?> clientCert = Cert.NONE;
        Trust<?> clientTrust = Trust.NONE;
        Cert<?> serverCert = Cert.NONE;
        Trust<?> serverTrust = Trust.NONE;
        boolean requireClientAuth;
        boolean clientTrustAll;
        boolean startTLS;
        String[] enabledCipherSuites = new String[0];
        String[] enabledSecureTransportProtocols = new String[0];
        boolean sni;
        SocketAddress bindAddress;
        SocketAddress connectAddress = this.bindAddress = SocketAddress.inetSocketAddress((int)4043, (String)"localhost");
        String serverName;
        X509Certificate clientPeerCert;
        String indicatedServerName;

        TLSTest() {
        }

        public TLSTest clientCert(Cert<?> clientCert) {
            this.clientCert = clientCert;
            return this;
        }

        public TLSTest clientTrust(Trust<?> clientTrust) {
            this.clientTrust = clientTrust;
            return this;
        }

        public TLSTest serverCert(Cert<?> serverCert) {
            this.serverCert = serverCert;
            return this;
        }

        public TLSTest serverTrust(Trust<?> serverTrust) {
            this.serverTrust = serverTrust;
            return this;
        }

        public TLSTest requireClientAuth(boolean requireClientAuth) {
            this.requireClientAuth = requireClientAuth;
            return this;
        }

        public TLSTest clientTrustAll(boolean clientTrustAll) {
            this.clientTrustAll = clientTrustAll;
            return this;
        }

        public TLSTest startTLS(boolean startTLS) {
            this.startTLS = startTLS;
            return this;
        }

        public TLSTest enabledCipherSuites(String[] enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public TLSTest enabledSecureTransportProtocols(String[] enabledSecureTransportProtocols) {
            this.enabledSecureTransportProtocols = enabledSecureTransportProtocols;
            return this;
        }

        public TLSTest address(SocketAddress address) {
            this.bindAddress = address;
            this.connectAddress = address;
            return this;
        }

        public TLSTest bindAddress(SocketAddress address) {
            this.bindAddress = address;
            return this;
        }

        public TLSTest connectAddress(SocketAddress address) {
            this.connectAddress = address;
            return this;
        }

        public TLSTest serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public TLSTest sni(boolean sni) {
            this.sni = sni;
            return this;
        }

        public X509Certificate clientPeerCert() {
            return this.clientPeerCert;
        }

        void run(boolean shouldPass) {
            NetTest.this.server.close();
            NetServerOptions options = new NetServerOptions();
            if (!this.startTLS) {
                options.setSsl(true);
            }
            options.setTrustOptions((TrustOptions)this.serverTrust.get());
            options.setKeyCertOptions((KeyCertOptions)this.serverCert.get());
            if (this.requireClientAuth) {
                options.setClientAuth(ClientAuth.REQUIRED);
            }
            for (String suite : this.enabledCipherSuites) {
                options.addEnabledCipherSuite(suite);
            }
            if (this.enabledSecureTransportProtocols.length > 0) {
                options.getEnabledSecureTransportProtocols().forEach(arg_0 -> ((NetServerOptions)options).removeEnabledSecureTransportProtocol(arg_0));
            }
            for (String protocol : this.enabledSecureTransportProtocols) {
                options.addEnabledSecureTransportProtocol(protocol);
            }
            options.setSni(this.sni);
            Consumer<NetSocket> certificateChainChecker = socket -> {
                try {
                    X509Certificate[] certs = socket.peerCertificateChain();
                    if (this.clientCert != Cert.NONE) {
                        NetTest.this.assertNotNull(certs);
                        NetTest.this.assertEquals(1L, certs.length);
                    } else {
                        NetTest.this.assertNull(certs);
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    NetTest.this.assertTrue(this.clientTrust.get() != Trust.NONE || this.clientTrustAll);
                }
            };
            NetTest.this.server = NetTest.this.vertx.createNetServer(options);
            if (!shouldPass) {
                NetTest.this.waitForMore(1);
            }
            NetTest.this.server.exceptionHandler(err -> NetTest.this.complete());
            Handler serverHandler = socket -> {
                this.indicatedServerName = socket.indicatedServerName();
                SSLSession sslSession = socket.sslSession();
                if (socket.isSsl()) {
                    NetTest.this.assertNotNull(sslSession);
                    certificateChainChecker.accept((NetSocket)socket);
                } else {
                    NetTest.this.assertNull(sslSession);
                }
                AtomicBoolean upgradedServer = new AtomicBoolean();
                AtomicInteger upgradedServerCount = new AtomicInteger();
                socket.handler(buff -> {
                    socket.write(buff);
                    if (this.startTLS) {
                        if (upgradedServer.compareAndSet(false, true)) {
                            this.indicatedServerName = socket.indicatedServerName();
                            NetTest.this.assertFalse(socket.isSsl());
                            socket.exceptionHandler(err -> {
                                if (shouldPass) {
                                    NetTest.this.fail("Should not fail to connect");
                                } else {
                                    NetTest.this.complete();
                                }
                            });
                            socket.upgradeToSsl(v -> {
                                certificateChainChecker.accept((NetSocket)socket);
                                upgradedServerCount.incrementAndGet();
                                NetTest.this.assertTrue(socket.isSsl());
                            });
                        } else {
                            NetTest.this.assertTrue(socket.isSsl());
                            NetTest.this.assertEquals(1L, upgradedServerCount.get());
                        }
                    } else {
                        NetTest.this.assertTrue(socket.isSsl());
                    }
                });
            };
            NetTest.this.server.connectHandler(serverHandler).listen(this.bindAddress, NetTest.this.onSuccess(ar -> {
                NetTest.this.client.close();
                NetClientOptions clientOptions = new NetClientOptions();
                if (!this.startTLS) {
                    clientOptions.setSsl(true);
                }
                if (this.clientTrustAll) {
                    clientOptions.setTrustAll(true);
                }
                clientOptions.setTrustOptions((TrustOptions)this.clientTrust.get());
                clientOptions.setKeyCertOptions((KeyCertOptions)this.clientCert.get());
                for (String suite : this.enabledCipherSuites) {
                    clientOptions.addEnabledCipherSuite(suite);
                }
                if (this.enabledSecureTransportProtocols.length > 0) {
                    clientOptions.getEnabledSecureTransportProtocols().forEach(arg_0 -> ((NetClientOptions)clientOptions).removeEnabledSecureTransportProtocol(arg_0));
                }
                for (String protocol : this.enabledSecureTransportProtocols) {
                    clientOptions.addEnabledSecureTransportProtocol(protocol);
                }
                NetTest.this.client = NetTest.this.vertx.createNetClient(clientOptions);
                NetTest.this.client.connect(this.connectAddress, this.serverName, ar2 -> {
                    if (ar2.succeeded()) {
                        if (!this.startTLS && !shouldPass) {
                            NetTest.this.fail("Should not connect");
                            return;
                        }
                        int numChunks = 100;
                        int chunkSize = 100;
                        ArrayList<Buffer> toSend = new ArrayList<Buffer>();
                        Buffer expected = Buffer.buffer();
                        for (int i = 0; i < 100; ++i) {
                            Buffer chunk = TestUtils.randomBuffer(100);
                            toSend.add(chunk);
                            expected.appendBuffer(chunk);
                        }
                        Buffer received = Buffer.buffer();
                        NetSocket socket = (NetSocket)ar2.result();
                        if (socket.isSsl()) {
                            try {
                                this.clientPeerCert = socket.peerCertificateChain()[0];
                            }
                            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                                // empty catch block
                            }
                        }
                        AtomicBoolean upgradedClient = new AtomicBoolean();
                        socket.handler(buffer -> {
                            received.appendBuffer(buffer);
                            if (received.length() == expected.length()) {
                                NetTest.this.assertEquals(expected, received);
                                NetTest.this.complete();
                            }
                            if (this.startTLS && !upgradedClient.get()) {
                                upgradedClient.set(true);
                                NetTest.this.assertFalse(socket.isSsl());
                                Handler handler = v -> {
                                    NetTest.this.assertTrue(socket.isSsl());
                                    try {
                                        this.clientPeerCert = socket.peerCertificateChain()[0];
                                    }
                                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                                        // empty catch block
                                    }
                                    for (int i = 1; i < 100; ++i) {
                                        socket.write((Buffer)toSend.get(i));
                                    }
                                };
                                socket.exceptionHandler(err -> {
                                    if (shouldPass) {
                                        NetTest.this.fail("Should not fail to connect");
                                    } else {
                                        NetTest.this.complete();
                                    }
                                });
                                if (this.serverName != null) {
                                    socket.upgradeToSsl(this.serverName, handler);
                                } else {
                                    socket.upgradeToSsl(handler);
                                }
                            } else {
                                NetTest.this.assertTrue(socket.isSsl());
                            }
                        });
                        int numToSend = this.startTLS ? 1 : 100;
                        for (int i = 0; i < numToSend; ++i) {
                            socket.write((Buffer)toSend.get(i));
                        }
                    } else if (shouldPass) {
                        ar2.cause().printStackTrace();
                        NetTest.this.fail("Should not fail to connect");
                    } else {
                        NetTest.this.complete();
                    }
                });
            }));
        }
    }
}

