/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.AsyncTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class WriteStreamTest
extends AsyncTestBase {
    @Test
    public void testEndWithItemStreamAsync() {
        Object item = new Object();
        Throwable cause = new Throwable();
        EndWithItemStreamAsync src = new EndWithItemStreamAsync();
        src.end(item);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(0L, src.endCount.get());
        this.assertEquals(0L, src.resolvedCount.get());
        src.writeFut.complete();
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertEquals(0L, src.resolvedCount.get());
        src.endFut.complete();
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertEquals(1L, src.resolvedCount.get());
        this.assertTrue(src.resolvedFut.future().succeeded());
        this.assertNull(src.resolvedFut.future().result());
        src = new EndWithItemStreamAsync();
        src.end(item);
        src.writeFut.fail(cause);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(0L, src.endCount.get());
        this.assertEquals(1L, src.resolvedCount.get());
        this.assertTrue(src.resolvedFut.future().failed());
        this.assertSame(cause, src.resolvedFut.future().cause());
        src = new EndWithItemStreamAsync();
        src.end(item);
        src.writeFut.complete();
        src.endFut.fail(cause);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertEquals(1L, src.resolvedCount.get());
        this.assertTrue(src.resolvedFut.future().failed());
        this.assertSame(cause, src.resolvedFut.future().cause());
    }

    @Test
    public void testEndStreamAsync() {
        Object item = new Object();
        EndStreamSync src = new EndStreamSync();
        src.end(item);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertEquals(Arrays.asList(item), src.items);
    }

    @Test
    public void testEndStreamAsync2() {
        Object item = new Object();
        EndStreamSync2 src = new EndStreamSync2();
        try {
            src.end(item);
            this.fail();
        }
        catch (Exception e) {
            this.assertSame(e, src.cause);
        }
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(0L, src.endCount.get());
        this.assertEquals(Collections.singletonList(item), src.items);
    }

    @Test
    public void testEndStreamAsync3() {
        Object item = new Object();
        EndStreamSync3 src = new EndStreamSync3();
        try {
            src.end(item);
            this.fail();
        }
        catch (Exception e) {
            this.assertSame(e, src.cause);
        }
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertEquals(Collections.singletonList(item), src.items);
    }

    static class EndStreamSync3
    extends StreamBase<Object> {
        AtomicInteger writeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        List<Object> items = new ArrayList<Object>();
        RuntimeException cause = new RuntimeException();

        EndStreamSync3() {
        }

        @Override
        public StreamBase<Object> write(Object data) {
            this.items.add(data);
            this.writeCount.incrementAndGet();
            return this;
        }

        @Override
        public void end() {
            this.endCount.incrementAndGet();
            throw this.cause;
        }
    }

    static class EndStreamSync2
    extends StreamBase<Object> {
        AtomicInteger writeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        List<Object> items = new ArrayList<Object>();
        RuntimeException cause = new RuntimeException();

        EndStreamSync2() {
        }

        @Override
        public StreamBase<Object> write(Object data) {
            this.items.add(data);
            this.writeCount.incrementAndGet();
            throw this.cause;
        }

        @Override
        public void end() {
            this.endCount.incrementAndGet();
        }
    }

    static class EndStreamSync
    extends StreamBase<Object> {
        AtomicInteger writeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        List<Object> items = new ArrayList<Object>();

        EndStreamSync() {
        }

        @Override
        public StreamBase<Object> write(Object data) {
            this.items.add(data);
            this.writeCount.incrementAndGet();
            return this;
        }

        @Override
        public void end() {
            this.endCount.incrementAndGet();
        }
    }

    static class EndWithItemStreamAsync
    extends StreamBase<Object> {
        AtomicInteger writeCount = new AtomicInteger();
        Promise<Void> writeFut = Promise.promise();
        AtomicInteger endCount = new AtomicInteger();
        Promise<Void> endFut = Promise.promise();
        AtomicInteger resolvedCount = new AtomicInteger();
        Promise<Void> resolvedFut = Promise.promise();

        EndWithItemStreamAsync() {
        }

        @Override
        public StreamBase<Object> write(Object data, Handler<AsyncResult<Void>> handler) {
            this.writeCount.incrementAndGet();
            this.writeFut.future().setHandler(handler);
            return this;
        }

        @Override
        public void end(Handler<AsyncResult<Void>> handler) {
            this.endCount.incrementAndGet();
            this.endFut.future().setHandler(handler);
        }

        public void end(Object item) {
            this.end(item, ar -> {
                this.resolvedCount.incrementAndGet();
                this.resolvedFut.handle(ar);
            });
        }
    }

    static class StreamBase<T>
    implements WriteStream<T> {
        StreamBase() {
        }

        public StreamBase<T> exceptionHandler(Handler<Throwable> handler) {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> write(T data) {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> write(T data, Handler<AsyncResult<Void>> handler) {
            throw new UnsupportedOperationException();
        }

        public void end() {
            throw new UnsupportedOperationException();
        }

        public void end(Handler<AsyncResult<Void>> handler) {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> setWriteQueueMaxSize(int maxSize) {
            throw new UnsupportedOperationException();
        }

        public boolean writeQueueFull() {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> drainHandler(@Nullable Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }
    }
}

