/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.test.core.BlockedThreadWarning;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;

public class BlockedThreadCheckerTest
extends VertxTestBase {
    @Rule
    public BlockedThreadWarning blockedThreadWarning = new BlockedThreadWarning();

    @Test
    public void testBlockCheckDefault() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(6000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        this.vertx.deployVerticle((Verticle)verticle);
        this.await();
        this.blockedThreadWarning.expectMessage("vert.x-eventloop-thread", VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME, VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT);
    }

    @Test
    public void testBlockCheckExceptionTimeLimit() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(3000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        long maxEventLoopExecuteTime = 1L;
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxEventLoopExecuteTime(maxEventLoopExecuteTime);
        vertxOptions.setMaxEventLoopExecuteTimeUnit(maxEventLoopExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxEventLoopExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxEventLoopExecuteTimeUnit);
        Vertx newVertx = this.vertx(vertxOptions);
        newVertx.deployVerticle((Verticle)verticle);
        this.await();
        this.blockedThreadWarning.expectMessage("vert.x-eventloop-thread", maxEventLoopExecuteTime, maxEventLoopExecuteTimeUnit);
    }

    @Test
    public void testBlockCheckWorker() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(3000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        long maxWorkerExecuteTime = 1L;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        vertxOptions.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxWorkerExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxWorkerExecuteTimeUnit);
        Vertx newVertx = this.vertx(vertxOptions);
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setWorker(true);
        newVertx.deployVerticle((Verticle)verticle, deploymentOptions);
        this.await();
        this.blockedThreadWarning.expectMessage("vert.x-worker-thread", maxWorkerExecuteTime, maxWorkerExecuteTimeUnit);
    }

    @Test
    public void testBlockCheckExecuteBlocking() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                this.vertx.executeBlocking(fut -> {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        BlockedThreadCheckerTest.this.fail();
                    }
                    BlockedThreadCheckerTest.this.testComplete();
                }, ar -> {});
            }
        };
        long maxWorkerExecuteTime = 1L;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        vertxOptions.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxWorkerExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxWorkerExecuteTimeUnit);
        Vertx newVertx = this.vertx(vertxOptions);
        newVertx.deployVerticle((Verticle)verticle);
        this.await();
        this.blockedThreadWarning.expectMessage("vert.x-worker-thread", maxWorkerExecuteTime, maxWorkerExecuteTimeUnit);
    }
}

