/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class VertxTest
extends AsyncTestBase {
    @Test
    public void testCloseHooksCalled() throws Exception {
        AtomicInteger closedCount = new AtomicInteger();
        Closeable myCloseable1 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((Object)Future.succeededFuture());
        };
        Closeable myCloseable2 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((Object)Future.succeededFuture());
        };
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        vertx.addCloseHook(myCloseable1);
        vertx.addCloseHook(myCloseable2);
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseHookFailure1() throws Exception {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Handler<AsyncResult<Void>> completionHandler) {
                if (closedCount.incrementAndGet() == 1) {
                    throw new RuntimeException();
                }
                completionHandler.handle((Object)Future.succeededFuture());
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseHookFailure2() throws Exception {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Handler<AsyncResult<Void>> completionHandler) {
                if (closedCount.incrementAndGet() == 1) {
                    completionHandler.handle((Object)Future.succeededFuture());
                    throw new RuntimeException();
                }
                completionHandler.handle((Object)Future.succeededFuture());
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        });
        this.await();
    }
}

