/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import org.junit.Test;

public class Http1xProxyTest
extends HttpTestBase {
    @Test
    public void testHttpProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(this.client.get(8080, "localhost", "/"));
    }

    @Test
    public void testHttpProxyRequestOverrideClientSsl() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(true).setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        this.testHttpProxyRequest2(this.client.get(new RequestOptions().setSsl(Boolean.valueOf(false)).setHost("localhost").setPort(8080)));
    }

    private void testHttpProxyRequest2(HttpClientRequest clientReq) throws Exception {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            clientReq.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
                this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
                this.testComplete();
            });
            clientReq.exceptionHandler(this::fail);
            clientReq.end();
        }));
        this.await();
    }

    @Test
    public void testHttpProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.HTTP);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.assertEquals("Host header doesn't contain target host", "localhost:8080", this.proxy.getLastRequestHeaders().get("Host"));
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }

    @Test
    public void testHttpProxyFtpRequest() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort())));
        String url = "ftp://ftp.gnu.org/gnu/";
        this.proxy.setForceUri("http://localhost:8080/");
        HttpClientRequest clientReq = this.client.getAbs("ftp://ftp.gnu.org/gnu/");
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            clientReq.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals("request did sent the expected url", "ftp://ftp.gnu.org/gnu/", this.proxy.getLastUri());
                this.testComplete();
            });
            clientReq.exceptionHandler(this::fail);
            clientReq.end();
        }));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequest() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort())));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }

    @Test
    public void testHttpSocksProxyRequestAuth() throws Exception {
        this.startProxy("user", ProxyType.SOCKS5);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setHost("localhost").setPort(this.proxy.getPort()).setUsername("user").setPassword("user")));
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> this.client.get(8080, "localhost", "/", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertNotNull("request did not go through proxy", this.proxy.getLastUri());
            this.testComplete();
        }).exceptionHandler(th -> this.fail((Throwable)th)).end()));
        this.await();
    }
}

