/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.test.core.TestUtils;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class Http2SettingsTest
extends HttpTestBase {
    long[] min = new long[]{0L, 0L, 0L, 0L, 16384L, 0L};
    long[] max = new long[]{0xFFFFFFFFL, 1L, 0xFFFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFL, Integer.MAX_VALUE};

    @Test
    public void testSettingsMin() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new Http2Settings().set(i, this.min[i - 1] - 1L);
                this.fail();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Http2Settings settings = new Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.min[i - 1]);
        }
        HttpUtils.fromVertxSettings((Http2Settings)settings);
    }

    @Test
    public void testSettinsMax() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new Http2Settings().set(i, this.max[i - 1] + 1L);
                this.fail("Was expecting setting " + (i - 1) + " update to throw IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Http2Settings settings = new Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.max[i - 1]);
        }
        HttpUtils.fromVertxSettings((Http2Settings)settings);
    }

    @Test
    public void toNettySettings() {
        int i;
        Http2Settings settings = new Http2Settings();
        for (int i2 = 7; i2 <= 65535; ++i2) {
            settings.set(65535, Math.min(0xFFFFFFFFL, TestUtils.randomPositiveLong()));
        }
        io.netty.handler.codec.http2.Http2Settings conv = HttpUtils.fromVertxSettings((Http2Settings)settings);
        for (i = 1; i <= 65535; ++i) {
            this.assertEquals(settings.get(i), conv.get((char)i));
        }
        settings = HttpUtils.toVertxSettings((io.netty.handler.codec.http2.Http2Settings)conv);
        for (i = 1; i <= 65535; ++i) {
            this.assertEquals(settings.get(i), conv.get((char)i));
        }
    }

    @Test
    public void testSettings() {
        Http2Settings settings = new Http2Settings();
        this.assertEquals(true, settings.isPushEnabled());
        this.assertEquals(Integer.MAX_VALUE, settings.getMaxHeaderListSize());
        this.assertEquals(0xFFFFFFFFL, settings.getMaxConcurrentStreams());
        this.assertEquals(65535L, settings.getInitialWindowSize());
        this.assertEquals(16384L, settings.getMaxFrameSize());
        this.assertEquals(null, settings.getExtraSettings());
        Http2Settings update = TestUtils.randomHttp2Settings();
        this.assertFalse(settings.equals((Object)update));
        this.assertNotSame(settings.hashCode(), settings.hashCode());
        this.assertSame(settings, settings.setHeaderTableSize(update.getHeaderTableSize()));
        this.assertEquals(settings.getHeaderTableSize(), update.getHeaderTableSize());
        this.assertSame(settings, settings.setPushEnabled(update.isPushEnabled()));
        this.assertEquals(settings.isPushEnabled(), update.isPushEnabled());
        this.assertSame(settings, settings.setMaxHeaderListSize(update.getMaxHeaderListSize()));
        this.assertEquals(settings.getMaxHeaderListSize(), update.getMaxHeaderListSize());
        this.assertSame(settings, settings.setMaxConcurrentStreams(update.getMaxConcurrentStreams()));
        this.assertEquals(settings.getMaxConcurrentStreams(), update.getMaxConcurrentStreams());
        this.assertSame(settings, settings.setInitialWindowSize(update.getInitialWindowSize()));
        this.assertEquals(settings.getInitialWindowSize(), update.getInitialWindowSize());
        this.assertSame(settings, settings.setMaxFrameSize(update.getMaxFrameSize()));
        this.assertEquals(settings.getMaxFrameSize(), update.getMaxFrameSize());
        this.assertSame(settings, settings.setExtraSettings(update.getExtraSettings()));
        HashMap extraSettings = new HashMap(update.getExtraSettings());
        this.assertEquals(update.getExtraSettings(), extraSettings);
        extraSettings.clear();
        this.assertEquals(update.getExtraSettings(), settings.getExtraSettings());
        this.assertTrue(settings.equals((Object)update));
        this.assertEquals(settings.hashCode(), settings.hashCode());
        settings = new Http2Settings(update);
        this.assertEquals(settings.getHeaderTableSize(), update.getHeaderTableSize());
        this.assertEquals(settings.isPushEnabled(), update.isPushEnabled());
        this.assertEquals(settings.getMaxHeaderListSize(), update.getMaxHeaderListSize());
        this.assertEquals(settings.getMaxConcurrentStreams(), update.getMaxConcurrentStreams());
        this.assertEquals(settings.getInitialWindowSize(), update.getInitialWindowSize());
        this.assertEquals(settings.getMaxFrameSize(), update.getMaxFrameSize());
        this.assertEquals(update.getExtraSettings(), settings.getExtraSettings());
    }

    @Test
    public void testEqualsHashCode() throws Exception {
        Http2Settings s1 = new Http2Settings().setHeaderTableSize(1024L);
        Http2Settings s2 = new Http2Settings().setHeaderTableSize(1024L);
        Http2Settings s3 = new Http2Settings(s1.toJson());
        Http2Settings s4 = new Http2Settings().setHeaderTableSize(2048L);
        this.assertEquals(s1, s1);
        this.assertEquals(s2, s2);
        this.assertEquals(s3, s3);
        this.assertEquals(s1, s2);
        this.assertEquals(s2, s1);
        this.assertEquals(s2, s3);
        this.assertEquals(s3, s2);
        this.assertEquals(s1, s3);
        this.assertEquals(s3, s1);
        this.assertEquals(s1.hashCode(), s2.hashCode());
        this.assertEquals(s2.hashCode(), s3.hashCode());
        this.assertFalse(s1.equals(null));
        this.assertFalse(s2.equals(null));
        this.assertFalse(s3.equals(null));
        Assert.assertNotEquals((Object)s1, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s1);
        Assert.assertNotEquals((Object)s2, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s2);
        Assert.assertNotEquals((Object)s3, (Object)s4);
        Assert.assertNotEquals((Object)s4, (Object)s3);
        Assert.assertNotEquals((long)s1.hashCode(), (long)s4.hashCode());
        Assert.assertNotEquals((long)s2.hashCode(), (long)s4.hashCode());
        Assert.assertNotEquals((long)s3.hashCode(), (long)s4.hashCode());
    }
}

