/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.DeploymentManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.assertj.core.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentManagerTest {
    private static boolean isJarOrZip(File file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    @Test
    public void extractClasspathTest() throws URISyntaxException {
        for (URL cpURL : DeploymentManager.extractClasspath((ClassLoader)this.getClass().getClassLoader())) {
            File cpEntry = new File(cpURL.toURI());
            Assert.assertTrue((String)("Classpath entry does not exist: " + cpURL), (boolean)cpEntry.exists());
            if (!cpEntry.isFile()) continue;
            Assert.assertTrue((String)("Classpath entry is a file but not a zip or jar: " + cpURL), (boolean)DeploymentManagerTest.isJarOrZip(cpEntry));
        }
    }

    @Test
    public void extractClasspathWithExplodedJarTest() throws MalformedURLException {
        URL cp = new File("src/test/resources/cpExtraction/exploded").toURI().toURL();
        URLClassLoader ucl = new URLClassLoader((URL[])Arrays.array((Object[])new URL[]{cp}), null);
        for (URL cpURL : DeploymentManager.extractCPByManifest((ClassLoader)ucl)) {
            Assert.assertEquals((String)"extractCPByManifest does not handle exploded JARs correct", (Object)cp, (Object)cpURL);
        }
    }
}

