/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Utils;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.test.core.TestUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JsonCodecTest {
    private static final TypeReference<Integer> INTEGER_TYPE_REF = new TypeReference<Integer>(){};
    private static final TypeReference<Long> LONG_TYPE_REF = new TypeReference<Long>(){};
    private static final TypeReference<String> STRING_TYPE_REF = new TypeReference<String>(){};
    private static final TypeReference<Float> FLOAT_TYPE_REF = new TypeReference<Float>(){};
    private static final TypeReference<Double> DOUBLE_TYPE_REF = new TypeReference<Double>(){};
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Object>> LIST_TYPE_REF = new TypeReference<List<Object>>(){};
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REF = new TypeReference<Boolean>(){};

    @Test
    public void testEncodeJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", "foo");
        jsonObject.put("mycharsequence", (CharSequence)new StringBuilder("oob"));
        jsonObject.put("myint", Integer.valueOf(123));
        jsonObject.put("mylong", Long.valueOf(1234L));
        jsonObject.put("myfloat", Float.valueOf(1.23f));
        jsonObject.put("mydouble", Double.valueOf(2.34));
        jsonObject.put("myboolean", Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", bytes);
        Instant now = Instant.now();
        jsonObject.put("myinstant", now);
        jsonObject.putNull("mynull");
        jsonObject.put("myobj", new JsonObject().put("foo", "bar"));
        jsonObject.put("myarr", new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String expected = "{\"mystr\":\"foo\",\"mycharsequence\":\"oob\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybinary\":\"" + strBytes + "\",\"myinstant\":\"" + DateTimeFormatter.ISO_INSTANT.format(now) + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}";
        String json = jsonObject.encode();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonArray() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("foo");
        jsonArray.add(Integer.valueOf(123));
        jsonArray.add(Long.valueOf(1234L));
        jsonArray.add(Float.valueOf(1.23f));
        jsonArray.add(Double.valueOf(2.34));
        jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add(bytes);
        jsonArray.addNull();
        jsonArray.add(new JsonObject().put("foo", "bar"));
        jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String expected = "[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        String json = jsonArray.encode();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonObjectToBuffer() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", "foo");
        jsonObject.put("mycharsequence", (CharSequence)new StringBuilder("oob"));
        jsonObject.put("myint", Integer.valueOf(123));
        jsonObject.put("mylong", Long.valueOf(1234L));
        jsonObject.put("myfloat", Float.valueOf(1.23f));
        jsonObject.put("mydouble", Double.valueOf(2.34));
        jsonObject.put("myboolean", Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", bytes);
        Instant now = Instant.now();
        jsonObject.put("myinstant", now);
        jsonObject.putNull("mynull");
        jsonObject.put("myobj", new JsonObject().put("foo", "bar"));
        jsonObject.put("myarr", new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Buffer expected = Buffer.buffer((String)("{\"mystr\":\"foo\",\"mycharsequence\":\"oob\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybinary\":\"" + strBytes + "\",\"myinstant\":\"" + DateTimeFormatter.ISO_INSTANT.format(now) + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}"), (String)"UTF-8");
        Buffer json = jsonObject.toBuffer();
        Assert.assertArrayEquals((byte[])expected.getBytes(), (byte[])json.getBytes());
    }

    @Test
    public void testEncodeJsonArrayToBuffer() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("foo");
        jsonArray.add(Integer.valueOf(123));
        jsonArray.add(Long.valueOf(1234L));
        jsonArray.add(Float.valueOf(1.23f));
        jsonArray.add(Double.valueOf(2.34));
        jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add(bytes);
        jsonArray.addNull();
        jsonArray.add(new JsonObject().put("foo", "bar"));
        jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Buffer expected = Buffer.buffer((String)("[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]"), (String)"UTF-8");
        Buffer json = jsonArray.toBuffer();
        Assert.assertArrayEquals((byte[])expected.getBytes(), (byte[])json.getBytes());
    }

    @Test
    public void testEncodeJsonObjectPrettily() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("mystr", "foo");
        jsonObject.put("myint", Integer.valueOf(123));
        jsonObject.put("mylong", Long.valueOf(1234L));
        jsonObject.put("myfloat", Float.valueOf(1.23f));
        jsonObject.put("mydouble", Double.valueOf(2.34));
        jsonObject.put("myboolean", Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonObject.put("mybinary", bytes);
        Instant now = Instant.now();
        jsonObject.put("myinstant", now);
        jsonObject.put("myobj", new JsonObject().put("foo", "bar"));
        jsonObject.put("myarr", new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String expected = "{" + Utils.LINE_SEPARATOR + "  \"mystr\" : \"foo\"," + Utils.LINE_SEPARATOR + "  \"myint\" : 123," + Utils.LINE_SEPARATOR + "  \"mylong\" : 1234," + Utils.LINE_SEPARATOR + "  \"myfloat\" : 1.23," + Utils.LINE_SEPARATOR + "  \"mydouble\" : 2.34," + Utils.LINE_SEPARATOR + "  \"myboolean\" : true," + Utils.LINE_SEPARATOR + "  \"mybinary\" : \"" + strBytes + "\"," + Utils.LINE_SEPARATOR + "  \"myinstant\" : \"" + strInstant + "\"," + Utils.LINE_SEPARATOR + "  \"myobj\" : {" + Utils.LINE_SEPARATOR + "    \"foo\" : \"bar\"" + Utils.LINE_SEPARATOR + "  }," + Utils.LINE_SEPARATOR + "  \"myarr\" : [ \"foo\", 123 ]" + Utils.LINE_SEPARATOR + "}";
        String json = jsonObject.encodePrettily();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testEncodeJsonArrayPrettily() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("foo");
        jsonArray.add(Integer.valueOf(123));
        jsonArray.add(Long.valueOf(1234L));
        jsonArray.add(Float.valueOf(1.23f));
        jsonArray.add(Double.valueOf(2.34));
        jsonArray.add(Boolean.valueOf(true));
        byte[] bytes = TestUtils.randomByteArray(10);
        jsonArray.add(bytes);
        jsonArray.addNull();
        jsonArray.add(new JsonObject().put("foo", "bar"));
        jsonArray.add(new JsonArray().add("foo").add(Integer.valueOf(123)));
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        String expected = "[ \"foo\", 123, 1234, 1.23, 2.34, true, \"" + strBytes + "\", null, {" + Utils.LINE_SEPARATOR + "  \"foo\" : \"bar\"" + Utils.LINE_SEPARATOR + "}, [ \"foo\", 123 ] ]";
        String json = jsonArray.encodePrettily();
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void testDecodeJsonObject() {
        byte[] bytes = TestUtils.randomByteArray(10);
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Instant now = Instant.now();
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String json = "{\"mystr\":\"foo\",\"myint\":123,\"mylong\":1234,\"myfloat\":1.23,\"mydouble\":2.34,\"myboolean\":true,\"mybinary\":\"" + strBytes + "\",\"myinstant\":\"" + strInstant + "\",\"mynull\":null,\"myobj\":{\"foo\":\"bar\"},\"myarr\":[\"foo\",123]}";
        JsonObject obj = new JsonObject(json);
        Assert.assertEquals((Object)json, (Object)obj.encode());
        Assert.assertEquals((Object)"foo", (Object)obj.getString("mystr"));
        Assert.assertEquals((Object)123, (Object)obj.getInteger("myint"));
        Assert.assertEquals((Object)1234L, (Object)obj.getLong("mylong"));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)obj.getFloat("myfloat"));
        Assert.assertEquals((Object)2.34, (Object)obj.getDouble("mydouble"));
        Assert.assertTrue((boolean)obj.getBoolean("myboolean"));
        Assert.assertArrayEquals((byte[])bytes, (byte[])obj.getBinary("mybinary"));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(bytes), (Object)obj.getValue("mybinary"));
        Assert.assertEquals((Object)now, (Object)obj.getInstant("myinstant"));
        Assert.assertEquals((Object)now.toString(), (Object)obj.getValue("myinstant"));
        Assert.assertTrue((boolean)obj.containsKey("mynull"));
        JsonObject nestedObj = obj.getJsonObject("myobj");
        Assert.assertEquals((Object)"bar", (Object)nestedObj.getString("foo"));
        JsonArray nestedArr = obj.getJsonArray("myarr");
        Assert.assertEquals((Object)"foo", (Object)nestedArr.getString(0));
        Assert.assertEquals((Object)123, (Object)nestedArr.getInteger(1));
    }

    @Test
    public void testDecodeJsonArray() {
        byte[] bytes = TestUtils.randomByteArray(10);
        String strBytes = Base64.getEncoder().encodeToString(bytes);
        Instant now = Instant.now();
        String strInstant = DateTimeFormatter.ISO_INSTANT.format(now);
        String json = "[\"foo\",123,1234,1.23,2.34,true,\"" + strBytes + "\",\"" + strInstant + "\",null,{\"foo\":\"bar\"},[\"foo\",123]]";
        JsonArray arr = new JsonArray(json);
        Assert.assertEquals((Object)"foo", (Object)arr.getString(0));
        Assert.assertEquals((Object)123, (Object)arr.getInteger(1));
        Assert.assertEquals((Object)1234L, (Object)arr.getLong(2));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)arr.getFloat(3));
        Assert.assertEquals((Object)2.34, (Object)arr.getDouble(4));
        Assert.assertEquals((Object)true, (Object)arr.getBoolean(5));
        Assert.assertArrayEquals((byte[])bytes, (byte[])arr.getBinary(6));
        Assert.assertEquals((Object)Base64.getEncoder().encodeToString(bytes), (Object)arr.getValue(6));
        Assert.assertEquals((Object)now, (Object)arr.getInstant(7));
        Assert.assertEquals((Object)now.toString(), (Object)arr.getValue(7));
        Assert.assertTrue((boolean)arr.hasNull(8));
        JsonObject obj = arr.getJsonObject(9);
        Assert.assertEquals((Object)"bar", (Object)obj.getString("foo"));
        JsonArray arr2 = arr.getJsonArray(10);
        Assert.assertEquals((Object)"foo", (Object)arr2.getString(0));
        Assert.assertEquals((Object)123, (Object)arr2.getInteger(1));
    }

    @Test
    public void testDecodeJsonObjectWithComments() {
        String jsonWithComments = "// single line comment\n/*\n  This is a multi \n  line comment\n*/\n{\n// another single line comment this time inside the JSON object itself\n  \"foo\": \"bar\" // and a single line comment at end of line \n/*\n  This is a another multi \n  line comment this time inside the JSON object itself\n*/\n}";
        JsonObject json = new JsonObject(jsonWithComments);
        Assert.assertEquals((Object)"{\"foo\":\"bar\"}", (Object)json.encode());
    }

    @Test
    public void testDecodeJsonArrayWithComments() {
        String jsonWithComments = "// single line comment\n/*\n  This is a multi \n  line comment\n*/\n[\n// another single line comment this time inside the JSON array itself\n  \"foo\", \"bar\" // and a single line comment at end of line \n/*\n  This is a another multi \n  line comment this time inside the JSON array itself\n*/\n]";
        JsonArray json = new JsonArray(jsonWithComments);
        Assert.assertEquals((Object)"[\"foo\",\"bar\"]", (Object)json.encode());
    }

    @Test
    public void testDecodeJsonObjectWithInvalidJson() {
        for (String test : new String[]{"null", "3", "\"3", "qiwjdoiqwjdiqwjd"}) {
            try {
                new JsonObject(test);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
            try {
                new JsonObject(Buffer.buffer((String)test));
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDecodeJsonArrayWithInvalidJson() {
        for (String test : new String[]{"null", "3", "\"3", "qiwjdoiqwjdiqwjd"}) {
            try {
                new JsonArray(test);
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
            try {
                new JsonArray(Buffer.buffer((String)test));
                Assert.fail();
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void encodeCustomTypeInstant() {
        Instant now = Instant.now();
        String json = Json.encode((Object)now);
        Assert.assertNotNull((Object)json);
        Instant decoded = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(json.substring(1, json.length() - 1)));
        Assert.assertEquals((Object)now, (Object)decoded);
    }

    @Test
    public void encodeCustomTypeBinary() {
        byte[] data = new byte[]{104, 101, 108, 108, 111};
        String json = Json.encode((Object)data);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"aGVsbG8=\"", (Object)json);
    }

    @Test
    public void encodeNull() {
        String json = Json.encode(null);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"null", (Object)json);
    }

    @Test
    public void encodeToBuffer() {
        Buffer json = Json.encodeToBuffer((Object)"Hello World!");
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"\"Hello World!\"", (Object)json.toString());
    }

    @Test
    public void encodeNullToBuffer() {
        Buffer json = Json.encodeToBuffer(null);
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)"null", (Object)json.toString());
    }

    @Test
    public void testDecodeValue() {
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42, INTEGER_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"42"), 42L, LONG_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"\"foobar\""), "foobar", STRING_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), Float.valueOf(3.4f), FLOAT_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"3.4"), 3.4, DOUBLE_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"{\"foo\":4}"), Collections.singletonMap("foo", 4), MAP_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"[0,1,2]"), Arrays.asList(0, 1, 2), LIST_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"true"), true, BOOLEAN_TYPE_REF);
        this.assertDecodeValue(Buffer.buffer((String)"false"), false, BOOLEAN_TYPE_REF);
    }

    private <T> void assertDecodeValue(Buffer buffer, T expected, TypeReference<T> ref) {
        Type type = ref.getType();
        Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        Assert.assertEquals(expected, (Object)Json.decodeValue((Buffer)buffer, (Class)clazz));
        Assert.assertEquals(expected, (Object)JacksonCodec.decodeValue((Buffer)buffer, ref));
        Assert.assertEquals(expected, (Object)Json.decodeValue((String)buffer.toString(StandardCharsets.UTF_8), (Class)clazz));
        Assert.assertEquals(expected, (Object)JacksonCodec.decodeValue((String)buffer.toString(StandardCharsets.UTF_8), ref));
        Buffer nullValue = Buffer.buffer((String)"null");
        Assert.assertNull((Object)Json.decodeValue((Buffer)nullValue, (Class)clazz));
        Assert.assertNull((Object)JacksonCodec.decodeValue((Buffer)nullValue, ref));
        Assert.assertNull((Object)Json.decodeValue((String)nullValue.toString(StandardCharsets.UTF_8), (Class)clazz));
        Assert.assertNull((Object)JacksonCodec.decodeValue((String)nullValue.toString(StandardCharsets.UTF_8), ref));
    }

    @Test
    public void testDecodeBufferUnknowContent() {
        this.testDecodeUnknowContent(true);
    }

    @Test
    public void testDecodeStringUnknowContent() {
        this.testDecodeUnknowContent(false);
    }

    private void testDecodeUnknowContent(boolean asBuffer) {
        String number = String.valueOf(1);
        Assert.assertEquals((Object)1, (Object)(asBuffer ? Json.decodeValue((Buffer)Buffer.buffer((String)number)) : Json.decodeValue((String)number)));
        String bool = Boolean.TRUE.toString();
        Assert.assertEquals((Object)true, (Object)(asBuffer ? Json.decodeValue((Buffer)Buffer.buffer((String)bool)) : Json.decodeValue((String)bool)));
        String text = "\"whatever\"";
        Assert.assertEquals((Object)"whatever", (Object)(asBuffer ? Json.decodeValue((Buffer)Buffer.buffer((String)text)) : Json.decodeValue((String)text)));
        String nullText = "null";
        Assert.assertNull((Object)(asBuffer ? Json.decodeValue((Buffer)Buffer.buffer((String)nullText)) : Json.decodeValue((String)nullText)));
        JsonObject obj = new JsonObject().put("foo", "bar");
        Assert.assertEquals((Object)obj, (Object)(asBuffer ? Json.decodeValue((Buffer)obj.toBuffer()) : Json.decodeValue((String)obj.toString())));
        JsonArray arr = new JsonArray().add(Integer.valueOf(1)).add(Boolean.valueOf(false)).add("whatever").add(obj);
        Assert.assertEquals((Object)arr, (Object)(asBuffer ? Json.decodeValue((Buffer)arr.toBuffer()) : Json.decodeValue((String)arr.toString())));
        String invalidText = "\"invalid";
        try {
            if (asBuffer) {
                Json.decodeValue((Buffer)Buffer.buffer((String)invalidText));
            } else {
                Json.decodeValue((String)invalidText);
            }
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
    }
}

