/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.impl.BlockedThreadChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BlockedThreadWarning
implements TestRule {
    private boolean doTest;
    private String poolName;
    private long maxExecuteTime;
    private TimeUnit maxExecuteTimeUnit;
    private List<String> logs = new ArrayList<String>();

    public synchronized void expectMessage(String poolName, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        this.doTest = true;
        this.poolName = poolName;
        this.maxExecuteTime = maxExecuteTime;
        this.maxExecuteTimeUnit = maxExecuteTimeUnit;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                BlockedThreadWarning blockedThreadWarning = BlockedThreadWarning.this;
                synchronized (blockedThreadWarning) {
                    BlockedThreadWarning.this.logs.clear();
                }
                Logger logger = Logger.getLogger(BlockedThreadChecker.class.getName());
                Handler handler = new Handler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void publish(LogRecord record) {
                        BlockedThreadWarning blockedThreadWarning = BlockedThreadWarning.this;
                        synchronized (blockedThreadWarning) {
                            BlockedThreadWarning.this.logs.add(record.getMessage());
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                };
                logger.addHandler(handler);
                try {
                    base.evaluate();
                    BlockedThreadWarning.this.doTest();
                }
                finally {
                    logger.removeHandler(handler);
                }
            }
        };
    }

    private synchronized void doTest() {
        if (!this.doTest) {
            return;
        }
        Assert.assertThat(this.logs, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)" has been blocked for "), (Matcher)CoreMatchers.containsString((String)(" time limit is " + this.maxExecuteTimeUnit.toMillis(this.maxExecuteTime) + " ms")), (Matcher)CoreMatchers.containsString((String)("Thread[" + this.poolName + "-")))));
    }
}

