/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakecluster;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.impl.AsynchronousCounter;
import io.vertx.core.shareddata.impl.LocalAsyncLocks;
import io.vertx.core.shareddata.impl.LocalAsyncMapImpl;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.test.fakecluster.ChoosableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class FakeClusterManager
implements ClusterManager {
    private static Map<String, FakeClusterManager> nodes = Collections.synchronizedMap(new LinkedHashMap());
    private static ConcurrentMap<String, LocalAsyncMapImpl> asyncMaps = new ConcurrentHashMap<String, LocalAsyncMapImpl>();
    private static ConcurrentMap<String, ConcurrentMap> asyncMultiMaps = new ConcurrentHashMap<String, ConcurrentMap>();
    private static ConcurrentMap<String, Map> syncMaps = new ConcurrentHashMap<String, Map>();
    private static LocalAsyncLocks localAsyncLocks = new LocalAsyncLocks();
    private static ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private String nodeID;
    private NodeListener nodeListener;
    private VertxInternal vertx;

    public void setVertx(Vertx vertx) {
        this.vertx = (VertxInternal)vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doJoin(String nodeID, FakeClusterManager node) {
        if (nodes.containsKey(nodeID)) {
            throw new IllegalStateException("Node has already joined!");
        }
        nodes.put(nodeID, node);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberAdded(nodeID)).start();
            }
        }
    }

    private synchronized void memberAdded(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeAdded(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLeave(String nodeID) {
        nodes.remove(nodeID);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberRemoved(nodeID)).start();
            }
        }
    }

    private synchronized void memberRemoved(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeLeft(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        ConcurrentMap prevMap;
        ConcurrentMap map = (ConcurrentHashMap)asyncMultiMaps.get(name);
        if (map == null && (prevMap = (ConcurrentMap)asyncMultiMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture(new FakeAsyncMultiMap(theMap))));
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        LocalAsyncMapImpl asyncMap = asyncMaps.computeIfAbsent(name, n -> new LocalAsyncMapImpl((Vertx)this.vertx));
        this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)asyncMap)));
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        Map prevMap;
        Map map = (ConcurrentHashMap)syncMaps.get(name);
        if (map == null && (prevMap = (Map)syncMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        return theMap;
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        localAsyncLocks.acquire((Context)this.vertx.getOrCreateContext(), name, timeout, resultHandler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        AtomicLong counter = new AtomicLong();
        AtomicLong prev = counters.putIfAbsent(name, counter);
        if (prev != null) {
            counter = prev;
        }
        AtomicLong theCounter = counter;
        ContextInternal context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)new AsynchronousCounter(this.vertx, theCounter))));
    }

    public String getNodeID() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNodes() {
        ArrayList<String> res;
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            res = new ArrayList<String>(nodes.keySet());
        }
        return res;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                this.nodeID = UUID.randomUUID().toString();
                FakeClusterManager.doJoin(this.nodeID, this);
            }
            fut.complete();
        }, resultHandler);
    }

    public void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                if (this.nodeID != null) {
                    if (this.nodeListener != null) {
                        this.nodeListener = null;
                    }
                    FakeClusterManager.doLeave(this.nodeID);
                    this.nodeID = null;
                }
            }
            fut.complete();
        }, resultHandler);
    }

    public boolean isActive() {
        return this.nodeID != null;
    }

    public static void reset() {
        nodes.clear();
        asyncMaps.clear();
        asyncMultiMaps.clear();
        localAsyncLocks = new LocalAsyncLocks();
        counters.clear();
        syncMaps.clear();
    }

    private class FakeAsyncMultiMap<K, V>
    implements AsyncMultiMap<K, V> {
        private final ConcurrentMap<K, ChoosableSet<V>> map;
        private final TaskQueue taskQueue = new TaskQueue();

        public FakeAsyncMultiMap(ConcurrentMap<K, ChoosableSet<V>> map) {
            this.map = map;
        }

        public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
            ContextInternal ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                ChoosableSet prevVals;
                ChoosableSet<Object> vals = (ChoosableSet<Object>)this.map.get(k);
                if (vals == null && (prevVals = this.map.putIfAbsent(k, vals = new ChoosableSet<Object>(1))) != null) {
                    vals = prevVals;
                }
                vals.add(v);
                fut.complete();
            }, this.taskQueue, completionHandler);
        }

        public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> asyncResultHandler) {
            ContextInternal ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                ChoosableSet it = (ChoosableSet)this.map.get(k);
                if (it == null) {
                    it = new ChoosableSet(0);
                }
                fut.complete((Object)it);
            }, this.taskQueue, asyncResultHandler);
        }

        public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
            ContextInternal ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                boolean removed;
                ChoosableSet vals = (ChoosableSet)this.map.get(k);
                boolean found = false;
                if (vals != null && (removed = vals.remove(v))) {
                    if (vals.isEmpty()) {
                        this.map.remove(k);
                    }
                    found = true;
                }
                fut.complete((Object)found);
            }, this.taskQueue, completionHandler);
        }

        public void removeAllForValue(V v, Handler<AsyncResult<Void>> completionHandler) {
            this.removeAllMatching(v::equals, completionHandler);
        }

        public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
            ContextInternal ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                Iterator mapIter = this.map.entrySet().iterator();
                while (mapIter.hasNext()) {
                    Map.Entry entry = mapIter.next();
                    ChoosableSet vals = (ChoosableSet)entry.getValue();
                    Iterator iter = vals.iterator();
                    while (iter.hasNext()) {
                        Object val = iter.next();
                        if (!p.test(val)) continue;
                        iter.remove();
                    }
                    if (!vals.isEmpty()) continue;
                    mapIter.remove();
                }
                fut.complete();
            }, this.taskQueue, completionHandler);
        }
    }
}

