/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.verticles;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;

public class FaultToleranceVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(FaultToleranceVerticle.class);
    private int id;
    private int numAddresses;

    public void start() throws Exception {
        JsonObject config = this.config();
        this.id = config.getInteger("id");
        this.numAddresses = config.getInteger("addressesCount");
        ArrayList<Future> registrationFutures = new ArrayList<Future>(this.numAddresses);
        for (int i = 0; i < this.numAddresses; ++i) {
            Promise registrationFuture = Promise.promise();
            registrationFutures.add(registrationFuture.future());
            this.vertx.eventBus().consumer(this.createAddress(this.id, i), msg -> msg.reply((Object)"pong")).completionHandler((Handler)registrationFuture);
        }
        Promise registrationFuture = Promise.promise();
        registrationFutures.add(registrationFuture.future());
        this.vertx.eventBus().consumer("ping", this::ping).completionHandler((Handler)registrationFuture);
        CompositeFuture.all(registrationFutures).setHandler(ar -> {
            if (ar.succeeded()) {
                this.vertx.eventBus().send("control", (Object)"start");
            }
        });
    }

    private void ping(Message<JsonArray> message) {
        JsonArray jsonArray = (JsonArray)message.body();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int node = jsonArray.getInteger(i);
            for (int j = 0; j < this.numAddresses; ++j) {
                this.vertx.eventBus().request(this.createAddress(node, j), (Object)"ping", ar -> {
                    if (ar.succeeded()) {
                        this.vertx.eventBus().send("control", (Object)"pong");
                    } else {
                        ReplyException replyException;
                        Throwable cause = ar.cause();
                        if (cause instanceof ReplyException && (replyException = (ReplyException)cause).failureType() == ReplyFailure.NO_HANDLERS) {
                            this.vertx.eventBus().send("control", (Object)"noHandlers");
                            return;
                        }
                        log.error((Object)("Unexpected error during ping (id=" + this.id + ")"), cause);
                    }
                });
            }
        }
    }

    private String createAddress(int id, int i) {
        return "address-" + id + "-" + i;
    }
}

