/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SharedServersConcurrencyTest
extends VertxTestBase {
    @Test
    @Repeat(times=100)
    public void testConcurrency() {
        SharedServersConcurrencyTest.deployVerticle(this.vertx, (Verticle)new MonitorVerticle()).compose(__ -> SharedServersConcurrencyTest.deployVerticle(this.vertx, (Verticle)new RestVerticle())).compose(__ -> SharedServersConcurrencyTest.deployVerticle(this.vertx, (Verticle)new ApiVerticle())).onComplete(this.onSuccess(__ -> this.testComplete()));
        this.await();
    }

    private static Future<String> deployVerticle(Vertx vertx, Verticle verticle) {
        return Future.future(promise -> vertx.deployVerticle(verticle, (Handler)promise));
    }

    private static class MonitorVerticle
    extends AbstractVerticle {
        private MonitorVerticle() {
        }

        public void start(Promise<Void> startPromise) {
            this.vertx.createHttpServer(new HttpServerOptions()).requestHandler(req -> {}).listen(16152, ar -> {
                if (ar.succeeded()) {
                    System.out.println("Monitor listening on port: " + ((HttpServer)ar.result()).actualPort());
                    startPromise.complete();
                } else {
                    startPromise.fail(ar.cause());
                }
            });
        }
    }

    private static class RestVerticle
    extends AbstractVerticle {
        private RestVerticle() {
        }

        public void start(Promise<Void> startPromise) {
            this.vertx.createHttpServer(new HttpServerOptions()).requestHandler(req -> {}).listen(15152, ar -> {
                if (ar.succeeded()) {
                    System.out.println("REST listening on port: " + ((HttpServer)ar.result()).actualPort());
                    startPromise.complete();
                } else {
                    startPromise.fail(ar.cause());
                }
            });
        }
    }

    private static class NetVerticle
    extends AbstractVerticle {
        private NetVerticle() {
        }

        public void start(Promise<Void> startPromise) {
            this.vertx.createNetServer(new NetServerOptions().setPort(20152)).connectHandler(netSocket -> {}).listen(ar -> {
                if (ar.succeeded()) {
                    startPromise.complete();
                } else {
                    startPromise.fail(ar.cause());
                }
            });
        }
    }

    private static class ApiVerticle
    extends AbstractVerticle {
        private ApiVerticle() {
        }

        public void start(Promise<Void> startPromise) {
            this.vertx.deployVerticle(() -> new NetVerticle(), new DeploymentOptions().setInstances(32), ar -> {
                if (ar.succeeded()) {
                    startPromise.complete();
                } else {
                    startPromise.fail(ar.cause());
                }
            });
        }
    }
}

