/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.netty.TestLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class DatagramTest
extends VertxTestBase {
    private volatile DatagramSocket peer1;
    private volatile DatagramSocket peer2;

    @Override
    protected void tearDown() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        if (this.peer1 != null) {
            this.peer1.close(ar -> {
                this.assertTrue(ar.succeeded());
                latch.countDown();
            });
        } else {
            latch.countDown();
        }
        if (this.peer2 != null) {
            this.peer2.close(ar2 -> {
                this.assertTrue(ar2.succeeded());
                latch.countDown();
            });
        } else {
            latch.countDown();
        }
        latch.await(10L, TimeUnit.SECONDS);
        super.tearDown();
    }

    @Test
    public void testDatagramSocket() throws Exception {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        TestUtils.assertNullPointerException(() -> this.peer1.send((Buffer)null, 1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send(Buffer.buffer(), -1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send(Buffer.buffer(), 65536, "127.0.0.1", ar -> {}));
        TestUtils.assertNullPointerException(() -> this.peer1.send((String)null, 1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send("", -1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send("", 65536, "127.0.0.1", ar -> {}));
        TestUtils.assertNullPointerException(() -> this.peer1.send((String)null, "UTF-8", 1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send("", "UTF-8", -1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.send("", "UTF-8", 65536, "127.0.0.1", ar -> {}));
        TestUtils.assertNullPointerException(() -> this.peer1.send("", null, 1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.sender(-1, "127.0.0.1"));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.sender(65536, "127.0.0.1"));
        TestUtils.assertNullPointerException(() -> this.peer1.sender(1, null));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.listen(-1, "127.0.0.1", ar -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.peer1.listen(65536, "127.0.0.1", ar -> {}));
        TestUtils.assertNullPointerException(() -> this.peer1.listen(1, null, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.peer1.listen(1, "127.0.0.1", null));
    }

    @Test
    public void testSendReceive() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            Buffer buffer = TestUtils.randomBuffer(128);
            this.peer2.handler(packet -> {
                ByteBuf buff;
                this.assertFalse(Thread.holdsLock(this.peer2));
                Buffer data = packet.data();
                for (buff = data.getByteBuf(); buff != buff.unwrap() && buff.unwrap() != null; buff = buff.unwrap()) {
                }
                this.assertTrue("Was expecting an unpooled buffer instead of " + buff.getClass().getSimpleName(), buff.getClass().getSimpleName().contains("Unpooled"));
                this.assertEquals(buffer, data);
                this.testComplete();
            });
            this.peer1.send(buffer, 1234, "127.0.0.1", ar2 -> {
                this.assertFalse(Thread.holdsLock(this.peer1));
                this.assertTrue(ar2.succeeded());
            });
        });
        this.await();
    }

    @Test
    public void testSendReceiveLargePacket() {
        int packetSize = 10000;
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setSendBufferSize(packetSize));
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setReceiveBufferSize(packetSize + 16));
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            Buffer buffer = TestUtils.randomBuffer(packetSize);
            this.peer2.handler(packet -> {
                this.assertEquals(buffer, packet.data());
                this.testComplete();
            });
            this.peer1.send(buffer, 1234, "127.0.0.1", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testEndHandler() {
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            this.peer2.endHandler(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                this.assertNull(stack.get());
                this.testComplete();
            });
            this.peer2.close();
        });
        this.await();
    }

    @Test
    public void testPauseResume() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            Buffer buffer = TestUtils.randomBuffer(128);
            AtomicBoolean received = new AtomicBoolean();
            this.peer2.handler(packet -> received.set(true));
            this.peer2.pause();
            this.peer1.send(buffer, 1234, "127.0.0.1", ar2 -> this.assertTrue(ar2.succeeded()));
            this.vertx.setTimer(1000L, l -> {
                AtomicInteger count = new AtomicInteger();
                this.peer2.handler(packet -> {
                    switch (count.getAndIncrement()) {
                        case 0: {
                            this.assertEquals(buffer, packet.data());
                            this.peer1.send(buffer, 1234, "127.0.0.1", ar2 -> this.assertTrue(ar2.succeeded()));
                            break;
                        }
                        case 1: {
                            this.assertFalse(received.get());
                            this.assertEquals(buffer, packet.data());
                            this.testComplete();
                            break;
                        }
                        default: {
                            this.fail();
                        }
                    }
                });
                this.peer2.resume();
            });
        });
        this.await();
    }

    @Test
    public void testSender() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            Buffer buffer = TestUtils.randomBuffer(128);
            this.peer2.handler(packet -> {
                this.assertEquals(buffer, packet.data());
                this.testComplete();
            });
            WriteStream sender1 = this.peer1.sender(1234, "127.0.0.1");
            sender1.write((Object)buffer);
        });
        this.await();
    }

    @Test
    public void testListenHostPort() {
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenPort() {
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.listen(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenInetSocketAddress() {
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenSamePortMultipleTimes() {
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2.listen(1234, "127.0.0.1", ar1 -> {
            this.assertTrue(ar1.succeeded());
            this.peer1.listen(1234, "127.0.0.1", ar2 -> {
                this.assertTrue(ar2.failed());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testEcho() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer1.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "127.0.0.1", ar -> {
            this.assertTrue(ar.succeeded());
            Buffer buffer = TestUtils.randomBuffer(128);
            this.peer2.handler(packet -> {
                this.assertEquals("127.0.0.1", packet.sender().host());
                this.assertEquals(1235L, packet.sender().port());
                this.assertEquals(buffer, packet.data());
                this.peer2.send(packet.data(), 1235, "127.0.0.1", ar2 -> this.assertTrue(ar2.succeeded()));
            });
            this.peer1.listen(1235, "127.0.0.1", ar2 -> {
                this.peer1.handler(packet -> {
                    this.assertEquals(buffer, packet.data());
                    this.assertEquals("127.0.0.1", packet.sender().host());
                    this.assertEquals(1234L, packet.sender().port());
                    this.testComplete();
                });
                this.peer1.send(buffer, 1234, "127.0.0.1", ar3 -> this.assertTrue(ar3.succeeded()));
            });
        });
        this.await();
    }

    @Test
    public void testSendAfterCloseFails() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer1.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.peer1.send("Test", 1234, "127.0.0.1", ar2 -> {
                this.assertTrue(ar2.failed());
                this.peer1 = null;
                this.peer2.close(ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.peer2.send("Test", 1234, "127.0.0.1", ar4 -> {
                        this.assertTrue(ar4.failed());
                        this.peer2 = null;
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testBroadcast() {
        if (USE_NATIVE_TRANSPORT) {
            return;
        }
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setBroadcast(true));
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setBroadcast(true));
        this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
        this.peer2.listen(1234, "0.0.0.0", ar1 -> {
            this.assertTrue(ar1.succeeded());
            Buffer buffer = TestUtils.randomBuffer(128);
            this.peer2.handler(packet -> {
                this.assertEquals(buffer, packet.data());
                this.testComplete();
            });
            this.peer1.send(buffer, 1234, "255.255.255.255", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testBroadcastFailsIfNotConfigured() {
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions());
        this.peer1.send("test", 1234, "255.255.255.255", ar -> {
            this.assertTrue(ar.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPause() {
    }

    @Test
    public void testMulticastJoinLeave() throws Exception {
        if (USE_NATIVE_TRANSPORT) {
            return;
        }
        Buffer buffer = TestUtils.randomBuffer(128);
        String groupAddress = "230.0.0.1";
        String iface = NetworkInterface.getByInetAddress(InetAddress.getByName("127.0.0.1")).getName();
        AtomicBoolean received = new AtomicBoolean();
        this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setMulticastNetworkInterface(iface));
        this.peer2 = this.vertx.createDatagramSocket(new DatagramSocketOptions().setMulticastNetworkInterface(iface));
        this.peer1.handler(packet -> {
            this.assertEquals(buffer, packet.data());
            received.set(true);
        });
        this.peer1.listen(1234, "0.0.0.0", ar1 -> {
            this.assertTrue(ar1.succeeded());
            this.peer1.listenMulticastGroup(groupAddress, iface, null, ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.peer2.send(buffer, 1234, groupAddress, ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.vertx.setTimer(1000L, id -> this.peer1.unlistenMulticastGroup(groupAddress, iface, null, ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        AtomicBoolean receivedAfter = new AtomicBoolean();
                        this.peer1.handler(packet -> receivedAfter.set(true));
                        this.peer2.send(buffer, 1234, groupAddress, ar5 -> {
                            this.assertTrue(ar5.succeeded());
                            this.vertx.setTimer(1000L, id2 -> {
                                this.assertFalse(receivedAfter.get());
                                this.assertTrue(received.get());
                                this.testComplete();
                            });
                        });
                    }));
                });
            });
        });
        this.await();
    }

    @Test
    public void testOptions() {
        DatagramSocketOptions options = new DatagramSocketOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(true));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertFalse(options.isBroadcast());
        this.assertEquals(options, options.setBroadcast(true));
        this.assertTrue(options.isBroadcast());
        this.assertTrue(options.isLoopbackModeDisabled());
        this.assertEquals(options, options.setLoopbackModeDisabled(false));
        this.assertFalse(options.isLoopbackModeDisabled());
        this.assertEquals(-1L, options.getMulticastTimeToLive());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMulticastTimeToLive(rand));
        this.assertEquals(rand, options.getMulticastTimeToLive());
        TestUtils.assertIllegalArgumentException(() -> options.setMulticastTimeToLive(-1));
        this.assertNull(options.getMulticastNetworkInterface());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setMulticastNetworkInterface(randString));
        this.assertEquals(randString, options.getMulticastNetworkInterface());
        this.assertFalse(options.isIpV6());
        this.assertEquals(options, options.setIpV6(true));
        this.assertTrue(options.isIpV6());
        this.testComplete();
    }

    @Test
    public void testCopyOptions() {
        DatagramSocketOptions options = new DatagramSocketOptions();
        Random rand = new Random();
        boolean broadcast = rand.nextBoolean();
        boolean loopbackModeDisabled = rand.nextBoolean();
        int multicastTimeToLive = TestUtils.randomPositiveInt();
        String multicastNetworkInterface = TestUtils.randomAlphaString(100);
        boolean reuseAddress = rand.nextBoolean();
        boolean ipV6 = rand.nextBoolean();
        options.setBroadcast(broadcast);
        options.setLoopbackModeDisabled(loopbackModeDisabled);
        options.setMulticastTimeToLive(multicastTimeToLive);
        options.setMulticastNetworkInterface(multicastNetworkInterface);
        options.setReuseAddress(reuseAddress);
        options.setIpV6(ipV6);
        DatagramSocketOptions copy = new DatagramSocketOptions(options);
        this.assertEquals(broadcast, copy.isBroadcast());
        this.assertEquals(loopbackModeDisabled, copy.isLoopbackModeDisabled());
        this.assertEquals(multicastTimeToLive, copy.getMulticastTimeToLive());
        this.assertEquals(multicastNetworkInterface, copy.getMulticastNetworkInterface());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(ipV6, copy.isIpV6());
        this.testComplete();
    }

    @Test
    public void testDefaultJsonOptions() {
        DatagramSocketOptions def = new DatagramSocketOptions();
        DatagramSocketOptions json = new DatagramSocketOptions(new JsonObject());
        this.assertEquals(def.isBroadcast(), json.isBroadcast());
        this.assertEquals(def.isLoopbackModeDisabled(), json.isLoopbackModeDisabled());
        this.assertEquals(def.getMulticastTimeToLive(), json.getMulticastTimeToLive());
        this.assertEquals(def.getMulticastNetworkInterface(), json.getMulticastNetworkInterface());
        this.assertEquals(def.isIpV6(), json.isIpV6());
    }

    @Test
    public void testCopyOptionsJson() {
        Random rand = new Random();
        boolean broadcast = rand.nextBoolean();
        boolean loopbackModeDisabled = rand.nextBoolean();
        int multicastTimeToLive = TestUtils.randomPositiveInt();
        String multicastNetworkInterface = TestUtils.randomAlphaString(100);
        boolean reuseAddress = rand.nextBoolean();
        boolean ipV6 = rand.nextBoolean();
        JsonObject json = new JsonObject().put("broadcast", Boolean.valueOf(broadcast)).put("loopbackModeDisabled", Boolean.valueOf(loopbackModeDisabled)).put("multicastTimeToLive", Integer.valueOf(multicastTimeToLive)).put("multicastNetworkInterface", multicastNetworkInterface).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("ipV6", Boolean.valueOf(ipV6));
        DatagramSocketOptions copy = new DatagramSocketOptions(json);
        this.assertEquals(broadcast, copy.isBroadcast());
        this.assertEquals(loopbackModeDisabled, copy.isLoopbackModeDisabled());
        this.assertEquals(multicastTimeToLive, copy.getMulticastTimeToLive());
        this.assertEquals(multicastNetworkInterface, copy.getMulticastNetworkInterface());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(ipV6, copy.isIpV6());
        this.testComplete();
    }

    @Test
    public void testOptionsCopied() {
        DatagramSocketOptions options = new DatagramSocketOptions();
        options.setReuseAddress(true);
        options.setReusePort(true);
        this.peer1 = this.vertx.createDatagramSocket(options);
        this.peer2 = this.vertx.createDatagramSocket(options);
        options.setReuseAddress(false);
        this.peer1.listen(1234, "127.0.0.1", this.onSuccess(v1 -> this.peer2.listen(1234, "127.0.0.1", this.onSuccess(v2 -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testUseInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                TestUtils.assertIllegalStateException(() -> DatagramTest.this.peer1 = this.vertx.createDatagramSocket(new DatagramSocketOptions()));
                DatagramTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging(new DatagramSocketOptions(), new DatagramSocketOptions());
        this.assertFalse(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testSendLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging(new DatagramSocketOptions().setLogActivity(true), new DatagramSocketOptions());
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testListenLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging(new DatagramSocketOptions(), new DatagramSocketOptions().setLogActivity(true));
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    private TestLoggerFactory testLogging(DatagramSocketOptions sendOptions, DatagramSocketOptions listenOptions) throws Exception {
        return TestUtils.testLogging(() -> {
            this.peer1 = this.vertx.createDatagramSocket(sendOptions);
            this.peer2 = this.vertx.createDatagramSocket(listenOptions);
            this.peer2.exceptionHandler(t -> this.fail(t.getMessage()));
            this.peer2.listen(1234, "127.0.0.1", ar -> {
                this.assertTrue(ar.succeeded());
                Buffer buffer = TestUtils.randomBuffer(128);
                this.peer2.handler(packet -> {
                    this.assertEquals(buffer, packet.data());
                    this.testComplete();
                });
                this.peer1.send(buffer, 1234, "127.0.0.1", ar2 -> this.assertTrue(ar2.succeeded()));
            });
            this.await();
        });
    }
}

