/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.RepeatRule;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.junit.Rule;

public class VertxTestBase
extends AsyncTestBase {
    public static final boolean USE_NATIVE_TRANSPORT = Boolean.getBoolean("vertx.useNativeTransport");
    public static final boolean USE_DOMAIN_SOCKETS = Boolean.getBoolean("vertx.useDomainSockets");
    private static final Logger log = LoggerFactory.getLogger(VertxTestBase.class);
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    protected Vertx vertx;
    protected Vertx[] vertices;
    private List<Vertx> created;
    protected static final String[] ENABLED_CIPHER_SUITES;

    protected void vinit() {
        this.vertx = null;
        this.vertices = null;
        this.created = null;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vinit();
        VertxOptions options = this.getOptions();
        boolean nativeTransport = options.getPreferNativeTransport();
        this.vertx = this.vertx(options);
        if (nativeTransport) {
            this.assertTrue(this.vertx.isNativeTransportEnabled());
        }
    }

    protected VertxOptions getOptions() {
        VertxOptions options = new VertxOptions();
        options.setPreferNativeTransport(USE_NATIVE_TRANSPORT);
        return options;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.vertx != null) {
            this.close(this.vertx);
        }
        if (this.created != null) {
            this.closeClustered(this.created);
        }
        FakeClusterManager.reset();
        super.tearDown();
    }

    protected void closeClustered(List<Vertx> clustered) throws Exception {
        CountDownLatch latch = new CountDownLatch(clustered.size());
        for (Vertx clusteredVertx : clustered) {
            clusteredVertx.close(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to shutdown vert.x", ar.cause());
                }
                latch.countDown();
            });
        }
        this.assertTrue(latch.await(180L, TimeUnit.SECONDS));
    }

    protected Vertx vertx() {
        return this.vertx(new VertxOptions());
    }

    protected Vertx vertx(VertxOptions options) {
        if (this.created == null) {
            this.created = new ArrayList<Vertx>();
        }
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        this.created.add(vertx);
        return vertx;
    }

    protected void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> ar) {
        if (this.created == null) {
            this.created = Collections.synchronizedList(new ArrayList());
        }
        Vertx.clusteredVertx((VertxOptions)options, event -> {
            if (event.succeeded()) {
                this.created.add((Vertx)event.result());
            }
            ar.handle(event);
        });
    }

    protected ClusterManager getClusterManager() {
        return null;
    }

    protected void startNodes(int numNodes) {
        this.startNodes(numNodes, this.getOptions());
    }

    protected void startNodes(int numNodes, VertxOptions options) {
        VertxOptions[] array = new VertxOptions[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            array[i] = options;
        }
        this.startNodes(array);
    }

    protected void startNodes(VertxOptions ... options) {
        int numNodes = options.length;
        CountDownLatch latch = new CountDownLatch(numNodes);
        this.vertices = new Vertx[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            int index = i;
            options[i].setClusterManager(this.getClusterManager()).getEventBusOptions().setHost("localhost").setPort(0).setClustered(true);
            this.clusteredVertx(options[i], (Handler<AsyncResult<Vertx>>)((Handler)ar -> {
                try {
                    if (ar.failed()) {
                        ar.cause().printStackTrace();
                    }
                    this.assertTrue("Failed to start node", ar.succeeded());
                    this.vertices[index] = (Vertx)ar.result();
                }
                finally {
                    latch.countDown();
                }
            }));
        }
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    protected static void setOptions(TCPSSLOptions sslOptions, KeyCertOptions options) {
        if (options instanceof JksOptions) {
            sslOptions.setKeyStoreOptions((JksOptions)options);
        } else if (options instanceof PfxOptions) {
            sslOptions.setPfxKeyCertOptions((PfxOptions)options);
        } else {
            sslOptions.setPemKeyCertOptions((PemKeyCertOptions)options);
        }
    }

    protected Context createWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setWorker(true), ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        return (Context)fut.get();
    }

    protected List<Context> createWorkers(int num) throws Exception {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (int i = 0; i < num; ++i) {
            contexts.add(this.createWorker());
        }
        return contexts;
    }

    static {
        String[] suites = new String[]{};
        try {
            suites = SSLContext.getDefault().getSocketFactory().getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        ENABLED_CIPHER_SUITES = suites;
    }
}

