/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.BenchmarkContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class ContextBenchmark
extends BenchmarkBase {
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(String buf) {
    }

    @Benchmark
    public void runOnContext(BaselineState state) {
        state.context.runOnContext(state.task);
    }

    @Benchmark
    @Fork(jvmArgsAppend={"-Dvertx.threadChecks=false", "-Dvertx.disableContextTimings=true", "-Dvertx.disableTCCL=true"})
    public void runOnContextNoChecks(BaselineState state) {
        state.context.runOnContext(state.task);
    }

    @Benchmark
    public void executeFromIO(BaselineState state) {
        state.context.executeFromIO(state.task);
    }

    @Benchmark
    @Fork(jvmArgsAppend={"-Dvertx.threadChecks=false", "-Dvertx.disableContextTimings=true", "-Dvertx.disableTCCL=true"})
    public void executeFromIONoChecks(BaselineState state) {
        state.context.executeFromIO(state.task);
    }

    @State(value=Scope.Thread)
    public static class BaselineState {
        Vertx vertx;
        BenchmarkContext context;
        Handler<Void> task;

        @Setup
        public void setup() {
            this.vertx = Vertx.vertx();
            this.context = BenchmarkContext.create(this.vertx);
            this.task = v -> ContextBenchmark.consume("the-string");
        }
    }
}

