/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.verticles.HAVerticle1;
import io.vertx.test.verticles.HAVerticle2;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HATest
extends VertxTestBase {
    protected Vertx vertx1;
    protected Vertx vertx2;
    protected Vertx vertx3;
    protected Vertx vertx4 = null;

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    protected void tearDown() throws Exception {
        this.closeVertices(this.vertx1, this.vertx2, this.vertx3, this.vertx4);
        super.tearDown();
    }

    @Test
    public void testSimpleFailover() throws Exception {
        this.startNodes(2, new VertxOptions().setHAEnabled(true));
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertices[0].deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(1L, this.vertices[0].deploymentIDs().size());
            this.assertEquals(0L, this.vertices[1].deploymentIDs().size());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.kill(0);
        HATest.assertWaitUntil(() -> this.vertices[1].deploymentIDs().size() == 1);
        this.checkDeploymentExists(1, "java:" + HAVerticle1.class.getName(), options);
    }

    @Test
    public void testQuorum() throws Exception {
        this.vertx1 = this.startVertx(2);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
            this.testComplete();
        });
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty());
        this.vertx2 = this.startVertx(2);
        this.await();
    }

    @Test
    public void testQuorumLost() throws Exception {
        this.vertx1 = this.startVertx(3);
        this.vertx2 = this.startVertx(3);
        this.vertx3 = this.startVertx(3);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
        });
        this.vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx2.deploymentIDs().contains(ar.result()));
        });
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1 && this.vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx3.close(ar -> latch.countDown());
        this.awaitLatch(latch);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty() && this.vertx2.deploymentIDs().isEmpty());
        this.vertx4 = this.startVertx(3);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1 && this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testCleanCloseNoFailover() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        CountDownLatch deployLatch = new CountDownLatch(1);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            deployLatch.countDown();
        });
        this.awaitLatch(deployLatch);
        ((VertxInternal)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not be called"));
        this.vertx2.close(ar -> this.vertx.setTimer(500L, tid -> this.testComplete()));
        this.await();
    }

    @Test
    public void testFailureInFailover() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        this.vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        ((VertxInternal)this.vertx2).failDuringFailover(true);
        ((VertxInternal)this.vertx3).failDuringFailover(true);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)this.vertx3).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)this.vertx1).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx2.deploymentIDs().isEmpty());
        this.assertTrue(this.vertx3.deploymentIDs().isEmpty());
        ((VertxInternal)this.vertx2).failDuringFailover(false);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxInternal)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxInternal)this.vertx3).simulateKill();
        this.awaitLatch(latch3);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testHaGroups() throws Exception {
        this.vertx1 = this.startVertx("group1", 1);
        this.vertx2 = this.startVertx("group1", 1);
        this.vertx3 = this.startVertx("group2", 1);
        this.vertx4 = this.startVertx("group2", 1);
        CountDownLatch latch1 = new CountDownLatch(2);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.vertx3.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx3.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxInternal)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxInternal)this.vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)this.vertx3).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx4.deploymentIDs().size() == 1);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxInternal)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxInternal)this.vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 4"));
        ((VertxInternal)this.vertx1).simulateKill();
        this.awaitLatch(latch3);
        this.assertTrue(this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testNoFailoverToNonHANode() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx(null, 0, false);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        ((VertxInternal)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxInternal)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxInternal)this.vertx1).simulateKill();
        this.vertx2.close(ar -> this.vertx.setTimer(500L, tid -> this.testComplete()));
        this.await();
    }

    @Test
    public void testNonHADeployments() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(2);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx2.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(false), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx2.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)this.vertx2).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        String depID = (String)this.vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)this.vertx1).getDeployment(depID).verticleIdentifier().equals("java:" + HAVerticle1.class.getName()));
    }

    @Test
    public void testCloseRemovesFromCluster() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        this.vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx3.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx3.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.vertx2.close(ar -> {
            ((VertxInternal)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
                this.assertTrue(succeeded);
                latch2.countDown();
            });
            ((VertxInternal)this.vertx3).simulateKill();
        });
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        String depID = (String)this.vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)this.vertx1).getDeployment(depID).verticleIdentifier().equals("java:" + HAVerticle1.class.getName()));
    }

    @Test
    public void testQuorumWithHaGroups() throws Exception {
        this.vertx1 = this.startVertx("group1", 2);
        this.vertx2 = this.startVertx("group2", 2);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx1.deploymentIDs().contains(ar.result()));
        });
        Thread.sleep(500L);
        this.assertTrue(this.vertx1.deploymentIDs().isEmpty());
        this.vertx3 = this.startVertx("group1", 2);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(this.vertx2.deploymentIDs().contains(ar.result()));
        });
        Thread.sleep(500L);
        this.assertTrue(this.vertx2.deploymentIDs().isEmpty());
        this.vertx4 = this.startVertx("group2", 2);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx4.close(ar -> latch.countDown());
        this.awaitLatch(latch);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().isEmpty());
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.vertx3.close(ar -> latch2.countDown());
        this.awaitLatch(latch2);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty());
    }

    protected Vertx startVertx() throws Exception {
        return this.startVertx(null, 1);
    }

    protected Vertx startVertx(int quorumSize) throws Exception {
        return this.startVertx(null, quorumSize);
    }

    protected Vertx startVertx(String haGroup, int quorumSize) throws Exception {
        return this.startVertx(haGroup, quorumSize, true);
    }

    protected Vertx startVertx(String haGroup, int quorumSize, boolean ha) throws Exception {
        VertxOptions options = new VertxOptions().setHAEnabled(ha).setClusterManager(this.getClusterManager());
        options.getEventBusOptions().setClustered(true).setHost("localhost");
        if (ha) {
            options.setQuorumSize(quorumSize);
            if (haGroup != null) {
                options.setHAGroup(haGroup);
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference vertxRef = new AtomicReference();
        this.clusteredVertx(options, this.onSuccess(vertx -> {
            vertxRef.set(vertx);
            latch.countDown();
        }));
        latch.await(2L, TimeUnit.MINUTES);
        return (Vertx)vertxRef.get();
    }

    protected void checkDeploymentExists(int pos, String verticleName, DeploymentOptions options) {
        VertxInternal vi = (VertxInternal)this.vertices[pos];
        for (String deploymentID : vi.deploymentIDs()) {
            Deployment dep = vi.getDeployment(deploymentID);
            if (!verticleName.equals(dep.verticleIdentifier()) || !options.equals((Object)dep.deploymentOptions())) continue;
            return;
        }
        this.fail("Can't find deployment for verticleName: " + verticleName + " on node " + pos);
    }

    protected void kill(int pos) {
        VertxInternal v = (VertxInternal)this.vertices[pos];
        v.executeBlocking(fut -> {
            try {
                v.simulateKill();
                fut.complete();
            }
            catch (Exception e) {
                fut.fail((Throwable)e);
            }
        }, false, ar -> {
            if (!ar.succeeded()) {
                this.fail(ar.cause());
            }
        });
    }

    protected void closeVertices(Vertx ... vertices) throws Exception {
        CountDownLatch latch = new CountDownLatch(vertices.length);
        for (int i = 0; i < vertices.length; ++i) {
            if (vertices[i] != null) {
                vertices[i].close(this.onSuccess(res -> latch.countDown()));
                continue;
            }
            latch.countDown();
        }
        latch.await(2L, TimeUnit.MINUTES);
    }
}

