/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.VertxTestBase;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Test;

public class VerticleFactoryTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        VerticleFactory factory = (VerticleFactory)this.vertx.verticleFactories().iterator().next();
        this.vertx.unregisterVerticleFactory(factory);
    }

    @Test
    public void testRegister() {
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
    }

    @Test
    public void testUnregister() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
    }

    @Test
    public void testRegisterTwice() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.registerVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterTwice() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterNoFact() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterUnregisterTwo() {
        TestVerticleFactory fact1 = new TestVerticleFactory("foo");
        TestVerticleFactory fact2 = new TestVerticleFactory("bar");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.assertEquals(2L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact2);
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertFalse(this.vertx.verticleFactories().contains(fact2));
    }

    @Test
    public void testMatchWithPrefix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = new TestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "aa:myverticle1";
        String name2 = "bb:myverticle2";
        String name3 = "cc:myverticle3";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions(), ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMatchWithSuffix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = new TestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "myverticle1.aa";
        String name2 = "myverticle2.bb";
        String name3 = "myverticle3.cc";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions(), ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testNoMatch() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = new TestVerticleFactory("bb", (Verticle)verticle2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        String name1 = "cc:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertFalse(ar.succeeded());
            this.assertFalse(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertTrue(ar.cause() instanceof ClassNotFoundException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testResolve() {
        if (!(Thread.currentThread().getContextClassLoader() instanceof URLClassLoader)) {
            return;
        }
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact = new TestVerticleFactory("actual", (Verticle)verticle);
        this.vertx.registerVerticleFactory((VerticleFactory)fact);
        TestVerticleFactory factResolve = new TestVerticleFactory("resolve", "actual:myverticle", "othergroup");
        this.vertx.registerVerticleFactory((VerticleFactory)factResolve);
        JsonObject config = new JsonObject().put("foo", "bar");
        DeploymentOptions original = new DeploymentOptions().setWorker(false).setConfig(config).setIsolationGroup("somegroup");
        DeploymentOptions options = new DeploymentOptions(original);
        this.vertx.deployVerticle("resolve:someid", options, res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("resolve:someid", factResolve.identifierToResolve);
            this.assertEquals(options, factResolve.deploymentOptionsToResolve);
            this.assertEquals("actual:myverticle", fact.identifier);
            this.assertTrue(verticle.startCalled);
            this.assertTrue(verticle.startCalled);
            this.assertEquals(1L, this.vertx.deploymentIDs().size());
            Deployment dep = ((VertxInternal)this.vertx).getDeployment((String)res.result());
            this.assertNotNull(dep);
            this.assertFalse(original.equals((Object)dep.deploymentOptions()));
            this.assertFalse(dep.deploymentOptions().getConfig().containsKey("foo"));
            this.assertEquals("quux", dep.deploymentOptions().getConfig().getString("wibble"));
            this.assertTrue(dep.deploymentOptions().isWorker());
            this.assertEquals("othergroup", dep.deploymentOptions().getIsolationGroup());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testResolve2() {
        if (!(Thread.currentThread().getContextClassLoader() instanceof URLClassLoader)) {
            return;
        }
        VerticleFactory fact = new VerticleFactory(){

            public String prefix() {
                return "resolve";
            }

            public boolean requiresResolve() {
                return true;
            }

            public void resolve(String identifier, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<String> resolution) {
                deploymentOptions.setMultiThreaded(true);
                VerticleFactoryTest.this.vertx.runOnContext(v -> resolution.complete((Object)"whatever"));
            }

            public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
                throw new AssertionError((Object)"Should not be called");
            }
        };
        this.vertx.registerVerticleFactory(fact);
        this.vertx.deployVerticle("resolve:someid");
        this.vertx.deployVerticle("resolve:someid", this.onFailure(err -> {
            this.assertEquals(IllegalArgumentException.class, err.getClass());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testOrdering() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate2() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertTrue(res.succeeded());
            this.assertEquals("aa:someverticle", fact3.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInCreateAll() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", (Verticle)verticle, 3, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle", res -> {
            this.assertFalse(res.succeeded());
            this.assertTrue(res.cause() instanceof ClassNotFoundException);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInResolve() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory factActual = new TestVerticleFactory("actual", (Verticle)verticle);
        this.vertx.registerVerticleFactory((VerticleFactory)factActual);
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", "actual:someverticle", 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", "actual:someverticle", 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", "actual:someverticle", 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:blah", res -> {
            this.assertTrue(res.succeeded());
            this.assertNull(fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.assertEquals("aa:blah", fact2.identifierToResolve);
            this.assertNull(fact1.identifierToResolve);
            this.assertNull(fact3.identifierToResolve);
            this.assertEquals("actual:someverticle", factActual.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingFailedInResolve2() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory factActual = new TestVerticleFactory("actual", (Verticle)verticle);
        this.vertx.registerVerticleFactory((VerticleFactory)factActual);
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", "actual:someverticle", 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", "actual:someverticle", 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", "actual:someverticle", 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:blah", res -> {
            this.assertTrue(res.succeeded());
            this.assertNull(fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.assertEquals("aa:blah", fact3.identifierToResolve);
            this.assertNull(fact1.identifierToResolve);
            this.assertNull(fact2.identifierToResolve);
            this.assertEquals("actual:someverticle", factActual.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testOrderingAllFailedInResolve() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory factActual = new TestVerticleFactory("actual", (Verticle)verticle);
        this.vertx.registerVerticleFactory((VerticleFactory)factActual);
        TestVerticleFactory fact2 = new TestVerticleFactory("aa", "actual:someverticle", 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", "actual:someverticle", 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = new TestVerticleFactory("aa", "actual:someverticle", 3, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:blah", res -> {
            this.assertTrue(res.failed());
            this.assertTrue(res.cause() instanceof IOException);
            this.assertNull(fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.assertNull(fact3.identifierToResolve);
            this.assertNull(fact1.identifierToResolve);
            this.assertNull(fact2.identifierToResolve);
            this.assertNull(factActual.identifier);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testNotBlockingCreate() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        String name1 = "aa:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertFalse(fact1.blockingCreate);
            this.assertFalse(fact1.createWorkerThread);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBlockingCreate() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        fact1.blockingCreate = true;
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        String name1 = "aa:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(fact1.blockingCreate);
            this.assertTrue(fact1.createWorkerThread);
            this.assertTrue(fact1.createContext.isEventLoopContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBlockingCreateFailureInCreate() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticleFactory fact1 = new TestVerticleFactory("aa", (Verticle)verticle1);
        fact1.blockingCreate = true;
        fact1.failInCreate = true;
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        String name1 = "aa:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions(), ar -> {
            this.assertFalse(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close(done -> this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertFalse(ar.succeeded());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithoutCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close(done -> {
            this.vertx.deployVerticle((Verticle)verticle);
            this.testComplete();
        });
        this.await();
    }

    @Test
    @Repeat(times=10)
    public void testConcurrentRegistrations() throws Exception {
        int count = 100;
        ArrayList<CompletableFuture<Void>> registrations = new ArrayList<CompletableFuture<Void>>(count);
        CyclicBarrier barrier = new CyclicBarrier(count);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < count; ++i) {
            TestVerticleFactory factory = new TestVerticleFactory("foo");
            registrations.add(CompletableFuture.runAsync(() -> {
                try {
                    barrier.await();
                    this.vertx.registerVerticleFactory((VerticleFactory)factory);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            }, executor));
        }
        CompletableFuture.allOf(registrations.toArray(new CompletableFuture[0])).get();
        this.assertEquals(count, this.vertx.verticleFactories().size());
    }

    @Test
    @Repeat(times=10)
    public void testConcurrentUnregistrations() throws Exception {
        int count = 100;
        ArrayList<CompletableFuture<Void>> unregistrations = new ArrayList<CompletableFuture<Void>>(count);
        CyclicBarrier barrier = new CyclicBarrier(count);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < count; ++i) {
            TestVerticleFactory factory = new TestVerticleFactory("foo");
            this.vertx.registerVerticleFactory((VerticleFactory)factory);
            unregistrations.add(CompletableFuture.runAsync(() -> {
                try {
                    barrier.await();
                    this.vertx.unregisterVerticleFactory((VerticleFactory)factory);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            }, executor));
        }
        CompletableFuture.allOf(unregistrations.toArray(new CompletableFuture[0])).get();
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
    }

    class TestVerticle
    extends AbstractVerticle {
        boolean startCalled;

        TestVerticle() {
        }

        public void start() throws Exception {
            this.startCalled = true;
        }

        public void stop() throws Exception {
        }
    }

    class TestVerticleFactory
    implements VerticleFactory {
        String prefix;
        Verticle verticle;
        String identifier;
        String isolationGroup;
        String resolvedIdentifier;
        String identifierToResolve;
        DeploymentOptions deploymentOptionsToResolve;
        int order;
        boolean failInCreate;
        boolean failInResolve;
        Context createContext;
        boolean createWorkerThread;
        boolean blockingCreate;

        TestVerticleFactory(String prefix) {
            this.prefix = prefix;
        }

        TestVerticleFactory(String prefix, Verticle verticle) {
            this.prefix = prefix;
            this.verticle = verticle;
        }

        TestVerticleFactory(String prefix, String resolvedIdentifier) {
            this.prefix = prefix;
            this.resolvedIdentifier = resolvedIdentifier;
        }

        TestVerticleFactory(String prefix, String resolvedIdentifier, String isolationGroup) {
            this.prefix = prefix;
            this.resolvedIdentifier = resolvedIdentifier;
            this.isolationGroup = isolationGroup;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order, boolean failInCreate) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
            this.failInCreate = failInCreate;
        }

        TestVerticleFactory(String prefix, String resolvedIdentifier, int order) {
            this.prefix = prefix;
            this.resolvedIdentifier = resolvedIdentifier;
            this.order = order;
        }

        TestVerticleFactory(String prefix, String resolvedIdentifier, int order, boolean failInResolve) {
            this.prefix = prefix;
            this.resolvedIdentifier = resolvedIdentifier;
            this.order = order;
            this.failInResolve = failInResolve;
        }

        public int order() {
            return this.order;
        }

        public boolean requiresResolve() {
            return this.resolvedIdentifier != null;
        }

        public void resolve(String identifier, DeploymentOptions deploymentOptions, ClassLoader classLoader, Promise<String> resolution) {
            if (this.failInResolve) {
                resolution.fail((Throwable)new IOException("whatever"));
            } else {
                this.identifierToResolve = identifier;
                this.deploymentOptionsToResolve = deploymentOptions;
                deploymentOptions.setConfig(new JsonObject().put("wibble", "quux"));
                deploymentOptions.setWorker(true);
                deploymentOptions.setIsolationGroup(this.isolationGroup);
                resolution.complete((Object)this.resolvedIdentifier);
            }
        }

        public void init(Vertx vertx) {
        }

        public String prefix() {
            return this.prefix;
        }

        public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
            if (this.failInCreate) {
                throw new ClassNotFoundException("whatever");
            }
            this.identifier = verticleName;
            this.createContext = Vertx.currentContext();
            this.createWorkerThread = Context.isOnWorkerThread();
            return this.verticle;
        }

        public void close() {
        }

        public boolean blockingCreate() {
            return this.blockingCreate;
        }
    }
}

